/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.util.security;

import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.util.ArrayUtility;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.util.FileUtility;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;

public final class SecurityManager {
    private static final int[] ROTATIONS = new int[]{37, 13, 23, 11, 41, 31, 17, 43, 19, 29};
    private static int UN_ROTATION = 0;
    private static int PWD_ROTATION = 0;
    public static final String CIPHER_SPEC = "AES/ECB/PKCS5PADDING";
    public static final String CIPHER_ALGORITHM = "AES";
    private static final int KEY_LENGTH = 32;
    private static char[] userName;
    private static char[] password;
    private static char[] extraChars;
    private static byte[] credential;
    private static byte[] salt;
    private static SecretKey credentialedSecretKey;

    private SecurityManager() {
    }

    public static void setExtraCharacters(char[] extraChars) {
        SecurityManager.extraChars = extraChars;
    }

    public static void setUserSuppliedCredentials(char[] userName, char[] password) {
        credential = SecurityManager.getCredential(extraChars, userName, password);
        salt = SecurityManager.getSalt(SecurityManager.bytesToChars(credential), userName, password);
        SecurityManager.setUserName(userName);
        SecurityManager.setPassword(password);
        Arrays.fill(userName, '*');
        Arrays.fill(password, '*');
        char[] keyChars = ArrayUtility.interleave(SecurityManager.bytesToChars(credential), SecurityManager.bytesToChars(salt));
        byte[] keyBytes = SecurityManager.getKeyBytes(SecurityManager.charsToBytes(keyChars));
        credentialedSecretKey = new SecretKeySpec(keyBytes, CIPHER_ALGORITHM);
    }

    public static char[] getUserName() {
        return SecurityManager.getModifiedCredential(UN_ROTATION, userName, false);
    }

    private static void setUserName(char[] userName) {
        UN_ROTATION = SecurityManager.getRotation(userName);
        char[] newUserName = SecurityManager.getModifiedCredential(UN_ROTATION, userName, true);
        SecurityManager.userName = newUserName;
    }

    public static char[] getPassword() {
        return SecurityManager.getModifiedCredential(PWD_ROTATION, password, false);
    }

    private static void setPassword(char[] password) {
        PWD_ROTATION = SecurityManager.getRotation(password);
        char[] newPassword = SecurityManager.getModifiedCredential(PWD_ROTATION, password, true);
        SecurityManager.password = newPassword;
    }

    private static char[] getModifiedCredential(int modulo, char[] source, boolean direction) {
        char[] newChars = new char[source.length];
        int i = 0;
        while (i < source.length) {
            char nc;
            int ncb = 0;
            ncb = direction ? source[i] * ROTATIONS[modulo] : source[i] / ROTATIONS[modulo];
            newChars[i] = nc = (char)ncb;
            ++i;
        }
        return newChars;
    }

    private static int getRotation(char[] source) {
        int sum = 0;
        int i = 0;
        while (i < source.length) {
            sum += source[i];
            ++i;
        }
        return sum % 10;
    }

    public static boolean readInitConfigData() {
        String initializationConfigFileName = ((KumbaCoreApplicationProperties)Application.getApplication().getApplicationProperties()).getInitConfigFile();
        ArrayList<Appliance> appliances = FileUtility.getInitConfig(initializationConfigFileName);
        if (FileUtility.initConfigFileExists() && appliances == null) {
            return false;
        }
        if (appliances != null) {
            char[] userName = SecurityManager.getUserName();
            char[] password = SecurityManager.getPassword();
            for (Appliance appliance : appliances) {
                appliance.setConnected(false);
                if (!appliance.getUseApplicationCredentialsForLogin()) continue;
                appliance.setXmlManagementUserName(userName);
                appliance.setXmlManagementPassword(password);
                appliance.setSshManagementUserName(userName);
                appliance.setSshManagementPassword(password);
            }
            ThreadManager.startThreadManager(appliances.size());
            new AsynchMethodInvoker((Object)Application.getApplication(), "setAttribute", new Object[]{"Appliances", appliances}, 100);
        }
        return true;
    }

    public static Cipher getCipher(int cipherMode) {
        return SecurityManager.getCipher(cipherMode, credentialedSecretKey);
    }

    public static Cipher getCipher(int cipherMode, SecretKey secretKey) {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_SPEC);
            cipher.init(cipherMode, secretKey);
            return cipher;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] getCredential(char[] extraChars, char[] userName, char[] password) {
        return SecurityManager.generateDigest(extraChars, userName, password);
    }

    public static byte[] getSalt(char[] extraChars, char[] userName, char[] password) {
        return SecurityManager.generateDigest(ArrayUtility.reverse(extraChars), ArrayUtility.reverse(userName), ArrayUtility.reverse(password));
    }

    public static final byte[] generateDigest(char[] extraChars, char[] userName, char[] password) {
        char[] interleave = ArrayUtility.interleave(extraChars, ArrayUtility.reverse(userName), ArrayUtility.reverse(password));
        byte[] interleaveBytes = new byte[interleave.length];
        int i = 0;
        while (i < interleave.length) {
            interleaveBytes[i] = (byte)interleave[i];
            ++i;
        }
        return DigestUtils.sha512(interleaveBytes);
    }

    public static final char[] encryptApplianceCredentials(Appliance appliance, char[] userName, char[] password) {
        return SecurityManager.cryptApplianceCredentials(appliance, userName, password, 1);
    }

    public static final char[] decryptApplianceCredentials(Appliance appliance, char[] userName, char[] password) {
        return SecurityManager.cryptApplianceCredentials(appliance, userName, password, 2);
    }

    public static final char[] cryptApplianceCredentials(Appliance appliance, char[] userName, char[] password, int mode) {
        if (appliance == null || userName == null || password == null) {
            return null;
        }
        char[] applianceUser = ArrayUtility.interleave(appliance.getXmlManagementHost().toCharArray(), appliance.getName().toCharArray(), userName, extraChars);
        byte[] applianceUserDigest = DigestUtils.sha512(SecurityManager.charsToBytes(applianceUser));
        byte[] keyBytes = SecurityManager.getKeyBytes(applianceUserDigest);
        SecretKeySpec key = new SecretKeySpec(keyBytes, CIPHER_ALGORITHM);
        try {
            Cipher encryptCipher = Cipher.getInstance(CIPHER_SPEC);
            encryptCipher.init(mode, key);
            byte[] cipherPassword = encryptCipher.doFinal(SecurityManager.charsToBytes(password));
            return SecurityManager.bytesToChars(cipherPassword);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static final char[] ensurePasswordLength(String password, int length) {
        int hashCode = ((String)password).hashCode() % 256;
        while (((String)password).length() < length) {
            password = (String)password + (String)password;
        }
        char[] passwordChars = ((String)password).toCharArray();
        int i = 0;
        while (i < passwordChars.length) {
            passwordChars[i] = (char)(passwordChars[i] * hashCode % 256);
            if ((hashCode = (hashCode + passwordChars[i]) % 256) == 0) {
                hashCode = Arrays.hashCode(passwordChars) % 256;
            }
            ++i;
        }
        return passwordChars;
    }

    /*
     * Unable to fully structure code
     */
    public static final byte[] getKeyBytes(byte[] keyChars) {
        sum = 0L;
        i = 0;
        while (i < keyChars.length) {
            sum += (long)keyChars[i];
            ++i;
        }
        mod = Math.abs((int)(sum % (long)keyChars.length));
        while (mod == 0) {
            mod = Math.abs(keyChars[mod]);
        }
        bitSet = new BitSet(keyChars.length);
        bytes = new byte[32];
        i = 0;
        offset = mod;
        ** GOTO lbl29
        {
            offset -= keyChars.length;
            do {
                if (offset >= keyChars.length) continue block2;
                while (bitSet.get(offset)) {
                    ++offset;
                    while (offset >= keyChars.length) {
                        offset -= keyChars.length;
                    }
                }
                bytes[i] = keyChars[offset];
                bitSet.set(offset);
                ++i;
                offset += mod;
lbl29:
                // 2 sources

            } while (i < 32);
        }
        return bytes;
    }

    public static final byte[] charsToBytes(char[] chars) {
        byte[] bytes = new byte[chars.length];
        int i = 0;
        while (i < chars.length) {
            bytes[i] = (byte)chars[i];
            ++i;
        }
        return bytes;
    }

    private static final char[] bytesToChars(byte[] bytes) {
        char[] chars = new char[bytes.length];
        int i = 0;
        while (i < bytes.length) {
            chars[i] = (char)bytes[i];
            ++i;
        }
        return chars;
    }
}

