/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.app;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.ApplicationParameters;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.io.ASCFileWriter;
import com.jmorgan.lang.ApplicationProperties;
import com.jmorgan.lang.ApplicationServices;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.AttributeChangeListener;
import com.jmorgan.lang.GUIApplication;
import com.jmorgan.lang.InvocationEventInvoker;
import com.jmorgan.lang.StackTrace;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.dialog.wizard.WizardPage;
import com.jmorgan.swing.text.editor.DefaultSyntaxKit;
import com.jmorgan.util.DynamicClassLoader;
import com.jmorgan.util.Index;
import com.jmorgan.util.Pair;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.jmorgan.util.logging.LoggingConfig;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.app.SSLHelper;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ApplianceGroupObject;
import com.kumbasoft.core.tools.ListDomains;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.util.security.UILicenseNotificationListener;
import com.kumbasoft.core.util.security.LicenseManager;
import com.kumbasoft.dpaa.app.DPAAApplicationParameters;
import com.kumbasoft.dpaa.app.DPAAApplicationProperties;
import com.kumbasoft.dpaa.app.DPAAApplicationServices;
import com.kumbasoft.dpaa.ui.DPAADarkMetalTheme;
import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.Border;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class DPAA
extends GUIApplication
implements AttributeChangeListener {
    private DPAA kumbaApplication = this;
    private DPAAApplicationProperties kumbaApplicationProperties = (DPAAApplicationProperties)this.getApplicationProperties();

    static {
        try {
            DynamicClassLoader.loadClass("com.kumbasoft.core.app.KumbaCoreConstants");
            DynamicClassLoader.loadClass("com.kumbasoft.core.ui.KumbaCoreUIConstants");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public DPAA(String[] args) {
        super(args);
        WizardPage.LABEL_CONTENTS_DIRECTORY = this.kumbaApplicationProperties.getHelpFilesDirectory();
        WizardPage.FILE_NAME_SUFFIX = ".html";
        this.addAttributeChangeListener(this);
        new AsynchMethodInvoker((Object)this.getApplicationServices(), "logon", KumbaCoreConstants.THREAD_WAIT);
    }

    @Override
    protected void processArguments(String[] args) {
        super.processArguments(args);
        ((DPAAApplicationServices)this.getApplicationServices()).processArguments(args);
    }

    @Override
    public String getPropertiesFileName() {
        return ((DPAAApplicationServices)this.getApplicationServices()).getPropertiesFileName(this.getClass().getSimpleName());
    }

    @Override
    public void loadProperties(String propertiesFileName, ApplicationProperties applicationProperties) {
        ((DPAAApplicationServices)this.getApplicationServices()).loadProperties(propertiesFileName, applicationProperties);
    }

    @Override
    public <BeanType extends ApplicationParameters> BeanType getApplicationParametersBean() {
        if (this.applicationParameters == null) {
            this.applicationParameters = new DPAAApplicationParameters();
        }
        ((DPAAApplicationServices)this.getApplicationServices()).setParameters((DPAAApplicationParameters)this.applicationParameters);
        return (BeanType)this.applicationParameters;
    }

    @Override
    protected ApplicationServices createApplicationServicesObject() {
        DPAAApplicationServices applicationServices = new DPAAApplicationServices();
        applicationServices.setApplication(this);
        return applicationServices;
    }

    @Override
    public String getApplicationLogFileName() {
        String appLogFileName = super.getApplicationLogFileName();
        return ((DPAAApplicationServices)this.getApplicationServices()).getApplicationLogFileName(appLogFileName);
    }

    @Override
    public void setApplicationLogging(String appLogFileName) {
        super.setApplicationLogging(appLogFileName);
        ((DPAAApplicationServices)this.getApplicationServices()).setApplicationLogging(appLogFileName);
    }

    @Override
    public String getArtRoot() {
        return "resources/";
    }

    @Override
    protected void setupDefaultUI() {
        super.setupDefaultUI();
        this.setApplicationColors();
        UIManager.put("Button.border", KumbaCoreUIConstants.BUTTON_BORDER);
        UIManager.put("Button.borderHover", KumbaCoreUIConstants.HOVER_BORDER_CONTROLLER);
        UIManager.put("OptionPane.questionIcon", KumbaCoreUIConstants.QUESTION_ICON);
        UIManager.put("ScrollBar.width", 10);
        UIManager.put("Table.ascendingSortIcon", KumbaCoreUIConstants.SORT_AZ_ICON);
        UIManager.put("Table.descendingSortIcon", KumbaCoreUIConstants.SORT_ZA_ICON);
        MetalLookAndFeel.setCurrentTheme(new DPAADarkMetalTheme());
        try {
            UIManager.setLookAndFeel(new MetalLookAndFeel());
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        DefaultSyntaxKit.initKit();
    }

    public void setApplicationColors() {
        UIDefaults uiDefaults = UIManager.getLookAndFeelDefaults();
        for (Object key : uiDefaults.keySet()) {
            Border border;
            if (!(key instanceof String)) continue;
            String keyString = (String)key;
            if (StringUtility.containsIgnoreCase(keyString, "disabled")) {
                UIManager.put(key, KumbaCoreUIConstants.DISABLED_FOREGROUND);
                continue;
            }
            if (keyString.endsWith("selectionForeground")) {
                UIManager.put(key, KumbaCoreUIConstants.BACKGROUND);
                continue;
            }
            if (keyString.endsWith("selectionBackground")) {
                UIManager.put(key, KumbaCoreUIConstants.FOREGROUND);
                continue;
            }
            if (StringUtility.containsIgnoreCase(keyString, "foreground")) {
                UIManager.put(key, KumbaCoreUIConstants.FOREGROUND);
                continue;
            }
            if (StringUtility.containsIgnoreCase(keyString, "background")) {
                UIManager.put(key, KumbaCoreUIConstants.BACKGROUND);
                continue;
            }
            if (StringUtility.containsIgnoreCase(keyString, "darkShadow")) {
                UIManager.put(key, KumbaCoreUIConstants.DARK_SHADOW);
                continue;
            }
            if (StringUtility.containsIgnoreCase(keyString, "shadow")) {
                UIManager.put(key, KumbaCoreUIConstants.LIGHT_BACKGROUND);
                continue;
            }
            if (StringUtility.containsIgnoreCase(keyString, "highlight")) {
                UIManager.put(key, KumbaCoreUIConstants.LIGHT_BACKGROUND);
                continue;
            }
            if (!keyString.endsWith("border") || !BeanService.hasProperty(border = UIManager.getBorder(keyString), "lineColor")) continue;
            Border newBorder = BorderFactory.createLineBorder(KumbaCoreUIConstants.FOREGROUND);
            UIManager.put(key, newBorder);
        }
        UIManager.put("ActiveLabel.foreground", KumbaCoreUIConstants.FOREGROUND);
        UIManager.put("Button.select", KumbaCoreUIConstants.LIGHT_BACKGROUND);
        UIManager.put("Button.focus", KumbaCoreUIConstants.BACKGROUND);
        UIManager.put("Button.border", KumbaCoreUIConstants.BUTTON_BORDER);
        UIManager.put("Button.borderHover", KumbaCoreUIConstants.HOVER_BORDER_CONTROLLER);
        UIManager.put("ComboBox.arrowColor", KumbaCoreUIConstants.FOREGROUND);
        UIManager.put("List.selectionForeground", KumbaCoreUIConstants.LIST_SELECTED_FOREGROUND);
        UIManager.put("List.selectionBackground", KumbaCoreUIConstants.LIST_SELECTED_BACKGROUND);
        UIManager.put("MenuItem.selectionForeground", KumbaCoreUIConstants.LIST_SELECTED_FOREGROUND);
        UIManager.put("MenuItem.selectionBackground", KumbaCoreUIConstants.LIST_SELECTED_BACKGROUND);
        UIManager.put("OptionPane.questionIcon", KumbaCoreUIConstants.QUESTION_ICON);
        UIManager.put("PasswordField.matchedColor", KumbaCoreUIConstants.MATCHED_PASSWORD);
        UIManager.put("PasswordField.unMatchedColor", KumbaCoreUIConstants.UNMATCHED_PASSWORD);
        UIManager.put("RadioButton.darkShadow", KumbaCoreUIConstants.FOREGROUND);
        UIManager.put("ScrollBar.thumb", KumbaCoreUIConstants.LIGHT_BACKGROUND);
        UIManager.put("ScrollBar.thumbHighlight", KumbaCoreUIConstants.LIGHT_BACKGROUND);
        UIManager.put("ScrollBar.thumbShadow", KumbaCoreUIConstants.FOREGROUND);
        UIManager.put("ScrollBar.thumbDarkShadow", Color.WHITE);
        UIManager.put("ScrollBar.background", KumbaCoreUIConstants.BACKGROUND);
        UIManager.put("ScrollBar.darkShadow", KumbaCoreUIConstants.FOREGROUND);
        UIManager.put("ScrollBar.arrowColor", KumbaCoreUIConstants.FOREGROUND);
        UIManager.put("ScrollBar.arrowDisabled", KumbaCoreUIConstants.LIGHT_BACKGROUND);
        UIManager.put("ScrollBar.width", 10);
        UIManager.put("Spinner.arrowColor", KumbaCoreUIConstants.FOREGROUND);
        UIManager.put("Table.cellBorderColor", KumbaCoreUIConstants.TABLE_CELL_BORDER_COLOR);
        UIManager.put("Table.selectionForeground", KumbaCoreUIConstants.BACKGROUND);
        UIManager.put("Table.selectionBackground", KumbaCoreUIConstants.FOREGROUND);
        UIManager.put("Table.alternateForeground", KumbaCoreUIConstants.FOREGROUND);
        UIManager.put("Table.alternateBackground", KumbaCoreUIConstants.LIGHT_BACKGROUND);
        UIManager.put("Table.gridColor", KumbaCoreUIConstants.LIGHT_BACKGROUND);
        UIManager.put("Table.ascendingSortIcon", KumbaCoreUIConstants.SORT_AZ_ICON);
        UIManager.put("Table.descendingSortIcon", KumbaCoreUIConstants.SORT_ZA_ICON);
        UIManager.put("TabbedPane.selected", KumbaCoreUIConstants.LIGHT_BACKGROUND);
        UIManager.put("TabbedPane.contentAreaColor", KumbaCoreUIConstants.LIGHT_BACKGROUND);
        UIManager.put("TitledBorder.titleColor", KumbaCoreUIConstants.FOREGROUND.darker());
    }

    @Override
    protected Font getDefaultFont() {
        return KumbaCoreUIConstants.FONT;
    }

    @Reflected
    public void loadDomains(ArrayList<Appliance> appliances) {
        this.getApplicationLogger().finer("(appliances):  Starting.");
        HashMap<Appliance, Boolean> domainsLoadedMap = new HashMap<Appliance, Boolean>();
        for (Appliance appliance : appliances) {
            domainsLoadedMap.put(appliance, false);
            AsynchMethodInvoker loadDomainsThread = new AsynchMethodInvoker((Object)this, "loadDomains", (Object)appliance);
            new InvocationEventInvoker(loadDomainsThread, 2, this, "domainsLoaded", appliance, domainsLoadedMap);
        }
        this.getApplicationLogger().finer("(appliances):  Done");
    }

    @Reflected
    public void loadDomains(Appliance appliance) {
        this.getApplicationLogger().finer(() -> LMG.log("(appliance=%s)", () -> appliance.getName()));
        new ListDomains(appliance);
    }

    @Reflected
    private void domainsLoaded(Appliance appliance, HashMap<Appliance, Boolean> domainsLoadedMap) {
        this.getApplicationLogger().finer(() -> LMG.log("(appliance-%s, domainsLoadedMap=)", () -> appliance.getName()));
        if (CollectionUtility.isNotEmpty(appliance.getDomains())) {
            this.setAttribute("Domain Groups", "");
        }
    }

    @Override
    public void attributeAdded(Object key, Object value) {
        if (key.equals("Appliances")) {
            this.getApplicationLogger().finer(() -> LMG.log("(key=%s, value)", () -> key.toString()));
            this.handleApplianceChanges(value);
        } else if (key.equals("healthChecksAllowed")) {
            this.getApplicationLogger().finer(() -> LMG.log("(key=%s, value=%s)", () -> key.toString(), () -> value.toString()));
        } else {
            this.getApplicationLogger().finer(() -> LMG.log("(key=%s, value)", () -> key.toString()));
        }
    }

    @Override
    public void attributeChanged(Object key, Object oldValue, Object newValue) {
        if (key.equals("Appliances")) {
            this.getApplicationLogger().finer(() -> LMG.log("(key=%s, oldValue, newValue)", () -> key.toString()));
            this.handleApplianceChanges(newValue);
        } else if (key.equals("healthChecksAllowed")) {
            this.getApplicationLogger().finer(() -> LMG.log("(key=%s, value=%s)", () -> key.toString(), () -> newValue.toString()));
        } else {
            this.getApplicationLogger().finer(() -> LMG.log("(key=%s, oldValue, newValue)", () -> key.toString()));
        }
    }

    @Override
    public void attributeRemoved(Object key, Object value) {
        if (key.equals("Appliances")) {
            this.getApplicationLogger().finer(() -> LMG.log("(key=%s, value)", () -> key.toString()));
            this.handleApplianceChanges(value);
        } else if (key.equals("healthChecksAllowed")) {
            this.getApplicationLogger().finer(() -> LMG.log("(key=%s, value=%s)", () -> key.toString(), () -> value.toString()));
        } else {
            this.getApplicationLogger().finer(() -> LMG.log("(key=%s, value)", () -> key.toString()));
        }
    }

    public void handleApplianceChanges(Object value) {
        this.getApplicationLogger().finer(() -> LMG.log("(value)", new Supplier[0]));
        if (value == null) {
            this.getApplicationLogger().severe("(value):  HOW CAN THIS VALUE BE NULL?");
        }
        ArrayList appliances = (ArrayList)value;
        new AsynchMethodInvoker((Object)this, "loadDomains", (Object)appliances);
        this.buildApplianceGroups(appliances);
        new AsynchMethodInvoker(LicenseManager.class, "checkLicenseAgainstAppliances", (Object)appliances, 60000);
        new AsynchMethodInvoker((Object)this.getApplicationServices(), "createFirmwareMetaData", (Object)appliances, 2000);
    }

    protected void buildApplianceGroups(ArrayList<Appliance> appliances) {
        this.getApplicationLogger().finer(() -> LMG.log("(appliances):  Starting", new Supplier[0]));
        if (CollectionUtility.isEmpty(appliances)) {
            this.getApplicationLogger().info(() -> LMG.log("(appliances):  Appliances is empty.  Returning.", new Supplier[0]));
            return;
        }
        Index<Pair, Appliance> applianceGroups = new Index<Pair, Appliance>();
        Pair<String, Boolean> allGroupKey = new Pair<String, Boolean>("All", true);
        for (Appliance appliance : appliances) {
            applianceGroups.put(allGroupKey, appliance);
            applianceGroups.put(new Pair<String, Boolean>(appliance.getName(), false), appliance);
            ArrayList<String> categories = appliance.getCategories();
            if (!CollectionUtility.isNotEmpty(categories)) continue;
            for (String category : categories) {
                applianceGroups.put(new Pair<String, Boolean>(category, true), appliance);
            }
        }
        ArrayList<ApplianceGroupObject> applianceGroupList = new ArrayList<ApplianceGroupObject>();
        for (Pair groupInfo : applianceGroups.getKeys()) {
            ArrayList applianceGroup = (ArrayList)applianceGroups.get(groupInfo);
            String groupName = (String)groupInfo.getFirst();
            ApplianceGroupObject ago = new ApplianceGroupObject(groupName, applianceGroup);
            ago.setCreatedFromCategory((Boolean)groupInfo.getSecond());
            applianceGroupList.add(ago);
        }
        this.setAttribute("Appliance Groups", applianceGroupList);
        this.getApplicationLogger().finer("(appliances):  Complete");
    }

    @Reflected
    private void cleanupTemporaryFiles() {
        ((DPAAApplicationServices)this.getApplicationServices()).cleanupTemporaryFiles();
    }

    public static void main(String[] args) {
        LoggingConfig.initialize();
        try {
            LicenseManager.licenseNotificationListener = new UILicenseNotificationListener();
            LicenseManager.LICENSE = LicenseManager.checkLicense("DPAA\u00ae", "./configs/License.txt", true);
            LicenseManager.checkLicenseEntitlement(DPAA.class);
            SSLHelper.setupSSL();
            new DPAA(args);
        }
        catch (Exception e) {
            String stackTrace = StackTrace.getStackTrace(e);
            try {
                new ASCFileWriter("DPAAStartup.log", stackTrace);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            new JMMessageBox(null, "Error Starting DPAA", "Please locate the 'DPAAStartup.log' file in the DPAA application directory and email it to Kumba Software LLC Support.");
            System.exit(-1);
        }
    }
}

