/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.ScrollablePanel;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.event.ComponentEventInvoker;
import com.jmorgan.swing.event.ExtendedTableModelEvent;
import com.jmorgan.swing.table.DynamicBeanColumnModel;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.jmorgan.swing.table.MultiLineTableHeaderRenderer;
import com.jmorgan.swing.table.StringOptionsTableCellEditor;
import com.jmorgan.swing.table.TableCellEditorRenderer;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.swing.util.ScrollSynchronizer;
import com.jmorgan.swing.util.WindowCloser;
import com.jmorgan.text.NumericalRangeValidator;
import com.jmorgan.text.RegularExpressionValidator;
import com.jmorgan.text.StringLengthValidator;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.Index;
import com.jmorgan.util.Pair;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.comparator.BeanComparator;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.CertificateInformation;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.NotApplicable;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.ModifyTool;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.CommandResultsDialog;
import com.kumbasoft.core.ui.editors.DPEnumerationTableCellEditor;
import com.kumbasoft.core.ui.editors.DPFileTableCellEditor;
import com.kumbasoft.core.ui.editors.DPObjectListTableCellEditor;
import com.kumbasoft.core.ui.renderers.HighlightDifferenceModifyingTableCellRenderer;
import com.kumbasoft.core.ui.renderers.NotApplicableTableCellRenderer;
import com.kumbasoft.core.util.DataPowerFileUtility;
import com.kumbasoft.core.util.DataStructureUtility;
import com.kumbasoft.dpaa.ui.panels.configurations.DisplayCertificateInfoPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class CompareObjectsDialog
extends JMDialog
implements TableModelListener {
    private static final String[] NON_EDITABLE_PROPERTIES = new String[]{"isExternal", "isIntrinsic", "isLocal", "isReadOnly", "configObjectType"};
    private ArrayList<DataPowerConfig> dataPowerObjects;
    private ArrayList<StatusObjectStatus> allObjects;
    private HashMap<String, String> propertyNameMap;
    private HashMap<String, DataPowerConfig> columnToObjectMap;
    private DynamicBean[] columnInfo;
    private DynamicBeanTableModel tableModel;
    private DynamicBeanColumnModel columnModel;
    private JMTable table;
    private JMScrollPane scrollPane;
    private boolean isEditable;
    private int lastRow;
    private int lastCol;
    private JMCheckBox cbxSynchronizeChanges;
    private JMButton btnSaveChanges;
    private ScrollablePanel certificateComparePanel;
    private static final String[] NUMERICAL_TYPES = new String[]{"long", "int"};
    private CommandResultsDialog commandResultsDialog;

    public CompareObjectsDialog(JFrame owner, String title, Object ... arguments) {
        super(owner, title, true, arguments);
    }

    @Override
    public void buildGUI(Object ... arguments) {
        this.isEditable = true;
        if (arguments.length > 1) {
            DynamicBean dialogArguments = (DynamicBean)arguments[0];
            this.isEditable = (Boolean)dialogArguments.getProperty("editable");
        }
        this.columnToObjectMap = new HashMap();
        this.propertyNameMap = new HashMap();
        this.lastRow = -1;
        this.lastCol = -1;
        ArrayList objectsToCompare = (ArrayList)arguments[arguments.length - 1];
        if (CollectionUtility.isNotEmpty(objectsToCompare)) {
            Object dataPowerObject = objectsToCompare.get(0);
            if (dataPowerObject instanceof DataPowerConfig) {
                this.dataPowerObjects = objectsToCompare;
                this.createControlsPanel();
                new AsynchMethodInvoker((Object)this, "listAllObjects", this.dataPowerObjects);
                this.buildObjectCompare(this.dataPowerObjects);
                new ComponentEventInvoker(this.scrollPane, 8, (Object)this, "resizeObjectTable");
            } else if (dataPowerObject instanceof CertificateInformation) {
                ArrayList certInfo = objectsToCompare;
                this.buildCertificateCompare(certInfo);
                new ComponentEventInvoker(this.scrollPane, 8, (Object)this, "resizeCertificatePanels");
            }
        } else {
            this.setSize(400, 400);
            this.setPreferredSize(new Dimension(400, 400));
            new AsynchMethodInvoker((Object)this, "showLoadError");
        }
    }

    @Reflected
    private void listAllObjects(ArrayList<DataPowerConfig> dataPowerObjects) {
        HashMap<Appliance, Index<Domain, DataPowerConfig>> objectMap = DataStructureUtility.mapByApplianceDomain(dataPowerObjects);
        Index<Appliance, Domain> selectedDomains = new Index<Appliance, Domain>();
        for (Appliance appliance : objectMap.keySet()) {
            Index<Domain, DataPowerConfig> domainMap = objectMap.get(appliance);
            selectedDomains.put(appliance, domainMap.getKeys());
        }
        ConfigurationManager configurationManager = new ConfigurationManager();
        this.allObjects = configurationManager.listObjects(selectedDomains, null, null);
    }

    @Reflected
    private void showLoadError() {
        new JMMessageBox((JFrame)this.getOwner(), "Error loading objects", LabelUtility.wrapInHTML("Failure attempting to compare the selected objects.\n\nPlease contact KumbaSoft technical support and let them know what you were doing."));
        new AsynchMethodInvoker(WindowCloser.class, "closeWindow", (Object)this);
    }

    private void createControlsPanel() {
        if (!this.isEditable) {
            return;
        }
        JMPanel panel = KumbaCoreUIConstants.createFlowLayoutPanel(2);
        this.cbxSynchronizeChanges = new JMCheckBox("Synchronize Changes", true);
        this.cbxSynchronizeChanges.setVisible(this.dataPowerObjects.size() > 1);
        this.btnSaveChanges = new JMButton(KumbaCoreUIConstants.SAVE_ICON);
        new ActionEventInvoker(this.btnSaveChanges, this, "fileSave");
        panel.addAll(this.cbxSynchronizeChanges, this.btnSaveChanges);
        this.add((Component)panel, "North");
    }

    private void buildObjectCompare(ArrayList<DataPowerConfig> dataPowerObjects) {
        Iterator stringsForEditor;
        Object objectMap;
        Iterator editableRows;
        Iterator<String> validationRegexp;
        UniqueArrayList<String> properties = new UniqueArrayList<String>();
        HashMap<String, String> propertyDisplayMap = new HashMap<String, String>();
        String[] columnNames = new String[dataPowerObjects.size() + 1];
        this.columnInfo = new DynamicBean[columnNames.length];
        columnNames[0] = "propertyName";
        int cn = 1;
        for (DataPowerConfig dataPowerObject : dataPowerObjects) {
            String applianceName = dataPowerObject.getAppliance().getName();
            String domainName = dataPowerObject.getSourceDomain().getName();
            String objectType = dataPowerObject.getConfigObjectType();
            String objectName = dataPowerObject.getName();
            DynamicBean ci = new DynamicBean();
            ci.setProperty("appliance", dataPowerObject.getAppliance());
            ci.setProperty("domain", dataPowerObject.getSourceDomain());
            ci.setProperty("objectName", objectName);
            this.columnInfo[cn] = ci;
            columnNames[cn] = String.format("%s\n%s\n%s\n%s", applianceName, domainName, objectType, objectName);
            this.columnToObjectMap.put(columnNames[cn], dataPowerObject);
            ArrayList<String> propertyNames = BeanService.getPropertyNames(dataPowerObject);
            properties.addAll(propertyNames);
            for (String propertyName : propertyNames) {
                String displayName;
                XMLInfo xmlInfo = ConfigurationManager.getXMLInfo(dataPowerObject.getClass(), propertyName);
                String string = displayName = xmlInfo == null ? StringUtility.getDisplayableTitle(propertyName) : xmlInfo.displayValue();
                if (StringUtility.isEmpty(displayName)) {
                    displayName = StringUtility.getDisplayableTitle(propertyName);
                }
                propertyDisplayMap.put(propertyName, displayName);
            }
            ++cn;
        }
        properties.sort();
        Index<String, Integer> editableCells = new Index<String, Integer>();
        Index<String, Integer> requiredCells = new Index<String, Integer>();
        Index<String, Integer> urlTypeCells = new Index<String, Integer>();
        Index<Integer, Pair<Integer, Object>> enumeratedCells = new Index<Integer, Pair<Integer, Object>>();
        Index<Integer, Pair<Integer, String>> referenceCells = new Index<Integer, Pair<Integer, String>>();
        Index<Integer, Pair<Integer, Iterator<String>>> regexCells = new Index<Integer, Pair<Integer, Iterator<String>>>();
        Index<Integer, Pair<Integer, Object[]>> valueListCells = new Index<Integer, Pair<Integer, Object[]>>();
        Index<Integer, Pair<Integer, Pair<Integer, Long>>> rangeCells = new Index<Integer, Pair<Integer, Pair<Integer, Long>>>();
        Index<Integer, Pair<Integer, Pair<Integer, Integer>>> lengthCells = new Index<Integer, Pair<Integer, Pair<Integer, Integer>>>();
        ArrayList<DynamicBean> tableData = new ArrayList<DynamicBean>(properties.size());
        int row = -1;
        for (String propertyName : properties) {
            if (propertyName.equals("appliance") || propertyName.equals("sourceDomain") || propertyName.equals("name") || propertyName.equals("status") || propertyName.equals("fQON")) continue;
            ++row;
            String displayPropertyName = (String)propertyDisplayMap.get(propertyName);
            this.propertyNameMap.put(displayPropertyName, propertyName);
            DynamicBean objectBean = new DynamicBean();
            objectBean.setProperty("propertyName", displayPropertyName);
            cn = 1;
            for (DataPowerConfig object : dataPowerObjects) {
                Object value = null;
                boolean isEnumeration = false;
                String enumerationName = null;
                boolean isURL = false;
                boolean isReference = false;
                String referencedType = "";
                validationRegexp = ".*";
                Object[] allowedValues = new String[]{};
                int numericalMinimum = -1;
                long numericalMaximum = -1L;
                int minimumLength = -1;
                int maximumLength = -1;
                if (BeanService.hasProperty(object, propertyName)) {
                    Method propertyAccessor;
                    XMLInfo xmlInfo;
                    if (JMDialog.applicationLogger != null) {
                        JMDialog.applicationLogger.finer(() -> LMG.log("(dataPowerObjects):  Getting accessor for property %s.%s", () -> object.getClass().getName(), () -> propertyName));
                    }
                    if ((xmlInfo = (XMLInfo)BeanService.getMethodAnnotation(propertyAccessor = BeanService.getPropertyAccessor(object, propertyName), XMLInfo.class)) != null) {
                        String dataPowerType;
                        if (JMDialog.applicationLogger != null) {
                            JMDialog.applicationLogger.finer(() -> LMG.log("(dataPowerObjects):  Property %s.%s XML Info=%s", () -> object.getClass().getName(), () -> propertyName, () -> xmlInfo));
                        }
                        validationRegexp = xmlInfo.validationRegex();
                        allowedValues = xmlInfo.allowedValues();
                        numericalMinimum = xmlInfo.minimum();
                        numericalMaximum = xmlInfo.maximum();
                        minimumLength = xmlInfo.minimumLength();
                        maximumLength = xmlInfo.maximumLength();
                        isEnumeration = xmlInfo.isEnumeration();
                        if (isEnumeration) {
                            enumerationName = xmlInfo.dataPowerType();
                        }
                        if ((dataPowerType = xmlInfo.dataPowerType()).equals("dmURL") || dataPowerType.equals("dmFSFile")) {
                            isURL = true;
                        } else if (dataPowerType.equals("dmReference")) {
                            isReference = true;
                            referencedType = xmlInfo.refType();
                        }
                    } else if (JMDialog.applicationLogger != null) {
                        JMDialog.applicationLogger.info(() -> LMG.log("(dataPowerObjects): xmlInfo is null for %s.%s", () -> object.getClass().getName(), () -> propertyName));
                    }
                    value = BeanService.getPropertyValue(object, propertyName);
                    if (value == null) {
                        value = CompareObjectsDialog.getDefaultValue(object, propertyName);
                    }
                }
                if (value != null) {
                    if (value instanceof ObjectReference) {
                        ObjectReference objectReference = (ObjectReference)value;
                        value = objectReference.getName();
                    } else if (value instanceof ArrayList) {
                        ArrayList values = (ArrayList)value;
                        StringBuilder sb = new StringBuilder("<br/><span style=\"color: yellow; font: italic 8px; margin: 5px\">(Edit using the 'Manage...' popup menu items.)</span><br/><br/>");
                        for (Object v : values) {
                            if (sb.length() > 12) {
                                sb.append("<br/>");
                            }
                            if (v instanceof ObjectReference) {
                                ObjectReference objectReference = (ObjectReference)v;
                                v = objectReference.getName();
                            } else if (v instanceof JMBean) {
                                v = CompareObjectsDialog.buildBeanCellValue(v);
                                v = String.valueOf(v) + "<br/>";
                            }
                            sb.append(v.toString());
                        }
                        value = LabelUtility.wrapInHTML(sb.toString());
                    } else if (value instanceof JMBean) {
                        value = LabelUtility.wrapInHTML(CompareObjectsDialog.buildBeanCellValue(value));
                    }
                }
                if (this.isEditableProperty(object, propertyName, value)) {
                    editableCells.put(columnNames[cn], row);
                    requiredCells.put(columnNames[cn], row);
                    if (isURL) {
                        urlTypeCells.put(columnNames[cn], row);
                    }
                    if (isEnumeration) {
                        enumeratedCells.put(Integer.valueOf(cn), new Pair<Integer, Object>(row, enumerationName));
                    }
                    if (isReference) {
                        referenceCells.put(Integer.valueOf(cn), new Pair<Integer, String>(row, referencedType));
                    }
                    if (!isReference && StringUtility.isNotEmpty(validationRegexp)) {
                        regexCells.put(Integer.valueOf(cn), new Pair<Integer, Iterator<String>>(row, validationRegexp));
                    }
                    if (!ArrayUtility.isEmpty(allowedValues)) {
                        valueListCells.put(Integer.valueOf(cn), new Pair<Integer, Object[]>(row, allowedValues));
                    }
                    if (minimumLength > 0 || maximumLength < Integer.MAX_VALUE) {
                        lengthCells.put(Integer.valueOf(cn), new Pair<Integer, Pair<Integer, Integer>>(row, new Pair<Integer, Integer>(minimumLength, maximumLength)));
                    }
                    if (numericalMinimum > 0 || numericalMaximum < Integer.MAX_VALUE) {
                        rangeCells.put(Integer.valueOf(cn), new Pair<Integer, Pair<Integer, Long>>(row, new Pair<Integer, Long>(numericalMinimum, numericalMaximum)));
                    }
                }
                if (value == null) {
                    value = new NotApplicable();
                }
                objectBean.setProperty(columnNames[cn++], value);
            }
            tableData.add(objectBean);
        }
        this.tableModel = new DynamicBeanTableModel();
        this.tableModel.addTableModelListener(this);
        this.columnModel = new DynamicBeanColumnModel(this.tableModel);
        this.tableModel.addAll(tableData);
        this.columnModel.setColumnOrder(columnNames);
        for (String propertyName : editableCells.getKeys()) {
            editableRows = editableCells.get(propertyName);
            int editableColumn = this.tableModel.getColumnIndex(propertyName);
            Iterator<Object> iterator = editableRows.iterator();
            while (iterator.hasNext()) {
                int editableRow = (Integer)iterator.next();
                this.tableModel.setCellEditable(editableRow, editableColumn);
            }
        }
        Index<String, String> editorFiles = new Index<String, String>();
        for (String propertyName : urlTypeCells.getKeys()) {
            Collection requiredRows = requiredCells.get(propertyName);
            Collection editableRows2 = urlTypeCells.get(propertyName);
            int editableColumn = this.columnModel.getColumnIndex(propertyName);
            DynamicBean columnData = this.columnInfo[editableColumn];
            Appliance appliance = (Appliance)columnData.getProperty("appliance");
            Domain domain = (Domain)columnData.getProperty("domain");
            String editorFilesKey = String.format("%s-%s", appliance.getName(), domain.getName());
            ArrayList<String> domainFiles = (ArrayList<String>)editorFiles.get(editorFilesKey);
            if (domainFiles == null) {
                domainFiles = DataPowerFileUtility.getDomainFiles(appliance, domain);
                for (String domainFile : domainFiles) {
                    editorFiles.put(editorFilesKey, domainFile);
                }
            }
            validationRegexp = editableRows2.iterator();
            while (validationRegexp.hasNext()) {
                int editableRow = (Integer)((Object)validationRegexp.next());
                ArrayList<String> dropDownList = new ArrayList<String>(domainFiles);
                if (requiredRows == null || !requiredRows.contains(editableRow)) {
                    dropDownList.add(0, "");
                }
                DPFileTableCellEditor cellEditor = new DPFileTableCellEditor(dropDownList);
                this.columnModel.setEditor(editableRow, editableColumn, cellEditor);
            }
        }
        editableRows = enumeratedCells.getKeys().iterator();
        while (editableRows.hasNext()) {
            int columnNumber = (Integer)editableRows.next();
            Collection enumeratedRows = enumeratedCells.get(columnNumber);
            for (Object enumeratedRow : enumeratedRows) {
                DPEnumerationTableCellEditor cellEditor = new DPEnumerationTableCellEditor((String)((Pair)enumeratedRow).second);
                this.columnModel.setEditor((Integer)((Pair)enumeratedRow).first, columnNumber, cellEditor);
            }
        }
        if (referenceCells.size() > 0) {
            Object enumeratedRow;
            while (CollectionUtility.isEmpty(this.allObjects)) {
                ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
            }
            BeanComparator statusSorter = new BeanComparator("name");
            objectMap = DataStructureUtility.mapByApplianceDomain(this.allObjects);
            enumeratedRow = referenceCells.getKeys().iterator();
            while (enumeratedRow.hasNext()) {
                int columnNumber = (Integer)enumeratedRow.next();
                Collection referenceRows = referenceCells.get(columnNumber);
                String propertyName = this.columnModel.getColumnName(columnNumber);
                Collection requiredRows = requiredCells.get(propertyName);
                for (Object referenceRow : referenceRows) {
                    int refRow = (Integer)((Pair)referenceRow).first;
                    String objectType = (String)((Pair)referenceRow).second;
                    DynamicBean ci = this.columnInfo[columnNumber];
                    Appliance appliance = (Appliance)ci.getProperty("appliance");
                    Domain domain = (Domain)ci.getProperty("domain");
                    Index objectsByAppliance = (Index)((HashMap)objectMap).get(appliance);
                    Collection<StatusObjectStatus> objectsByDomain = objectsByAppliance.get(domain);
                    HashMap<String, Index<String, StatusObjectStatus>> mapByTypeName = DataStructureUtility.mapByTypeAndName(objectsByDomain);
                    Index<String, StatusObjectStatus> objectsByType = mapByTypeName.get(objectType);
                    ArrayList<StatusObjectStatus> objectsForEditor = null;
                    if (!CollectionUtility.isEmpty(objectsByType)) {
                        objectsForEditor = (ArrayList<StatusObjectStatus>)objectsByType.getValues();
                        if (requiredRows == null || !requiredRows.contains(refRow)) {
                            StatusObjectStatus blankObject = new StatusObjectStatus();
                            blankObject.setAppliance(appliance);
                            blankObject.setSourceDomain(domain);
                            blankObject.setAdminState("enabled");
                            blankObject.setDataPowerClass(objectType);
                            blankObject.setName("");
                            objectsForEditor.add(blankObject);
                        }
                        Collections.sort(objectsForEditor, statusSorter);
                    } else {
                        objectsForEditor = new ArrayList<StatusObjectStatus>();
                    }
                    DPObjectListTableCellEditor cellEditor = new DPObjectListTableCellEditor(objectsForEditor);
                    this.columnModel.setEditor(refRow, columnNumber, cellEditor);
                }
            }
        }
        objectMap = valueListCells.getKeys().iterator();
        while (objectMap.hasNext()) {
            int columnNumber = (Integer)objectMap.next();
            Collection valueListRows = valueListCells.get(columnNumber);
            stringsForEditor = new ArrayList();
            String propertyName = this.columnModel.getColumnName(columnNumber);
            Collection requiredRows = requiredCells.get(propertyName);
            for (Pair referenceRow : valueListRows) {
                int refRow = (Integer)referenceRow.first;
                String[] valuesList = (String[])referenceRow.second;
                ((ArrayList)((Object)stringsForEditor)).addAll(Arrays.asList(valuesList));
                if (requiredRows == null || !requiredRows.contains(refRow)) {
                    ((ArrayList)((Object)stringsForEditor)).add((String)"");
                }
                Collections.sort(stringsForEditor);
                StringOptionsTableCellEditor cellEditor = new StringOptionsTableCellEditor((Collection<String>)((Object)stringsForEditor));
                this.columnModel.setEditor(refRow, columnNumber, cellEditor);
            }
        }
        this.table = new JMTable(this.tableModel, this.columnModel);
        NotApplicableTableCellRenderer naRenderer = new NotApplicableTableCellRenderer();
        this.columnModel.setRenderer(NotApplicable.class, (TableCellRenderer)naRenderer);
        HighlightDifferenceModifyingTableCellRenderer diffRenderer = new HighlightDifferenceModifyingTableCellRenderer(new Color(111, 38, 61));
        this.columnModel.addModifyingRenderer(diffRenderer);
        stringsForEditor = regexCells.getKeys().iterator();
        while (stringsForEditor.hasNext()) {
            int columnNumber = (Integer)stringsForEditor.next();
            Collection regexRows = regexCells.get(columnNumber);
            for (Pair regexRow : regexRows) {
                int refRow = (Integer)regexRow.first;
                String regexp = (String)regexRow.second;
                RegularExpressionValidator validator = new RegularExpressionValidator(regexp);
                TableCellEditorRenderer editor = (TableCellEditorRenderer)this.table.getCellEditor(row, columnNumber);
                editor.setValidator(refRow, columnNumber, validator);
            }
        }
        stringsForEditor = lengthCells.getKeys().iterator();
        while (stringsForEditor.hasNext()) {
            int columnNumber = (Integer)stringsForEditor.next();
            Collection lengthRows = lengthCells.get(columnNumber);
            for (Pair lengthRow : lengthRows) {
                int refRow = (Integer)lengthRow.first;
                Pair lengthRestrictions = (Pair)lengthRow.second;
                StringLengthValidator validator = new StringLengthValidator((Integer)lengthRestrictions.first, (Integer)lengthRestrictions.second);
                TableCellEditorRenderer editor = (TableCellEditorRenderer)this.table.getCellEditor(row, columnNumber);
                editor.setValidator(refRow, columnNumber, validator);
            }
        }
        stringsForEditor = rangeCells.getKeys().iterator();
        while (stringsForEditor.hasNext()) {
            int columnNumber = (Integer)stringsForEditor.next();
            Collection rangeRows = rangeCells.get(columnNumber);
            for (Pair rangleRow : rangeRows) {
                int refRow = (Integer)rangleRow.first;
                Pair range = (Pair)rangleRow.second;
                NumericalRangeValidator validator = new NumericalRangeValidator((Number)range.first, (Number)range.second);
                TableCellEditorRenderer editor = (TableCellEditorRenderer)this.table.getCellEditor(row, columnNumber);
                editor.setValidator(refRow, columnNumber, validator);
            }
        }
        this.table.getTableHeader().setDefaultRenderer(new MultiLineTableHeaderRenderer(this.table));
        this.table.setMinimumColumnWidth(100);
        this.table.optimizeColumnWidths();
        this.table.optimizeRowHeights();
        this.scrollPane = new JMScrollPane(this.table);
        this.contentPane.add((Component)this.scrollPane, "Center");
        Dimension tableSize = this.table.getPreferredSize();
        int width = tableSize.width + 25;
        int height = tableSize.height + 122;
        if (width > 1880) {
            width = 1880;
        } else if (width < 400) {
            width = 400;
        }
        if (height > 1000) {
            height = 1000;
        } else if (height < 400) {
            height = 400;
        }
        this.setPreferredSize(new Dimension(width, height));
        this.setSize(width, height);
    }

    private static Object getDefaultValue(DataPowerConfig object, String propertyName) {
        Method propertyAccessor = BeanService.getPropertyAccessor(object, propertyName);
        XMLInfo xmlInfo = (XMLInfo)BeanService.getMethodAnnotation(propertyAccessor, XMLInfo.class);
        int multiplicity = -1;
        String javaType = "";
        String defaultValue = "";
        String dataPowerType = "String";
        if (xmlInfo == null) {
            Class<?> type = BeanService.getPropertyType(object, propertyName);
            javaType = type.getSimpleName();
            if (javaType.equals("ArrayList")) {
                multiplicity = 2;
            } else if (javaType.equals("ObjectReference")) {
                dataPowerType = "dmReference";
            } else if (Comparison.isIn(javaType, NUMERICAL_TYPES)) {
                dataPowerType = "int";
            }
        } else {
            multiplicity = xmlInfo.multiplicity();
            javaType = xmlInfo.javaType();
            defaultValue = xmlInfo.defaultValue();
            dataPowerType = xmlInfo.dataPowerType();
        }
        if (multiplicity > 1) {
            return null;
        }
        switch (javaType) {
            case "String": {
                if (StringUtility.isNotEmpty(defaultValue)) {
                    return defaultValue;
                }
                if (dataPowerType.equals("dmToggle")) {
                    return "off";
                }
                return "";
            }
            case "long": {
                if (StringUtility.isNotEmpty(defaultValue)) {
                    return Long.parseLong(defaultValue);
                }
                return 0L;
            }
            case "int": {
                if (StringUtility.isNotEmpty(defaultValue)) {
                    return Integer.parseInt(defaultValue);
                }
                return 0;
            }
        }
        if (dataPowerType.equals("dmReference")) {
            return "";
        }
        return null;
    }

    private static String buildBeanCellValue(Object value) {
        ArrayList<String> beanProperties = BeanService.getPropertyNames(value);
        StringBuilder sb = new StringBuilder();
        for (String beanProperty : beanProperties) {
            Object beanPropertyValue;
            if (sb.length() > 0) {
                sb.append("<br/>");
            }
            if ((beanPropertyValue = BeanService.getPropertyValue(value, beanProperty)) == null) {
                beanPropertyValue = "";
            }
            sb.append(String.format("%s=%s", beanProperty, beanPropertyValue.toString()));
        }
        return sb.toString();
    }

    private void buildCertificateCompare(ArrayList<CertificateInformation> certificates) {
        this.certificateComparePanel = new ScrollablePanel(new GridLayout(1, certificates.size(), 10, 10));
        this.certificateComparePanel.setAutoResize(false);
        ScrollSynchronizer scrollSynchronizer = new ScrollSynchronizer();
        for (CertificateInformation certificate : certificates) {
            DisplayCertificateInfoPanel certInfoPanel = new DisplayCertificateInfoPanel(certificate);
            JMScrollPane cipScrollPane = certInfoPanel.getScrollPane();
            scrollSynchronizer.addScrollPane(cipScrollPane);
            this.certificateComparePanel.add(certInfoPanel);
        }
        this.scrollPane = new JMScrollPane(this.certificateComparePanel);
        this.contentPane.add(this.scrollPane);
        int width = certificates.size() * 600;
        if (width > 1880) {
            width = 1880;
        }
        this.setPreferredSize(new Dimension(width, 600));
        this.setSize(width, 600);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        Logger logger = Application.getApplication().getApplicationLogger();
        logger.finer("(TableModelEvent e): Starting");
        if (e.getType() != 0) {
            logger.finer("(TableModelEvent e): Model event is not UPDATE.  Ignoring event.");
            return;
        }
        int row = e.getFirstRow();
        int column = e.getColumn();
        if (row < 0 || column < 0) {
            logger.finer(() -> LMG.log("(TableModelEvent e):  Row is %d.  Column is %d.  Ignoring Event.", () -> row, () -> column));
            return;
        }
        ExtendedTableModelEvent ee = (ExtendedTableModelEvent)e;
        Object newValue = ee.getNewValue();
        Object oldValue = ee.getOldValue();
        logger.finer(() -> LMG.log("(TableModelEvent e):  Old and new values in row %d, col %d are:  Old -> '%s', New -> '%s'", () -> row, () -> column, () -> oldValue, () -> newValue));
        boolean areEqual = BeanService.areEqual(newValue, oldValue);
        logger.finer(() -> LMG.log("(TableModelEvent e):  Last Row: %d, Row: %d.  Last Column: %d, Column: %d.  Are equal: %b.", () -> this.lastRow, () -> row, () -> this.lastCol, () -> column, () -> areEqual));
        if (this.lastRow == row && this.lastCol == column && !areEqual && this.cbxSynchronizeChanges.isSelected()) {
            logger.finer(() -> LMG.log("(TableModelEvent e):  Values in row %d, col %d ('%s' != '%s') are not equal and synchronization is on.  Syncrhonizing.", () -> row, () -> column, () -> oldValue, () -> newValue));
            int columnCount = this.tableModel.getColumnCount();
            int c = 0;
            while (c < columnCount) {
                if (c != column && !this.tableModel.getColumnName(c).equals("propertyName")) {
                    logger.finer(() -> LMG.log("(TableModelEvent e):  Synchronizing the value '%s' to row %d, col %d.", () -> newValue, () -> row, () -> column));
                    this.tableModel.setValueAt(newValue, row, c);
                }
                ++c;
            }
        }
        this.lastRow = row;
        this.lastCol = column;
        logger.finer(() -> LMG.log("(TableModelEvent e): Last Row = %d, Last Col: %d.  Done.", () -> this.lastRow, () -> this.lastCol));
    }

    @Reflected
    private void fileSave() {
        Logger logger = Application.getApplication().getApplicationLogger();
        logger.finer("(): Starting");
        this.table.commitEdits();
        int columnCount = this.tableModel.getColumnCount();
        int rowCount = this.tableModel.getRowCount();
        logger.finer(() -> LMG.log("(): Found %d rows and %d columns.", () -> rowCount, () -> columnCount));
        int propertyNameColumn = 0;
        int column = 0;
        while (column < columnCount) {
            String columnName = this.tableModel.getColumnName(column);
            if (columnName.equals("propertyName")) {
                propertyNameColumn = column;
                break;
            }
            ++column;
        }
        int logColumn = propertyNameColumn;
        logger.finer(() -> LMG.log("(): Property Name Column: %d.  Processing data in columns.", () -> logColumn));
        int column2 = 0;
        while (column2 < columnCount) {
            block28: {
                if (column2 == propertyNameColumn) break block28;
                String columnName = this.tableModel.getColumnName(column2);
                DataPowerConfig object = this.columnToObjectMap.get(columnName);
                boolean modified = false;
                int lColumn = column2;
                logger.finer(() -> LMG.log("(): Processing Column: %d - %s", () -> lColumn, () -> columnName));
                int row = 0;
                while (row < rowCount) {
                    block30: {
                        Object pv;
                        String referencedType;
                        boolean isReference;
                        Comparable propertyValue;
                        Object originalValue;
                        String propertyName;
                        block31: {
                            String propertyDisplayName;
                            block29: {
                                propertyDisplayName = (String)this.tableModel.getValueAt(row, propertyNameColumn);
                                propertyName = this.propertyNameMap.get(propertyDisplayName);
                                if (BeanService.hasProperty(object, propertyName)) break block29;
                                logger.finer(() -> LMG.log("(): Property '%s' doesn't exist for '%s'.  Skipping.", () -> propertyName, () -> object.getClass().getName()));
                                break block30;
                            }
                            originalValue = BeanService.getPropertyValue(object, propertyName);
                            String originalValueClass = originalValue == null ? "" : originalValue.getClass().getSimpleName();
                            int r = row;
                            logger.finer(() -> LMG.log("(): Row: %d", () -> r));
                            logger.finer(() -> LMG.log("(): Property Display Name: %s", () -> propertyDisplayName));
                            logger.finer(() -> LMG.log("(): Property Name: %s", () -> propertyName));
                            logger.finer(() -> LMG.log("(): Original Value: %s", () -> String.valueOf(originalValue)));
                            logger.finer(() -> LMG.log("(): Original Value Class: %s", () -> originalValueClass));
                            if (!this.isEditableProperty(object, propertyName, originalValue)) break block30;
                            logger.finer(() -> LMG.log("(): Property %s is editable", () -> propertyName));
                            propertyValue = this.tableModel.getValueAt(row, column2);
                            Method propertyAccessor = BeanService.getPropertyAccessor(object, propertyName);
                            XMLInfo xmlInfo = (XMLInfo)BeanService.getMethodAnnotation(propertyAccessor, XMLInfo.class);
                            String javaType = "String";
                            isReference = false;
                            referencedType = null;
                            if (xmlInfo != null) {
                                javaType = xmlInfo.javaType();
                                String dataPowerType = xmlInfo.dataPowerType();
                                if (dataPowerType.equals("dmReference")) {
                                    isReference = true;
                                    referencedType = xmlInfo.refType();
                                }
                            }
                            if (!javaType.equals("long") && !javaType.equals("int")) break block31;
                            pv = (Number)((Object)propertyValue);
                            logger.finer(() -> CompareObjectsDialog.lambda$59((Number)pv));
                            switch (originalValueClass) {
                                case "Integer": {
                                    propertyValue = ((Number)pv).intValue();
                                    break;
                                }
                                case "Long": {
                                    propertyValue = ((Number)pv).longValue();
                                    break;
                                }
                                case "Float": {
                                    propertyValue = Float.valueOf(((Number)pv).floatValue());
                                    break;
                                }
                                case "Double": {
                                    propertyValue = ((Number)pv).doubleValue();
                                }
                            }
                        }
                        if (isReference) {
                            ObjectReference objectReference = new ObjectReference();
                            objectReference.setClassName(referencedType);
                            objectReference.setName((String)((Object)propertyValue));
                            propertyValue = objectReference;
                        }
                        if (!BeanService.areEqual(originalValue, propertyValue)) {
                            pv = propertyValue;
                            logger.config(() -> LMG.log("(): ColumnName=%s:  Property %s will be set to %s in %s %s within the %s domain of %s", () -> columnName, () -> propertyName, () -> String.valueOf(pv), () -> object.getConfigObjectType(), () -> object.getName(), () -> object.getSourceDomain().getName(), () -> object.getAppliance().getName()));
                            modified = true;
                            BeanService.setPropertyValue(object, propertyName, propertyValue);
                        }
                    }
                    ++row;
                }
                if (modified) {
                    logger.config(() -> LMG.log("(): Invoking ModifyTool for %s -> %s for %s -> %s", () -> object.getAppliance().getName(), () -> object.getSourceDomain().getName(), () -> object.getConfigObjectType(), () -> object.getName()));
                    if (this.commandResultsDialog == null) {
                        this.commandResultsDialog = new CommandResultsDialog((JDialog)this, "Saving Configurations");
                    }
                    ModifyTool modifyTool = new ModifyTool(object.getAppliance(), object.getSourceDomain(), object);
                    modifyTool.addManagementCommandSubscriber(this.commandResultsDialog);
                }
            }
            ++column2;
        }
        logger.fine("(): Clearing the cache");
        Index<Appliance, Domain> selectedDomains = ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection();
        ConfigurationManager.clearCache(selectedDomains);
        if (this.commandResultsDialog != null) {
            this.commandResultsDialog.waitingToClose();
            while (this.commandResultsDialog.isShowing()) {
                ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
            }
            this.commandResultsDialog.dispose();
            this.commandResultsDialog = null;
        }
        logger.fine("(): Done");
    }

    private boolean isEditableProperty(DataPowerConfig dpConfig, String propertyName, Object propertyValue) {
        block23: {
            String javaType;
            if (!this.isEditable) {
                return false;
            }
            if (dpConfig.getIsReadOnly()) {
                return false;
            }
            if (Comparison.isIn(propertyName, NON_EDITABLE_PROPERTIES)) break block23;
            if (!BeanService.hasProperty(dpConfig, propertyName)) {
                return false;
            }
            Class<?> propertyType = BeanService.getPropertyType(dpConfig, propertyName);
            switch (javaType = propertyType.getSimpleName()) {
                case "ObjectReference": 
                case "String": 
                case "Integer": 
                case "Long": 
                case "Boolean": 
                case "Double": {
                    return true;
                }
                case "ArrayList": {
                    return false;
                }
            }
            JMDialog.applicationLogger.info(() -> LMG.log("(dpConfig=%s, propertyName=%s, propertyValue): Should this be editable", () -> dpConfig.getConfigObjectType(), () -> propertyName));
        }
        return false;
    }

    @Reflected
    private void resizeObjectTable() {
        JMDialog.applicationLogger.finer("():  Starting");
        int scrollPaneWidth = this.scrollPane.getWidth();
        int vScrollBarWidth = this.scrollPane.getVerticalScrollBar().getWidth();
        int viewPortWidth = scrollPaneWidth - vScrollBarWidth;
        int columnCount = this.table.getColumnCount();
        int propertyColumnWidth = this.columnModel.getColumn(0).getWidth();
        JMDialog.applicationLogger.finer(() -> LMG.log("():  New Table Width: %d, Column Count: %d, Property Column Width: %d", () -> viewPortWidth, () -> columnCount, () -> propertyColumnWidth));
        int desiredTableWidth = propertyColumnWidth;
        int c = 1;
        while (c < columnCount) {
            TableColumn column = this.columnModel.getColumn(c);
            int minimumColumnWidth = column.getMinWidth();
            int columnWidth = Math.max(column.getWidth(), minimumColumnWidth);
            desiredTableWidth += columnWidth;
            int columnIndex = c;
            JMDialog.applicationLogger.finer(() -> LMG.log("():  Column %d Width: %d, Adjusting to %d", () -> columnIndex, () -> column.getWidth(), () -> columnWidth));
            this.columnModel.setColumnWidth(c, columnWidth);
            ++c;
        }
        this.table.setWidth(desiredTableWidth);
        JMDialog.applicationLogger.finer("():  Done");
    }

    @Reflected
    private void resizeCertificatePanels() {
        JMDialog.applicationLogger.finest("():  Starting");
        int scrollPaneWidth = this.scrollPane.getWidth();
        int scrollPaneHeight = this.scrollPane.getHeight();
        int vScrollBarWidth = this.scrollPane.getVerticalScrollBar().getWidth();
        int hScrollBarHeight = this.scrollPane.getHorizontalScrollBar().getHeight();
        int viewPortWidth = scrollPaneWidth - vScrollBarWidth;
        int viewPortHeight = scrollPaneHeight - hScrollBarHeight;
        JMDialog.applicationLogger.finest(() -> LMG.log("():  Scroll Pane Width: %d, Scroll Pane Height: %d, Scroll Bar Width: %d, Scroll Bar Height: %d, View Port Width: %d, View Port Height: %d", () -> scrollPaneWidth, () -> scrollPaneHeight, () -> vScrollBarWidth, () -> hScrollBarHeight, () -> viewPortWidth, () -> viewPortHeight));
        this.certificateComparePanel.setSize(viewPortWidth, viewPortHeight);
        this.certificateComparePanel.setPreferredSize(viewPortWidth, viewPortHeight);
        this.certificateComparePanel.revalidate();
        JMDialog.applicationLogger.finest("():  Done");
    }

    private static /* synthetic */ String lambda$59(Number number) {
        return LMG.log("(): Original Value is a number: %d", () -> number.longValue());
    }
}

