/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs;

import com.jmorgan.swing.JMDialog;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.util.ScrollSynchronizer;
import com.kumbasoft.core.beans.ConfigurationRelationship;
import com.kumbasoft.core.beans.ConfigurationRelationshipType;
import com.kumbasoft.core.beans.DataPowerObject;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.dpaa.ui.panels.configurations.ConfigurationRelationshipGraphPanel;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.JFrame;

public class ConfigurationRelationshipDialog
extends JMDialog {
    public static final String DIALOG_TITLE = "Show Object References";
    private int objectCount;

    public ConfigurationRelationshipDialog(JFrame owner, Object ... arguments) {
        super(owner, String.format("%s (Please Wait - This can take a while)", DIALOG_TITLE), arguments);
    }

    @Override
    public void buildGUI(Object ... arguments) {
        ArrayList selectedObjects = (ArrayList)arguments[0];
        ConfigurationRelationshipType relationshipType = (ConfigurationRelationshipType)((Object)arguments[1]);
        this.objectCount = selectedObjects.size();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridLayout(1, this.objectCount, 10, 1));
        ScrollSynchronizer scrollSynchronizer = new ScrollSynchronizer();
        for (DataPowerObject configObject : selectedObjects) {
            ConfigurationRelationship configurationRelationship = new ConfigurationRelationship(configObject, relationshipType);
            ConfigurationRelationshipGraphPanel graphPanel = new ConfigurationRelationshipGraphPanel(configurationRelationship);
            JMScrollPane scrollPane = new JMScrollPane(graphPanel);
            contentPane.add(scrollPane);
            scrollSynchronizer.addScrollPane(scrollPane);
        }
        this.setPreferredSize(new Dimension(this.computeWidth(), 600));
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
    }

    private int computeWidth() {
        int width = 500 * this.objectCount;
        if (width > 1500) {
            width = 1500;
        }
        return width;
    }
}

