/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.copymoveWizard;

import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.lang.Application;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.CopyMoveFilesBean;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.dpaa.ui.dialogs.copymoveWizard.CopyMoveFilesEditBean;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;

public class CopyMoveDirectoriesFinalEditPage
extends KumbaCoreWizardPage<CopyMoveFilesBean> {
    private BeanTableModel<CopyMoveFilesEditBean> tableModel;
    private BeanColumnModel<CopyMoveFilesEditBean> columnModel;
    private JMTable table;

    public CopyMoveDirectoriesFinalEditPage(CopyMoveFilesBean model) {
        super(model);
    }

    public CopyMoveDirectoriesFinalEditPage(CopyMoveFilesBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Override
    protected void saveDataToModel() {
        Application application = Application.getApplication();
        String app = String.valueOf(application);
        ConcurrentHashMap<Object, Object> attributes = application.getAttributes();
        String thisAttributes = attributes.getClass().getSimpleName() + "@" + Integer.toHexString(attributes.hashCode());
        KumbaCoreWizardPage.logger.finer(() -> LMG.log("(): Getting appliances from app %s, attributes=%s", () -> app, () -> thisAttributes));
        ArrayList appliances = (ArrayList)application.getAttribute("Appliances");
        BeanIndexer nameIndexer = new BeanIndexer(appliances);
        Index nameIndex = nameIndexer.getIndexOf("name", null);
        ArrayList sourceFiles = ((CopyMoveFilesBean)this.model).getObjects();
        this.table.commitEdits();
        ArrayList<CopyMoveFilesEditBean> destinations = this.tableModel.getModelData();
        for (DataPowerFileInfo sourceFile : sourceFiles) {
            String sourceAbsolutePath = sourceFile.getBaseDirectory();
            for (CopyMoveFilesEditBean destination : destinations) {
                String destSourceFileName = destination.getSourceFileName();
                if (!sourceFile.getAppliance().getName().equals(destination.getSourceAppliance()) || !sourceFile.getSourceDomain().getName().equals(destination.getSourceDomain()) || !sourceAbsolutePath.equals(destSourceFileName)) continue;
                String destApplianceName = destination.getTargetAppliance();
                String destDomainName = destination.getTargetDomain();
                String destDirectory = destination.getTargetDirectory();
                Appliance destAppliance = (Appliance)nameIndex.get(destApplianceName, 0);
                Domain domain = destAppliance.getDomain(destDomainName, true);
                DataPowerFileInfo targetFile = new DataPowerFileInfo(destAppliance, domain, null, 0L, destDirectory, "");
                ((CopyMoveFilesBean)this.model).addDestinationName(sourceFile, targetFile);
            }
        }
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createBorderLayout());
        int mode = ((CopyMoveFilesBean)this.model).getMode();
        String labelText = (mode == 0 ? "Copy" : "Move") + " Directories";
        this.tableModel = new BeanTableModel<CopyMoveFilesEditBean>(CopyMoveFilesEditBean.class);
        this.tableModel.setEditableColumns("targetDirectory");
        this.columnModel = new BeanColumnModel<CopyMoveFilesEditBean>(this.tableModel);
        this.columnModel.hideColumn("targetFileName");
        this.columnModel.setColumnOrder("sourceAppliance", "sourceDomain", "sourceFileName", "targetAppliance", "targetDomain", "targetDirectory");
        this.columnModel.setColumnTitle("sourceFileName", "Directory to " + labelText);
        this.table = new JMTable(this.tableModel, this.columnModel);
        JMScrollPane scrollPane = new JMScrollPane(this.table);
        LabeledComponent cpLabel = new LabeledComponent(labelText, (Component)scrollPane, 1);
        panel.add((Component)cpLabel, "Center");
        return panel;
    }

    @Override
    protected void updateControls() {
        this.tableModel.reset(false);
        ArrayList sourceFiles = ((CopyMoveFilesBean)this.model).getObjects();
        ArrayList<Appliance> destAppliances = ((CopyMoveFilesBean)this.model).getDestinationAppliances();
        ArrayList<String> destDomains = ((CopyMoveFilesBean)this.model).getDestinationDomains();
        boolean duplicateSourceDirectories = ((CopyMoveFilesBean)this.model).duplicateSourceDirectories();
        HashMap<Domain, String> destDirectories = ((CopyMoveFilesBean)this.model).getDestinationDirectories();
        for (DataPowerFileInfo sourceFile : sourceFiles) {
            String sourceAppliance = sourceFile.getAppliance().getName();
            String sourceDomain = sourceFile.getSourceDomain().getName();
            String sourceBaseDirectory = sourceFile.getBaseDirectory();
            String sourceDirectory = StringUtility.substringAfter(sourceBaseDirectory, "/");
            for (Appliance appliance : destAppliances) {
                String destApplianceName = appliance.getName();
                for (String destDomainName : destDomains) {
                    Domain domain = appliance.getDomain(destDomainName, true);
                    if (domain == null) continue;
                    if (duplicateSourceDirectories) {
                        String destDirectory = sourceFile.getBaseDirectory();
                        String finalDirectory = String.format("%s/%s", destDirectory, sourceDirectory);
                        CopyMoveFilesEditBean sourceDestBean = new CopyMoveFilesEditBean(sourceAppliance, sourceDomain, sourceBaseDirectory, destApplianceName, destDomainName, finalDirectory, "");
                        this.tableModel.addRow(sourceDestBean);
                        continue;
                    }
                    for (Domain destDirDomain : destDirectories.keySet()) {
                        if (!destDirDomain.getName().equals(destDomainName)) continue;
                        String destDirectory = destDirectories.get(destDirDomain);
                        String finalDirectory = String.format("%s%s", destDirectory, sourceDirectory);
                        CopyMoveFilesEditBean sourceDestBean = new CopyMoveFilesEditBean(sourceAppliance, sourceDomain, sourceBaseDirectory, destApplianceName, destDomainName, finalDirectory, "");
                        this.tableModel.addRow(sourceDestBean);
                    }
                }
            }
        }
        this.table.optimizeColumnWidths();
    }
}

