/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.createValCredWizard;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.layout.OutlineLayout;
import com.jmorgan.util.Index;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.CertificateInformation;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.core.util.DataStructureUtility;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JSeparator;

public class NewValcredFromCertsReviewWizardPage
extends KumbaCoreWizardPage<DynamicBean> {
    public NewValcredFromCertsReviewWizardPage(DynamicBean model) {
        super(model);
    }

    public NewValcredFromCertsReviewWizardPage(DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    protected void saveDataToModel() {
    }

    @Override
    protected void updateControls() {
        ((KumbaCoreWizardPanel)this.controlsPanel).removeAll();
        ((KumbaCoreWizardPanel)this.controlsPanel).add(new JMLabel("The following validation credentials will be created when selecting 'Finish'"));
        JSeparator titleSeparator = new JSeparator();
        titleSeparator.setPreferredSize(new Dimension(600, 2));
        ((KumbaCoreWizardPanel)this.controlsPanel).add(titleSeparator);
        String valCredName = (String)((DynamicBean)this.model).getProperty("valCredName");
        ArrayList certificates = (ArrayList)((DynamicBean)this.model).getProperty("certificates");
        HashMap certsByAppliance = DataStructureUtility.mapByApplianceDomain(certificates);
        ((DynamicBean)this.model).setProperty("certsByAppliance", certsByAppliance);
        for (Appliance appliance : certsByAppliance.keySet()) {
            Index certsByDomain = certsByAppliance.get(appliance);
            for (Domain domain : certsByDomain.getKeys()) {
                JMPanel valCredPanel = NewValcredFromCertsReviewWizardPage.createApplianceDomainValcredInfo(appliance, domain, valCredName);
                ((KumbaCoreWizardPanel)this.controlsPanel).add(valCredPanel);
                ArrayList certs = (ArrayList)certsByDomain.get(domain);
                for (CertificateInformation cert : certs) {
                    ((KumbaCoreWizardPanel)this.controlsPanel).add((Component)new JMLabel("Certificate: " + cert.getCertificateObjectName()), (Object)valCredPanel);
                }
                JSeparator sectionSeparator = new JSeparator();
                sectionSeparator.setPreferredSize(new Dimension(600, 2));
                ((KumbaCoreWizardPanel)this.controlsPanel).add(sectionSeparator);
            }
        }
        ((KumbaCoreWizardPanel)this.controlsPanel).repaint();
    }

    private static JMPanel createApplianceDomainValcredInfo(Appliance appliance, Domain domain, String valCredName) {
        JMPanel panel = KumbaCoreUIConstants.createFlowLayoutPanel(0);
        String applianceName = appliance.getName();
        String domainName = domain.getName();
        JMLabel applianceLabel = new JMLabel("Appliance:" + applianceName);
        JMLabel domainLabel = new JMLabel("Domain: " + domainName);
        JMLabel valCredLabel = new JMLabel("Validation Credential: " + valCredName);
        panel.addAll(applianceLabel, domainLabel, valCredLabel);
        return panel;
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(new OutlineLayout(50, 10));
        return panel;
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }
}

