/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMComboBox;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.combobox.JMComboBoxModel;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.AbstractCryptoObjectWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.LoadCryptoObjectData;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.ComboBoxModel;
import javax.swing.JDialog;

public class CryptoObjectFromDPFileWizardPage
extends AbstractCryptoObjectWizardPage {
    private JMComboBoxModel<String> cbxModel;
    private JMComboBox<String> cbxDataPowerFiles;

    public CryptoObjectFromDPFileWizardPage(DynamicBean model, String helpFile) {
        super(model, helpFile);
    }

    @Override
    public boolean isDataValid() {
        if (!super.isDataValid()) {
            return false;
        }
        String selectedFile = (String)this.cbxDataPowerFiles.getSelectedItem();
        if (StringUtility.isEmpty(selectedFile)) {
            new JMMessageBox((JDialog)this.parentDialog, "No file selected", "Please select an on-board file.");
        }
        return true;
    }

    @Override
    protected void saveDataToModel() {
        super.saveDataToModel();
        String selectedFile = (String)this.cbxDataPowerFiles.getSelectedItem();
        ((DynamicBean)this.model).setProperty("localFile", selectedFile);
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = super.createControlsPanel();
        this.cbxModel = new JMComboBoxModel();
        this.cbxDataPowerFiles = new JMComboBox<String>((ComboBoxModel<String>)this.cbxModel);
        LabeledComponent lbl = new LabeledComponent("Data Files:", this.cbxDataPowerFiles);
        lbl.setPreferredSize(100, 25);
        panel.add((Component)lbl, 0);
        new AsynchMethodInvoker((Object)this, "waitForFiles");
        return panel;
    }

    @Reflected
    private void waitForFiles() {
        logger.finer("(): Starting");
        LoadCryptoObjectData dataLoader = (LoadCryptoObjectData)((DynamicBean)this.model).getProperty("dataLoader");
        Index<String, DataPowerFileInfo> dataPowerFiles = dataLoader.getDataPowerFiles();
        while (dataPowerFiles == null) {
            logger.finer("():  No DataPower Files Yet.");
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
            dataPowerFiles = dataLoader.getDataPowerFiles();
        }
        logger.finer("():  Got the datapower files.");
        ArrayList fileNames = (ArrayList)dataPowerFiles.getKeys();
        Collections.sort(fileNames);
        logger.finer(() -> LMG.log("():  Adding %d files to the combo box model.", () -> fileNames.size()));
        this.cbxModel.addAll(fileNames);
        logger.finer("(): Done");
    }
}

