/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.dialog.wizard.WizardDialog;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.CryptoObjectFromDPFileWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.CryptoObjectFromExternalFileWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.CryptoObjectFromURLWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.cryptoObjectWizards.LoadCryptoObjectData;
import javax.swing.JFrame;

public class UpdateCryptoObjectWizardDialog
extends WizardDialog<DynamicBean> {
    public UpdateCryptoObjectWizardDialog(JFrame owner, DynamicBean model, int objectType, String updateType) {
        super(owner, "Update Crypto Object File Reference");
        model.setProperty("dialog", this);
        model.setProperty("dataLoader", new LoadCryptoObjectData(model));
        model.setProperty("objectType", objectType);
        int sourceType = 0;
        String newTitle = switch (objectType) {
            case 0 -> {
                sourceType = 1;
                yield "Update Crypto Certificate";
            }
            case 1 -> {
                sourceType = 2;
                yield "Update Crypto Key";
            }
            case 2 -> {
                sourceType = 2;
                yield "Update Kerberos Keytab";
            }
            case 3 -> {
                sourceType = 3;
                yield "Update Shared Secret Key";
            }
            default -> "";
        };
        this.setTitle(newTitle);
        model.setProperty("sourcetype", sourceType);
        String helpFile = switch (updateType) {
            case "certFromLocalFile" -> "UpdateCryptoCertFromDPFilePage.html";
            case "certFromExternalFile" -> "UpdateCryptoCertFromExternalFilePage.html";
            case "certFromURL" -> "UpdateCryptoCertFromURLPage.html";
            case "keyFromLocalFile" -> {
                if (objectType == 1) {
                    yield "UpdateCryptoKeyFromDPFilePage.html";
                }
                if (objectType == 2) {
                    yield "UpdateKeyTabFromDPFilePage.html";
                }
                yield "UpdateShareSecretKeyFromDPFilePage.html";
            }
            case "keyFromExternalFile" -> {
                if (objectType == 1) {
                    yield "UpdateCryptoKeyFromExternalFilePage.html";
                }
                if (objectType == 2) {
                    yield "UpdateKeyTabFromExternalFilePage.html";
                }
                yield "UpdateSharedSecretKeyFromExternalFilePage.html";
            }
            default -> "";
        };
        CryptoObjectFromExternalFileWizardPage wizardPage = switch (updateType) {
            case "keyFromLocalFile", "certFromLocalFile" -> new CryptoObjectFromDPFileWizardPage(model, helpFile);
            case "keyFromExternalFile", "certFromExternalFile" -> new CryptoObjectFromExternalFileWizardPage(model, helpFile);
            case "certFromURL" -> new CryptoObjectFromURLWizardPage(model, helpFile);
            default -> null;
        };
        this.addWizardPage(wizardPage, "page");
        this.setSize(700, 460);
        this.startWizard();
    }
}

