/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.fileWizards;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.event.ExtendedTableModelEvent;
import com.jmorgan.swing.table.DynamicBeanColumnModel;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.dpaa.ui.dialogs.fileWizards.DirectoryListTableCellEditor;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class RenameFilesWizardPage
extends KumbaCoreWizardPage<DynamicBean>
implements TableModelListener {
    private JMCheckBox cbxSynchronizeChanges;
    private DynamicBeanTableModel tableModel;
    private DynamicBeanColumnModel columnModel;
    private JMTable table;
    private DirectoryListTableCellEditor directoryEditor;

    public RenameFilesWizardPage(DynamicBean model) {
        super(model);
    }

    public RenameFilesWizardPage(DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    protected void saveDataToModel() {
        this.table.commitEdits();
        ArrayList<DynamicBean> newData = this.tableModel.getModelData();
        ((DynamicBean)this.model).setProperty("newData", newData);
        ((DynamicBean)this.model).setProperty("keepOriginal", this.cbxSynchronizeChanges.isSelected());
    }

    @Override
    public void tableChanged(TableModelEvent evt) {
        if (!this.cbxSynchronizeChanges.isSelected() || this.table.getRowCount() < 2) {
            return;
        }
        ExtendedTableModelEvent tableModelEvent = (ExtendedTableModelEvent)evt;
        if (tableModelEvent.getType() == 0) {
            boolean nameIsDifferent;
            String newDirectory;
            int row = tableModelEvent.getFirstRow();
            if (row == -1) {
                return;
            }
            DynamicBean editedData = this.tableModel.getValue(row);
            String baseDirectory = (String)editedData.getProperty("baseDirectory");
            boolean directoryIsDifferent = !baseDirectory.equals(newDirectory = (String)editedData.getProperty("newDirectory"));
            String name = (String)editedData.getProperty("fileName");
            String newName = (String)editedData.getProperty("newName");
            newName = newName.trim();
            boolean bl = nameIsDifferent = !name.equals(newName);
            if (directoryIsDifferent || nameIsDifferent) {
                int r = 0;
                while (r < this.tableModel.getRowCount()) {
                    if (r != row) {
                        DynamicBean rData = this.tableModel.getValue(r);
                        String rBDir = (String)rData.getProperty("baseDirectory");
                        String rName = (String)rData.getProperty("fileName");
                        if (directoryIsDifferent && baseDirectory.equals(rBDir)) {
                            rData.setProperty("newDirectory", newDirectory);
                        }
                        if (nameIsDifferent && name.equals(rName)) {
                            rData.setProperty("newName", newName);
                        }
                    }
                    ++r;
                }
            }
        }
        this.table.repaint();
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createBorderLayout());
        this.cbxSynchronizeChanges = new JMCheckBox("Synchronize Changes", true);
        ArrayList files = (ArrayList)((DynamicBean)this.model).getProperty("files");
        ArrayList<DynamicBean> renameModel = new ArrayList<DynamicBean>(files.size());
        for (DataPowerFileInfo object : files) {
            DynamicBean objectClone = new DynamicBean(object);
            objectClone.setProperty("newName", object.getFileName());
            objectClone.setProperty("newDirectory", object.getBaseDirectory());
            renameModel.add(objectClone);
        }
        this.tableModel = new DynamicBeanTableModel();
        this.tableModel.addAll(renameModel);
        this.tableModel.setEditableColumns("newDirectory", "newName");
        this.tableModel.addComputedExpression("appliance", "name");
        this.tableModel.addComputedExpression("sourceDomain", "name");
        ArrayList directories = (ArrayList)((DynamicBean)this.model).getProperty("directories");
        this.directoryEditor = new DirectoryListTableCellEditor(directories);
        this.columnModel = new DynamicBeanColumnModel(this.tableModel);
        this.columnModel.hideColumns("adminState", "absolutePath", "configObjectType", "fileStore", "isExternal", "isIntrinsic", "isLocal", "isReadOnly", "quiesceState", "userSummary", "name", "fileDate", "fileSize", "fileData", "fileContent", "localFile", "deleteable", "status", "fQON");
        this.columnModel.setColumnOrder("appliance", "sourceDomain", "baseDirectory", "fileName", "newDirectory", "newName");
        this.columnModel.setColumnTitle("sourceDomain", "Domain");
        this.columnModel.setEditor("newDirectory", this.directoryEditor);
        this.table = new JMTable(this.tableModel, this.columnModel);
        this.tableModel.addTableModelListener(this);
        panel.add((Component)this.cbxSynchronizeChanges, "North");
        panel.add(new JMScrollPane(this.table));
        this.table.optimizeColumnWidths();
        return panel;
    }
}

