/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.ipWizard;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.table.DynamicBeanColumnModel;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JDialog;

public class IPAssignmentWizardPage
extends KumbaCoreWizardPage<DynamicBean> {
    private DynamicBeanTableModel tableModel;
    private DynamicBeanColumnModel columnModel;
    private JMTable table;
    private String assignToTitle;
    private String assignToPropertyName;
    private String assignToIndexName;

    public IPAssignmentWizardPage(DynamicBean model, String assignToTitle, String assignToPropertyName, String assignToIndexName) {
        super(model);
        this.setAssignToTitle(assignToTitle);
        this.setAssignToPropertyName(assignToPropertyName);
        this.setAssignToIndexName(assignToIndexName);
    }

    public IPAssignmentWizardPage(DynamicBean model, String assignToTitle, String assignToPropertyName, String assignToIndexName, String contentsOrFileName) {
        super(model, contentsOrFileName);
        this.setAssignToTitle(assignToTitle);
        this.setAssignToPropertyName(assignToPropertyName);
        this.setAssignToIndexName(assignToIndexName);
    }

    public String getAssignToTitle() {
        return this.assignToTitle;
    }

    public void setAssignToTitle(String assignToTitle) {
        this.assignToTitle = assignToTitle;
    }

    public String getAssignToPropertyName() {
        return this.assignToPropertyName;
    }

    public void setAssignToPropertyName(String assignToPropertyName) {
        this.assignToPropertyName = assignToPropertyName;
    }

    public String getAssignToIndexName() {
        return this.assignToIndexName;
    }

    public void setAssignToIndexName(String assignToIndexName) {
        this.assignToIndexName = assignToIndexName;
    }

    @Override
    public boolean isDataValid() {
        this.table.commitEdits();
        ArrayList<DynamicBean> staticHostData = this.tableModel.getModelData();
        for (DynamicBean ha : staticHostData) {
            boolean create = (Boolean)ha.getProperty("create");
            if (!create) continue;
            String ipAddress = (String)ha.getProperty("ipAddress");
            String staticHost = (String)ha.getProperty(this.getAssignToPropertyName());
            if (!StringUtility.isEmpty(staticHost)) continue;
            String assignToTitle = this.getAssignToTitle();
            String assignToText = assignToTitle.toLowerCase();
            new JMMessageBox((JDialog)this.parentDialog, assignToTitle + " Not Defined", String.format("The %s is not defined for %s.  Define a %s to continue.", assignToText, ipAddress, assignToText));
            return false;
        }
        return true;
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Override
    protected void saveDataToModel() {
        Index ipApplianceIndex = (Index)((DynamicBean)this.model).getProperty("ipApplianceIndex");
        this.table.commitEdits();
        ArrayList<DynamicBean> staticHostData = this.tableModel.getModelData();
        ArrayList<DynamicBean> finalData = new ArrayList<DynamicBean>();
        String assignToPropertyName = this.getAssignToPropertyName();
        for (DynamicBean ha : staticHostData) {
            boolean create = (Boolean)ha.getProperty("create");
            if (!create) continue;
            String ipAddress = (String)ha.getProperty("ipAddress");
            String assignToValue = (String)ha.getProperty(assignToPropertyName);
            ArrayList appliances = (ArrayList)ipApplianceIndex.get(ipAddress);
            for (Appliance appliance : appliances) {
                DynamicBean finalBean = new DynamicBean();
                finalBean.setProperty("appliance", appliance);
                finalBean.setProperty("ipAddress", ipAddress);
                finalBean.setProperty(assignToPropertyName, assignToValue);
                finalData.add(finalBean);
            }
        }
        ((DynamicBean)this.model).setProperty("finalData", finalData);
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createBorderLayout());
        Index originalValuesIndex = (Index)((DynamicBean)this.model).getProperty(this.getAssignToIndexName());
        Index ipApplianceIndex = (Index)((DynamicBean)this.model).getProperty("ipApplianceIndex");
        String assignToPropertyName = this.getAssignToPropertyName();
        ArrayList<DynamicBean> ipValueTableData = new ArrayList<DynamicBean>();
        for (String ipAddress : ipApplianceIndex.getKeys()) {
            DynamicBean ipValueEntry = new DynamicBean();
            ipValueEntry.setProperty("ipAddress", ipAddress);
            ArrayList currentAssignedValue = (ArrayList)originalValuesIndex.get(ipAddress);
            if (CollectionUtility.isEmpty(currentAssignedValue)) {
                ipValueEntry.setProperty(assignToPropertyName, "");
            } else {
                String staticHost = (String)currentAssignedValue.get(0);
                ipValueEntry.setProperty(assignToPropertyName, staticHost);
            }
            ipValueEntry.setProperty("create", true);
            ipValueTableData.add(ipValueEntry);
        }
        this.tableModel = new DynamicBeanTableModel();
        this.tableModel.setEditableColumns(assignToPropertyName, "create");
        this.columnModel = new DynamicBeanColumnModel(this.tableModel);
        this.columnModel.setColumnOrder("ipAddress", assignToPropertyName, "create");
        this.table = new JMTable(this.tableModel, this.columnModel);
        this.tableModel.addAll(ipValueTableData);
        this.table.optimizeColumnWidths();
        panel.add((Component)new JMScrollPane(this.table), "Center");
        return panel;
    }
}

