/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.passwordWizards;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.ExceptionListenerClient;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.event.ExtendedTableModelEvent;
import com.jmorgan.swing.table.DynamicBeanColumnModel;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.jmorgan.util.Index;
import com.jmorgan.util.Pair;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.core.util.FileUtility;
import com.kumbasoft.dpaa.app.DPAAApplicationProperties;
import com.kumbasoft.dpaa.ui.dialogs.wizards.AbstractTableWizardPage;
import java.awt.Component;
import java.beans.ExceptionListener;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class ChangePasswordsWizardPage
extends AbstractTableWizardPage
implements TableModelListener {
    private JMCheckBox cbxSynchronizeChanges;
    private boolean suppressChangeEvents;

    public ChangePasswordsWizardPage(DynamicBean model) {
        super(model);
    }

    public ChangePasswordsWizardPage(DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = super.createControlsPanel();
        this.cbxSynchronizeChanges = new JMCheckBox("Synchronize Changes", true);
        panel.add((Component)this.cbxSynchronizeChanges, "North");
        this.tableModel.addTableModelListener(this);
        return panel;
    }

    @Override
    protected DynamicBeanTableModel createTableModel() {
        DPAAApplicationProperties applicationProperties = (DPAAApplicationProperties)Application.getApplication().getApplicationProperties();
        String passwordMapAliasFileName = applicationProperties.getPasswordAliasMapFileName();
        ExceptionListenerClient exceptionListenerClient = new ExceptionListenerClient();
        Index passwordMapData = (Index)FileUtility.readObject(passwordMapAliasFileName, (ExceptionListener)exceptionListenerClient);
        if (exceptionListenerClient.hasException()) {
            new JMMessageBox(null, "Failed to read password map alias map file", "Error reading password map alias map file.");
        }
        DynamicBeanTableModel tableModel = super.createTableModel();
        ArrayList objectsWithPasswords = (ArrayList)((DynamicBean)this.model).getProperty("objectsWithPasswords");
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<DataPowerConfig> configs = configurationManager.getObjects(objectsWithPasswords);
        for (DataPowerConfig object : configs) {
            Appliance appliance = object.getAppliance();
            Domain domain = object.getSourceDomain();
            String objectName = object.getName();
            String dataPowerType = object.getConfigObjectType();
            Collection mappedProperties = passwordMapData.get(object.getClass().getSimpleName());
            for (Pair mappedProperty : mappedProperties) {
                ObjectReference passwordAliasReference;
                String passwordField = (String)mappedProperty.first;
                String aliasField = (String)mappedProperty.second;
                String password = null;
                String propertyName = null;
                String propertyType = null;
                if (StringUtility.isNotEmpty(aliasField) && (passwordAliasReference = (ObjectReference)BeanService.getPropertyValue(object, aliasField)) != null) {
                    propertyName = passwordAliasReference.getName();
                    propertyType = "PasswordAlias";
                    password = "";
                }
                if (propertyName == null) {
                    propertyName = passwordField;
                    propertyType = "String";
                    password = (String)BeanService.getPropertyValue(object, passwordField);
                    if (StringUtility.isEmpty(password)) {
                        password = "";
                    }
                }
                if (propertyName == null && propertyType == null) continue;
                DynamicBean row = new DynamicBean();
                row.setProperty("appliance", appliance);
                row.setProperty("domain", domain);
                row.setProperty("dataPowerType", dataPowerType);
                row.setProperty("objectName", objectName);
                row.setProperty("propertyType", propertyType);
                row.setProperty("propertyName", propertyName);
                row.setProperty("password", password);
                row.setProperty("newPassword", password);
                tableModel.addRow(row);
            }
        }
        tableModel.addComputedExpression("appliance", "name");
        tableModel.addComputedExpression("domain", "name");
        tableModel.setEditableColumns("newPassword");
        return tableModel;
    }

    @Override
    protected DynamicBeanColumnModel createColumnModel() {
        DynamicBeanColumnModel columnModel = super.createColumnModel();
        columnModel.setColumnOrder("appliance", "domain", "dataPowerType", "objectName", "propertyName", "propertyValue", "password", "newPassword");
        columnModel.hideColumn("propertyType");
        return columnModel;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        ExtendedTableModelEvent ee = (ExtendedTableModelEvent)e;
        if (!this.cbxSynchronizeChanges.isSelected() || this.suppressChangeEvents || ee.getNewValue().equals(ee.getOldValue())) {
            return;
        }
        this.suppressChangeEvents = true;
        int changedRow = e.getFirstRow();
        DynamicBean changedValue = this.tableModel.getValue(changedRow);
        Domain domain = (Domain)changedValue.getProperty("domain");
        String objectType = (String)changedValue.getProperty("dataPowerType");
        String objectName = (String)changedValue.getProperty("objectName");
        String propertyName = (String)changedValue.getProperty("propertyName");
        String password = (String)changedValue.getProperty("newPassword");
        int rowCount = this.tableModel.getRowCount();
        int row = 0;
        while (row < rowCount) {
            if (row != changedRow) {
                DynamicBean value = this.tableModel.getValue(row);
                Domain vDomain = (Domain)value.getProperty("domain");
                String vObjectType = (String)value.getProperty("dataPowerType");
                String vObjectName = (String)value.getProperty("objectName");
                String vPropertyName = (String)value.getProperty("propertyName");
                if (domain.equals(vDomain) && objectType.equals(vObjectType) && objectName.equals(vObjectName) && propertyName.equals(vPropertyName)) {
                    value.setProperty("newPassword", password);
                }
            }
            ++row;
        }
        this.suppressChangeEvents = false;
        this.table.repaint();
    }

    @Override
    protected void saveDataToModel() {
        this.table.commitEdits();
        ArrayList<DynamicBean> tableData = this.tableModel.getModelData();
        ((DynamicBean)this.model).setProperty("changedData", tableData);
    }
}

