/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.probe;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.ScrollablePanel;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.event.ComponentEventInvoker;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.probe.TransactionManifest;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.dpaa.ui.dialogs.probe.ProbeViewDialog;
import com.kumbasoft.dpaa.ui.dialogs.probe.TransactionViewPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.ArrayList;

public class ProbeViewPanel
extends AbstractPanel {
    private ProbeViewDialog dialog;
    private JMButton btnClose;
    private ScrollablePanel probeViewContainer;
    private ArrayList<TransactionViewPanel> transactionViewPanels;

    public ProbeViewPanel(ProbeViewDialog dialog) {
        super(KumbaCoreUIConstants.createBorderLayout());
        this.dialog = dialog;
        JMPanel controlsPanel = this.createControlsPanel();
        this.probeViewContainer = new ScrollablePanel(KumbaCoreUIConstants.createVerticalFlowLayout(3));
        this.add((Component)controlsPanel, "North");
        this.add((Component)new JMScrollPane(this.probeViewContainer), "Center");
        new ComponentEventInvoker(dialog, 8, (Object)this, "dialogResized");
        new ActionEventInvoker(this.btnClose, dialog, "swapPanels");
        this.transactionViewPanels = new ArrayList();
    }

    @Reflected
    private void dialogResized() {
        if (this.transactionViewPanels == null) {
            return;
        }
        Dimension dialogSize = this.dialog.getSize();
        Insets dialogInsets = this.dialog.getInsets();
        AbstractPanel.logger.finest(() -> LMG.log("(): Dialog Size %s, Dialog Insets %s.  Number of transaction view panels: %d", () -> dialogSize, () -> dialogInsets, () -> this.transactionViewPanels.size()));
        for (TransactionViewPanel panel : this.transactionViewPanels) {
            Dimension panelSize = panel.getSize();
            int newWidth = dialogSize.width - dialogInsets.left - dialogInsets.right - 30;
            AbstractPanel.logger.finest(() -> LMG.log("(): Setting transaction view panel size to (%d, %d)", () -> newWidth, () -> dimension.height));
            panel.setSize(newWidth, panelSize.height);
            panel.setPreferredSize(newWidth, panelSize.height);
            panel.invalidate();
        }
    }

    private JMPanel createControlsPanel() {
        JMPanel panel = new JMPanel(KumbaCoreUIConstants.createFlowLayout(2));
        this.btnClose = new JMButton(KumbaCoreUIConstants.PREVIOUS_ICON);
        panel.add(this.btnClose);
        return panel;
    }

    public void setTransactions(ArrayList<TransactionManifest> selectedTransactions) {
        this.close();
        for (TransactionManifest transactionManifest : selectedTransactions) {
            TransactionViewPanel tvp = new TransactionViewPanel(transactionManifest);
            this.transactionViewPanels.add(tvp);
            this.probeViewContainer.add(tvp);
        }
        new AsynchMethodInvoker(GUIServices.class, "forciblyRevalidate", (Object)this, 250);
    }

    void close() {
        for (TransactionViewPanel tvp : this.transactionViewPanels) {
            this.probeViewContainer.remove(tvp);
        }
        this.transactionViewPanels.clear();
        this.repaint();
    }
}

