/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.probe;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMComboBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.component.ObjectPropertyDisplayPanel;
import com.jmorgan.swing.dialog.DialogPanel;
import com.jmorgan.swing.dialog.GenericDialog;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.event.WindowEventInvoker;
import com.jmorgan.swing.menu.JMPopupMenu;
import com.jmorgan.swing.menu.PopupMenuController;
import com.jmorgan.swing.spinner.NumberSpinner;
import com.jmorgan.swing.util.InsetsFactory;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.probe.ProbeController;
import com.kumbasoft.core.beans.probe.TransactionManifest;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.ModifyProperty;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.dpaa.app.DPAAApplicationProperties;
import com.kumbasoft.dpaa.ui.dialogs.probe.ProbeViewDialog;
import com.kumbasoft.dpaa.ui.dialogs.probe.TransactionManifestComparePanel;
import com.kumbasoft.dpaa.ui.dialogs.probe.TransactionManifestPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JDialog;
import org.apache.commons.io.FileUtils;

public class TransactionListPanel
extends AbstractPanel
implements PopupMenuController {
    private static final String REFRESH_MODE_REPLACE = "Replace";
    private static final String REFRESH_MODE_APPEND = "Append";
    private ProbeViewDialog dialog;
    private ArrayList<StatusObjectStatus> selectedObjects;
    private TransactionManifestPanel manifestPanel;
    private JMComboBox<String> cbxTransactionHistory;
    private JMComboBox<String> cbxRefreshMode;
    private JMCheckBox cbxAutoRefresh;
    private NumberField nfAutoRefreshInterval;
    private AsynchMethodInvoker<Void> autoRefreshThread;
    private JMButton btnRefreshProbes;
    private JMButton btnFlushProbes;
    private JMCheckBox cbxDisableProbesOnExit;

    public TransactionListPanel(ProbeViewDialog dialog, ArrayList<StatusObjectStatus> selectedObjects) {
        super(KumbaCoreUIConstants.createBorderLayout());
        this.selectedObjects = selectedObjects;
        this.dialog = dialog;
        JMPanel controlsPanel = this.createControlsPanel();
        this.manifestPanel = new TransactionManifestPanel();
        this.add((Component)controlsPanel, "North");
        this.add((Component)this.manifestPanel, "Center");
        this.createPopupMenu();
        new ActionEventInvoker(this.cbxTransactionHistory, this, "setTransactionHistory");
        new ActionEventInvoker(this.cbxAutoRefresh, this, "setAutoRefresh");
        new ActionEventInvoker(this.btnRefreshProbes, this, "getProbeData");
        new ActionEventInvoker(this.btnFlushProbes, this, "flushProbes");
        new WindowEventInvoker((Object)this.dialog, 2, this, "dialogClosing");
        new AsynchMethodInvoker((Object)this, "turnProbesOn", (Object)true);
    }

    private JMPanel createControlsPanel() {
        JMPanel leftPanel = new JMPanel(new FlowLayout(0));
        leftPanel.setInsets(InsetsFactory.createFixedInsets(16, 5));
        this.cbxTransactionHistory = new JMComboBox<String>((ItemType[])new String[]{"10", "25", "50", "100", "200", "unbounded"});
        this.cbxTransactionHistory.setEditable(true);
        this.cbxTransactionHistory.setEditorAlignment(4);
        this.cbxTransactionHistory.setDropDownAlignment(4);
        LabeledComponent lblTransactionHistory = new LabeledComponent("Transaction History:", this.cbxTransactionHistory);
        this.cbxRefreshMode = new JMComboBox<String>((ItemType[])new String[]{REFRESH_MODE_APPEND, REFRESH_MODE_REPLACE});
        LabeledComponent lblRefreshMode = new LabeledComponent("Refresh Mode:", this.cbxRefreshMode);
        this.btnRefreshProbes = new JMButton("Refresh");
        this.btnRefreshProbes.setEnabled(false);
        this.cbxAutoRefresh = new JMCheckBox("Auto Refresh (ms):", true);
        this.nfAutoRefreshInterval = new NumberField((double)KumbaCoreConstants.PROBE_REFRESH_INTERVAL, "###0;-###0");
        NumberSpinner nsAutoRefreshInterval = new NumberSpinner(this.nfAutoRefreshInterval, 1000.0, 0.0, 2.147483647E9);
        this.btnFlushProbes = new JMButton("Flush Probes");
        leftPanel.addAll(lblTransactionHistory, ComponentFactory.createSpacer(20, 1), lblRefreshMode, this.btnRefreshProbes, ComponentFactory.createSpacer(10, 1), this.cbxAutoRefresh, nsAutoRefreshInterval, ComponentFactory.createSpacer(20, 1), this.btnFlushProbes);
        JMPanel rightPanel = new JMPanel(new FlowLayout(2));
        rightPanel.setInsets(InsetsFactory.createFixedInsets(10, 5));
        this.cbxDisableProbesOnExit = new JMCheckBox("Disable Probes on Exit", true);
        rightPanel.addAll(this.cbxDisableProbesOnExit, this.getPopupMenuButton());
        JMPanel panel = new JMPanel(new BorderLayout());
        panel.add((Component)leftPanel, "West");
        panel.add((Component)rightPanel, "Center");
        return panel;
    }

    @Reflected
    private void dialogClosing() {
        logger.finer("(): Starting");
        if (this.cbxDisableProbesOnExit.isSelected()) {
            logger.config("(): Turning off probes.");
            this.turnProbesOff();
        }
        if (this.autoRefreshThread != null) {
            logger.finer("(): Cancelling running threads.");
            this.autoRefreshThread.cancel();
            this.autoRefreshThread = null;
        }
        logger.finer("(): Cleaning out probe capture directory.");
        TransactionListPanel.cleanoutProbeCapture();
        logger.finer("(): Done");
    }

    @Override
    protected void createPopupMenu() {
        JMPopupMenu popupMenu = this.getPopupMenu(this.manifestPanel.getDisplayTable());
        popupMenu.setPopupController(this);
        MethodInvoker fnPtr = new MethodInvoker((Object)this.manifestPanel, "getSelectedValues", new Object[0]);
        popupMenu.addMenuItem("Open selected Transactions...", (Object)this.dialog, "openTransactions", fnPtr);
        popupMenu.addSeparator();
        popupMenu.addMenuItem("Compare Transaction Manifests...", (Object)this, "fileOpen");
        popupMenu.setEnabled(false);
    }

    @Override
    public boolean isPopupReady() {
        return this.manifestPanel.getTableModel().getRowCount() > 0 && this.manifestPanel.getDisplayTable().getSelectedRowCount() > 0;
    }

    @Reflected
    private void setTransactionHistory() {
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        String transactionHistory = this.cbxTransactionHistory.getSelectedItem().toString();
        String propertyName = transactionHistory == "unbounded" ? "DebugMode" : "DebugHistory";
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        for (StatusObjectStatus object : this.selectedObjects) {
            ModifyProperty<String> mp = new ModifyProperty<String>(object, propertyName, transactionHistory);
            mtil.addThread(mp.getProcessThread());
        }
        ThreadManager.monitorAsynchThreadLifeCycle("TransactionListPanel.setTransactionHistory()", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
    }

    @Reflected
    private void setAutoRefresh() {
        if (this.cbxAutoRefresh.isSelected()) {
            this.nfAutoRefreshInterval.setEnabled(true);
            this.btnRefreshProbes.setEnabled(false);
            this.getProbeData();
        } else {
            if (this.autoRefreshThread != null) {
                this.autoRefreshThread.cancel();
            }
            this.nfAutoRefreshInterval.setEnabled(false);
            this.btnRefreshProbes.setEnabled(true);
        }
    }

    @Reflected
    private void flushProbes() {
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        if (this.cbxAutoRefresh.isSelected() && this.autoRefreshThread != null) {
            this.autoRefreshThread.cancel();
            this.autoRefreshThread = null;
        }
        this.turnProbesOff();
        this.manifestPanel.reset();
        TransactionListPanel.cleanoutProbeCapture();
        this.turnProbesOn(false);
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
    }

    @Reflected
    private void fileOpen() {
        ArrayList selectedItems = this.manifestPanel.getSelectedValues();
        if (CollectionUtility.isEmpty(selectedItems)) {
            return;
        }
        Component[] panels = new ObjectPropertyDisplayPanel[selectedItems.size()];
        int i = 0;
        while (i < selectedItems.size()) {
            ObjectPropertyDisplayPanel<TransactionManifest> panel = new ObjectPropertyDisplayPanel<TransactionManifest>((TransactionManifest)selectedItems.get(i));
            panel.addPropertyException("transactionDirectory");
            panel.addPropertyException("transactionRules");
            panel.addPropertyExpression("appliance", "appliance.name");
            panel.addPropertyExpression("domain", "domain.name");
            panels[i] = panel;
            ++i;
        }
        TransactionManifestComparePanel comparePanel = new TransactionManifestComparePanel();
        comparePanel.addAll(panels);
        GenericDialog displayDialog = new GenericDialog((JDialog)this.dialog, "Compare Manifests", (DialogPanel)comparePanel, true);
        displayDialog.setSize(1000, 400);
        displayDialog.setLocationRelativeTo(this.dialog);
        displayDialog.setVisible(true);
    }

    private static void cleanoutProbeCapture() {
        logger.finer("(): Starting");
        DPAAApplicationProperties applicationProperties = (DPAAApplicationProperties)Application.getApplication().getApplicationProperties();
        String probeCaptureDirectoryName = applicationProperties.getProbeCaptureDirectory();
        File probeCaptureDirectory = new File(probeCaptureDirectoryName);
        logger.info(() -> LMG.log("(): Cleaning out probe directory: '%s'", () -> probeCaptureDirectory.getAbsolutePath()));
        try {
            FileUtils.cleanDirectory(probeCaptureDirectory);
        }
        catch (IOException e) {
            logger.warning(() -> LMG.log("(): Error Cleaning out probe directory: '%s'\n%s", () -> probeCaptureDirectory.getAbsolutePath(), () -> e.getMessage()));
        }
        logger.finer("(): Done");
    }

    @Reflected
    private void getProbeData() {
        block13: {
            AbstractPanel.logger.finer("(): Starting.");
            if (!this.dialog.isShowing()) {
                AbstractPanel.logger.info("(): Dialog is not showing.  It may have closed after the last thread was started?");
                TransactionListPanel.cleanoutProbeCapture();
                return;
            }
            this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
            String refreshMode = this.cbxRefreshMode.getSelectedItem().toString();
            if (refreshMode.equals(REFRESH_MODE_REPLACE)) {
                this.manifestPanel.getTableModel().reset();
                this.manifestPanel.repaint();
            }
            AbstractPanel.logger.finer(() -> LMG.log("(): Capturing probes for %d selected objects.", () -> this.selectedObjects.size()));
            ArrayList<TransactionManifest> transactionManifests = ProbeController.captureProbes(this.selectedObjects);
            AbstractPanel.logger.finer(() -> LMG.log("(): Completed probe capture for %d selected objects.  Got %d transaction manifests.", () -> this.selectedObjects.size(), () -> transactionManifests.size()));
            if (transactionManifests.size() <= 0) break block13;
            TransactionManifest firstManifest = transactionManifests.get(0);
            String transactionHistory = firstManifest.getTransactionHistory();
            this.cbxTransactionHistory.setSelectedItem(transactionHistory);
            switch (refreshMode) {
                case "Append": {
                    AbstractPanel.logger.finer(() -> LMG.log("(): Adding %d transaction manifests to table.", () -> transactionManifests.size()));
                    this.manifestPanel.addTableData(transactionManifests);
                    break;
                }
                case "Replace": {
                    AbstractPanel.logger.finer(() -> LMG.log("(): Setting %d transaction manifests to table.", () -> transactionManifests.size()));
                    this.manifestPanel.setTableData(transactionManifests);
                }
            }
        }
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
        if (this.cbxAutoRefresh.isSelected() && this.dialog.isShowing()) {
            int refreshInterval = (int)this.nfAutoRefreshInterval.getNumber();
            AbstractPanel.logger.finer(() -> LMG.log("(): Auto Refresh is on.  Refreshing in %dms.", () -> refreshInterval));
            this.autoRefreshThread = new AsynchMethodInvoker((Object)this, "getProbeData", refreshInterval);
        }
        AbstractPanel.logger.finer("(): Done.");
    }

    @Reflected
    private void turnProbesOn(boolean forceExtract) {
        this.setProbeState("on");
        if (forceExtract || !this.cbxAutoRefresh.isSelected()) {
            this.getProbeData();
        }
    }

    @Reflected
    private void turnProbesOff() {
        this.setProbeState("off");
    }

    private void setProbeState(String state) {
        logger.finer(() -> LMG.log("(%s): Starting", () -> state));
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        for (StatusObjectStatus object : this.selectedObjects) {
            logger.config(() -> LMG.log("(%s):  Setting debug mode for %s", () -> state, () -> object.getFQON()));
            ModifyProperty<String> mp = new ModifyProperty<String>(object, "DebugMode", state);
            mtil.addThread(mp.getProcessThread());
        }
        ThreadManager.monitorAsynchThreadLifeCycle("TransactionListPanel.setProbeState(state=" + state + ")", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        logger.finer(() -> LMG.log("(%s): Done", () -> state));
    }
}

