/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.replaceWizard;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.event.ExtendedTableModelEvent;
import com.jmorgan.swing.table.DynamicBeanColumnModel;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.jmorgan.util.Index;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.core.ui.editors.DPObjectListTableCellEditor;
import com.kumbasoft.core.util.DataStructureUtility;
import com.kumbasoft.dpaa.ui.dialogs.wizards.AbstractRefactorWizardPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.event.TableModelEvent;

public class ReplaceWizardPage
extends AbstractRefactorWizardPage {
    public ReplaceWizardPage(DynamicBean model) {
        super(model);
    }

    public ReplaceWizardPage(DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Override
    protected void loadAllObjectsByType(DynamicBean model) {
        super.loadAllObjectsByType(model);
        int columnNumber = this.columnModel.getColumnIndex("replaceName");
        int rowCount = this.table.getRowCount();
        int row = 0;
        while (row < rowCount) {
            DynamicBean rowData = this.tableModel.getValue(row);
            Appliance appliance = (Appliance)rowData.getProperty("appliance");
            Domain domain = (Domain)rowData.getProperty("sourceDomain");
            String objectType = (String)rowData.getProperty("dataPowerClass");
            Collection objectsByType = this.allObjectsByType.get(objectType);
            HashMap objectIndex = DataStructureUtility.mapByApplianceDomain(objectsByType);
            Index objectsByAppliance = objectIndex.get(appliance);
            Collection objectsByDomain = objectsByAppliance.get(domain);
            DPObjectListTableCellEditor cellEditor = new DPObjectListTableCellEditor((ArrayList)objectsByDomain);
            this.columnModel.setEditor(row, columnNumber, cellEditor);
            ++row;
        }
    }

    @Override
    public void tableChanged(TableModelEvent evt) {
        if (!this.cbxSynchronizeChanges.isSelected() || this.table.getRowCount() < 2) {
            return;
        }
        ExtendedTableModelEvent tableModelEvent = (ExtendedTableModelEvent)evt;
        if (tableModelEvent.getType() == 0) {
            int row = tableModelEvent.getFirstRow();
            if (row == -1) {
                return;
            }
            DynamicBean editedData = this.tableModel.getValue(row);
            String type = (String)editedData.getProperty("dataPowerClass");
            String name = (String)editedData.getProperty("name");
            String targetName = (String)editedData.getProperty("replaceName");
            int r = 0;
            while (r < this.tableModel.getRowCount()) {
                if (r != row) {
                    DynamicBean rData = this.tableModel.getValue(r);
                    String rType = (String)rData.getProperty("dataPowerClass");
                    String rName = (String)rData.getProperty("name");
                    if (type.equals(rType) && name.equals(rName)) {
                        rData.setProperty("replaceName", targetName);
                    }
                }
                ++r;
            }
        }
        this.table.repaint();
    }

    @Override
    protected void saveDataToModel() {
        super.saveDataToModel();
        ArrayList data = (ArrayList)((DynamicBean)this.model).getProperty("newData");
        ArrayList<DynamicBean> refactorData = new ArrayList<DynamicBean>();
        for (DynamicBean refactorRow : data) {
            String targetName;
            String sourceName = (String)refactorRow.getProperty("name");
            if (sourceName.equals(targetName = (String)refactorRow.getProperty("replaceName"))) continue;
            refactorData.add(refactorRow);
        }
        ((DynamicBean)this.model).setProperty("newData", refactorData);
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        ArrayList selectedObjects = (ArrayList)((DynamicBean)this.model).getProperty("selectedObjects");
        this.refactorModel = new ArrayList(selectedObjects.size());
        for (StatusObjectStatus object : selectedObjects) {
            DynamicBean objectClone = new DynamicBean(object);
            objectClone.setProperty("replaceName", object.getName());
            this.refactorModel.add(objectClone);
        }
        return super.createControlsPanel();
    }

    @Override
    protected DynamicBeanTableModel createTableModel() {
        DynamicBeanTableModel tableModel = super.createTableModel();
        tableModel.setEditableColumns("replaceName");
        return tableModel;
    }

    @Override
    protected DynamicBeanColumnModel createColumnModel() {
        this.columnModel = super.createColumnModel();
        this.columnModel.setColumnOrder("appliance", "sourceDomain", "dataPowerClass", "name", "replaceName");
        this.columnModel.setColumnTitle("replaceName", "Replacement Object");
        return this.columnModel;
    }
}

