/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.statusGraphWizard;

import com.jmorgan.beans.DynamicBean;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.beans.StatusProviderGraphDefinition;
import com.kumbasoft.core.beans.StatusProviderInfo;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPage;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JDialog;
import javax.swing.ListModel;

public class StatusDiffGraphSelectionWizardPage
extends KumbaCoreWizardPage<DynamicBean> {
    private JMListModel<String> graphDefinitionListModel;
    private JMList<String> graphDefinitionList;

    public StatusDiffGraphSelectionWizardPage(DynamicBean model) {
        super(model);
    }

    public StatusDiffGraphSelectionWizardPage(DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
    }

    @Override
    public boolean isFinalPage() {
        return true;
    }

    @Override
    public boolean isDataValid() {
        if (this.graphDefinitionList.getSelectedIndex() == -1) {
            new JMMessageBox((JDialog)this.parentDialog, "Nothing Selected", "You must selected at least one graph definition.");
            return false;
        }
        return true;
    }

    @Override
    protected void saveDataToModel() {
        String selectedGraph = this.graphDefinitionList.getSelectedItem();
        ((DynamicBean)this.model).setProperty("selectedGraph", selectedGraph);
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        StatusProviderInfo statusProviderInfo = (StatusProviderInfo)((DynamicBean)this.model).getProperty("statusProviderInfo");
        ArrayList<StatusProviderGraphDefinition> graphDefinitions = statusProviderInfo.getGraphs();
        Collection graphDefinitionNames = CollectionUtility.getPropertyValues(graphDefinitions, "graphName");
        Collections.sort((ArrayList)graphDefinitionNames);
        this.graphDefinitionListModel = new JMListModel(graphDefinitionNames);
        this.graphDefinitionList = new JMList<String>((ListModel<String>)this.graphDefinitionListModel);
        this.graphDefinitionList.setSelectionMode(0);
        KumbaCoreWizardPanel controlsPanel = new KumbaCoreWizardPanel(KumbaCoreUIConstants.createBorderLayout());
        JMLabel label = new JMLabel("Graph Definition Names");
        controlsPanel.add((Component)label, "North");
        controlsPanel.add((Component)new JMScrollPane(this.graphDefinitionList), "Center");
        return controlsPanel;
    }
}

