/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.dialogs.wizards;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.table.DynamicBeanColumnModel;
import com.jmorgan.swing.table.DynamicBeanTableModel;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.ui.dialog.wizard.KumbaCoreWizardPanel;
import com.kumbasoft.dpaa.ui.dialogs.wizards.AbstractTableWizardPage;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.event.TableModelListener;

public abstract class AbstractRefactorWizardPage
extends AbstractTableWizardPage
implements TableModelListener {
    protected JMCheckBox cbxSynchronizeChanges;
    protected Index<String, StatusObjectStatus> allObjectsByType;
    protected ArrayList<DynamicBean> refactorModel;

    public AbstractRefactorWizardPage(DynamicBean model) {
        super(model);
        new AsynchMethodInvoker((Object)this, "loadAllObjectsByType", (Object)model);
    }

    public AbstractRefactorWizardPage(DynamicBean model, String contentsOrFileName) {
        super(model, contentsOrFileName);
        new AsynchMethodInvoker((Object)this, "loadAllObjectsByType", (Object)model);
    }

    @Reflected
    protected void loadAllObjectsByType(DynamicBean model) {
        ArrayList selectedObjects = (ArrayList)((DynamicBean)this.model).getProperty("selectedObjects");
        Index<Appliance, Domain> selectedDomains = Index.createIndexFrom(selectedObjects, "appliance", "sourceDomain");
        BeanIndexer<StatusObjectStatus> typeIndexer = new BeanIndexer<StatusObjectStatus>(selectedObjects);
        Index selectedByType = typeIndexer.getIndexOf("dataPowerClass", "");
        String delimitedTypes = StringUtility.getDelimitedString(selectedByType.getKeys(), "$|^");
        String expression = String.format("(^%s$)", delimitedTypes);
        ConfigurationManager configurationManager = new ConfigurationManager();
        ArrayList<StatusObjectStatus> allObjects = configurationManager.listObjects(selectedDomains, expression, ".*");
        typeIndexer.setBeanCollection(allObjects);
        this.allObjectsByType = typeIndexer.getIndexOf("dataPowerClass", "");
    }

    @Override
    protected KumbaCoreWizardPanel createControlsPanel() {
        KumbaCoreWizardPanel panel = super.createControlsPanel();
        this.cbxSynchronizeChanges = new JMCheckBox("Synchronize Changes", true);
        this.tableModel.addTableModelListener(this);
        panel.add((Component)this.cbxSynchronizeChanges, "North");
        this.table.optimizeColumnWidths();
        return panel;
    }

    @Override
    protected void saveDataToModel() {
        this.table.commitEdits();
        ArrayList<DynamicBean> data = this.tableModel.getModelData();
        ((DynamicBean)this.model).setProperty("newData", data);
    }

    @Override
    protected DynamicBeanTableModel createTableModel() {
        DynamicBeanTableModel tableModel = super.createTableModel();
        tableModel.addAll(this.refactorModel);
        tableModel.addComputedExpression("appliance", "name");
        tableModel.addComputedExpression("sourceDomain", "name");
        return tableModel;
    }

    @Override
    protected DynamicBeanColumnModel createColumnModel() {
        DynamicBeanColumnModel columnModel = super.createColumnModel();
        this.columnModel.hideColumns("adminState", "configState", "errorCode", "eventCode", "opState", "statusTime", "status", "fQON");
        this.columnModel.setColumnTitle("sourceDomain", "Domain");
        this.columnModel.setColumnTitle("dataPowerClass", "Object Type");
        return columnModel;
    }
}

