/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.Testing;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTextArea;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.component.PreferredSizeComponent;
import com.jmorgan.util.Index;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.dpaa.ui.panels.Testing.RawXMITool;
import java.awt.Component;

public class XMITestingPanel
extends AbstractPanel {
    private JMTextArea taXMI;
    private JMTextArea output;
    private JMButton btnRun = ComponentFactory.createButton(null, "Run", "Run the XMI", true, this, "runXMI", new Object[0]);

    public XMITestingPanel() {
        super(KumbaCoreUIConstants.createVerticalFlowLayout(3));
        this.add(new PreferredSizeComponent(this.btnRun, 0));
        this.taXMI = new JMTextArea(20, 132);
        LabeledComponent lblXMI = new LabeledComponent("XMI", (Component)new JMScrollPane(this.taXMI), 1);
        this.add(lblXMI);
        this.output = new JMTextArea(20, 132);
        LabeledComponent lblOutput = new LabeledComponent("Output", (Component)new JMScrollPane(this.output), 1);
        this.add(lblOutput);
    }

    @Reflected
    private void runXMI() {
        String xmi = this.taXMI.getText().trim();
        if (StringUtility.isEmpty(xmi)) {
            return;
        }
        this.output.setText("");
        Index<Appliance, Domain> selectedDomains = ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection();
        for (Appliance appliance : selectedDomains.getKeys()) {
            this.output.append("*".repeat(80));
            this.output.append("\n");
            this.output.append(StringUtility.setInField("Appliance: " + appliance.getName(), 80, ' ', 2));
            this.output.append("\n");
            this.output.append("*".repeat(80));
            this.output.append("\n");
            for (Domain domain : selectedDomains.get(appliance)) {
                this.output.append("-".repeat(80));
                this.output.append("\n");
                this.output.append(StringUtility.setInField("Domain: " + domain.getName(), 80, ' ', 2));
                this.output.append("\n");
                this.output.append("-".repeat(80));
                this.output.append("\n");
                String request = xmi.replace("${domain.name}", domain.getName());
                RawXMITool rawXMITool = new RawXMITool(appliance, domain, request);
                try {
                    XMLElement response = rawXMITool.getResponse();
                    this.output.append(response == null ? "" : response.toString());
                }
                catch (Exception e) {
                    this.output.append(e.getMessage());
                    e.printStackTrace();
                }
                this.output.append("\n\n");
            }
            this.output.append("\n\n");
        }
    }
}

