/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.cacheManagement;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.JMBean;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.event.ItemEventInvoker;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerAction;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.actions.ActionFlushAPIGWDocumentCache;
import com.kumbasoft.core.beans.actions.ActionFlushAPIGWLDAPPoolCache;
import com.kumbasoft.core.beans.actions.ActionFlushAPIGWStylesheetCache;
import com.kumbasoft.core.beans.actions.ActionFlushExpiredAPIGWDocuments;
import com.kumbasoft.core.beans.actions.ActionInvalidateAPIGWDocumentCache;
import com.kumbasoft.core.beans.config.ConfigAPIGateway;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.dpaa.ui.panels.cacheManagement.AbstractObjectCacheManagementPanel;
import java.awt.FlowLayout;
import java.util.ArrayList;

public class APIGatewayCacheManagementPanel
extends AbstractObjectCacheManagementPanel<ConfigAPIGateway> {
    private JMCheckBox cbxStyleSheetCache = ComponentFactory.createCheckbox(null, "Stylesheet Cache", "Clear the stylesheet cache for all selected API Gateways", false, true, null, null, new Object[0]);
    private JMTextField tfStylesheetMatchPattern = ComponentFactory.createTextField("*", 150, 25, null, null, new Object[0]);
    private JMCheckBox cbxDocumentCache;
    private JMTextField tfDocumentMatchPattern;
    private JMCheckBox cbxInvalidateDocument;
    private JMTextField tfInvalidateDocumentMatchPattern;
    private JMCheckBox cbxExpiredDocumentCache;
    private JMTextField tfExpiredDocumentMatchPattern;
    private JMTextField tfExpiredDocumentMatchingKey;
    private JMCheckBox cbxLDAPPoolCache;

    public APIGatewayCacheManagementPanel() {
        JMPanel styleSheetCachePanel = AbstractObjectCacheManagementPanel.getCheckboxFieldPanel(this.cbxStyleSheetCache, this.tfStylesheetMatchPattern);
        this.cbxDocumentCache = ComponentFactory.createCheckbox(null, "Document Cache", "Clear the document cache for all selected API Gatewatys", false, true, null, null, new Object[0]);
        this.tfDocumentMatchPattern = ComponentFactory.createTextField("*", 150, 25, null, null, new Object[0]);
        JMPanel documentCachePanel = AbstractObjectCacheManagementPanel.getCheckboxFieldPanel(this.cbxDocumentCache, this.tfDocumentMatchPattern);
        this.cbxInvalidateDocument = ComponentFactory.createCheckbox(null, "Invalidate Documents", "Invalidate document in the cache for all selected API Gateways", false, true, null, null, new Object[0]);
        this.tfInvalidateDocumentMatchPattern = ComponentFactory.createTextField("*", 150, 25, null, null, new Object[0]);
        JMPanel invalidateDocumentPanel = AbstractObjectCacheManagementPanel.getCheckboxFieldPanel(this.cbxInvalidateDocument, this.tfInvalidateDocumentMatchPattern);
        this.cbxExpiredDocumentCache = ComponentFactory.createCheckbox(null, "Expired Documents", "Clear the expried documents within the cache for all selected API Gateways", false, true, null, null, new Object[0]);
        this.tfExpiredDocumentMatchPattern = ComponentFactory.createTextField("*", 150, 25, null, null, new Object[0]);
        this.tfExpiredDocumentMatchingKey = ComponentFactory.createTextField("*", 290, 25, null, null, new Object[0]);
        this.tfExpiredDocumentMatchingKey.setEnabled(false);
        JMPanel expiredDocumentCachePanel = AbstractObjectCacheManagementPanel.getCheckboxFieldPanel(this.cbxExpiredDocumentCache, this.tfExpiredDocumentMatchPattern);
        JMPanel matchKeyPanel = new JMPanel(new FlowLayout(0, 10, 1));
        matchKeyPanel.addAll(ComponentFactory.createSpacer(11, 10), new JMLabel("  Expired Matching Key: "), this.tfExpiredDocumentMatchingKey);
        MethodInvoker isSelectedMethodInvoker = new MethodInvoker((Object)this.cbxExpiredDocumentCache, "isSelected", new Object[0]);
        new ItemEventInvoker(this.cbxExpiredDocumentCache, this.tfExpiredDocumentMatchingKey, "setEnabled", isSelectedMethodInvoker);
        this.cbxLDAPPoolCache = ComponentFactory.createCheckbox(null, "LDAP Pool Cache", "Clear the LDAP pool cache for all selected API Gateways", false, true, null, null, new Object[0]);
        JMPanel cbxPanel = new JMPanel(new VerticalFlowLayout(3, 10));
        cbxPanel.addAll(styleSheetCachePanel, documentCachePanel, invalidateDocumentPanel, expiredDocumentCachePanel, matchKeyPanel, this.cbxLDAPPoolCache);
        this.rightPanel.add(cbxPanel);
    }

    @Override
    protected String getListNameLabel() {
        return "API Gateways";
    }

    @Override
    protected String getObjectType() {
        return "APIGateway";
    }

    @Override
    protected int getButtonLeftMargin() {
        return 240;
    }

    @Override
    protected String getButtonText() {
        return "Clear Cache";
    }

    @Override
    protected String getButtonToolTip() {
        return "Clears all selected caches for all selected API Gateways";
    }

    @Override
    protected String getActionEventMethod() {
        return "clearAPIGatewayCache";
    }

    @Reflected
    private void clearAPIGatewayCache() {
        this.openResultsDialogAndSetWaitCursor("Clear API Gateway Caches");
        this.clearCache("clearAPIGatewayCache");
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void clearAPIGatewayCache(Appliance appliance, Domain domain, String apiGateway) {
        String cacheNameList;
        int lastComma;
        ArrayList<DataPowerAction> actions = new ArrayList<DataPowerAction>();
        ObjectReference<ConfigAPIGateway> or = new ObjectReference<ConfigAPIGateway>();
        or.setClassName("APIGateway");
        or.setName(apiGateway);
        ArrayList<String> cacheNames = new ArrayList<String>();
        if (this.cbxStyleSheetCache.isSelected()) {
            ActionFlushAPIGWStylesheetCache fssc = new ActionFlushAPIGWStylesheetCache();
            fssc.setAPIGateway(or);
            actions.add(fssc);
            cacheNames.add("Stylesheet");
        }
        if (this.cbxDocumentCache.isSelected()) {
            String documentPattern = this.tfDocumentMatchPattern.getText();
            ActionFlushAPIGWDocumentCache fsc = new ActionFlushAPIGWDocumentCache();
            fsc.setAPIGateway(or);
            fsc.setMatchPattern(documentPattern);
            actions.add(fsc);
            cacheNames.add("Document");
        }
        if (this.cbxExpiredDocumentCache.isSelected()) {
            String expiredDocumentsPattern = this.tfExpiredDocumentMatchPattern.getText();
            String matchingKeyPattern = this.tfExpiredDocumentMatchingKey.getText();
            ActionFlushExpiredAPIGWDocuments fed = new ActionFlushExpiredAPIGWDocuments();
            fed.setAPIGateway(or);
            fed.setMatchPattern(expiredDocumentsPattern);
            fed.setMatchKey(matchingKeyPattern);
            actions.add(fed);
            cacheNames.add("Expired Document");
        }
        if (this.cbxInvalidateDocument.isSelected()) {
            String invalidatePattern = this.tfInvalidateDocumentMatchPattern.getText();
            ActionInvalidateAPIGWDocumentCache idc = new ActionInvalidateAPIGWDocumentCache();
            idc.setAPIGateway(or);
            idc.setMatchPattern(invalidatePattern);
            actions.add(idc);
            cacheNames.add("Invalid Document");
        }
        if (this.cbxLDAPPoolCache.isSelected()) {
            ActionFlushAPIGWLDAPPoolCache fLdapC = new ActionFlushAPIGWLDAPPoolCache();
            fLdapC.setAPIGateway(or);
            actions.add(fLdapC);
            cacheNames.add("LDAP Pool");
        }
        if ((lastComma = (cacheNameList = StringUtility.getDelimitedString(cacheNames, ", ")).lastIndexOf(", ")) > 0) {
            cacheNameList = StringUtility.replaceAt(cacheNameList, ", ", " and ", lastComma);
        }
        String commandDescription = String.format("Flush %s %s for %s", cacheNameList, cacheNames.size() > 1 ? "Caches" : "Cache", apiGateway);
        for (JMBean jMBean : actions) {
            ActionTool actionTool = new ActionTool(appliance, domain, jMBean);
            actionTool.setCommandDescription(commandDescription);
            actionTool.addManagementCommandSubscriber(this.commandResultsDialog);
        }
    }
}

