/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.cacheManagement;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.JMBean;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.layout.VerticalFlowLayout;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerAction;
import com.kumbasoft.core.beans.actions.ActionFlushArpCache;
import com.kumbasoft.core.beans.actions.ActionFlushDNSCache;
import com.kumbasoft.core.beans.actions.ActionFlushGatewayScriptCache;
import com.kumbasoft.core.beans.actions.ActionFlushNDCache;
import com.kumbasoft.core.beans.actions.ActionFlushRBMCache;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.dpaa.ui.panels.cacheManagement.AbstractCacheManagementPanel;
import java.awt.Dimension;
import java.util.ArrayList;

public class SystemCacheManagementPanel
extends AbstractCacheManagementPanel {
    private JMCheckBox cbxRBMCache;
    private JMCheckBox cbxARPCache;
    private JMCheckBox cbxDNSCache;
    private JMCheckBox cbxNDCache;
    private JMCheckBox cbxGWSCache;

    public SystemCacheManagementPanel() {
        JMPanel cbxPanel = new JMPanel(new VerticalFlowLayout(0, 10));
        this.cbxRBMCache = this.createCheckBox("RBM Cache", "Clear the RBM Cache");
        this.cbxARPCache = this.createCheckBox("ARP Cache", "Clear the rp Cache");
        this.cbxDNSCache = this.createCheckBox("DNS Cache", "Clear the DNS Cache");
        this.cbxNDCache = this.createCheckBox("ND Cache", "Clear the ND Cache");
        this.cbxGWSCache = this.createCheckBox("GatewayScript Cache", "Clear the GatewayScript Cache");
        cbxPanel.addAll(this.cbxRBMCache, this.cbxARPCache, this.cbxDNSCache, this.cbxNDCache, this.cbxGWSCache);
        this.rightPanel.add(cbxPanel);
        new AsynchMethodInvoker((Object)this, "setClearCacheButtonEnabled", (Object)true, 500);
    }

    private JMCheckBox createCheckBox(String label, String toolTip) {
        JMCheckBox checkBox = ComponentFactory.createCheckbox(null, label, toolTip, false, true, null, null, new Object[0]);
        checkBox.setPreferredSize(new Dimension(200, 25));
        return checkBox;
    }

    @Override
    protected String getButtonText() {
        return "Clear Selected Caches";
    }

    @Override
    protected String getButtonToolTip() {
        return "Clears all selected caches";
    }

    @Override
    protected String getActionEventMethod() {
        return "clearSystemCache";
    }

    @Reflected
    private void clearSystemCache() {
        Object dialogTitle = null;
        if (this.cbxRBMCache.isSelected()) {
            dialogTitle = "Clear RBM";
        }
        if (this.cbxARPCache.isSelected()) {
            dialogTitle = dialogTitle == null ? "Clear ARP" : (String)dialogTitle + ", ARP";
        }
        if (this.cbxDNSCache.isSelected()) {
            dialogTitle = dialogTitle == null ? "Clear DNS" : (String)dialogTitle + ", DNS";
        }
        if (this.cbxNDCache.isSelected()) {
            dialogTitle = dialogTitle == null ? "Clear ND" : (String)dialogTitle + ", ND";
        }
        if (this.cbxGWSCache.isSelected()) {
            dialogTitle = dialogTitle == null ? "Clear GWS" : (String)dialogTitle + ", GWS";
        }
        if (((String)dialogTitle).contains(", ")) {
            int comma = ((String)dialogTitle).lastIndexOf(", ");
            String end = ((String)dialogTitle).substring(comma);
            String newEnd = end.replace(", ", " and ");
            dialogTitle = ((String)dialogTitle).replace(end, newEnd);
        }
        dialogTitle = (String)dialogTitle + " Cache";
        this.openResultsDialogAndSetWaitCursor((String)dialogTitle);
        ApplianceDomainChangeMonitor.getInstance().invokeProcessByApplianceSelection(this, "clearSystemCache", true);
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void clearSystemCache(Appliance appliance) {
        ArrayList<DataPowerAction> actions = new ArrayList<DataPowerAction>();
        if (this.cbxRBMCache.isSelected()) {
            actions.add(new ActionFlushRBMCache());
        }
        if (this.cbxARPCache.isSelected()) {
            actions.add(new ActionFlushArpCache());
        }
        if (this.cbxDNSCache.isSelected()) {
            actions.add(new ActionFlushDNSCache());
        }
        if (this.cbxNDCache.isSelected()) {
            actions.add(new ActionFlushNDCache());
        }
        if (this.cbxGWSCache.isSelected()) {
            ActionFlushGatewayScriptCache actionFlushGatewayScriptCache = new ActionFlushGatewayScriptCache();
            actionFlushGatewayScriptCache.setType("path");
            actions.add(actionFlushGatewayScriptCache);
        }
        for (JMBean jMBean : actions) {
            ActionTool actionTool = new ActionTool(appliance, jMBean);
            actionTool.addManagementCommandSubscriber(this.commandResultsDialog);
        }
    }
}

