/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.files;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.io.ASCFileReader;
import com.jmorgan.io.FileWriterHelper;
import com.jmorgan.j2ee.xml.XMLFormatter;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.text.JMCaret;
import com.jmorgan.util.Pair;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.util.DataPowerFileUtility;
import com.kumbasoft.core.util.FileUtility;
import com.kumbasoft.dpaa.ui.dialogs.DataPowerFileDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.event.FocusListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import javax.swing.BoundedRangeModel;
import javax.swing.JEditorPane;
import javax.swing.JScrollBar;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentListener;

public class FileEditorPanel
extends AbstractPanel {
    private String title;
    private String fileContents;
    private String mimeType;
    private DataPowerFileInfo dataPowerFile;
    private File externalFile;
    private JEditorPane fileDataEditor;
    private JMScrollPane scrollPane;
    private JMButton btnClose;
    private JMButton btnFormat;
    private JMButton btnUndo;
    private JMButton btnSave;
    private boolean isEditable;
    private int errorCount = 0;

    public FileEditorPanel(DataPowerFileInfo dataPowerFile) {
        this(dataPowerFile, true);
    }

    public FileEditorPanel(DataPowerFileInfo dataPowerFile, boolean isEditable) {
        super(KumbaCoreUIConstants.createBorderLayout());
        AbstractPanel.logger.fine(() -> LMG.log("(DataPowerFileInfo dataPowerFile=%s, boolean isEditable=%b): Creating Panel", () -> dataPowerFile.getAbsolutePath(), () -> isEditable));
        this.title = String.format("%s - %s - %s", dataPowerFile.getAppliance().getName(), dataPowerFile.getSourceDomain().getName(), dataPowerFile.getAbsolutePath());
        this.createFilePanel(isEditable);
        this.setDataPowerFile(dataPowerFile);
    }

    public FileEditorPanel(File externalFile) {
        super(KumbaCoreUIConstants.createBorderLayout());
        AbstractPanel.logger.fine(() -> LMG.log("(File externalFile=%s): Creating Panel", () -> externalFile.getAbsolutePath()));
        this.title = externalFile.getAbsolutePath();
        this.createFilePanel(true);
        this.setExternalFile(externalFile);
    }

    private void createFilePanel(boolean isEditable) {
        String loggerPrefix = String.format("(isEditable=%s): ", isEditable);
        AbstractPanel.logger.finer(() -> LMG.log("%sStarting", () -> loggerPrefix));
        this.isEditable = isEditable;
        this.btnClose = new JMButton(KumbaCoreUIConstants.STOP_ICON, "Close this file");
        new ActionEventInvoker(this.btnClose, this, "fileClose");
        JMPanel titlePanel = new JMPanel(new BorderLayout());
        JMLabel titleLabel = new JMLabel(this.title);
        titlePanel.add((Component)titleLabel, "Center");
        titlePanel.add((Component)this.btnClose, "East");
        this.add((Component)titlePanel, "North");
        AbstractPanel.logger.finer(() -> LMG.log("%sBuilding editor", () -> loggerPrefix));
        this.fileDataEditor = new JEditorPane();
        if (isEditable) {
            AbstractPanel.logger.finer(() -> LMG.log("%sCreating edit components", () -> loggerPrefix));
            JMCaret caret = new JMCaret();
            caret.setForceSelectionToRemainVisible(true);
            this.fileDataEditor.setCaret(caret);
            caret.setSelectionVisible(true);
            this.btnFormat = new JMButton(KumbaCoreUIConstants.FORMAT_ICON, "Format the current document.");
            new ActionEventInvoker(this.btnFormat, this, "editFormat");
            this.btnUndo = new JMButton(KumbaCoreUIConstants.UNDO_ICON, "Revert all changes back to the last save.");
            new ActionEventInvoker(this.btnUndo, this, "editUndo");
            this.btnSave = new JMButton(KumbaCoreUIConstants.SAVE_ICON, "Saves the file back to DataPower.");
            new ActionEventInvoker(this.btnSave, this, "fileSave");
            JMPanel buttonPanel = KumbaCoreUIConstants.createFlowLayoutPanel(2);
            buttonPanel.addAll(this.btnFormat, this.btnUndo, this.btnSave);
            this.add((Component)buttonPanel, "South");
        } else {
            this.fileDataEditor.setEditable(false);
        }
        AbstractPanel.logger.finer(() -> LMG.log("%sBuilding scroll pane", () -> loggerPrefix));
        this.scrollPane = new JMScrollPane(this.fileDataEditor);
        this.add((Component)this.scrollPane, "Center");
        AbstractPanel.logger.finer(() -> LMG.log("%sDone", () -> loggerPrefix));
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setSynchronizeMode(boolean synchronizing) {
        this.btnFormat.setEnabled(!synchronizing);
        this.btnSave.setEnabled(!synchronizing);
        this.btnUndo.setEnabled(!synchronizing);
    }

    public JEditorPane getFileDataEditor() {
        return this.fileDataEditor;
    }

    public void setEditorFont(Font font) {
        logger.finer(() -> LMG.log("(Font=%s->%s): Starting", () -> font.getFamily(), () -> font.getName()));
        this.fileDataEditor.setFont(font);
        this.invalidate();
        this.repaint();
        logger.finer(() -> LMG.log("(Font=%s->%s): Done", () -> font.getFamily(), () -> font.getName()));
    }

    public JMScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public Pair<JScrollBar, JScrollBar> getScrollBars() {
        JScrollBar horizontalScrollBar = this.scrollPane.getHorizontalScrollBar();
        JScrollBar verticalScrollBar = this.scrollPane.getVerticalScrollBar();
        return new Pair<JScrollBar, JScrollBar>(horizontalScrollBar, verticalScrollBar);
    }

    public void setScrollPosition(int horizontalPosition, int verticalPosition) {
        BoundedRangeModel hModel = this.scrollPane.getHorizontalScrollBar().getModel();
        BoundedRangeModel vModel = this.scrollPane.getVerticalScrollBar().getModel();
        AbstractPanel.logger.finer(() -> LMG.log("(horizontalPosition=%d, verticalPosition=%d)", () -> horizontalPosition, () -> verticalPosition));
        FileEditorPanel.setScrollPosition(hModel, horizontalPosition);
        FileEditorPanel.setScrollPosition(vModel, verticalPosition);
    }

    private static void setScrollPosition(BoundedRangeModel model, int position) {
        int extent = model.getExtent();
        int maximum = model.getMaximum();
        int upperLimit = maximum - extent;
        if (position < upperLimit) {
            try {
                model.setValue(position);
            }
            catch (Exception e) {
                AbstractPanel.logger.warning(() -> LMG.log("(BoundedRangeModel, position=%d): Error synchronizing scrolling:  %s", () -> position, () -> e.getMessage()));
            }
        }
    }

    public Pair<BoundedRangeModel, BoundedRangeModel> getScrollModel() {
        BoundedRangeModel hModel = this.scrollPane.getHorizontalScrollBar().getModel();
        BoundedRangeModel vModel = this.scrollPane.getVerticalScrollBar().getModel();
        return new Pair<BoundedRangeModel, BoundedRangeModel>(hModel, vModel);
    }

    public void setScrollModel(BoundedRangeModel horizontalScrollModel, BoundedRangeModel verticalScrollBar) {
        this.scrollPane.getHorizontalScrollBar().setModel(horizontalScrollModel);
        this.scrollPane.getVerticalScrollBar().setModel(verticalScrollBar);
    }

    public int getContentsSize() {
        return this.fileDataEditor.getText().length();
    }

    public void setDataPowerFile(DataPowerFileInfo dataPowerFile) {
        this.dataPowerFile = dataPowerFile;
        this.fileContents = new String(this.dataPowerFile.getFileData());
        String fileName = dataPowerFile.getFileName().toLowerCase();
        this.initFileEditor(fileName);
    }

    public void setExternalFile(File externalFile) {
        this.externalFile = externalFile;
        try {
            ASCFileReader reader = new ASCFileReader(this.externalFile);
            this.fileContents = reader.readAll();
            logger.finer(() -> LMG.log("(File externalFile=%s): Contents Size: %d", () -> externalFile.getAbsolutePath(), () -> this.fileContents.length()));
            this.initFileEditor(externalFile.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initFileEditor(String fileName) {
        boolean error = false;
        String mimeType = this.setMimeType(fileName);
        String applianceName = this.dataPowerFile == null ? "Not On Appliance" : this.dataPowerFile.getAppliance().getName();
        String domainName = this.dataPowerFile == null ? "Not In A Domain" : this.dataPowerFile.getSourceDomain().getName();
        AbstractPanel.logger.finer(() -> LMG.log("(fileName = '%s->%s->%s'): Guessed mimeType is %s.", () -> applianceName, () -> domainName, () -> fileName, () -> mimeType));
        try {
            this.fileDataEditor.setContentType(mimeType);
            this.fileDataEditor.setText(this.fileContents);
            this.errorCount = 0;
        }
        catch (NullPointerException e) {
            AbstractPanel.logger.severe(() -> LMG.log("(fileName = '%s->%s->%s'): NullPointerException tyring to set mimeType '%s' to editor:  %s.", () -> applianceName, () -> domainName, () -> fileName, () -> mimeType, () -> e.getMessage()));
            error = true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            AbstractPanel.logger.severe(() -> LMG.log("(fileName = '%s->%s->%s'): Array Index Out of bounds assigning file contents of size %d to editor:  %s.", () -> applianceName, () -> domainName, () -> fileName, () -> this.fileContents.length(), () -> e.getMessage()));
            error = true;
        }
        catch (Error e) {
            AbstractPanel.logger.severe(() -> LMG.log("(fileName = '%s->%s%s'): Error assigning file contents of size %d to editor:  %s.", () -> applianceName, () -> domainName, () -> fileName, () -> this.fileContents.length(), () -> e.getMessage()));
            error = true;
        }
        if (error) {
            if (this.errorCount < 10) {
                ++this.errorCount;
                AbstractPanel.logger.info(() -> LMG.log("(fileName = '%s->%s->%s'): Retry #%d.", () -> applianceName, () -> domainName, () -> fileName, () -> this.errorCount));
                new AsynchMethodInvoker((Object)this, "initFileEditor", (Object)fileName, this.errorCount * KumbaCoreConstants.THREAD_WAIT);
            } else {
                this.fileDataEditor.setText("Error reading file.  Try again.");
                this.errorCount = 0;
            }
        }
        this.repaint();
    }

    public boolean isReady() {
        return this.errorCount == 0;
    }

    private String setMimeType(String fileName) {
        this.mimeType = FileUtility.getMimeType(fileName);
        return this.mimeType;
    }

    public void addDocumentListener(DocumentListener listener) {
        this.fileDataEditor.getDocument().addDocumentListener(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.fileDataEditor.getDocument().removeDocumentListener(listener);
    }

    public void addCaretListener(CaretListener listener) {
        this.fileDataEditor.addCaretListener(listener);
    }

    public void removeCaretListener(CaretListener listener) {
        this.fileDataEditor.removeCaretListener(listener);
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        if (listener instanceof DataPowerFileDialog) {
            this.fileDataEditor.addFocusListener(listener);
        } else {
            super.addFocusListener(listener);
        }
    }

    @Override
    public void removeFocusListener(FocusListener listener) {
        if (listener instanceof DataPowerFileDialog) {
            this.fileDataEditor.removeFocusListener(listener);
        } else {
            super.removeFocusListener(listener);
        }
    }

    public boolean isDirty() {
        return !this.fileContents.equals(this.fileDataEditor.getText());
    }

    @Reflected
    private void fileClose() {
        Container c = this.getParent();
        c.repaint(50L);
        c.remove(this);
    }

    @Reflected
    public void editFormat() {
        logger.finer("()");
        if (this.mimeType.equals("text/xml")) {
            try {
                String editorText = this.fileDataEditor.getText();
                editorText = XMLFormatter.format(editorText);
                this.fileDataEditor.setText(editorText);
            }
            catch (RuntimeException e) {
                logger.warning(() -> LMG.log("(): %s\n", () -> e.getMessage()));
            }
        }
        logger.finer("()");
    }

    @Reflected
    public void editUndo() {
        logger.finer("():  Starting");
        this.fileDataEditor.setText(this.fileContents);
        logger.finer("():  Done");
    }

    @Reflected
    public void fileSave() {
        logger.finer("(): Starting");
        this.fileContents = this.fileDataEditor.getText();
        if (this.dataPowerFile != null) {
            logger.finer(() -> LMG.log("(): Saving the DataPower File %s", () -> this.dataPowerFile.getAbsolutePath()));
            this.saveDataPowerFile();
        } else if (this.externalFile != null) {
            logger.finer(() -> LMG.log("(): Saving the external File %s", () -> this.externalFile.getAbsolutePath()));
            this.saveExternalFile();
        }
        logger.finer("(): Done");
    }

    private void saveDataPowerFile() {
        logger.finer("(): Starting");
        this.dataPowerFile.setFileContent(this.fileContents);
        DataPowerFileUtility.saveDataPowerFiles(this.dataPowerFile);
        logger.finer("(): Done");
    }

    private void saveExternalFile() {
        logger.finer("(): Starting");
        FileWriterHelper fw = new FileWriterHelper(this.externalFile);
        fw.open();
        BufferedWriter bw = (BufferedWriter)fw.getWriter();
        try {
            bw.write(this.fileContents);
            bw.close();
        }
        catch (IOException e) {
            logger.severe(() -> LMG.log("(): Error writing External File '%s' - '%s'", () -> this.externalFile.getAbsolutePath(), () -> e.getMessage()));
            e.printStackTrace();
        }
        logger.finer("(): Done");
    }
}

