/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.files;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.io.ASCFileWriter;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMScrollPane;
import com.jmorgan.swing.JMTable;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.dialog.wizard.WizardDialog;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.event.ListSelectionEventInvoker;
import com.jmorgan.swing.list.JMListCellRenderer;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.swing.menu.PopupMenuController;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.swing.util.ComponentService;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.Index;
import com.jmorgan.util.Pair;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.SubstringSelector;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigObjectCache;
import com.kumbasoft.core.beans.ConfigObjectSubscriber;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.ConfigurationRelationshipType;
import com.kumbasoft.core.beans.CopyMoveFilesBean;
import com.kumbasoft.core.beans.CopyMoveType;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.beans.actions.ActionCreateDir;
import com.kumbasoft.core.beans.status.StatusHSMKeyStatus;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.tools.ActionController;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.DataPowerFileReader;
import com.kumbasoft.core.tools.DirectoryCopyMove;
import com.kumbasoft.core.tools.DirectoryDeleter;
import com.kumbasoft.core.tools.DirectoryLister;
import com.kumbasoft.core.tools.FileCopyMove;
import com.kumbasoft.core.tools.FileRename;
import com.kumbasoft.core.tools.FileUploader;
import com.kumbasoft.core.tools.ListFiles;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.AbstractSearchPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.models.DataPowerFileInfoColumnModel;
import com.kumbasoft.core.ui.models.DataPowerFileInfoTableModel;
import com.kumbasoft.core.util.DataPowerFileUtility;
import com.kumbasoft.core.util.FileUtility;
import com.kumbasoft.core.util.HSMFSUtil;
import com.kumbasoft.core.util.RegexUtility;
import com.kumbasoft.dpaa.ui.dialogs.ConfigurationRelationshipDialog;
import com.kumbasoft.dpaa.ui.dialogs.DataPowerFileDialog;
import com.kumbasoft.dpaa.ui.dialogs.copymoveWizard.CopyMoveDirectoriesWizardDialog;
import com.kumbasoft.dpaa.ui.dialogs.copymoveWizard.CopyMoveFilesWizardDialog;
import com.kumbasoft.dpaa.ui.dialogs.fileWizards.DeleteFilesBean;
import com.kumbasoft.dpaa.ui.dialogs.fileWizards.DeleteFilesWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.fileWizards.NewFileReviewWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.fileWizards.NewFileWizardContentPage;
import com.kumbasoft.dpaa.ui.dialogs.fileWizards.NewFileWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.fileWizards.RenameFilesWarningPage;
import com.kumbasoft.dpaa.ui.dialogs.fileWizards.RenameFilesWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.fileWizards.SearchReplaceWizardDialog;
import com.kumbasoft.dpaa.ui.dialogs.manageDirectoriesWizards.CreateDirectoryWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.manageDirectoriesWizards.DeleteDirectoryWizardPage;
import com.kumbasoft.dpaa.ui.panels.files.CreateNewFIle;
import com.kumbasoft.dpaa.ui.panels.files.ManageFilesPopupMenu;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.ListModel;

public class ManageFilesPanel
extends AbstractSearchPanel<DataPowerFileInfo>
implements ConfigObjectSubscriber<DataPowerFileInfo>,
ManagementCommandSubscriber,
PopupMenuController {
    private static final String FILE_SEARCH = "FILE_SEARCH";
    private static final String FILE_NEW = "FILE_NEW";
    private static final String FILE_OPEN = "FILE_OPEN";
    private static final String FILE_COPY = "FILE_COPY";
    private static final String FILE_MOVE = "FILE_MOVE";
    private static final String FILE_SAVE = "FILE_SAVE";
    private static final String FILE_RENAME = "FILE_RENAME";
    private static final String FILE_DELETE = "FILE_DELETE";
    private static final String[] EXPORT_EXCLUSIONS = new String[]{"sharedcert:", "cert:", "isamcert:", "hsm:", "image:", "policyframework:"};
    private static final String[] REFACTOR_EXCLUSIONS = new String[]{"cert:", "isamcert:", "export:", "hsm:", "image:", "policyframework:"};
    private static final String[] CONTENT_SEARCH_EXCLUSIONS = new String[]{"cert:", "sharedcert:", "pubcert:", "isamcert:", "export:", "image:", "hsm:", "chkpoints:", "temporary:/log", "temporary:/image"};
    private JMListModel<String> directoryListModel;
    private JMList<String> directoryList;
    private JMListCellRenderer<String> directoryRenderer;
    private JMButton btnAddDirectory;
    private JMButton btnDeleteDirectory;
    private JMButton btnCopyDirectory;
    private ConfigObjectCache<DataPowerFileInfo> dpDirectoryCache;
    private Index<String, DataPowerFileInfo> nameIndex;
    private JMCheckBox cbxSearchContents;
    private JMTextField tfContentsPattern;
    private final ReadWriteLock LOCK = new ReentrantReadWriteLock();
    private boolean searchContents;
    private Pattern contentsPattern;
    private ArrayList<DataPowerFileInfo> filesToSearch;
    private int processFileNumber;
    private Index<String, DataPowerFileInfo> searchDirectories;
    private String processConfigAction;
    private DataPowerFileDialog dataPowerFileDialog;
    private Index<Appliance, Domain> lastSelectionOnHold;
    private boolean readingDirectories = false;
    private File lastDirectory;
    private AsynchMethodInvoker<Void> tableRepaintThread;

    public ManageFilesPanel() {
        super(DataPowerFileInfo.class);
        this.topPanel.add(this.createContentsSearchPanel());
        this.createDirectoryManagementList();
        this.createPopupMenu();
        if (this.displayTable == null) {
            logger.severe("(): display table is null.  Timing issue?");
        }
        this.popupMenu.addPopupMenuClient(this.displayTable);
        this.dpDirectoryCache = new ConfigObjectCache();
        ApplianceDomainChangeMonitor.getInstance().addDomainChangeSubscriber(this, "domainsChanged");
    }

    @Override
    public void updateUI() {
        if (this.directoryRenderer != null) {
            KumbaCoreUIConstants.setupRenderer(this.directoryRenderer);
        }
        super.updateUI();
    }

    private void createDirectoryManagementList() {
        this.directoryListModel = new JMListModel();
        this.directoryList = new JMList<String>((ListModel<String>)this.directoryListModel);
        this.directoryRenderer = (JMListCellRenderer)this.directoryList.getCellRenderer();
        JMScrollPane scroller = new JMScrollPane(this.directoryList);
        new ListSelectionEventInvoker(this.directoryList, this, "checkDirectoryButtonState");
        JMLabel listLabel = new JMLabel("Directories:");
        this.btnAddDirectory = new JMButton(KumbaCoreUIConstants.ADD_ICON, "Add a new directory to the selected appliances, domains and directories");
        new ActionEventInvoker(this.btnAddDirectory, this, "createDirectory");
        this.btnDeleteDirectory = new JMButton(KumbaCoreUIConstants.DELETE_ICON, "Delete the selected directories from the selected appliances, and domains.");
        this.btnDeleteDirectory.setEnabled(false);
        new ActionEventInvoker(this.btnDeleteDirectory, this, "deleteDirectory");
        this.btnCopyDirectory = new JMButton(KumbaCoreUIConstants.COPY_ICON, "Copy the selected directories to another domain or other appliances.");
        this.btnCopyDirectory.setEnabled(false);
        new ActionEventInvoker(this.btnCopyDirectory, this, "copyDirectory");
        JMPanel buttonPanel = new JMPanel(new FlowLayout(2));
        buttonPanel.addAll(this.btnAddDirectory, this.btnDeleteDirectory, this.btnCopyDirectory);
        JMPanel labelPanel = KumbaCoreUIConstants.createBorderLayoutPanel();
        labelPanel.add((Component)listLabel, "Center");
        labelPanel.add((Component)buttonPanel, "East");
        this.leftPanel.add((Component)labelPanel, "North");
        this.leftPanel.add((Component)scroller, "Center");
    }

    private JMPanel createContentsSearchPanel() {
        this.cbxSearchContents = new JMCheckBox("Search Contents:");
        this.tfContentsPattern = new JMTextField();
        this.tfContentsPattern.setPreferredSize(414, 25);
        ComponentService.addClearIcon(this.tfContentsPattern, "Clear the search expression.");
        ComponentService.addHelpIcon(this.tfContentsPattern, this.getHelpFile("contentsField", "Enter a regular expression for finding text withing the files' contents."));
        JMPanel searchContentsPanel = new JMPanel(new FlowLayout(0, 10, 1));
        searchContentsPanel.addAll(ComponentFactory.createSpacer(4, 1), this.cbxSearchContents, this.tfContentsPattern);
        return searchContentsPanel;
    }

    @Override
    protected void createPopupMenu() {
        logger.finer("(): Starting");
        if (this.displayTableScrollPane == null) {
            logger.severe("(): display table scroll pane is NULL.  Timing issue?");
        }
        this.popupMenu = new ManageFilesPopupMenu(this, this.displayTable, this.displayTableScrollPane);
        logger.finer("(): Done");
    }

    @Override
    protected String getTFPatternLabel() {
        return "File Name Match Pattern:";
    }

    @Override
    protected int getMatchPatternLabelWidth() {
        return 150;
    }

    @Override
    protected String getProcessMethodName() {
        return "listFiles";
    }

    @Override
    public BeanTableModel<DataPowerFileInfo> getTableModel() {
        return new DataPowerFileInfoTableModel();
    }

    @Override
    protected BeanColumnModel<DataPowerFileInfo> getColumnModel() {
        DataPowerFileInfoColumnModel columnModel = new DataPowerFileInfoColumnModel();
        return columnModel;
    }

    @Reflected
    void domainsChanged(Index<Appliance, Domain> domainSelection) {
        if (this.readingDirectories) {
            logger.finer("(Index<Appliance, Domain> domainSelection): Actively reading directories.  Will wait so we don't have a collision.");
            this.lastSelectionOnHold = domainSelection;
            return;
        }
        this.LOCK.writeLock().lock();
        try {
            logger.finer("(Index<Appliance, Domain> domainSelection): Starting to read new list of directories");
            this.readingDirectories = true;
            this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
            this.directoryList.clearSelection();
            this.dpDirectoryCache.clearCache();
            this.displayTable.clearSelection();
            this.tableModel.reset();
            this.displayTable.repaint();
            boolean isDefaultInScope = false;
            block3: for (Appliance appliance : domainSelection.getKeys()) {
                Collection<Domain> domains = domainSelection.get(appliance);
                for (Domain domain : domains) {
                    if (!domain.getName().equals("default")) continue;
                    logger.finer("(Index<Appliance, Domain> domainSelection): 'default' domain is selected.");
                    isDefaultInScope = true;
                    break block3;
                }
                if (CollectionUtility.isNotEmpty(domains)) break;
            }
            ArrayList<String> fileStores = new ArrayList<String>();
            String[] stringArray = DPEnumerations.FILESTORE_LOCATION;
            int domain = DPEnumerations.FILESTORE_LOCATION.length;
            int domains = 0;
            while (domains < domain) {
                Object fileStore = stringArray[domains];
                if (Comparison.isIn(fileStore, DataPowerFileUtility.FILESTORE_EXCLUSIONS)) {
                    logger.finer(() -> ManageFilesPanel.lambda$0((String)fileStore));
                } else if (!isDefaultInScope && Comparison.isIn(fileStore, DataPowerFileUtility.DEFAULT_DOMAIN_FILESTORES)) {
                    logger.finer(() -> ManageFilesPanel.lambda$2((String)fileStore));
                } else {
                    fileStores.add((String)fileStore);
                }
                ++domains;
            }
            if (isDefaultInScope) {
                logger.finer("(Index<Appliance, Domain> domainSelection): Looking for HSM keys in all selected appliances.");
                Collection<StatusHSMKeyStatus> hsmKeys = HSMFSUtil.getHSMKeys(domainSelection.getKeys());
                if (CollectionUtility.isNotEmpty(hsmKeys)) {
                    logger.finer("(Index<Appliance, Domain> domainSelection): At least one appliance has HSM keys.  Including 'hsm:' as a filestore.");
                    fileStores.add("hsm:");
                }
            }
            logger.finer("(Index<Appliance, Domain> domainSelection): Building list directory threads.");
            MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
            DirectoryLister.list(domainSelection, fileStores, mtil);
            DirectoryLister.addConfigObjectSubscriber(this.dpDirectoryCache);
            boolean completedOK = ThreadManager.monitorAsynchThreadLifeCycle("ManageFilesPanel.domainsChanged(...)", mtil, fileStores.size() * KumbaCoreConstants.STARTUP_DELAY, 0);
            if (completedOK) {
                logger.finer("(Index<Appliance, Domain> domainSelection) List directories threads complete.  Building unique directory name list.");
            } else {
                logger.warning("(Index<Appliance, Domain> domainSelection) List directories threads did not complete on time.  Building unique directory name list with what we have.");
            }
            UniqueArrayList<Object> directoryNames = new UniqueArrayList<Object>();
            for (DataPowerFileInfo dpFileInfo : this.dpDirectoryCache.getObjectCache()) {
                if (dpFileInfo == null) continue;
                Object dpDirName = dpFileInfo.getName();
                if (!((String)dpDirName).endsWith("/")) {
                    dpDirName = (String)dpDirName + "/";
                }
                dpDirName = StringUtility.coalesce((String)dpDirName, "/");
                dpFileInfo.setName((String)dpDirName);
                directoryNames.add(dpDirName);
            }
            Collections.sort(directoryNames);
            logger.finer("(Index<Appliance, Domain> domainSelection) Unique directory name list complete.  Building new name index.");
            if (this.nameIndex != null) {
                this.nameIndex.clear();
                this.nameIndex = null;
            }
            BeanIndexer<DataPowerFileInfo> nameIndexer = new BeanIndexer<DataPowerFileInfo>(this.dpDirectoryCache.getObjectCache());
            this.nameIndex = nameIndexer.getIndexOf("name", null);
            logger.finer("(Index<Appliance, Domain> domainSelection). Cleaning up. Refreshing directory name list.");
            this.directoryListModel.clear();
            this.directoryListModel.addAll(directoryNames);
            this.readingDirectories = false;
            logger.finer("(Index<Appliance, Domain> domainSelection) Processing directories complete.");
            if (this.lastSelectionOnHold != null) {
                logger.fine("(Index<Appliance, Domain> domainSelection) Selection changed during read.  Invoking domainChanged processes again with last domain selection received.");
                new AsynchMethodInvoker((Object)this, "domainsChanged", this.lastSelectionOnHold);
                this.lastSelectionOnHold = null;
            }
            this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
        }
        finally {
            this.LOCK.writeLock().unlock();
        }
        logger.finer("Done");
    }

    @Override
    public boolean isPopupReady() {
        this.popupMenu.setMenuItemEnabled(".*", true);
        int rowCount = this.displayTable.getSelectedRowCount();
        if (rowCount == 0) {
            this.popupMenu.setMenuItemEnabled("(open|copy|move|export|refactor|replace|delete|showReferenced).*", false);
        } else {
            ArrayList<DataPowerFileInfo> exportableFiles;
            ArrayList<DataPowerFileInfo> refactorableFiles = this.getRefactorableFiles();
            if (CollectionUtility.isEmpty(refactorableFiles)) {
                this.popupMenu.setMenuItemEnabled("refactor.*", false);
            }
            if (CollectionUtility.isEmpty(exportableFiles = this.getExportableFiles())) {
                this.popupMenu.setMenuItemEnabled("export.*", false);
            }
        }
        return true;
    }

    @Reflected
    private void listFiles() {
        ArrayList<DataPowerFileInfo> searchDirectoryList;
        logger.finer("():  Starting");
        if (this.searchDirectories != null) {
            this.searchDirectories.clear();
            this.searchDirectories = null;
        }
        if (CollectionUtility.isNotEmpty(searchDirectoryList = this.getSelectedDirectories(true))) {
            BeanIndexer<DataPowerFileInfo> indexer = new BeanIndexer<DataPowerFileInfo>(searchDirectoryList);
            this.searchDirectories = indexer.getIndexOf("name", null);
        }
        this.searchContents = this.cbxSearchContents.isSelected();
        String contentsSearchString = this.tfContentsPattern.getText();
        if (StringUtility.isEmpty(contentsSearchString)) {
            this.searchContents = false;
        } else {
            try {
                String normalizedPattern = RegexUtility.normalizeRegex(contentsSearchString, this.useCaseSensitiveSearch);
                logger.finer(() -> LMG.log("(): Normalized regex is: %s,", () -> normalizedPattern));
                this.contentsPattern = Pattern.compile(normalizedPattern, 8);
            }
            catch (PatternSyntaxException e) {
                String message = LabelUtility.wrapInHTML("The search expression for contents is not a valid\nregular expression.\n\n" + e.getMessage());
                new JMMessageBox((JFrame)frame, "Invalid Content Search Regular Expression", message);
                this.resetUI();
                return;
            }
        }
        logger.finer("(): Listing Files.");
        Index<Appliance, Domain> searchDomains = ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection();
        ArrayList searchDirectoryNames = (ArrayList)this.searchDirectories.getKeys();
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        String matchPattern = this.getMatchPattern();
        ListFiles.list(searchDomains, searchDirectoryNames, matchPattern, mtil);
        ListFiles.addConfigObjectSubscriber(this);
        logger.fine(() -> LMG.log("(): There are %d running threads.", () -> mtil.getRunningThreadCount()));
        boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("ManageFilesPanel.listFiles()", mtil, KumbaCoreConstants.STARTUP_DELAY * 2, KumbaCoreConstants.THREAD_TIMEOUT);
        if (!completedOnTime) {
            logger.warning(() -> LMG.log("(): File list did not complete on time.  There are %d running threads.  Continuing with what we have.", () -> mtil.getRunningThreadCount()));
        }
        if (this.searchContents && CollectionUtility.isNotEmpty(this.filesToSearch)) {
            logger.info("(): Searching files by content.");
            this.searchFilesByContent();
        }
        this.resetUI();
        logger.finer("():  Done");
    }

    @Override
    public void processDataPowerConfig(DataPowerFileInfo dataPowerFile) {
        String loggerPrefix = String.format("(DataPowerFileInfo=%s): ", dataPowerFile.getFQON());
        AbstractPanel.logger.finer(() -> LMG.log("%s Starting", () -> loggerPrefix));
        byte[] fileData = dataPowerFile.getFileData();
        switch (this.processConfigAction) {
            case "FILE_SEARCH": {
                AbstractPanel.logger.finer(() -> LMG.log("%s Searching", () -> loggerPrefix));
                Object directory = dataPowerFile.getBaseDirectory();
                String directoryF = directory;
                boolean directoryMatches = true;
                if (!CollectionUtility.isEmpty(this.searchDirectories)) {
                    if (!((String)directory).endsWith("/")) {
                        directory = (String)directory + "/";
                    }
                    if (!this.searchDirectories.containsKey((String)directory)) {
                        directoryMatches = false;
                        AbstractPanel.logger.finer(() -> LMG.log("%s Directory %s does not match search selection", () -> loggerPrefix, () -> directoryF));
                    }
                    if (directoryMatches) {
                        AbstractPanel.logger.finer(() -> LMG.log("%s Directory %s matches search selection", () -> loggerPrefix, () -> directoryF));
                    }
                }
                if (!directoryMatches) break;
                if (this.searchContents) {
                    long endTime;
                    long elapsed;
                    this.updateProgressBar(++this.processFileNumber);
                    if (Comparison.startsWith((String)directory, CONTENT_SEARCH_EXCLUSIONS)) {
                        AbstractPanel.logger.finer(() -> LMG.log("%s Skipping search by content due to search exclusion for '%s'", () -> loggerPrefix, () -> directoryF));
                        break;
                    }
                    AbstractPanel.logger.finer(() -> LMG.log("%s Searching by file contents...", () -> loggerPrefix));
                    if (ArrayUtility.isEmpty(fileData)) {
                        AbstractPanel.logger.finer(() -> LMG.log("%s Adding file to read for searching content...", () -> loggerPrefix));
                        this.filesToSearch.add(dataPowerFile);
                        break;
                    }
                    AbstractPanel.logger.finer(() -> LMG.log("%s Got file data of %d bytes.  Searching contents.", () -> loggerPrefix, () -> fileData.length));
                    String fileText = new String(fileData);
                    Matcher matcher = this.contentsPattern.matcher(fileText);
                    long startTime = System.currentTimeMillis();
                    if (matcher.find()) {
                        AbstractPanel.logger.finer(() -> LMG.log("%s Match by contents successful", () -> loggerPrefix));
                        this.addRow(dataPowerFile);
                    }
                    if ((elapsed = (endTime = System.currentTimeMillis()) - startTime) > 5000L) {
                        AbstractPanel.logger.info(() -> LMG.log("%s Search Completed with latency of %dms.", () -> loggerPrefix, () -> elapsed));
                        break;
                    }
                    AbstractPanel.logger.finer(() -> LMG.log("%s Search Completed with latency of %dms.", () -> loggerPrefix, () -> elapsed));
                    break;
                }
                AbstractPanel.logger.finer(() -> LMG.log("%s Match by name successful", () -> loggerPrefix));
                this.addRow(dataPowerFile);
                break;
            }
            case "FILE_OPEN": {
                AbstractPanel.logger.finer(() -> LMG.log("%s Opening File in dialog.", () -> loggerPrefix));
                this.LOCK.writeLock().lock();
                try {
                    this.dataPowerFileDialog.addDataPowerFile(dataPowerFile);
                }
                catch (Throwable throwable) {
                    AbstractPanel.logger.finer(() -> LMG.log("%s Releasing write lock.", () -> loggerPrefix));
                    this.LOCK.writeLock().unlock();
                    throw throwable;
                }
                AbstractPanel.logger.finer(() -> LMG.log("%s Releasing write lock.", () -> loggerPrefix));
                this.LOCK.writeLock().unlock();
                break;
            }
            case "FILE_SAVE": {
                AbstractPanel.logger.finer(() -> LMG.log("%s Saving", () -> loggerPrefix));
                this.saveFile(dataPowerFile, fileData);
                break;
            }
            case "FILE_DELETE": {
                AbstractPanel.logger.finer(() -> LMG.log("%s Deleting", () -> loggerPrefix));
                this.updateProgressBar(++this.processFileNumber);
            }
        }
        AbstractPanel.logger.finer(() -> LMG.log("%s Done", () -> loggerPrefix));
    }

    private void searchFilesByContent() {
        AbstractPanel.logger.finer("(): Starting");
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        this.processFileNumber = 0;
        this.showProgressBar(this.filesToSearch.size());
        this.progressBar.setValue(0);
        DataPowerFileReader.readFiles(this.filesToSearch, mtil, this);
        AbstractPanel.logger.fine(() -> LMG.log("():  There are %d threads running so far.  Waiting.", () -> mtil.getRunningThreadCount()));
        boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("ManageFilesPanel.searchFilesByContent()", mtil, KumbaCoreConstants.STARTUP_DELAY, KumbaCoreConstants.MAXIMUM_TIMEOUT);
        if (!completedOnTime) {
            AbstractPanel.logger.warning(() -> LMG.log("():  Did not complete searching for files in time with %d threads still running.  This still may complete, but returning control to the user.", () -> mtil.getRunningThreadCount()));
        } else {
            AbstractPanel.logger.finer("(): Done reading files");
        }
        this.hideProgressBar();
        AbstractPanel.logger.finer("(): Done");
    }

    private boolean saveFile(DataPowerFileInfo dataPowerFile, byte[] fileData) {
        File outputFile = ManageFilesPanel.getOutputFile(dataPowerFile);
        String statusTitle = String.format("Save File %s", outputFile.getAbsolutePath());
        boolean successful = FileUtility.writeFile(outputFile, fileData);
        if (successful) {
            ManagementCommandStatus status = new ManagementCommandStatus(dataPowerFile.getAppliance(), dataPowerFile.getSourceDomain(), statusTitle, null, "Save succeeded");
            this.commandResultsDialog.commandSucceeded(status);
        } else {
            ManagementCommandError error = new ManagementCommandError(dataPowerFile.getAppliance(), dataPowerFile.getSourceDomain(), statusTitle, null, "Failed to save file");
            this.commandResultsDialog.commandFailed(error);
        }
        return successful;
    }

    private static File getOutputFile(DataPowerFileInfo dataPowerFile) {
        String baseDirName = String.format("%s%s%s%s%s", applicationProperties.getFileBackupDirectory(), File.separator, dataPowerFile.getAppliance().getName(), File.separator, dataPowerFile.getSourceDomain().getName());
        File baseDir = new File(baseDirName);
        baseDir.mkdirs();
        String dataPowerDirectory = dataPowerFile.getBaseDirectory();
        dataPowerDirectory = dataPowerDirectory.replace(":", "");
        baseDir = new File(baseDir, dataPowerDirectory);
        baseDir.mkdirs();
        String dpFileName = dataPowerFile.getFileName();
        File outputFile = new File(baseDir, dpFileName);
        Application.getApplication().getApplicationLogger().fine(String.format("ManageFilesPanel.getOutputFile(DataPowerFileInfo): *****  Output File Name: %s", outputFile));
        return outputFile;
    }

    @Override
    public void configProcessingComplete() {
    }

    @Reflected
    private void checkDirectoryButtonState() {
        boolean buttonsEnabled = this.directoryList.getSelectedIndex() >= 0;
        this.btnCopyDirectory.setEnabled(buttonsEnabled);
        this.btnDeleteDirectory.setEnabled(buttonsEnabled);
    }

    @Reflected
    private void createDirectory() {
        ArrayList<DataPowerFileInfo> selectedDirectories = this.getSelectedDirectories(false);
        if (selectedDirectories == null) {
            new JMMessageBox((JFrame)frame, "No Directories Selected", LabelUtility.wrapInHTML("At least one parent directory must be selected.\n\nPlease Select at least one directory in which\nto create the new directory."));
            return;
        }
        DynamicBean createDirectoryData = new DynamicBean();
        createDirectoryData.setProperty("selectedDirectories", selectedDirectories);
        createDirectoryData.setProperty("directoryName", "");
        WizardDialog<DynamicBean> createDirectoryWizard = new WizardDialog<DynamicBean>((JFrame)frame, "Create Directory");
        createDirectoryWizard.addWizardPage(new CreateDirectoryWizardPage(createDirectoryData), "createDirectory");
        createDirectoryWizard.setSize(1000, 600);
        createDirectoryWizard.startWizard();
        if (WizardDialog.wasCancelled() || StringUtility.isEmpty((String)createDirectoryData.getProperty("directoryName"))) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Create Directory");
        for (DataPowerFileInfo selectedDirectory : selectedDirectories) {
            Object selectedDirectoryName = selectedDirectory.getName().trim();
            if (!((String)selectedDirectoryName).endsWith("/")) {
                selectedDirectoryName = (String)selectedDirectoryName + "/";
            }
            String newDirectoryName = String.format("%s%s", selectedDirectoryName, createDirectoryData.getProperty("directoryName"));
            String newDirectoryNameF = newDirectoryName = StringUtility.coalesce(newDirectoryName, "/");
            logger.config(() -> LMG.log("Creating Directory For:  %s -> %s -> %s", () -> selectedDirectory.getAppliance().getName(), () -> selectedDirectory.getSourceDomain().getName(), () -> newDirectoryNameF));
            ActionCreateDir createDirectoryAction = new ActionCreateDir();
            createDirectoryAction.setDir(newDirectoryName);
            ActionTool actionTool = new ActionTool(selectedDirectory.getAppliance(), selectedDirectory.getSourceDomain(), createDirectoryAction);
            actionTool.setCommandDescription(String.format("Create Directory %s", newDirectoryName));
            actionTool.addManagementCommandSubscriber(this.commandResultsDialog);
        }
        this.waitForResultsDialogToCloseAndResetCursor();
        this.domainsChanged(ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection());
    }

    @Reflected
    private void copyDirectory() {
        this.copyMoveDirectory(FILE_COPY);
    }

    private void copyMoveDirectory(String mode) {
        String loggerPrefix = String.format("(mode = %s)", mode);
        AbstractPanel.logger.finer(() -> LMG.log("%s: Starting.", () -> loggerPrefix));
        ArrayList<DataPowerFileInfo> selectedDirectories = this.getSelectedDirectories(false);
        if (selectedDirectories == null) {
            AbstractPanel.logger.info(() -> LMG.log("%s: No directories selected.  Returning.", () -> loggerPrefix));
            return;
        }
        String dialogTitle = mode.equals(FILE_COPY) ? "Copy Directory" : "Move Directory";
        AbstractPanel.logger.finer(() -> LMG.log("%s: Setting up wizard.", () -> loggerPrefix));
        CopyMoveFilesBean copyMoveFilesBean = new CopyMoveFilesBean(selectedDirectories);
        copyMoveFilesBean.setMode(mode.equals(FILE_COPY) ? 0 : 1);
        new CopyMoveDirectoriesWizardDialog((JFrame)frame, dialogTitle, copyMoveFilesBean);
        if (WizardDialog.wasCancelled()) {
            AbstractPanel.logger.info(() -> LMG.log("%s: Wizard was cancelled.  Returning.", () -> loggerPrefix));
            return;
        }
        this.openResultsDialogAndSetWaitCursor(dialogTitle);
        DirectoryCopyMove processor = new DirectoryCopyMove(copyMoveFilesBean);
        processor.addManagementCommandSubscriber(this.commandResultsDialog);
        this.waitForResultsDialogToCloseAndResetCursor();
        this.domainsChanged(ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection());
        AbstractPanel.logger.finer(() -> LMG.log("%s: Done.", () -> loggerPrefix));
    }

    @Reflected
    private void deleteDirectory() {
        ArrayList<DataPowerFileInfo> selectedDirectories = this.getSelectedDirectories(false);
        if (selectedDirectories == null) {
            return;
        }
        DynamicBean deleteDirectoryData = new DynamicBean();
        deleteDirectoryData.setProperty("selectedDirectories", selectedDirectories);
        WizardDialog<DynamicBean> createDirectoryWizard = new WizardDialog<DynamicBean>((JFrame)frame, "Delete Directory");
        createDirectoryWizard.addWizardPage(new DeleteDirectoryWizardPage(deleteDirectoryData), "deleteDirectory");
        createDirectoryWizard.setSize(800, 600);
        createDirectoryWizard.startWizard();
        if (WizardDialog.wasCancelled()) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Delete Directories");
        DirectoryDeleter directoryDeleter = new DirectoryDeleter(selectedDirectories);
        directoryDeleter.addManagementCommandSubscriber(this.commandResultsDialog);
        this.waitForResultsDialogToCloseAndResetCursor();
        this.domainsChanged(ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection());
    }

    private ArrayList<DataPowerFileInfo> getSelectedDirectories(boolean listAllIfNoSelection) {
        logger.finer(() -> LMG.log("(listAllIfNoSelection=%b): Starting", () -> listAllIfNoSelection));
        List selectedDirectoryNames = this.directoryList.getSelectedValuesList();
        if (selectedDirectoryNames.size() == 0) {
            logger.finer(() -> LMG.log("(listAllIfNoSelection=%b): No directories are selected.", () -> listAllIfNoSelection));
            if (listAllIfNoSelection) {
                logger.finer(() -> LMG.log("(listAllIfNoSelection=%b): Listing all directories since none are selected", () -> listAllIfNoSelection));
                selectedDirectoryNames = (List)this.directoryListModel.getAll();
            } else {
                logger.finer(() -> LMG.log("(listAllIfNoSelection=%b): Done. Returning no directories since none are selected.", () -> listAllIfNoSelection));
                return null;
            }
        }
        int selectedDirectoryCount = selectedDirectoryNames.size();
        logger.finer(() -> LMG.log("(listAllIfNoSelection=%b): Added %d selected directories.", () -> listAllIfNoSelection, () -> selectedDirectoryCount));
        ArrayList<DataPowerFileInfo> selectedDirectories = new ArrayList<DataPowerFileInfo>();
        for (String selectedDirectoryName : selectedDirectoryNames) {
            selectedDirectories.addAll(this.nameIndex.get(selectedDirectoryName));
        }
        logger.finer(() -> LMG.log("(listAllIfNoSelection=%b): Done.  Returning %d directories.", () -> listAllIfNoSelection, () -> selectedDirectories.size()));
        return selectedDirectories;
    }

    @Reflected
    private void fileNew() {
        this.processConfigAction = FILE_NEW;
        Collection<String> directories = this.directoryListModel.getAll();
        DynamicBean newFileModel = new DynamicBean();
        newFileModel.setProperty("directories", directories);
        newFileModel.setProperty("directoryIndex", this.nameIndex);
        WizardDialog<DynamicBean> newFileWizard = new WizardDialog<DynamicBean>((JFrame)AbstractPanel.frame, "Create a New File");
        newFileWizard.addWizardPage(new NewFileWizardPage(newFileModel), "fileName");
        newFileWizard.addWizardPage(new NewFileWizardContentPage(newFileModel), "fileContent");
        newFileWizard.addWizardPage(new NewFileReviewWizardPage(newFileModel), "review");
        newFileWizard.setSize(1000, 600);
        newFileWizard.startWizard();
        if (WizardDialog.wasCancelled()) {
            return;
        }
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        String newFileName = (String)newFileModel.getProperty("newFileName");
        String content = (String)newFileModel.getProperty("fileContent");
        String temporaryDirectoryName = ((KumbaCoreApplicationProperties)Application.getApplication().getApplicationProperties()).getTemporaryDirectory();
        File temporaryDirectory = new File(temporaryDirectoryName);
        temporaryDirectory.mkdirs();
        File localFile = new File(temporaryDirectory, newFileName);
        try {
            localFile.createNewFile();
            if (StringUtility.isNotEmpty(content)) {
                new ASCFileWriter(localFile, content);
            }
        }
        catch (IOException ioe) {
            this.showMessage("Error Creating Temporary File", String.format("There was an error creating %s.  Ensure you have proper permissions to create files on your system.", localFile.getAbsolutePath()));
            this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
            return;
        }
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        CreateNewFIle createNewFile = new CreateNewFIle(newFileModel);
        createNewFile.getProcessThread().addInvocationListener(stil);
        boolean completedInTime = stil.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
        if (!completedInTime) {
            AbstractPanel.logger.warning("(): Timed out waiting for new files to be created.  It may Continuing.");
        }
        if (createNewFile.createdNewDirectory()) {
            int directoryListSize = this.directoryList.getItemCount();
            this.domainsChanged(ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection());
            int lastDirectoryListSize = directoryListSize;
            do {
                ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
            } while ((directoryListSize = this.directoryList.getItemCount()) == lastDirectoryListSize);
            this.directoryList.setSelectedValue(createNewFile.getNewBaseDirectory() + "/", true);
        }
        this.searchFind();
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
    }

    @Reflected
    private void fileOpen() {
        this.fileOpen(0);
    }

    private void fileOpen(int otherFileCount) {
        AbstractPanel.logger.finer("(int otherFileCount): Starting");
        this.processConfigAction = FILE_OPEN;
        ArrayList<DataPowerFileInfo> selectedFiles = this.getSelectedFiles();
        AbstractPanel.logger.finer(() -> LMG.log("(int otherFileCount): Opening %d files.", () -> selectedFiles.size()));
        if (CollectionUtility.isEmpty(selectedFiles)) {
            return;
        }
        this.dataPowerFileDialog = new DataPowerFileDialog((JFrame)frame, selectedFiles.size() + otherFileCount);
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        DataPowerFileReader.readFiles(selectedFiles, mtil, this);
        ThreadManager.monitorAsynchThreadLifeCycle("ManageFilesPanel.fileOpen(otherFileCount)", mtil, selectedFiles.size() * KumbaCoreConstants.STARTUP_DELAY, 0);
        if (otherFileCount == 0) {
            this.dataPowerFileDialog.setVisible(true);
        }
        AbstractPanel.logger.finer("(int otherFileCount): Done");
    }

    @Reflected
    private void fileCompareWithExternal() {
        AbstractPanel.logger.finer("(): Starting");
        JFileChooser fileChooser = new JFileChooser(this.lastDirectory);
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.setMultiSelectionEnabled(true);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setDialogTitle("Select one or more files to compare with those selected");
        int option = fileChooser.showDialog(frame, "Open");
        if (option == 1) {
            return;
        }
        Object[] selectedFiles = fileChooser.getSelectedFiles();
        if (ArrayUtility.isEmpty(selectedFiles)) {
            return;
        }
        this.lastDirectory = ((File)selectedFiles[0]).getParentFile();
        AbstractPanel.logger.finer("(): Loading on box files first");
        this.fileOpen(selectedFiles.length);
        AbstractPanel.logger.finer(() -> ManageFilesPanel.lambda$84((File[])selectedFiles));
        Object[] objectArray = selectedFiles;
        int n = selectedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            Object file = objectArray[n2];
            this.dataPowerFileDialog.addExternalFile((File)file);
            ++n2;
        }
        this.dataPowerFileDialog.setVisible(true);
        AbstractPanel.logger.finer("(): Done");
    }

    @Reflected
    private void fileExportFile() {
        this.processConfigAction = FILE_SAVE;
        ArrayList<DataPowerFileInfo> selectedFiles = this.getSelectedFiles();
        if (CollectionUtility.isEmpty(selectedFiles)) {
            return;
        }
        String title = selectedFiles.size() > 1 ? "Save Files" : "Save File";
        this.openResultsDialogAndSetWaitCursor(title);
        for (DataPowerFileInfo dataPowerFileInfo : selectedFiles) {
            DataPowerFileReader fileReader = new DataPowerFileReader(dataPowerFileInfo, true);
            fileReader.addConfigObjectSubscriber(DataPowerFileInfo.class, this);
        }
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Reflected
    private void fileRename() {
        this.processConfigAction = FILE_RENAME;
        ArrayList<DataPowerFileInfo> editableFiles = this.getRefactorableFiles();
        if (CollectionUtility.isEmpty(editableFiles)) {
            this.showMessage("Rename Selection Error", "There are no files you have selected that can be renamed.");
            return;
        }
        DynamicBean renameData = new DynamicBean();
        renameData.setProperty("files", editableFiles);
        SubstringSelector subStringSelector = new SubstringSelector(this.directoryListModel.getAll(), 0, "local:");
        Collection localDirectories = subStringSelector.getSelectedElements();
        renameData.setProperty("directories", localDirectories);
        WizardDialog<DynamicBean> renameFilesWizard = new WizardDialog<DynamicBean>((JFrame)frame, "Refactor Rename Selected Files");
        renameFilesWizard.addWizardPage(new RenameFilesWizardPage(renameData), "files");
        renameFilesWizard.addWizardPage(new RenameFilesWarningPage(renameData), "warning");
        renameFilesWizard.setSize(1200, 600);
        renameFilesWizard.startWizard();
        if (WizardDialog.wasCancelled()) {
            return;
        }
        String title = editableFiles.size() > 1 ? "Rename Files" : "Rename File";
        this.openResultsDialogAndSetWaitCursor(title);
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        ArrayList renameDataList = (ArrayList)renameData.getProperty("newData");
        boolean keepOriginal = (Boolean)renameData.getProperty("keepOriginal");
        for (DynamicBean fileRenameInfo : renameDataList) {
            DataPowerFileInfo sourceFile = new DataPowerFileInfo();
            fileRenameInfo.toObject(sourceFile);
            String oldName = sourceFile.getName();
            String oldDirectory = sourceFile.getBaseDirectory();
            String newName = (String)fileRenameInfo.getProperty("newName");
            String newDirectory = (String)fileRenameInfo.getProperty("newDirectory");
            if (oldDirectory.equals(newDirectory) && oldName.equals(newName)) continue;
            DataPowerFileInfo targetFile = BeanService.getClone(sourceFile);
            targetFile.setFileName(newName);
            targetFile.setBaseDirectory(newDirectory);
            FileRename fileRename = new FileRename(sourceFile, targetFile, keepOriginal);
            mtil.addThread(fileRename.getProcessThread());
            fileRename.addManagementCommandSubscriber(this.commandResultsDialog);
        }
        ThreadManager.monitorAsynchThreadLifeCycle("ManageFilesPanel.loadDirectories()", mtil, KumbaCoreConstants.STARTUP_DELAY, 0);
        this.waitForResultsDialogToCloseAndResetCursor();
        Index<Appliance, Domain> affectedDomains = Index.createIndexFrom(editableFiles, "appliance", "sourceDomain");
        ConfigurationManager.clearCache(affectedDomains);
        this.searchFind();
    }

    ArrayList<DataPowerFileInfo> getRefactorableFiles() {
        return this.getAllowedFiles(REFACTOR_EXCLUSIONS);
    }

    ArrayList<DataPowerFileInfo> getExportableFiles() {
        return this.getAllowedFiles(EXPORT_EXCLUSIONS);
    }

    private ArrayList<DataPowerFileInfo> getAllowedFiles(String[] excludedFileStores) {
        ArrayList<DataPowerFileInfo> selectedFiles = this.getSelectedFiles();
        if (CollectionUtility.isEmpty(selectedFiles)) {
            return null;
        }
        ArrayList<DataPowerFileInfo> allowedFiles = new ArrayList<DataPowerFileInfo>();
        for (DataPowerFileInfo selectedFile : selectedFiles) {
            String fileStore = selectedFile.getFileStore();
            if (Comparison.isIn(fileStore, excludedFileStores)) continue;
            allowedFiles.add(selectedFile);
        }
        return allowedFiles;
    }

    @Reflected
    private void editCopy() {
        this.processConfigAction = FILE_COPY;
        this.copyMoveFile();
    }

    @Reflected
    private void editMove() {
        this.processConfigAction = FILE_MOVE;
        this.copyMoveFile();
    }

    private void copyMoveFile() {
        ArrayList<DataPowerFileInfo> selectedFiles = this.getSelectedFiles();
        if (CollectionUtility.isEmpty(selectedFiles)) {
            AbstractPanel.logger.info("(): No files to process.  Returning.");
            return;
        }
        AbstractPanel.logger.finer(() -> LMG.log("(): There are %d selected file(s).  Setting up wizard.", () -> selectedFiles.size()));
        CopyMoveFilesBean copyMoveFilesBean = new CopyMoveFilesBean(selectedFiles);
        int copyMoveMode = this.processConfigAction.equals(FILE_COPY) ? 0 : 1;
        copyMoveFilesBean.setMode(copyMoveMode);
        String dialogTitle = copyMoveMode == 0 ? "Copy Selected Files" : "Move Selected Files";
        new CopyMoveFilesWizardDialog((JFrame)frame, dialogTitle, copyMoveFilesBean);
        if (WizardDialog.wasCancelled()) {
            AbstractPanel.logger.finer("(): Wizard cancelled.  Returning.");
            return;
        }
        ArrayList<Pair<DataPowerFileInfo, DataPowerFileInfo>> destinationInformation = copyMoveFilesBean.getDestinationNames();
        if (destinationInformation == null) {
            AbstractPanel.logger.info("(): No destination information remaining after wizard.  Returning.");
            return;
        }
        this.showProgressBar(destinationInformation.size());
        this.processFileNumber = 0;
        boolean overwriteFiles = copyMoveFilesBean.overwriteFiles();
        boolean createDirectories = copyMoveFilesBean.createDirectories();
        this.openResultsDialogAndSetWaitCursor(dialogTitle);
        AbstractPanel.logger.finer(() -> LMG.log("(): Processing %d files.  Can overwrite: %b, Can create directories: %b", () -> destinationInformation.size(), () -> overwriteFiles, () -> createDirectories));
        ArrayList<Pair<DataPowerFileInfo, DataPowerFileInfo>> collisionDestinationSet = this.copyMoveDestinationSet(destinationInformation, copyMoveMode, createDirectories, overwriteFiles);
        while (collisionDestinationSet.size() > 0) {
            int collisionSize = collisionDestinationSet.size();
            AbstractPanel.logger.finer(() -> LMG.log("(): Processing %d collision files.", () -> collisionSize));
            collisionDestinationSet = this.copyMoveDestinationSet(collisionDestinationSet, copyMoveMode, createDirectories, overwriteFiles);
        }
        this.waitForResultsDialogToCloseAndResetCursor();
        this.hideProgressBar();
    }

    private ArrayList<Pair<DataPowerFileInfo, DataPowerFileInfo>> copyMoveDestinationSet(ArrayList<Pair<DataPowerFileInfo, DataPowerFileInfo>> destinationInformation, int copyMoveMode, boolean createDirectories, boolean overwriteFiles) {
        AbstractPanel.logger.finer(() -> LMG.log("(...): Processing %d files.  Can overwrite: %b, Can create directories: %b", () -> destinationInformation.size(), () -> overwriteFiles, () -> createDirectories));
        ArrayList<Pair<DataPowerFileInfo, DataPowerFileInfo>> collisionDestinationSet = new ArrayList<Pair<DataPowerFileInfo, DataPowerFileInfo>>();
        HashSet<Pair<Appliance, String>> processedFileNames = new HashSet<Pair<Appliance, String>>();
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        for (Pair<DataPowerFileInfo, DataPowerFileInfo> destinationInfo : destinationInformation) {
            DataPowerFileInfo source = (DataPowerFileInfo)destinationInfo.first;
            DataPowerFileInfo target = (DataPowerFileInfo)destinationInfo.second;
            String targetName = target.getFileName();
            Pair<Appliance, String> targetCollision = new Pair<Appliance, String>(target.getAppliance(), targetName);
            if (processedFileNames.contains(targetCollision)) {
                AbstractPanel.logger.info(() -> LMG.log("(...): A file with '%s' file name has been processed for appliance %s in this set.  Adding to collision set.", () -> targetName, () -> target.getAppliance().getName()));
                collisionDestinationSet.add(destinationInfo);
                continue;
            }
            this.updateProgressBar(++this.processFileNumber);
            processedFileNames.add(targetCollision);
            AbstractPanel.logger.finer(() -> LMG.log("(...): Processing '%s->%s->%s' to '%s->%s->%s'.", () -> source.getAppliance().getName(), () -> source.getSourceDomain().getName(), () -> source.getAbsolutePath(), () -> target.getAppliance().getName(), () -> target.getSourceDomain().getName(), () -> target.getAbsolutePath()));
            CopyMoveType copyMoveType = copyMoveMode == 0 ? CopyMoveType.COPY : CopyMoveType.MOVE;
            FileCopyMove fileCopyMove = new FileCopyMove(source, target, copyMoveType, createDirectories, overwriteFiles);
            mtil.addThread(fileCopyMove.getProcessThread());
            fileCopyMove.addManagementCommandSubscriber(this.commandResultsDialog);
        }
        AbstractPanel.logger.info("(...): Waiting for set to complete");
        ThreadManager.monitorAsynchThreadLifeCycle("ManageFilesPanel.copyMoveDestinationSet(...)", mtil, KumbaCoreConstants.THREAD_WAIT, 0);
        AbstractPanel.logger.finer(() -> LMG.log("(...): Returning %d collision files.", () -> collisionDestinationSet.size()));
        return collisionDestinationSet;
    }

    private ArrayList<DataPowerFileInfo> getSelectedFiles() {
        JMTable table = this.getDisplayTable();
        if (table.getSelectedRowCount() == 0) {
            return null;
        }
        int[] selectedRows = this.displayTable.getSelectedRows();
        ArrayList<DataPowerFileInfo> selectedFiles = new ArrayList<DataPowerFileInfo>();
        int r = 0;
        while (r < selectedRows.length) {
            DataPowerFileInfo dataPowerFileInfo = (DataPowerFileInfo)this.tableModel.getValue(selectedRows[r]);
            selectedFiles.add(dataPowerFileInfo);
            ++r;
        }
        return selectedFiles;
    }

    @Reflected
    private void showReferencedBy() {
        ArrayList<DataPowerFileInfo> selectedFiles = this.getSelectedFiles();
        if (selectedFiles == null) {
            return;
        }
        new ConfigurationRelationshipDialog((JFrame)AbstractPanel.frame, new Object[]{selectedFiles, ConfigurationRelationshipType.CHILD_UP});
    }

    @Reflected
    private void editDelete() {
        ArrayList<DataPowerFileInfo> selectedFiles = this.getSelectedFiles();
        if (selectedFiles == null) {
            return;
        }
        DeleteFilesBean deleteFilesBean = new DeleteFilesBean(selectedFiles);
        WizardDialog<DeleteFilesBean> deleteWizard = new WizardDialog<DeleteFilesBean>((JFrame)frame, "Delete Selected Files");
        DeleteFilesWizardPage deletePage = new DeleteFilesWizardPage(deleteFilesBean);
        deleteWizard.addWizardPage(deletePage, "deleteFiles");
        deleteWizard.setSize(800, 600);
        deleteWizard.startWizard();
        if (WizardDialog.wasCancelled()) {
            return;
        }
        this.processConfigAction = FILE_DELETE;
        this.displayTable.clearSelection();
        this.openResultsDialogAndSetWaitCursor("Delete Selected Files");
        ArrayList<DataPowerFileInfo> filesToDelete = deleteFilesBean.getFiles();
        this.processFileNumber = 0;
        this.showProgressBar(filesToDelete.size());
        ActionController.deleteFiles(filesToDelete, this, this.commandResultsDialog);
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    @Override
    public void commandSucceeded(ManagementCommandStatus commandStatus) {
        DynamicBean additionalCommandInfo = commandStatus.getAdditionalCommandInfo();
        DataPowerFileInfo dpFileInfo = (DataPowerFileInfo)additionalCommandInfo.getProperty("file");
        try {
            this.tableModel.deleteRow(dpFileInfo);
        }
        catch (IndexOutOfBoundsException e) {
            AbstractPanel.logger.warning(() -> LMG.log("Unable to remove the file from the table model due to %s: %s", () -> e.getClass().getSimpleName(), () -> e.getMessage()));
        }
        if (this.tableRepaintThread != null && !this.tableRepaintThread.hasCompleted()) {
            this.tableRepaintThread.cancel();
        }
        this.tableRepaintThread = new AsynchMethodInvoker((Object)this, "repaint", KumbaCoreConstants.THREAD_WAIT * 4);
    }

    @Override
    public void commandFailed(ManagementCommandError commandError) {
    }

    @Override
    protected void searchFind() {
        this.processConfigAction = FILE_SEARCH;
        this.filesToSearch = CollectionUtility.createOrClear(this.filesToSearch);
        super.searchFind();
    }

    @Reflected
    private void searchReplace() {
        logger.finer("(): Starting");
        int[] selectedRows = this.displayTable.getSelectedRows();
        ArrayList filesToSearch = this.tableModel.getValues(selectedRows);
        DynamicBean model = new DynamicBean();
        model.setProperty("selectedFiles", filesToSearch);
        logger.finer("(): Opening Wizard Dialog");
        new SearchReplaceWizardDialog((JFrame)frame, model);
        if (WizardDialog.wasCancelled()) {
            AbstractPanel.logger.finer("(): Wizard cancelled.");
            return;
        }
        ArrayList filesToSave = (ArrayList)model.getProperty("filesToUpload");
        if (CollectionUtility.isEmpty(filesToSave)) {
            logger.finer("(): No files change.  There is nothing to do.  Informing user and we are done.");
            new JMMessageBox((JFrame)frame, "No files changed", LabelUtility.wrapInHTML("No files changed.\n\nCheck your search and replace expressions\nand try again if needed."));
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Updating Search and Replace Files");
        logger.finer("(): Saving Files");
        DataPowerFileUtility.saveDataPowerFiles(filesToSave, this.commandResultsDialog);
        this.waitForResultsDialogToCloseAndResetCursor();
        logger.finer("(): Done");
    }

    @Reflected
    private void replaceFileWith() {
        JMTable table = this.getDisplayTable();
        if (table.getSelectedRowCount() == 0) {
            return;
        }
        File sourceFile = GUIServices.fileOpenDialog(null);
        if (sourceFile == null) {
            return;
        }
        String sourceFileName = sourceFile.getAbsolutePath();
        if (!this.continueAction("Are you sure?", "This will replace all the selected file(s) with " + sourceFileName)) {
            return;
        }
        this.openResultsDialogAndSetWaitCursor("Replace Files");
        int[] selectedRows = table.getSelectedRows();
        StringBuilder permissionDeniedFiles = new StringBuilder();
        ArrayList<DataPowerFileInfo> filesToUpload = new ArrayList<DataPowerFileInfo>();
        int r = 0;
        while (r < selectedRows.length) {
            DataPowerFileInfo dataPowerFileInfo = (DataPowerFileInfo)this.tableModel.getValue(selectedRows[r]);
            dataPowerFileInfo.setLocalFile(sourceFile);
            if (dataPowerFileInfo.getIsReadOnly()) {
                if (permissionDeniedFiles.length() > 0) {
                    permissionDeniedFiles.append("\n");
                }
                permissionDeniedFiles.append(dataPowerFileInfo.getName());
            } else {
                filesToUpload.add(dataPowerFileInfo);
            }
            ++r;
        }
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        FileUploader.upload(filesToUpload, mtil);
        FileUploader.addCommandSubscriber(this.commandResultsDialog);
        if (permissionDeniedFiles.length() > 0) {
            this.showMessage("Permission Denied", "No Permission to replace\n\n" + permissionDeniedFiles.toString());
        }
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    private static /* synthetic */ String lambda$0(String string) {
        return LMG.log("(Index<Appliance, Domain> domainSelection): FileStore '%s' is within the exclusion list", () -> string);
    }

    private static /* synthetic */ String lambda$2(String string) {
        return LMG.log("(Index<Appliance, Domain> domainSelection): FileStore '%s' is one of the default domain reserved file stores and we're not listing the default domain.", () -> string);
    }

    private static /* synthetic */ String lambda$84(File[] fileArray) {
        return LMG.log("(): Opening %d external files.", () -> fileArray.length);
    }
}

