/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.status;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.PropertyNotFoundException;
import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.beans.util.PropertyChangeInvoker;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.ExceptionListenerClient;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMTabbedPane;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.dialog.DialogPanel;
import com.jmorgan.swing.dialog.GenericDialog;
import com.jmorgan.swing.dialog.wizard.WizardDialog;
import com.jmorgan.swing.event.ChangeEventInvoker;
import com.jmorgan.swing.event.ListSelectionEventInvoker;
import com.jmorgan.swing.menu.JMMenu;
import com.jmorgan.swing.menu.JMPopupMenu;
import com.jmorgan.swing.menu.PopupMenuController;
import com.jmorgan.swing.spinner.NumberSpinner;
import com.jmorgan.swing.tabbedpane.TabPlacementDNDController;
import com.jmorgan.swing.table.BeanColumnModel;
import com.jmorgan.swing.table.BeanTableModel;
import com.jmorgan.swing.util.ComponentService;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.swing.util.LabelUtility;
import com.jmorgan.swing.util.WindowCloser;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.Index;
import com.jmorgan.util.NumberUtility;
import com.jmorgan.util.Pair;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.comparator.AnyObjectComparator;
import com.jmorgan.util.comparator.BeanComparator;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ApplianceGroupObject;
import com.kumbasoft.core.beans.ColumnPreference;
import com.kumbasoft.core.beans.DataPowerAction;
import com.kumbasoft.core.beans.DataPowerStatus;
import com.kumbasoft.core.beans.DataPowerStatusListener;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.StatusProviderGraphDefinition;
import com.kumbasoft.core.beans.StatusProviderInfo;
import com.kumbasoft.core.beans.StatusProviderMenuItemDefinition;
import com.kumbasoft.core.beans.config.ConfigDomain;
import com.kumbasoft.core.beans.status.StatusDocumentCachingSummaryGlobal;
import com.kumbasoft.core.beans.status.StatusDomainStatus;
import com.kumbasoft.core.beans.status.StatusDomainSummary;
import com.kumbasoft.core.beans.status.StatusDomainsMemoryStatus;
import com.kumbasoft.core.beans.status.StatusDomainsMemoryStatus2;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.DataPowerStatusMonitor;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.AbstractTablePanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.beans.TableDisplayPreference;
import com.kumbasoft.core.util.FileUtility;
import com.kumbasoft.core.util.RegexUtility;
import com.kumbasoft.dpaa.ui.dialogs.StatusFileDiffDialog;
import com.kumbasoft.dpaa.ui.dialogs.StatusGraphDiffDialog;
import com.kumbasoft.dpaa.ui.dialogs.advancedSearch.AdvancedStatusSearchPanel;
import com.kumbasoft.dpaa.ui.dialogs.statusGraphWizard.CreateStatusGraphPage;
import com.kumbasoft.dpaa.ui.dialogs.statusGraphWizard.StatusDiffGraphSelectionWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.statusGraphWizard.StatusDiffHistorySelectWizardPage;
import com.kumbasoft.dpaa.ui.dialogs.statusGraphWizard.StatusDiffPropertySelectionWizardPage;
import com.kumbasoft.dpaa.ui.panels.status.DataPowerStatusProviderListPanel;
import com.kumbasoft.dpaa.ui.panels.status.StatusProviderGraphPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.beans.ExceptionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.PatternSyntaxException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;

public class DataPowerStatusPanel
extends AbstractTablePanel<DataPowerStatus>
implements DataPowerStatusListener<DataPowerStatus>,
PopupMenuController {
    private static final String ACTION_PACKAGE_NAME = "com.kumbasoft.core.beans.actions";
    private static final String[] CHART_TYPE_NAMES = new String[]{"Line", "Area"};
    private static final ImageIcon[] CHART_TYPE_ICONS = new ImageIcon[]{KumbaCoreUIConstants.LINE_CHART_ICON, KumbaCoreUIConstants.AREA_CHART_ICON};
    private DataPowerStatusProviderListPanel providerPanel;
    private StatusProviderInfo statusProviderInfo;
    private JMTextField tfFilterExpression;
    private JMButton btnOpenSearchOptions;
    private JMButton btnGetStatus;
    private JMButton btnStop;
    private NumberField nfUpdateFrequency;
    private NumberSpinner nsUpdateFrequency;
    private NumberField nfMaxRows;
    private NumberSpinner nsMaxRows;
    private HashMap<String, JMenuItem> dynamicMenuItems;
    private HashMap<String, JMenuItem> graphStyleMenuItems;
    private JMTabbedPane tableGraphTabbedPane;
    private JMenuItem miCapture;
    private JMenuItem miCompare;
    private JMenuItem miAddGraph;
    private JMenuItem miDeleteGraph;
    private JMenuItem miGraphSaveCapture;
    private JMenuItem miGraphDiff;
    private JMTabbedPane graphTabbedPane;
    private JMPanel graphPanel;
    private ArrayList<StatusProviderGraphPanel> graphPanels;
    private ArrayList<DataPowerStatusMonitor<DataPowerStatus>> monitors;
    private HashMap<String, String> filterSpec;
    private String applicableDomain;
    private int updateFrequency;
    private UniqueArrayList<String> invalidProperties;
    private boolean stopping;
    private int lastMaxRows = -1;
    private String preferencesTableName;
    private int stopWait;

    public DataPowerStatusPanel(DataPowerStatusProviderListPanel providerPanel, StatusProviderInfo statusProviderInfo) {
        super(statusProviderInfo.getStatusClass());
        this.providerPanel = providerPanel;
        this.statusProviderInfo = statusProviderInfo;
        this.statusProviderInfo.incrementTimesViewed();
        this.createPopupMenu();
        JMPanel topPanel = this.createTopPanel();
        this.centerPanel.add((Component)topPanel, "North");
        ArrayList<String> graphableProperties = statusProviderInfo.getGraphableProperties();
        if (CollectionUtility.isNotEmpty(graphableProperties)) {
            this.tableGraphTabbedPane = new JMTabbedPane();
            this.graphTabbedPane = new JMTabbedPane();
            this.graphPanels = new ArrayList();
            for (StatusProviderGraphDefinition spgd : statusProviderInfo.getGraphs()) {
                StatusProviderGraphPanel graphPanel = new StatusProviderGraphPanel(spgd);
                this.graphPanels.add(graphPanel);
                this.graphTabbedPane.addTab(spgd.getGraphName(), graphPanel);
            }
            new TabPlacementDNDController(this.graphTabbedPane);
            this.graphPanel = KumbaCoreUIConstants.createBorderLayoutPanel();
            this.graphPanel.add((Component)this.graphTabbedPane, "Center");
            this.centerPanel.remove(this.tableDisplayPanel);
            this.tableGraphTabbedPane.addTab("Status Info", this.tableDisplayPanel);
            this.tableGraphTabbedPane.addTab("Graphs", this.graphPanel);
            new ChangeEventInvoker(this.tableGraphTabbedPane, this, "tabSelectionChanged");
            new TabPlacementDNDController(this.tableGraphTabbedPane);
            this.centerPanel.add((Component)this.tableGraphTabbedPane, "Center");
        }
        new ListSelectionEventInvoker(this.displayTable.getSelectionModel(), this, "setMenuActionComponentState");
    }

    @Override
    protected BeanColumnModel<DataPowerStatus> getColumnModel() {
        BeanColumnModel<DataPowerStatus> columnModel = super.getColumnModel();
        columnModel.hideColumn("fQON");
        return columnModel;
    }

    private JMPanel createTopPanel() {
        JMPanel topPanel = KumbaCoreUIConstants.createVerticalFlowLayoutPanel(3);
        topPanel.add(this.createControlsPanel());
        topPanel.add(this.createLimitsPanel());
        return topPanel;
    }

    private JMPanel createControlsPanel() {
        this.tfFilterExpression = new JMTextField();
        ComponentService.addClearIcon(this.tfFilterExpression, "Clear the status search expression.");
        ComponentService.addHelpIcon(this.tfFilterExpression, this.getHelpFile("searchField", "Enter a filtering expression"));
        LabeledComponent lblFilter = new LabeledComponent("Filter Expression:", (Component)this.tfFilterExpression, 115, 375);
        lblFilter.setPreferredSize(550, 25);
        this.btnOpenSearchOptions = ComponentFactory.createButton(KumbaCoreUIConstants.FILTER_ICON, null, "Build Search String", true, this, "searchFilters", new Object[0]);
        this.btnGetStatus = ComponentFactory.createButton(KumbaCoreUIConstants.START_ICON, null, "Start the status provider, repeating with the frequency set by the update frequency.", true, this, "startMonitoring", new Object[0]);
        this.btnGetStatus.setActivator(this.tfFilterExpression, 10);
        this.btnStop = ComponentFactory.createButton(KumbaCoreUIConstants.STOP_ICON, null, "Stop the continuous status updates.", false, this, "stop", new Object[0]);
        JMPanel filterInfo = new JMPanel();
        filterInfo.addAll(lblFilter, ComponentFactory.createSpacer(10, 10), this.btnOpenSearchOptions, this.btnGetStatus, this.btnStop);
        JMPanel hamburgerMenuPanel = new JMPanel(new FlowLayout(2));
        hamburgerMenuPanel.add(this.getPopupMenuButton());
        JMPanel controlsPanel = new JMPanel(new BorderLayout());
        controlsPanel.add((Component)filterInfo, "West");
        controlsPanel.add((Component)hamburgerMenuPanel, "Center");
        new PropertyChangeInvoker(this.tfFilterExpression, this, "toggleFilterButton");
        return controlsPanel;
    }

    private JMPanel createLimitsPanel() {
        this.nsUpdateFrequency = this.getUpdateFrequencyComponent();
        LabeledComponent lblUpdateFreq = new LabeledComponent("Update Frequency (ms):", (Component)this.nsUpdateFrequency);
        this.nfMaxRows = new NumberField(0.0);
        this.nsMaxRows = new NumberSpinner(this.nfMaxRows, 10.0, 0.0, 2.147483647E9);
        LabeledComponent lblMaxRows = new LabeledComponent("Maximum Rows:", (Component)this.nsMaxRows);
        JMPanel limits = new JMPanel();
        limits.addAll(lblUpdateFreq, ComponentFactory.createSpacer(30, 20), lblMaxRows);
        JMPanel forceLeftPanel = new JMPanel(new BorderLayout());
        forceLeftPanel.add((Component)limits, "West");
        forceLeftPanel.add((Component)new JMPanel(), "Center");
        return forceLeftPanel;
    }

    private NumberSpinner getUpdateFrequencyComponent() {
        this.nfUpdateFrequency = new NumberField((double)this.statusProviderInfo.getPreferredMonitorInterval());
        this.nsUpdateFrequency = new NumberSpinner(this.nfUpdateFrequency, 1000.0, 0.0, 2.147483647E9);
        this.nsUpdateFrequency.setPreferredSize(this.nfUpdateFrequency.getPreferredSize().width, 23);
        return this.nsUpdateFrequency;
    }

    @Override
    protected void createPopupMenu() {
        JMPopupMenu popupMenu = super.getPopupMenu(this.getDisplayTable());
        popupMenu.setPopupController(this);
        this.miCapture = popupMenu.addMenuItem("Capture Status Data...", (Object)this, "fileSave");
        this.miCompare = popupMenu.addMenuItem("Compare Status Capture...", (Object)this, "captureFileDiff");
        boolean hasDynamicMenuItems = this.statusProviderInfo.isDynamicPopupItemsSupported();
        if (hasDynamicMenuItems) {
            popupMenu.addSeparator();
            this.dynamicMenuItems = new HashMap();
            ArrayList<StatusProviderMenuItemDefinition> menuItems = new ArrayList<StatusProviderMenuItemDefinition>(this.statusProviderInfo.getMenuItems());
            Collections.sort(menuItems);
            for (StatusProviderMenuItemDefinition menuItem : menuItems) {
                String menuItemText = menuItem.getMenuItemText();
                if (menuItemText.trim().startsWith("-")) {
                    popupMenu.addSeparator();
                    continue;
                }
                JMenuItem mi = popupMenu.addMenuItem(menuItemText, (Object)this, "handleMenuAction", menuItem);
                this.dynamicMenuItems.put(menuItemText, mi);
                mi.setEnabled(false);
            }
        }
        if (this.statusProviderInfo.isGraphable()) {
            popupMenu.addSeparator();
            this.miAddGraph = popupMenu.addMenuItem("Add Graph...", (Object)this, "fileNew");
            this.miDeleteGraph = popupMenu.addMenuItem("Delete Graph...", (Object)this, "editDelete");
            popupMenu.addSeparator();
            this.graphStyleMenuItems = new HashMap();
            JMMenu graphStyleMenu = new JMMenu("Graph Style");
            int i = 0;
            while (i < CHART_TYPE_NAMES.length) {
                String menuName = CHART_TYPE_NAMES[i];
                ImageIcon icon = CHART_TYPE_ICONS[i];
                JMenuItem typeItem = graphStyleMenu.addMenuItem(menuName, this, "setChartType", i);
                typeItem.setIcon(icon);
                this.graphStyleMenuItems.put(menuName, graphStyleMenu);
                ++i;
            }
            popupMenu.add(graphStyleMenu);
            popupMenu.addSeparator();
            this.miGraphSaveCapture = popupMenu.addMenuItem("Capture Graph Data", (Object)this, "fileSave");
            this.miGraphSaveCapture.setEnabled(false);
            this.miGraphDiff = popupMenu.addMenuItem("Compare Graph Capture...", (Object)this, "captureGraphDiff");
            this.miGraphDiff.setEnabled(false);
        }
    }

    @Override
    public boolean isPopupReady() {
        this.setMenuActionComponentState();
        return true;
    }

    private boolean isMenuConditionMet(StatusProviderMenuItemDefinition menuItem, DataPowerStatus status) {
        boolean conditionMet = true;
        ArrayList<Pair<String, String>> conditions = menuItem.getMenuItemConditions();
        if (CollectionUtility.isNotEmpty(conditions)) {
            AnyObjectComparator comparer = new AnyObjectComparator(1);
            for (Pair<String, String> condition : conditions) {
                int cmp;
                String propertyName = (String)condition.first;
                String conditionalValue = (String)condition.second;
                Object statusValue = BeanService.getPropertyValue(status, propertyName);
                AbstractPanel.logger.finer(() -> LMG.log("(StatusProviderMenuItemDefinition menuItem, DataPowerStatus status): Evaluating %s %s = %s for %s.", () -> propertyName, () -> String.valueOf(statusValue), () -> condition.getSecond(), () -> status.getFQON()));
                if (conditionalValue.equals("\"\"") || conditionalValue.equals("''")) {
                    conditionalValue = null;
                }
                if (conditionalValue != null && (conditionalValue.startsWith("\"") || conditionalValue.startsWith("'")) && ((conditionalValue = conditionalValue.substring(1)).endsWith("\"") || conditionalValue.endsWith("'"))) {
                    conditionalValue = conditionalValue.substring(0, conditionalValue.length() - 1);
                }
                if ((cmp = comparer.compare(statusValue, conditionalValue)) != 0 && statusValue != null && StringUtility.containsAnyOf(conditionalValue, "{}[]()\\*+!^$|")) {
                    LMG.log(AbstractPanel.logger, Level.FINER, "DataPowerStatusPanel.isMenuConditionMet(StatusProviderMenuItemDefinition menuItem, DataPowerStatus status): Comparison failed for %s %s = %s for %s.  Trying as regex.", propertyName, String.valueOf(statusValue), conditionalValue, status.getFQON());
                    try {
                        String stringValue = statusValue.toString();
                        int n = cmp = stringValue.matches(conditionalValue) ? 0 : 1;
                        if (cmp == 0) {
                            LMG.log(AbstractPanel.logger, Level.FINER, "DataPowerStatusPanel.isMenuConditionMet(StatusProviderMenuItemDefinition menuItem, DataPowerStatus status): Regex comparison succeeded for %s %s = %s for %s.", propertyName, String.valueOf(statusValue), conditionalValue, status.getFQON());
                        }
                    }
                    catch (PatternSyntaxException e) {
                        LMG.log(AbstractPanel.logger, Level.SEVERE, "(StatusProviderMenuItemDefinition menuItem, DataPowerStatus status): The '%s' for property '%s' of status '%s' looks like it might be a regex, but isn't.  Fix in utility.", conditionalValue, propertyName, status.getFQON());
                    }
                }
                LMG.log(AbstractPanel.logger, Level.FINER, "(StatusProviderMenuItemDefinition menuItem, DataPowerStatus status): Does %s %s = %s for %s?  %b", propertyName, String.valueOf(statusValue), conditionalValue, status.getFQON(), cmp == 0);
                if (cmp == 0) continue;
                conditionMet = false;
                break;
            }
        }
        return conditionMet;
    }

    @Reflected
    private void setMenuActionComponentState() {
        int rowCount = this.displayTable.getRowCount();
        ArrayList selectedValues = this.getSelectedValues();
        this.miCapture.setEnabled(rowCount > 0);
        this.miCompare.setEnabled(rowCount > 0);
        if (this.statusProviderInfo.isDynamicPopupItemsSupported()) {
            ArrayList<StatusProviderMenuItemDefinition> menuItems = this.statusProviderInfo.getMenuItems();
            for (StatusProviderMenuItemDefinition menuItem : menuItems) {
                String menuItemText = menuItem.getMenuItemText();
                if (menuItemText.trim().startsWith("-")) continue;
                JMenuItem mi = this.dynamicMenuItems.get(menuItemText);
                if (selectedValues.size() == 0) {
                    mi.setEnabled(false);
                    continue;
                }
                boolean conditionMet = false;
                for (DataPowerStatus status : selectedValues) {
                    if (!this.isMenuConditionMet(menuItem, status)) continue;
                    conditionMet = true;
                    break;
                }
                mi.setEnabled(conditionMet);
            }
        }
        if (this.statusProviderInfo.isGraphable()) {
            this.miAddGraph.setEnabled(true);
            this.miDeleteGraph.setEnabled(CollectionUtility.isNotEmpty(this.statusProviderInfo.getGraphs()));
            this.miGraphSaveCapture.setEnabled(rowCount > 0);
            this.miGraphDiff.setEnabled(rowCount > 0);
        }
    }

    @Reflected
    private void handleMenuAction(StatusProviderMenuItemDefinition menuItem) {
        ArrayList selectedValues = this.getSelectedValues();
        if (CollectionUtility.isEmpty(selectedValues)) {
            return;
        }
        String verificationMessage = String.format("Are you sure you want to %s?", menuItem.getVerificationDialogMessage());
        new JMMessageBox((JFrame)frame, menuItem.getMenuItemText(), verificationMessage, 12);
        if (JMMessageBox.getSelection() == 8) {
            return;
        }
        String actionClassName = menuItem.getActionClass();
        String actionClassFQDN = String.format("%s.%s", ACTION_PACKAGE_NAME, actionClassName);
        ArrayList<Pair<String, String>> propertyMap = menuItem.getActionToStatusProperties();
        this.openResultsDialogAndSetWaitCursor(menuItem.getMenuItemText());
        for (DataPowerStatus status : selectedValues) {
            if (!this.isMenuConditionMet(menuItem, status)) {
                ManagementCommandError error = new ManagementCommandError(status.getAppliance(), status.getSourceDomain(), "Condition Not Met for " + status.getFQON(), null, "Skipping");
                this.commandResultsDialog.commandFailed(error);
                continue;
            }
            boolean metaDataError = false;
            String errorMessage = "";
            try {
                DataPowerAction action = (DataPowerAction)BeanService.getBean(actionClassFQDN);
                for (Pair<String, String> pm : propertyMap) {
                    block30: {
                        String javaType = this.getJavaType(action, (String)pm.first);
                        if (((String)pm.first).contains(".")) {
                            String complexPropertyName = StringUtility.substringBefore((String)pm.first, ".");
                            String nestedPropertyName = StringUtility.substringAfter((String)pm.first, ".");
                            javaType = this.getJavaType(action, complexPropertyName);
                            if (javaType == null) {
                                AbstractPanel.logger.config(() -> LMG.log("(StatusProviderMenuItemDefinition menuItem)", () -> actionClassName, () -> complexPropertyName, () -> nestedPropertyName));
                                return;
                            }
                            if (!javaType.startsWith("ObjectReference")) continue;
                            ObjectReference objectReference = (ObjectReference)BeanService.getPropertyValue(action, complexPropertyName);
                            if (objectReference == null) {
                                objectReference = new ObjectReference();
                                BeanService.setPropertyValue(action, complexPropertyName, objectReference);
                            }
                            if (((String)pm.second).startsWith("\"") || ((String)pm.second).startsWith("'")) {
                                pm.second = ((String)pm.second).substring(1);
                                pm.second = ((String)pm.second).substring(0, ((String)pm.second).length() - 1);
                                BeanService.setPropertyValue(objectReference, nestedPropertyName, pm.second);
                                continue;
                            }
                            Object value = BeanService.getPropertyValue(status, (String)pm.second);
                            BeanService.setPropertyValue(objectReference, nestedPropertyName, value);
                            continue;
                        }
                        if (((String)pm.second).startsWith("\"") || ((String)pm.second).startsWith("'")) {
                            String actualStringValue = ((String)pm.second).substring(1);
                            actualStringValue = actualStringValue.substring(0, actualStringValue.length() - 1);
                            BeanService.setPropertyValue(action, (String)pm.first, actualStringValue);
                            continue;
                        }
                        if (!NumberUtility.isNumber((String)pm.second)) break block30;
                        switch (javaType) {
                            case "int": {
                                BeanService.setPropertyValue(action, (String)pm.first, Integer.parseInt((String)pm.second));
                                break;
                            }
                            case "long": {
                                BeanService.setPropertyValue(action, (String)pm.first, Long.parseLong((String)pm.second));
                                break;
                            }
                            default: {
                                String javaTypeF = javaType;
                                AbstractPanel.logger.severe(() -> LMG.log("(StatusProviderMenuItemDefinition menuItem):  Hard-coded type %s not handled for %s.", () -> javaTypeF, () -> menuItem));
                                break;
                            }
                        }
                        continue;
                    }
                    try {
                        Object propertyValue = BeanService.getPropertyValue(status, (String)pm.second);
                        Class<?> actionType = BeanService.getPropertyType(action, (String)pm.first);
                        if (actionType.equals(Integer.class) && propertyValue.getClass().equals(Long.class)) {
                            propertyValue = ((Long)propertyValue).intValue();
                        }
                        BeanService.setPropertyValue(action, (String)pm.first, propertyValue);
                    }
                    catch (PropertyNotFoundException pnfe) {
                        AbstractPanel.logger.severe(() -> LMG.log("(StatusProviderMenuItemDefinition menuItem):  Status Action meta-data configuration error.  Status Property '%s.%s' is invalid.", () -> status.getClass().getName(), () -> pair.second));
                        errorMessage = String.format("Status Action meta-data configuration error.\nStatus Property '%s.%s' is invalid.\n\nPlease contact Kumbasoft Technical Support and report this error.", status.getClass().getSimpleName(), pm.second);
                        metaDataError = true;
                        break;
                    }
                    catch (Exception e) {
                        AbstractPanel.logger.severe(() -> LMG.log("(StatusProviderMenuItemDefinition menuItem):  Status Action meta-data configuration error.  Property '%s.%s' either invalid or cannot be set to '%s'.", () -> action.getClass().getName(), () -> pair.first, () -> BeanService.getPropertyValue(status, (String)pair.second)));
                        errorMessage = String.format("Status Action meta-data configuration error.\nProperty '%s.%s' either invalid or cannot be set to '%s'\n\nPlease contact Kumbasoft Technical Support and report this error.", action.getClass().getSimpleName(), pm.first, BeanService.getPropertyValue(status, (String)pm.second));
                        metaDataError = true;
                        break;
                    }
                }
                if (metaDataError) {
                    WindowCloser.closeWindow(this.commandResultsDialog, 0, false);
                    new JMMessageBox((JFrame)frame, "Status Action Error", LabelUtility.wrapInHTML(errorMessage));
                    return;
                }
                Appliance targetAppliance = status.getAppliance();
                Domain targetDomain = status.getSourceDomain();
                if (status instanceof StatusDocumentCachingSummaryGlobal || status instanceof StatusDomainStatus || status instanceof StatusDomainsMemoryStatus || status instanceof StatusDomainsMemoryStatus2) {
                    String domainName = (String)BeanService.getPropertyValue(status, "domain");
                    targetDomain = targetAppliance.getDomain(domainName);
                } else if (status instanceof StatusDomainSummary) {
                    StatusDomainSummary domainSummary = (StatusDomainSummary)status;
                    ObjectReference<ConfigDomain> objRef = domainSummary.getDomain();
                    String domainName = objRef.getName();
                    targetDomain = targetAppliance.getDomain(domainName);
                }
                ActionTool actionTool = new ActionTool(targetAppliance, targetDomain, action);
                actionTool.addManagementCommandSubscriber(this.commandResultsDialog);
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                logger.severe(() -> LMG.log("(StatusProviderMenuItemDefinition menuItem): Cannot instantiate action class instance for %s", () -> actionClassFQDN));
            }
        }
        this.waitForResultsDialogToCloseAndResetCursor();
    }

    private String getJavaType(Object statusOrAction, String propertyName) {
        Method accessor = BeanService.getPropertyAccessor(statusOrAction, propertyName);
        if (accessor == null) {
            AbstractPanel.logger.fine(() -> LMG.log("(Object statusOrAction, String propertyName):  Accessor cannot be found in %s for %s", () -> statusOrAction.getClass().getSimpleName(), () -> propertyName));
            return null;
        }
        XMLInfo xmlInfo = (XMLInfo)BeanService.getMethodAnnotation(accessor, XMLInfo.class);
        String javaType = xmlInfo.javaType();
        return javaType;
    }

    @Reflected
    private void setChartType(int chartTypeIndex) {
        for (StatusProviderGraphPanel graphPanel : this.graphPanels) {
            graphPanel.setChartType(chartTypeIndex);
        }
        this.providerPanel.saveStatusProviders();
    }

    public StatusProviderInfo getStatusProviderInfo() {
        return this.statusProviderInfo;
    }

    public void setStatusProviderInfo(StatusProviderInfo statusProviderInfo) {
        this.statusProviderInfo = statusProviderInfo;
    }

    @Override
    protected void setElementType(Class<DataPowerStatus> elementType) {
        this.preferencesTableName = elementType.getSimpleName();
        super.setElementType(elementType);
    }

    @Override
    protected String getPreferencesTableName() {
        return this.preferencesTableName;
    }

    @Override
    protected TableDisplayPreference applyTableDisplayPreferences() {
        TableDisplayPreference displayPreferences = super.applyTableDisplayPreferences();
        if (displayPreferences == null) {
            displayPreferences = new TableDisplayPreference();
            ArrayList<String> propertyNames = BeanService.getPropertyNames(this.elementType);
            ArrayList<String> defaultColumnOrder = new ArrayList<String>(propertyNames.size());
            propertyNames.remove("appliance");
            propertyNames.remove("sourceDomain");
            propertyNames.remove("statusTime");
            propertyNames.remove("fQON");
            Collections.sort(propertyNames);
            defaultColumnOrder.add("appliance");
            defaultColumnOrder.add("sourceDomain");
            defaultColumnOrder.addAll(propertyNames);
            defaultColumnOrder.add("statusTime");
            this.columnModel.setColumnOrder(defaultColumnOrder);
            int i = 0;
            for (String column : defaultColumnOrder) {
                ColumnPreference cp = new ColumnPreference(column, 100, i++);
                displayPreferences.addColumnPreference(cp);
                this.columnModel.setColumnWidth(column, 100);
            }
        }
        return displayPreferences;
    }

    @Reflected
    private void searchFilters() {
        AdvancedStatusSearchPanel panel = new AdvancedStatusSearchPanel(this.tfFilterExpression.getText(), this.statusProviderInfo);
        GenericDialog searchFiltersDialog = new GenericDialog(GUIServices.getFrame(this), "Build Status Search String", (DialogPanel)panel);
        searchFiltersDialog.setSize(900, 520);
        searchFiltersDialog.setModal(true);
        searchFiltersDialog.setVisible(true);
        String searchString = AdvancedStatusSearchPanel.searchOptionsString;
        this.tfFilterExpression.setText(searchString);
        this.toggleFilterButton();
    }

    private void toggleFilterButton() {
        String searchString = this.tfFilterExpression.getText();
        if (StringUtility.isEmpty(searchString)) {
            this.btnOpenSearchOptions.setIcon(KumbaCoreUIConstants.FILTER_ICON);
        } else {
            this.btnOpenSearchOptions.setIcon(KumbaCoreUIConstants.FILTER_CLEAR_ICON);
        }
    }

    @Reflected
    private void startMonitoring() {
        AbstractPanel.logger.finer("(): Starting.");
        this.resetTableData();
        if (CollectionUtility.isNotEmpty(this.graphPanels)) {
            AbstractPanel.logger.finer("(): Building graph panels.");
            for (StatusProviderGraphPanel statusProviderGraphPanel : this.graphPanels) {
                statusProviderGraphPanel.clearGraphData();
            }
        }
        this.filterSpec = this.getFilterSpec();
        if (this.invalidProperties == null) {
            this.invalidProperties = new UniqueArrayList();
        } else {
            this.invalidProperties.clear();
        }
        this.btnGetStatus.setEnabled(false);
        this.btnStop.setEnabled(true);
        this.miCapture.setEnabled(false);
        if (this.miGraphSaveCapture != null) {
            this.miGraphSaveCapture.setEnabled(false);
        }
        this.miCompare.setEnabled(false);
        if (this.miGraphDiff != null) {
            this.miGraphDiff.setEnabled(false);
        }
        AbstractPanel.logger.finer("(): Notifying provider panel.");
        this.providerPanel.startMonitoring(this.statusProviderInfo);
        List<ApplianceGroupObject> applianceGroups = this.getSelectedApplianceGroup();
        Collection<Domain> domainGroups = this.getSelectedDomains();
        if (applianceGroups == null || domainGroups == null) {
            AbstractPanel.logger.info("(): No appliances or domains are selected.  Returning.");
            return;
        }
        this.applicableDomain = this.statusProviderInfo.getApplicableDomain();
        this.updateFrequency = (int)this.nfUpdateFrequency.getNumber();
        if (this.monitors != null) {
            this.monitors.clear();
            this.monitors = null;
        }
        this.monitors = new ArrayList();
        Collection<Appliance> selectedAppliances = this.getSelectedAppliances();
        AbstractPanel.logger.finer("(): Resolving domains.");
        Object selectedDomains = null;
        boolean defaultDomainOnly = false;
        if (this.applicableDomain.equals(".*")) {
            selectedDomains = this.getSelectedDomains();
        } else {
            defaultDomainOnly = true;
            selectedDomains = "default";
        }
        AbstractPanel.logger.finer("(): Building expressions.");
        StringBuilder applianceList = new StringBuilder();
        for (Appliance appliance : selectedAppliances) {
            if (applianceList.length() > 0) {
                applianceList.append(", ");
            }
            applianceList.append(appliance.getName());
        }
        StringBuilder domainList = new StringBuilder();
        if (selectedDomains instanceof String) {
            String selection = (String)selectedDomains;
            domainList.append(selection);
        } else {
            for (Domain domain : (Collection)selectedDomains) {
                if (domainList.length() > 0) {
                    domainList.append(", ");
                }
                domainList.append(domain.getName());
            }
        }
        String filterExpression = this.tfFilterExpression.getText();
        if (this.frameStatusBar == null) {
            AbstractPanel.logger.info("(): Frame status bar is NULL.  How can that be?  Looking for it.");
            this.frameStatusBar = frame.getStatusBar();
            if (this.frameStatusBar == null) {
                AbstractPanel.logger.info("(): Frame status bar is still NULL.  Find out why and fix it!");
            }
        }
        if (this.frameStatusBar != null) {
            this.frameStatusBar.setMessage(String.format("Appliances: %s     Domains: %s     Filter: %s", applianceList, domainList, filterExpression));
        }
        AbstractPanel.logger.finer("(): Building monitors.  Waiting for them to complete.");
        MultiThreadInvocationListener mtil = ApplianceDomainChangeMonitor.getInstance().invokeProcessByApplianceSelection(this, "setupStatusMonitor", defaultDomainOnly);
        AbstractPanel.logger.finer("(): Done building monitors.  Waiting for setup to complete.");
        int threadCount = mtil.getThreads().size();
        if (threadCount > 0) {
            ThreadManager.monitorAsynchThreadLifeCycle("DataPowerStatusPanel.startMonitoring()", mtil, threadCount * KumbaCoreConstants.STARTUP_DELAY, KumbaCoreConstants.THREAD_TIMEOUT);
        }
        if (this.updateFrequency <= 0) {
            this.resetUI();
        }
        AbstractPanel.logger.finer("(): Done.");
    }

    @Reflected
    private void setupStatusMonitor(Appliance appliance) {
        AbstractPanel.logger.finer(() -> LMG.log("(appliance=%s):  Starting.", () -> appliance.getName()));
        this.setupStatusMonitor(appliance, appliance.getDomain("default"));
        AbstractPanel.logger.finer(() -> LMG.log("(appliance=%s):  Done.", () -> appliance.getName()));
    }

    @Reflected
    private void setupStatusMonitor(Appliance appliance, Domain domain) {
        AbstractPanel.logger.finer(() -> LMG.log("(appliance=%s, domain=%s):  Starting.", () -> appliance.getName(), () -> domain.getName()));
        Domain applicableDomain = this.applicableDomain.equals("default") ? appliance.getDomain("default") : domain;
        try {
            AbstractPanel.logger.finer(() -> LMG.log("(appliance=%s, domain=%s):  Starting.", () -> appliance.getName(), () -> applicableDomain.getName()));
            DataPowerStatusMonitor monitor = new DataPowerStatusMonitor(appliance, applicableDomain, this.statusProviderInfo.getName(), (int)this.nfUpdateFrequency.getNumber());
            monitor.addStatusListener(this);
            this.monitors.add(monitor);
        }
        catch (IllegalArgumentException e) {
            AbstractPanel.logger.severe(() -> LMG.log("(appliance=%s, domain=%s):  Illegal Argument:\n\t\ts.", () -> appliance.getName(), () -> applicableDomain.getName(), () -> e.getMessage()));
            e.printStackTrace();
        }
        AbstractPanel.logger.finer(() -> LMG.log("(appliance=%s, domain=%s):  Done.", () -> appliance.getName(), () -> domain.getName()));
    }

    private HashMap<String, String> getFilterSpec() {
        String[] fieldSpecs;
        HashMap<String, String> filterSpec = new HashMap<String, String>();
        String filterString = this.tfFilterExpression.getText();
        if (StringUtility.isEmpty(filterString)) {
            return filterSpec;
        }
        String[] stringArray = fieldSpecs = filterString.split(",");
        int n = fieldSpecs.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldSpec = stringArray[n2];
            String[] fieldNVPair = fieldSpec.trim().split("=");
            if (fieldNVPair.length != 2) {
                new JMMessageBox((JFrame)frame, "Invalid Search Expression", LabelUtility.wrapInHTML("The search expression you entered is invalid.\n\nSee help for more information.\n\nWill ignore for now."));
                return new HashMap<String, String>();
            }
            Object propertyName = fieldNVPair[0].trim();
            propertyName = StringUtility.toNameCase((String)propertyName);
            propertyName = ((String)propertyName).replaceAll(" ", "");
            propertyName = ((String)propertyName).toLowerCase().charAt(0) + ((String)propertyName).substring(1);
            String valueExpression = fieldNVPair[1].trim();
            valueExpression = RegexUtility.normalizeRegex(valueExpression);
            filterSpec.put((String)propertyName, valueExpression);
            ++n2;
        }
        return filterSpec;
    }

    @Reflected
    void stop() {
        AbstractPanel.logger.finer("(): Starting");
        if (this.stopping && this.stopWait < KumbaCoreConstants.THREAD_TIMEOUT) {
            AbstractPanel.logger.info("(): Already stopping... waiting for previous process to complete.");
            new AsynchMethodInvoker((Object)this, "stop", KumbaCoreConstants.THREAD_WAIT);
            this.stopWait += KumbaCoreConstants.THREAD_WAIT;
            return;
        }
        if (this.stopWait >= KumbaCoreConstants.THREAD_TIMEOUT) {
            AbstractPanel.logger.info("(): Timed out waiting for the previous stop process to complete.");
        }
        this.stopping = true;
        this.stopWait = 0;
        if (this.monitors != null) {
            AbstractPanel.logger.finer(() -> LMG.log("(): Telling %d monitors to stop.", () -> this.monitors.size()));
            for (DataPowerStatusMonitor<DataPowerStatus> dsm : this.monitors) {
                dsm.stop();
            }
            boolean allStopped = false;
            int totalTime = 0;
            while (!allStopped && totalTime < KumbaCoreConstants.THREAD_TIMEOUT) {
                allStopped = true;
                for (DataPowerStatusMonitor<DataPowerStatus> dsm : this.monitors) {
                    if (dsm.isStopped()) continue;
                    allStopped = false;
                    break;
                }
                if (allStopped) continue;
                AbstractPanel.logger.finer("(): Waiting for monitors to stop.");
                ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
            }
            if (totalTime >= KumbaCoreConstants.THREAD_TIMEOUT) {
                AbstractPanel.logger.finer("(): Timed out waiting for minitors to stop.");
            }
            AbstractPanel.logger.finer("(): All monitors have stopped.  Removing listeners");
            for (DataPowerStatusMonitor<DataPowerStatus> dsm : this.monitors) {
                dsm.removeStatusListener(this);
            }
            AbstractPanel.logger.finer("(): Cleaning up.");
            this.monitors.clear();
            this.monitors = null;
        }
        this.resetUI();
        this.stopping = false;
        this.stopWait = 0;
        AbstractPanel.logger.finer("(): Done");
    }

    private void resetUI() {
        this.btnGetStatus.setEnabled(true);
        this.btnStop.setEnabled(false);
        this.providerPanel.stopMonitoring(this.statusProviderInfo);
        if (!CollectionUtility.isEmpty(this.invalidProperties)) {
            StringBuilder sb = new StringBuilder();
            for (String invalidProperty : this.invalidProperties) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(invalidProperty);
            }
            String message = String.format(LabelUtility.wrapInHTML("The following invalid properties were found in your filter expression.<br/><br/>%s<br/><br/>Be sure to enter the property name exactly as it appears in the status headers."), sb.toString());
            this.showMessage("Filter Expression Error", message);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void statusEvent(DataPowerStatus event) {
        int maxRows;
        boolean addEvent = true;
        String badField = null;
        if (event == null || event.getAppliance() == null || event.getSourceDomain() == null) {
            return;
        }
        String loggerPrefix = String.format("(DataPowerStatus=%s)", event.getFQON());
        if (this.filterSpec != null && this.filterSpec.size() > 0) {
            for (String field : this.filterSpec.keySet()) {
                try {
                    String fieldMatch;
                    String matchValue;
                    void var7_10;
                    Object value;
                    String string = field;
                    Class<?> propertyType = BeanService.getPropertyType(event, field);
                    if (propertyType.equals(ObjectReference.class)) {
                        String string2 = string + ".name";
                    }
                    if ((value = BeanService.getPropertyValue(event, (String)var7_10)) == null || (matchValue = value.toString()).matches(fieldMatch = this.filterSpec.get(field))) continue;
                    addEvent = false;
                }
                catch (NullPointerException nullPointerException) {
                    addEvent = false;
                    logger.fine(() -> LMG.log("%s: NullPointer Exception processing value - shouldn't happen.", () -> loggerPrefix));
                }
                catch (PropertyNotFoundException propertyNotFoundException) {
                    addEvent = false;
                    badField = field;
                    logger.info(() -> LMG.log("%s: Property '%s' not found.", () -> loggerPrefix, () -> field));
                }
                break;
            }
        }
        if (badField != null) {
            String badFielF = badField;
            logger.info(() -> LMG.log("%s: Trying to resolve for bad field name of '%s'.", () -> loggerPrefix, () -> badFielF));
            ArrayList<String> propertyNames = BeanService.getPropertyNames(event);
            for (String string : propertyNames) {
                if (!string.equalsIgnoreCase(badField)) continue;
                String valueExpression = this.filterSpec.get(badField);
                this.filterSpec.remove(badField);
                this.filterSpec.put(string, valueExpression);
                logger.finer(() -> LMG.log("%s: Changing bad field '%s' to value expression '%s' and replaying event.", () -> loggerPrefix, () -> badFielF, () -> valueExpression));
                this.statusEvent(event);
                return;
            }
            logger.info(() -> LMG.log("%s: Cound not resolve for bad field name of '%s'  Stopping.", () -> loggerPrefix, () -> badFielF));
            if (this.invalidProperties == null) {
                this.invalidProperties = new UniqueArrayList();
            }
            this.invalidProperties.add(badField);
            if (!this.stopping) {
                this.stopping = true;
                new AsynchMethodInvoker((Object)this, "stop", 1000);
                return;
            }
        }
        if (addEvent) {
            logger.finer(() -> LMG.log("%s: Event matches.  Adding event.", () -> loggerPrefix));
            this.addEvent(event);
            this.miCapture.setEnabled(true);
            if (this.miGraphSaveCapture != null) {
                this.miGraphSaveCapture.setEnabled(true);
            }
            this.miCompare.setEnabled(true);
            if (this.miGraphDiff != null) {
                this.miGraphDiff.setEnabled(true);
            }
        }
        if ((maxRows = (int)this.nfMaxRows.getNumber()) > 0) {
            if (maxRows != this.lastMaxRows) {
                if (CollectionUtility.isNotEmpty(this.graphPanels)) {
                    logger.finer(() -> LMG.log("%s: Setting max rows to %d on all graph panels.", () -> loggerPrefix, () -> maxRows));
                    for (StatusProviderGraphPanel spgp : this.graphPanels) {
                        spgp.setMaxRows(maxRows);
                    }
                }
                this.lastMaxRows = maxRows;
            }
            int rowCount = this.tableModel.getRowCount();
            logger.finer(() -> LMG.log("%s: Current row count = %d.", () -> loggerPrefix, () -> this.tableModel.getRowCount()));
            while (rowCount > maxRows) {
                try {
                    this.tableModel.deleteRow(--rowCount);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    int rowCountF = rowCount + 1;
                    logger.warning(() -> LMG.log("%s: ArrayIndexOutOfBoudsException removing %d from model size of %d.", () -> loggerPrefix, () -> rowCountF, () -> this.tableModel.getRowCount()));
                }
            }
        }
        int updateFrequency = (int)this.nfUpdateFrequency.getNumber();
        if (CollectionUtility.isNotEmpty(this.monitors)) {
            for (DataPowerStatusMonitor<DataPowerStatus> dataPowerStatusMonitor : this.monitors) {
                dataPowerStatusMonitor.setMonitorInterval(updateFrequency);
            }
        }
        if (updateFrequency == 0) {
            logger.finer(() -> LMG.log("%s: Update frequency is zero.  Stopping.", () -> loggerPrefix));
            this.btnGetStatus.setEnabled(true);
            this.btnStop.setEnabled(false);
        }
    }

    @Override
    public void statusComplete(Appliance appliance, Domain domain, String statusClass) {
    }

    @Override
    public void noStatus(Appliance appliance, Domain domain, String statusClass, DateTime statusTime) {
    }

    private void addEvent(DataPowerStatus event) {
        BeanTableModel<DataPowerStatus> tableModel = this.getTableModel();
        if (tableModel.getRowCount() == 0) {
            this.addRow(event);
        } else {
            try {
                tableModel.insertRow(event, 0);
            }
            catch (IndexOutOfBoundsException e) {
                ThreadUtility.sleep(50L);
                this.addEvent(event);
                return;
            }
        }
        if (CollectionUtility.isNotEmpty(this.graphPanels)) {
            for (StatusProviderGraphPanel spgp : this.graphPanels) {
                spgp.addEvent(event);
            }
        }
    }

    @Override
    public void statusChanged(DataPowerStatus lastEvent, DataPowerStatus thisEvent) {
    }

    @Override
    public void error(Appliance appliance, Domain domain, String statusClass, int errorCode, DataPowerStatus lastEvent) {
        Logger logger = Application.getApplication().getApplicationLogger();
        String error = String.format("DataPowerStatusPanel.connectionFailure(:  Appliance: %s, Domain: %s, StatuClass=%s, Last Event: %s)", appliance.getName(), domain.getName(), statusClass, String.valueOf(lastEvent));
        logger.info(error);
    }

    @Reflected
    private void tabSelectionChanged() {
        Component selectedTab = this.tableGraphTabbedPane.getSelectedComponent();
        if (selectedTab == this.graphPanel) {
            this.miDeleteGraph.setEnabled(this.graphPanels.size() > 0);
        } else {
            this.miDeleteGraph.setEnabled(false);
        }
    }

    @Reflected
    private void fileNew() {
        DynamicBean modelData = new DynamicBean();
        modelData.setProperty("statusProviderInfo", this.statusProviderInfo);
        CreateStatusGraphPage createStatusGraphPage = new CreateStatusGraphPage(modelData);
        WizardDialog<DynamicBean> createLogTargetDialog = new WizardDialog<DynamicBean>((JFrame)frame, "Create Status Graph");
        createLogTargetDialog.addWizardPage(createStatusGraphPage, "welcome");
        createLogTargetDialog.setSize(700, 400);
        createLogTargetDialog.startWizard();
        if (WizardDialog.wasCancelled()) {
            return;
        }
        StatusProviderGraphDefinition statusProviderGraphDefinition = (StatusProviderGraphDefinition)modelData.getProperty("graphDefinition");
        String graphName = statusProviderGraphDefinition.getGraphName();
        StatusProviderGraphPanel graphPanel = new StatusProviderGraphPanel(statusProviderGraphDefinition);
        if (this.getDisplayTable().getRowCount() > 0) {
            ArrayList<DataPowerStatus> currentData = this.getTableModel().getModelData();
            graphPanel.setData(currentData);
        }
        this.statusProviderInfo.addGraph(statusProviderGraphDefinition);
        this.providerPanel.saveStatusProviders();
        this.graphPanels.add(graphPanel);
        this.graphTabbedPane.addTab(graphName, graphPanel);
    }

    @Reflected
    private void fileSave() {
        DateTime saveTime = new DateTime();
        String statusProviderName = this.statusProviderInfo.getName();
        ArrayList statusData = this.tableModel.getModelData();
        BeanIndexer applianceIndexer = new BeanIndexer(statusData);
        Index applianceIndex = applianceIndexer.getIndexOf("appliance", null);
        String statusCaptureDirectory = ((KumbaCoreApplicationProperties)Application.getApplication().getApplicationProperties()).getStatusCaptureDirectory();
        String baseCaptureDirectoryName = String.format("%s%s%s", statusCaptureDirectory, File.separator, statusProviderName);
        File baseCaptureDirectory = new File(baseCaptureDirectoryName);
        for (Appliance appliance : applianceIndex.getKeys()) {
            File baseApplianceDirectory = new File(baseCaptureDirectory, appliance.getName());
            Collection statusByAppliance = applianceIndex.get(appliance);
            BeanIndexer domainIndexer = new BeanIndexer(statusByAppliance);
            Index domainIndex = domainIndexer.getIndexOf("sourceDomain", null);
            for (Domain domain : domainIndex.getKeys()) {
                File baseDomainDirectory = new File(baseApplianceDirectory, domain.getName());
                ArrayList statusByDomain = (ArrayList)domainIndex.get(domain);
                BeanComparator sorter = new BeanComparator();
                sorter.addCompareProperty("statusTime");
                Collections.sort(statusByDomain, sorter);
                long timeStamp = saveTime.getCalendar().getTimeInMillis();
                File statusOutputDir = new File(baseDomainDirectory, "" + timeStamp);
                if (!statusOutputDir.exists()) {
                    statusOutputDir.mkdirs();
                }
                File statusOutputFile = new File(statusOutputDir, "capture.xml");
                FileUtility.writeObject(statusOutputFile, (Object)statusByDomain);
            }
        }
        String string = this.statusProviderInfo.getDisplayName();
        this.showMessage(String.format("%s saved successfully!", string), String.format("The currently displayed output for the %s has been saved.", string));
    }

    @Reflected
    private void captureFileDiff() {
        DynamicBean model = new DynamicBean();
        Index<Appliance, Domain> domains = ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection();
        model.setProperty("domains", domains);
        model.setProperty("statusProviderInfo", this.statusProviderInfo);
        WizardDialog<DynamicBean> wizardDialog = new WizardDialog<DynamicBean>((JFrame)frame, "Status Delta");
        wizardDialog.addWizardPage(new StatusDiffHistorySelectWizardPage(model), "historyList");
        wizardDialog.addWizardPage(new StatusDiffPropertySelectionWizardPage(model), "propertyList");
        wizardDialog.setSize(800, 600);
        wizardDialog.startWizard();
        if (WizardDialog.wasCancelled()) {
            return;
        }
        Index statusCaptureHistory = (Index)model.getProperty("statusCaptureHistory");
        DateTime selectedCaptureTime = (DateTime)model.getProperty("selectedCaptureTime");
        ArrayList selectedProperties = (ArrayList)model.getProperty("selectedProperties");
        ArrayList currentData = this.tableModel.getModelData();
        DataPowerStatus sample = (DataPowerStatus)currentData.get(0);
        ArrayList<String> properties = BeanService.getPropertyNames(sample);
        ArrayList compareData = new ArrayList();
        ArrayList captureFiles = (ArrayList)statusCaptureHistory.get(selectedCaptureTime);
        for (File captureFile : captureFiles) {
            File fileToRead = new File(captureFile, "capture.xml");
            ExceptionListenerClient exceptionListenerClient = new ExceptionListenerClient();
            ArrayList captureData = (ArrayList)FileUtility.readObject(fileToRead, (ExceptionListener)exceptionListenerClient);
            if (exceptionListenerClient.hasException()) {
                new JMMessageBox(null, "Failed to read Status Capture Data", "Error reading capture file.");
            }
            compareData.addAll(captureData);
        }
        new StatusFileDiffDialog((JFrame)frame, this.statusProviderInfo, currentData, compareData, selectedCaptureTime, properties, selectedProperties);
    }

    @Reflected
    private void captureGraphDiff() {
        DynamicBean model = new DynamicBean();
        Index<Appliance, Domain> domains = ApplianceDomainChangeMonitor.getInstance().getCurrentDomainSelection();
        model.setProperty("domains", domains);
        model.setProperty("statusProviderInfo", this.statusProviderInfo);
        WizardDialog<DynamicBean> wizardDialog = new WizardDialog<DynamicBean>((JFrame)frame, "Status Graph Comparison");
        wizardDialog.addWizardPage(new StatusDiffHistorySelectWizardPage(model), "historyList");
        wizardDialog.addWizardPage(new StatusDiffGraphSelectionWizardPage(model), "graphList");
        wizardDialog.setSize(800, 600);
        wizardDialog.startWizard();
        if (WizardDialog.wasCancelled()) {
            return;
        }
        Index statusCaptureHistory = (Index)model.getProperty("statusCaptureHistory");
        DateTime selectedCaptureTime = (DateTime)model.getProperty("selectedCaptureTime");
        String selectedGraphName = (String)model.getProperty("selectedGraph");
        ArrayList currentData = this.tableModel.getModelData();
        ArrayList compareData = new ArrayList();
        ArrayList captureFiles = (ArrayList)statusCaptureHistory.get(selectedCaptureTime);
        for (File captureFile : captureFiles) {
            File fileToRead = new File(captureFile, "capture.xml");
            ExceptionListenerClient exceptionListenerClient = new ExceptionListenerClient();
            ArrayList captureData = (ArrayList)FileUtility.readObject(fileToRead, (ExceptionListener)exceptionListenerClient);
            if (exceptionListenerClient.hasException()) {
                new JMMessageBox(null, "Failed to read Status Capture Data", "Error reading capture file.");
            }
            compareData.addAll(captureData);
        }
        BeanComparator sorter = new BeanComparator();
        sorter.addCompareProperties("statusTime", "appliance.name", "sourceDomain.name");
        Collections.sort(compareData, sorter);
        new StatusGraphDiffDialog((JFrame)frame, this.statusProviderInfo, currentData, compareData, selectedCaptureTime, selectedGraphName);
    }

    @Reflected
    private void editDelete() {
        if (!this.continueAction("Delete the current graph?", "Do you want to delete the currently selected graph?")) {
            return;
        }
        StatusProviderGraphPanel graphPanel = (StatusProviderGraphPanel)this.graphTabbedPane.getSelectedComponent();
        this.graphPanels.remove(graphPanel);
        this.graphTabbedPane.remove(graphPanel);
        StatusProviderGraphDefinition statusProviderGraphDefinition = graphPanel.getGraphDefinition();
        this.statusProviderInfo.deleteGraph(statusProviderGraphDefinition);
        this.providerPanel.saveStatusProviders();
    }
}

