/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.status;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.rules.PropertyValueRule;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.swing.JMList;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.event.ListSelectionEventInvoker;
import com.jmorgan.swing.list.JMListCellRenderer;
import com.jmorgan.swing.list.JMListModel;
import com.jmorgan.swing.list.KeySearchListElementSelector;
import com.jmorgan.swing.util.GUIServices;
import com.jmorgan.swing.util.InsetsFactory;
import com.kumbasoft.core.beans.StatusProviderInfo;
import com.kumbasoft.core.beans.StatusProviderManager;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.ui.KumbaCoreUIPersistenceHandler;
import com.kumbasoft.dpaa.ui.panels.status.DataPowerStatusPanel;
import com.kumbasoft.dpaa.ui.panels.status.StatusProviderListCellValueRenderer;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.ListModel;

public class DataPowerStatusProviderListPanel
extends JMPanel {
    private ArrayList<StatusProviderInfo> statusProviderInfo;
    private JMList<StatusProviderInfo> providerList;
    private JMListModel<StatusProviderInfo> providerListModel;
    private JMPanel statusContainer;
    private CardLayout cardLayout;
    private JMButton btnStopAll;
    private JMListCellRenderer<StatusProviderInfo> listCellRenderer;
    private HashMap<String, DataPowerStatusPanel> panels;

    public DataPowerStatusProviderListPanel() {
        super(new BorderLayout(5, 5));
        this.setInsets(InsetsFactory.createFixedInsets(10));
        this.panels = new HashMap();
        this.cardLayout = new CardLayout();
        this.statusContainer = new JMPanel(this.cardLayout);
        JMPanel listPanel = this.createProviderListPanel();
        this.add((Component)listPanel, "West");
        this.add((Component)this.statusContainer, "Center");
        new ListSelectionEventInvoker(this.providerList, this, "statusProviderSelectionChanged");
        new AsynchMethodInvoker((Object)this, "loadStatusProviders", 1000);
    }

    @Override
    public void updateUI() {
        if (this.listCellRenderer != null) {
            KumbaCoreUIConstants.setupRenderer(this.listCellRenderer);
        }
        super.updateUI();
    }

    private JMPanel createProviderListPanel() {
        this.providerListModel = new JMListModel();
        this.providerList = new JMList<StatusProviderInfo>((ListModel<StatusProviderInfo>)this.providerListModel);
        new KeySearchListElementSelector<StatusProviderInfo>(this.providerList, "displayName");
        this.listCellRenderer = KumbaCoreUIConstants.createListCellRenderer(new StatusProviderListCellValueRenderer());
        PropertyValueRule monitoredRule = new PropertyValueRule();
        monitoredRule.addPropertyValueMap("isBeingMonitored", true);
        this.listCellRenderer.addUnSelectedColorRule(monitoredRule, KumbaCoreUIConstants.BACKGROUND);
        this.listCellRenderer.addSelectedColorRule(monitoredRule, KumbaCoreUIConstants.BACKGROUND);
        this.listCellRenderer.addUnSelectedBackgroundColorRule(monitoredRule, KumbaCoreUIConstants.STATUS_MONITORED_COLOR);
        this.listCellRenderer.addSelectedBackgroundColorRule(monitoredRule, KumbaCoreUIConstants.STATUS_MONITORED_COLOR);
        this.providerList.setCellRenderer(this.listCellRenderer);
        this.providerList.getSelectionModel().setSelectionMode(0);
        JMLabel title = new JMLabel("Status Providers:");
        this.btnStopAll = new JMButton(KumbaCoreUIConstants.STOP_ICON, "Stop all running providers.");
        this.btnStopAll.setEnabled(false);
        new ActionEventInvoker(this.btnStopAll, this, "stopAllMonitors");
        JMPanel titlePanel = new JMPanel(new BorderLayout());
        titlePanel.add((Component)title, "Center");
        titlePanel.add((Component)this.btnStopAll, "East");
        JMPanel listPanel = new JMPanel(new BorderLayout(1, 10));
        listPanel.add((Component)titlePanel, "North");
        listPanel.add((Component)KumbaCoreUIConstants.createScrollPane(this.providerList), "Center");
        listPanel.setPreferredSize(375, 20);
        return listPanel;
    }

    @Reflected
    private void loadStatusProviders() {
        this.statusProviderInfo = StatusProviderManager.loadStatusProviders();
        new AsynchMethodInvoker(this.providerListModel, "addAll", this.statusProviderInfo);
    }

    public void saveStatusProviders() {
        KumbaCoreUIPersistenceHandler.writeStatusProviderInfo(this.statusProviderInfo);
    }

    @Reflected
    private void statusProviderSelectionChanged() {
        StatusProviderInfo spi = this.providerList.getSelectedItem();
        if (spi == null) {
            return;
        }
        this.showStatusProviderPanel(spi);
    }

    @Reflected
    private void showStatusProviderPanel(StatusProviderInfo spi) {
        DataPowerStatusPanel panel = this.panels.get(spi.getName());
        if (panel == null) {
            panel = new DataPowerStatusPanel(this, spi);
            this.statusContainer.add((Component)panel, spi.getName());
            this.panels.put(spi.getName(), panel);
            this.saveStatusProviders();
        }
        this.cardLayout.show(this.statusContainer, spi.getName());
        GUIServices.getFrame(this).repaint();
    }

    void startMonitoring(StatusProviderInfo statusProviderInfo) {
        statusProviderInfo.setBeingMonitored(true);
        this.providerList.repaintSelectedCell();
        this.btnStopAll.setEnabled(true);
    }

    void stopMonitoring(StatusProviderInfo statusProviderInfo) {
        statusProviderInfo.setBeingMonitored(false);
        this.providerList.repaintSelectedCell();
        boolean atLeastOneBeingMonitored = false;
        Collection<StatusProviderInfo> statusProviders = this.providerListModel.getAll();
        for (StatusProviderInfo statusProvider : statusProviders) {
            if (!statusProvider.isBeingMonitored()) continue;
            atLeastOneBeingMonitored = true;
            break;
        }
        this.btnStopAll.setEnabled(atLeastOneBeingMonitored);
    }

    @Reflected
    private void stopAllMonitors() {
        Collection<StatusProviderInfo> statusProviders = this.providerListModel.getAll();
        for (StatusProviderInfo statusProvider : statusProviders) {
            statusProvider.setBeingMonitored(false);
            DataPowerStatusPanel statusPanel = this.panels.get(statusProvider.getName());
            if (statusPanel == null) continue;
            statusPanel.stop();
        }
        this.btnStopAll.setEnabled(false);
        this.providerList.repaint();
    }
}

