/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.dpaa.ui.panels.systemControl;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.swing.JMButton;
import com.jmorgan.swing.JMButtonGroup;
import com.jmorgan.swing.JMCheckBox;
import com.jmorgan.swing.JMMessageBox;
import com.jmorgan.swing.JMPanel;
import com.jmorgan.swing.JMPasswordField;
import com.jmorgan.swing.JMRadioButton;
import com.jmorgan.swing.JMTextField;
import com.jmorgan.swing.LabeledComponent;
import com.jmorgan.swing.NumberField;
import com.jmorgan.swing.combobox.ListComboBox;
import com.jmorgan.swing.component.ComponentFactory;
import com.jmorgan.swing.component.FileSelectorComponent;
import com.jmorgan.swing.event.ActionEventInvoker;
import com.jmorgan.swing.event.ItemEventInvoker;
import com.jmorgan.swing.spinner.NumberSpinner;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionPropertySelector;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.ConfigObjectCache;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.DataPowerFileInfo;
import com.kumbasoft.core.beans.actions.ActionApplyPatch;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.tools.FirmwareUpgrader;
import com.kumbasoft.core.tools.ListFiles;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.ui.AbstractPanel;
import com.kumbasoft.core.ui.ApplianceDomainChangeMonitor;
import com.kumbasoft.core.ui.KumbaCoreUIConstants;
import com.kumbasoft.core.util.DataPowerSSHClient;
import com.kumbasoft.dpaa.ui.panels.systemControl.AbstractSystemActionPanel;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JFrame;

public class ApplyPatchPanel
extends AbstractSystemActionPanel<ActionApplyPatch> {
    private static final String SCP_ERROR = "An error occurred while copying the file";
    private static final String SCP_SUCCESS = "File copy success";
    private static final String SCP_PERMISSION_DENIED = "Permission denied";
    private static final String SCP_FAILED_TO_RESOLVE_HOST_NAME = "Failed to resolve host name";
    private static final String SCP_CANNOT_COPY_FILE = "Cannot copy file";
    private static final String FILE_COPY_FAILED = "File copy failed - Error reading from source";
    private static final String HTTP_PANEL = "HTTPPanel";
    private static final String SCP_PANEL = "SCPPanel";
    private JMRadioButton rbHTTPSource;
    private JMRadioButton rbSCPSource;
    private JMPanel remoteLocationPanel = this.createCardPanel();
    private CardLayout remoteLocationLayout;
    private JMTextField tfURL;
    private JMButton btnGetFromURL;
    private JMRadioButton rbSCP;
    private JMRadioButton rbSFTP;
    private FileSelectorComponent fileSelectorComponent;
    private JMTextField tfSCPServerHost;
    private NumberField nfSCPPort;
    private JMTextField tfSCPServerUserName;
    private JMPasswordField tfSCPServerPassword;
    private ListComboBox cbxExistingDPImageFiles;
    private ListComboBox cbxXMLManagers;
    private JMCheckBox cbxOverwrite;
    private ArrayList<StatusObjectStatus> xmlManagers;
    private ConfigObjectCache<DataPowerFileInfo> imageFileCache;
    private String fileToUpload;

    public ApplyPatchPanel() {
        super("Upgrade Firmware");
        JMPanel sourceChoicePanel = this.createChoicePanel();
        this.cbxOverwrite = new JMCheckBox("Overwrite existing image?", true);
        this.cbxExistingDPImageFiles = new ListComboBox();
        LabeledComponent lblExistingFiles = new LabeledComponent("Image File:", (Component)this.cbxExistingDPImageFiles, 100, 300);
        this.cbxXMLManagers = new ListComboBox();
        LabeledComponent lblXMLManagers = new LabeledComponent("XML Manager:", (Component)this.cbxXMLManagers, 100, 200);
        Component spacer = ComponentFactory.createSpacer(2, 30);
        this.addAll(sourceChoicePanel, this.remoteLocationPanel, lblXMLManagers, this.cbxOverwrite, spacer, lblExistingFiles);
        this.xmlManagers = new ArrayList();
        this.imageFileCache = new ConfigObjectCache();
        this.setButtonState(false);
        ApplianceDomainChangeMonitor.getInstance().addApplianceChangeSubscriber(this, "appliancesChanged");
    }

    @Override
    protected Dimension getButtonSize() {
        return new Dimension(200, 25);
    }

    private JMPanel createChoicePanel() {
        JMPanel panel = KumbaCoreUIConstants.createBorderLayoutPanel();
        this.rbHTTPSource = new JMRadioButton("HTTP/HTTPS", true);
        this.rbHTTPSource.setSize(100, 25);
        new ItemEventInvoker(this.rbHTTPSource, this.remoteLocationLayout, "show", this.remoteLocationPanel, HTTP_PANEL);
        this.rbSCPSource = new JMRadioButton("SCP/SFTP");
        this.rbSCPSource.setSize(100, 25);
        new ItemEventInvoker(this.rbSCPSource, this.remoteLocationLayout, "show", this.remoteLocationPanel, SCP_PANEL);
        new JMButtonGroup(this.rbHTTPSource, this.rbSCPSource);
        panel.add((Component)this.rbHTTPSource, "Center");
        panel.add((Component)this.rbSCPSource, "East");
        return panel;
    }

    private JMPanel createCardPanel() {
        this.remoteLocationLayout = new CardLayout();
        JMPanel panel = new JMPanel(this.remoteLocationLayout);
        panel.add((Component)this.createHTTPPanel(), HTTP_PANEL);
        panel.add((Component)this.createSCPPanel(), SCP_PANEL);
        return panel;
    }

    private JMPanel createHTTPPanel() {
        JMPanel httpPanel = KumbaCoreUIConstants.createVerticalFlowLayoutPanel(0);
        this.tfURL = new JMTextField();
        LabeledComponent lblURL = new LabeledComponent("URL:", (Component)this.tfURL, 40, 400);
        this.btnGetFromURL = new JMButton("Get Image File");
        new ActionEventInvoker(this.btnGetFromURL, this, "uploadFile");
        JMPanel componentPanel = KumbaCoreUIConstants.createBorderLayoutPanel();
        componentPanel.add((Component)lblURL, "Center");
        componentPanel.add((Component)this.btnGetFromURL, "East");
        httpPanel.add(componentPanel);
        return httpPanel;
    }

    private JMPanel createSCPPanel() {
        JMPanel panel = KumbaCoreUIConstants.createVerticalFlowLayoutPanel(0);
        this.rbSCP = new JMRadioButton("SCP", true);
        this.rbSCP.setSize(75, 25);
        this.rbSFTP = new JMRadioButton("SFTP");
        this.rbSFTP.setSize(100, 25);
        new JMButtonGroup(this.rbSCP, this.rbSFTP);
        JMPanel rbPanel = KumbaCoreUIConstants.createBorderLayoutPanel();
        rbPanel.add((Component)this.rbSCP, "Center");
        rbPanel.add((Component)this.rbSFTP, "East");
        this.fileSelectorComponent = new FileSelectorComponent("Path to Image File:", "Upload File");
        this.fileSelectorComponent.setPreferredSize(686, 25);
        new ActionEventInvoker(this.fileSelectorComponent, this, "uploadFile");
        this.tfSCPServerHost = new JMTextField();
        LabeledComponent lblSCPServerHost = new LabeledComponent("SCP/SFTP Host:", (Component)this.tfSCPServerHost, 135, 300);
        this.nfSCPPort = new NumberField(22.0);
        this.nfSCPPort.setFormatString("###0;-###0");
        NumberSpinner nsSCPPort = new NumberSpinner(this.nfSCPPort);
        LabeledComponent lblSCPPort = new LabeledComponent("SCP/SFTP Port:", (Component)nsSCPPort, 100, 132);
        this.tfSCPServerUserName = new JMTextField();
        LabeledComponent lblSCPServerUserName = new LabeledComponent("SCP/SFTP User Name:", (Component)this.tfSCPServerUserName, 135, 200);
        JMPanel serverPort = KumbaCoreUIConstants.createBorderLayoutPanel();
        serverPort.add((Component)lblSCPServerHost, "Center");
        serverPort.add((Component)lblSCPPort, "East");
        this.tfSCPServerPassword = new JMPasswordField();
        this.tfSCPServerPassword.setName("ApplyPatchPanel.SCPServerPassword");
        LabeledComponent lblSCPServerPassword = new LabeledComponent("SCP/SFTP Password:", (Component)this.tfSCPServerPassword, 130, 200);
        JMPanel userNamePassword = KumbaCoreUIConstants.createBorderLayoutPanel();
        userNamePassword.add((Component)lblSCPServerUserName, "Center");
        userNamePassword.add((Component)lblSCPServerPassword, "East");
        Component spacer = ComponentFactory.createSpacer(2, 10);
        panel.addAll(rbPanel, serverPort, userNamePassword, spacer, this.fileSelectorComponent);
        return panel;
    }

    @Override
    protected String getCommandResultsDialogTitle() {
        return "Upgrade Firmware";
    }

    @Reflected
    private void appliancesChanged(ArrayList<Appliance> selectedAppliances) {
        new AsynchMethodInvoker((Object)this, "reloadXMLManagers", selectedAppliances);
        new AsynchMethodInvoker((Object)this, "reloadImageFiles", selectedAppliances);
    }

    @Reflected
    private void reloadXMLManagers(UniqueArrayList<Appliance> selectedAppliances) {
        if (this.xmlManagers != null) {
            this.xmlManagers.clear();
        }
        this.xmlManagers = null;
        this.cbxXMLManagers.clearListModel();
        this.cbxXMLManagers.getField().setText("");
        ConfigurationManager configurationManager = new ConfigurationManager();
        this.xmlManagers = configurationManager.listObjects(selectedAppliances, "XMLManager", ".*");
        CollectionPropertySelector<StatusObjectStatus> nameSelector = new CollectionPropertySelector<StatusObjectStatus>(this.xmlManagers);
        UniqueArrayList<String> uniqueNames = new UniqueArrayList<String>(nameSelector.get("name", String.class));
        uniqueNames.sort();
        this.cbxXMLManagers.addItems(uniqueNames);
        this.cbxXMLManagers.setSelectedValue("default");
    }

    @Reflected
    private void reloadImageFiles(UniqueArrayList<Appliance> selectedAppliances) {
        AbstractPanel.logger.finer("(UniqueArrayList<Appliance> selectedAppliances): Starting.");
        this.imageFileCache.clearCache();
        this.cbxExistingDPImageFiles.clearListModel();
        this.cbxExistingDPImageFiles.getField().setText("");
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        AbstractPanel.logger.finer("(UniqueArrayList<Appliance> selectedAppliances): Waiting for image file list.");
        for (Appliance appliance : selectedAppliances) {
            ListFiles listFiles = new ListFiles(appliance, appliance.getDomain("default"), "image:", ".*");
            mtil.addThread(listFiles.getProcessThread());
            listFiles.addConfigObjectSubscriber(DataPowerFileInfo.class, this.imageFileCache);
        }
        ThreadManager.monitorAsynchThreadLifeCycle("ApplyPatchPanel.reloadImageFiles(...)", mtil, selectedAppliances.size() * KumbaCoreConstants.STARTUP_DELAY, 0);
        int checkCount = 0;
        while (!this.imageFileCache.isComplete() && checkCount++ < 10) {
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
        }
        if (checkCount >= 10) {
            AbstractPanel.logger.warning("(UniqueArrayList<Appliance> selectedAppliances): Image file cache is not complete.");
        }
        AbstractPanel.logger.finer("(UniqueArrayList<Appliance> selectedAppliances): Reading image file cache.");
        Vector<DataPowerFileInfo> fileCache = this.imageFileCache.getObjectCache();
        if (fileCache.size() > 0) {
            CollectionPropertySelector<DataPowerFileInfo> nameSelector = new CollectionPropertySelector<DataPowerFileInfo>(fileCache);
            ArrayList names = (ArrayList)nameSelector.get("name", String.class);
            Collections.sort(names);
            UniqueArrayList uniqueNames = new UniqueArrayList(names);
            for (String name : uniqueNames) {
                this.cbxExistingDPImageFiles.addItem(name);
            }
            if (uniqueNames.size() > 0) {
                this.cbxExistingDPImageFiles.setSelectedIndex(0);
                this.setButtonState(true);
            }
        } else {
            AbstractPanel.logger.warning("(UniqueArrayList<Appliance> selectedAppliances): Image file cache is empty.");
        }
        AbstractPanel.logger.finer("(UniqueArrayList<Appliance> selectedAppliances): Done.");
    }

    @Reflected
    private void uploadFile() {
        if (this.rbSCPSource.isSelected()) {
            String fileName = this.fileSelectorComponent.getFileName();
            if (StringUtility.isEmpty(fileName)) {
                AbstractPanel.logger.severe("(): File name not provided for SCP copy.");
                this.showMessage("Must provide a file name", "You must provide a file name to upload.");
                return;
            }
            if (StringUtility.isEmpty(this.tfSCPServerHost.getText())) {
                AbstractPanel.logger.severe("(): Server host not provided for SCP copy.");
                this.showMessage("Must provide SCP/SFTP host", "You must provide a SCP/SFTP host to upload.");
                return;
            }
            if (StringUtility.isEmpty(this.tfSCPServerUserName.getText()) || StringUtility.isEmpty(this.tfSCPServerPassword.getText())) {
                AbstractPanel.logger.severe("(): SCP/SFTP credentials not provided.");
                this.showMessage("Must provide SCP/SFTP credentials", "You must provide a SCP/SFTP credentials.");
                return;
            }
        } else {
            String URL2 = this.tfURL.getText();
            if (StringUtility.isEmpty(URL2)) {
                AbstractPanel.logger.severe("(): URL not provided for HTTP copy.");
                this.showMessage("Must provide a URL", "You must provide a fully qualified URL to the image file to upload.");
                return;
            }
        }
        this.setCursor(KumbaCoreUIConstants.WAIT_CURSOR);
        ApplianceDomainChangeMonitor adcm = ApplianceDomainChangeMonitor.getInstance();
        MultiThreadInvocationListener uploadThreadInvocationListener = adcm.invokeProcessByApplianceSelection(this, "uploadFile", true);
        ThreadManager.monitorAsynchThreadLifeCycle("ApplyPatchPanel.uploadFile()", uploadThreadInvocationListener, KumbaCoreConstants.STARTUP_DELAY, 0);
        this.reloadImageFiles(adcm.getCurrentApplianceSelection());
        this.setCursor(KumbaCoreUIConstants.NORMAL_CURSOR);
    }

    @Reflected
    private void uploadFile(Appliance appliance) {
        DataPowerSSHClient dpSSHClient;
        String loggerPrefix;
        block13: {
            String dpPrompt;
            String successOrFailure;
            String fileName;
            int scpPort;
            String scpHost;
            block12: {
                String dpPromptF;
                block11: {
                    loggerPrefix = String.format("(Appliance=%s): ", appliance.getName());
                    AbstractPanel.logger.fine(loggerPrefix + "Starting.  Connecting via SSH client.");
                    dpSSHClient = new DataPowerSSHClient(appliance);
                    if (!dpSSHClient.connect()) {
                        AbstractPanel.logger.severe(() -> LMG.log("%sError Connecting to SSH.", () -> loggerPrefix));
                        String message = String.format("The SSH connection to the '%s' appliance could not be made.  Retry?", appliance.getName());
                        new JMMessageBox((JFrame)AbstractPanel.frame, "SSH Connection Error", message, 12);
                        int selection = JMMessageBox.getSelection();
                        if (selection == 4) {
                            new AsynchMethodInvoker((Object)this, "uploadFile", (Object)appliance);
                        }
                        return;
                    }
                    scpHost = this.tfSCPServerHost.getText();
                    scpPort = (int)this.nfSCPPort.getNumber();
                    fileName = this.getFileName();
                    String slashes = fileName.startsWith("/") ? "" : "/";
                    String dpFileName = String.format("image:%s%s", slashes, fileName);
                    successOrFailure = String.format("(%s|%s|%s.*|. %s.*)", SCP_SUCCESS, SCP_ERROR, SCP_FAILED_TO_RESOLVE_HOST_NAME, SCP_PERMISSION_DENIED);
                    AbstractPanel.logger.fine(() -> LMG.log("%sSending 'co' command.", () -> loggerPrefix));
                    dpSSHClient.sendToDataPower("co\n");
                    String afterCOPrompt = dpSSHClient.waitForPrompt();
                    AbstractPanel.logger.finer(() -> LMG.log("%sReceived '%s' prompt after sending 'co'.", () -> loggerPrefix, () -> afterCOPrompt));
                    AbstractPanel.logger.finer(() -> LMG.log("%sGetting copy command for file: '%s'.", () -> loggerPrefix, () -> dpFileName));
                    String copyCommand = this.getCopyCommand(dpFileName);
                    AbstractPanel.logger.fine(() -> LMG.log("%sSending copy command.\n\t\t%s", () -> loggerPrefix, () -> copyCommand));
                    dpSSHClient.sendToDataPower(copyCommand);
                    String prompt = dpSSHClient.getPromptString();
                    String passwordOrPrompt = String.format("(Password:|%s|..%s|. %s)", prompt, FILE_COPY_FAILED, SCP_CANNOT_COPY_FILE);
                    AbstractPanel.logger.finer(() -> LMG.log("%sWaiting for prompt matching '%s'.", () -> loggerPrefix, () -> passwordOrPrompt));
                    dpPromptF = dpPrompt = dpSSHClient.waitFor(passwordOrPrompt);
                    AbstractPanel.logger.fine(() -> LMG.log("%sReceived Prompt '%s'.", () -> loggerPrefix, () -> dpPromptF));
                    if (!dpPrompt.contains(FILE_COPY_FAILED)) break block11;
                    AbstractPanel.logger.severe(() -> LMG.log("%s%s", () -> loggerPrefix, () -> dpPromptF));
                    this.showMessage("File copy failed", String.format("Error reading from source.  Check to be sure the DataPower appliance %s can access the host", appliance.getName()));
                    AbstractPanel.logger.info(() -> LMG.log("%sDisconnecting SSH.", () -> loggerPrefix));
                    dpSSHClient.disconnect();
                    return;
                }
                if (!dpPrompt.contains(SCP_CANNOT_COPY_FILE)) break block12;
                AbstractPanel.logger.severe(() -> LMG.log("%s%s", () -> loggerPrefix, () -> dpPromptF));
                this.showMessage("File copy failed", String.format("Cannot copy the file to the DataPower appliance %s from %s.", appliance.getName(), scpHost));
                AbstractPanel.logger.info(() -> LMG.log("%sDisconnecting SSH.", () -> loggerPrefix));
                dpSSHClient.disconnect();
                return;
            }
            try {
                try {
                    String exitPrompt;
                    if (dpPrompt.contains("Password:")) {
                        String scpServerHostPassword = this.tfSCPServerPassword.getText();
                        AbstractPanel.logger.fine(() -> LMG.log("%sSending password to SCP server '%s'.", () -> loggerPrefix, () -> scpHost));
                        dpSSHClient.sendToDataPower(scpServerHostPassword + "\n");
                        String dpPrompt1F = dpPrompt = dpSSHClient.waitFor(successOrFailure);
                        AbstractPanel.logger.finer(() -> LMG.log("%sReceived '%s' prompt after sending password.  Waiting for DP prompt.", () -> loggerPrefix, () -> dpPrompt1F));
                        String nextPrompt = dpSSHClient.waitForPrompt();
                        AbstractPanel.logger.finer(() -> LMG.log("%sReceived '%s' prompt.", () -> loggerPrefix, () -> nextPrompt));
                    }
                    AbstractPanel.logger.finer(() -> LMG.log("%sSending 'exit' to DataPower.", () -> loggerPrefix));
                    dpSSHClient.sendToDataPower("exit\n");
                    String exitPrompt1F = exitPrompt = dpSSHClient.waitForPrompt();
                    AbstractPanel.logger.finer(() -> LMG.log("%sRecieved '%s' prompt.  Sending 'exit' to DataPower.", () -> loggerPrefix, () -> exitPrompt1F));
                    dpSSHClient.sendToDataPower("exit\n");
                    String exitPrompt2F = exitPrompt = dpSSHClient.waitForPrompt();
                    AbstractPanel.logger.finer(() -> LMG.log("%sRecieved '%s' prompt.", () -> loggerPrefix, () -> exitPrompt2F));
                    if (dpPrompt.contains(SCP_FAILED_TO_RESOLVE_HOST_NAME)) {
                        AbstractPanel.logger.severe(() -> LMG.log("%sHost %s on port %d cannot be resolved.", () -> loggerPrefix, () -> scpHost, () -> scpPort));
                        this.showMessage("Host cannot be resolved", String.format("Check your SCP/SFTP Host and try again.  Also check to be sure the DataPower appliance %s can access the SCP/SFTP host on port %d", appliance.getName(), scpPort));
                        break block13;
                    }
                    if (dpPrompt.contains(SCP_PERMISSION_DENIED)) {
                        AbstractPanel.logger.severe(() -> LMG.log("%sHost %s on port %d cannot be resolved.", () -> loggerPrefix, () -> scpHost, () -> scpPort));
                        this.showMessage("Permission denied copying image file", String.format("Check your SCP/SFTP Host, user name and password and try again.  Also check to be sure the DataPower appliance %s can access the SCP host on port %d", appliance.getName(), scpPort));
                        break block13;
                    }
                    if (!dpPrompt.contains(SCP_ERROR)) break block13;
                    AbstractPanel.logger.severe(() -> LMG.log("%sError copying image file.", () -> loggerPrefix));
                    this.showMessage("Error copying image file", String.format("There was an error copying the image file %s.  Everything else seemed to work.  Is there a firewall blocking on the external file host?", fileName));
                }
                catch (IOException e) {
                    AbstractPanel.logger.severe(() -> LMG.log("%sError entering command mode:\n\t\t%s", () -> loggerPrefix, () -> e.getMessage()));
                    this.showMessage("Error Uploading File", "Error entering command mode\n" + e.getMessage());
                    e.printStackTrace();
                    AbstractPanel.logger.info(() -> LMG.log("%sDisconnecting SSH.", () -> loggerPrefix));
                    dpSSHClient.disconnect();
                }
            }
            catch (Throwable throwable) {
                AbstractPanel.logger.info(() -> LMG.log("%sDisconnecting SSH.", () -> loggerPrefix));
                dpSSHClient.disconnect();
                throw throwable;
            }
        }
        AbstractPanel.logger.info(() -> LMG.log("%sDisconnecting SSH.", () -> loggerPrefix));
        dpSSHClient.disconnect();
        AbstractPanel.logger.fine(loggerPrefix + "Done.");
    }

    private String getFileName() {
        AbstractPanel.logger.finer("(): Starting");
        String fileName = "";
        if (this.rbHTTPSource.isSelected()) {
            String URL2 = this.tfURL.getText();
            int lastSlash = URL2.lastIndexOf("/");
            fileName = URL2.substring(lastSlash + 1);
        } else {
            this.fileToUpload = this.fileSelectorComponent.getFileName();
            int lastSlash = this.fileToUpload.lastIndexOf(File.separatorChar);
            fileName = this.fileToUpload.substring(lastSlash);
        }
        String fileNameF = fileName;
        AbstractPanel.logger.finer(() -> LMG.log("(): Done.  Returning '%s'.", () -> fileNameF));
        return fileName;
    }

    private String getCopyCommand(String dpFileName) {
        String loggerPrefix = String.format("(dpFileName=%s)", dpFileName);
        AbstractPanel.logger.finer(() -> LMG.log("%s: Starting", () -> loggerPrefix));
        boolean overWrite = this.cbxOverwrite.isSelected();
        String overwriteFlag = overWrite ? "-f " : "";
        String xmlManager = this.cbxXMLManagers.getText();
        String copyCommand = null;
        copyCommand = this.rbHTTPSource.isSelected() ? this.getHTTPCopyCommand(dpFileName, overwriteFlag, xmlManager) : this.getSCPCopyCommand(dpFileName, overwriteFlag, xmlManager);
        String copyCommandF = copyCommand;
        AbstractPanel.logger.finer(() -> LMG.log("%s: Done. Returning copy command: '%s'", () -> loggerPrefix, () -> copyCommandF));
        return copyCommand;
    }

    private String getHTTPCopyCommand(String dpFileName, String overwriteFlag, String xmlManager) {
        String loggerPrefix = String.format("(dpFileName=%s, overwriteFlag=%s, xmlManager=%s)", dpFileName, overwriteFlag, xmlManager);
        AbstractPanel.logger.finer(() -> LMG.log("%s: Starting", () -> loggerPrefix));
        String URL2 = this.tfURL.getText();
        String copyCommand = String.format("copy %s%s %s %s\n", overwriteFlag, URL2, dpFileName, xmlManager);
        AbstractPanel.logger.finer(() -> LMG.log("%s: Done.  Returning copy command='%s'", () -> loggerPrefix, () -> copyCommand));
        return copyCommand;
    }

    private String getSCPCopyCommand(String dpFileName, String overwriteFlag, String xmlManager) {
        String loggerPrefix = String.format("(dpFileName=%s, overwriteFlag=%s, xmlManager=%s)", dpFileName, overwriteFlag, xmlManager);
        AbstractPanel.logger.finer(() -> LMG.log("%s: Starting", () -> loggerPrefix));
        String scpServerHostName = this.tfSCPServerHost.getText();
        int scpServerPort = (int)this.nfSCPPort.getNumber();
        String scpServerHostUserName = this.tfSCPServerUserName.getText();
        String FQFN = this.fileToUpload;
        String protocol = this.rbSCP.isSelected() ? "scp" : "sftp";
        String copyCommand = String.format("copy %s%s://%s@%s:%d/%s %s\n", overwriteFlag, protocol, scpServerHostUserName, scpServerHostName, scpServerPort, FQFN, dpFileName);
        AbstractPanel.logger.finer(() -> LMG.log("%s: Done.  Returning copy command='%s'", () -> loggerPrefix, () -> copyCommand));
        return copyCommand;
    }

    @Override
    @Reflected
    protected void invokeSystemAction() {
        AbstractPanel.logger.finer("(): Starting.");
        this.actionObject = null;
        if (!this.isUserInputValid()) {
            AbstractPanel.logger.finer("(): User input is invalid.  Returning.");
            return;
        }
        this.openResultsDialogAndSetWaitCursor(this.getCommandResultsDialogTitle());
        AbstractPanel.logger.finer("(): Invoking performAction for each appliance.");
        ApplianceDomainChangeMonitor.getInstance().invokeProcessByApplianceSelection(this, "performAction", true, this.shouldInvokeSystemActionSyncronously());
        this.waitForResultsDialogToCloseAndResetCursor();
        AbstractPanel.logger.finer("(): Done.");
    }

    @Override
    protected boolean isUserInputValid() {
        AbstractPanel.logger.finer("(): Starting");
        String selectedImageFile = this.cbxExistingDPImageFiles.getText();
        if (StringUtility.isEmpty(selectedImageFile)) {
            AbstractPanel.logger.info("(): Selected image file is blank.");
            this.showMessage("No Image File Selected", "Select or upload an image file before proceeding");
            AbstractPanel.logger.finer("(): Done.  Returning false.");
            return false;
        }
        AbstractPanel.logger.finer("(): Done.  Returning true.");
        return true;
    }

    @Override
    protected ActionApplyPatch setupActionObjectType() {
        AbstractPanel.logger.finer("(): Starting");
        ActionApplyPatch actionObject = new ActionApplyPatch();
        actionObject.setAcceptLicense("");
        String selectedImageFile = this.cbxExistingDPImageFiles.getText();
        AbstractPanel.logger.finer(() -> LMG.log("(): Selected Image File: '%s'", () -> this.cbxExistingDPImageFiles.getText()));
        if (selectedImageFile.startsWith("image:")) {
            int lastSlash = selectedImageFile.lastIndexOf(47);
            if (lastSlash == -1) {
                lastSlash = 5;
            }
            selectedImageFile = selectedImageFile.substring(lastSlash + 1);
        }
        String selectedImageFileF = selectedImageFile;
        AbstractPanel.logger.finer(() -> LMG.log("(): Image File for Action Object: '%s'", () -> selectedImageFileF));
        actionObject.setFile(selectedImageFile);
        AbstractPanel.logger.finer("(): Done.  Returning action object");
        return actionObject;
    }

    @Override
    protected boolean autoResetCursorToNormal() {
        return false;
    }

    @Override
    protected void performAction(Appliance appliance) {
        AbstractPanel.logger.finer(() -> LMG.log("(Appliance=%s): Starting.", () -> appliance.getName()));
        String imageFileName = this.cbxExistingDPImageFiles.getText();
        SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
        AbstractPanel.logger.finer(() -> LMG.log("(Appliance=%s): Creating Firmware upgrader.", () -> appliance.getName()));
        FirmwareUpgrader firmwareUpgrader = new FirmwareUpgrader(appliance, imageFileName);
        firmwareUpgrader.addManagementCommandSubscriber(this.commandResultsDialog);
        firmwareUpgrader.getProcessThread().addInvocationListener(stil);
        AbstractPanel.logger.finer(() -> LMG.log("(Appliance=%s): Waiting for Firmware upgrader to complete.", () -> appliance.getName()));
        stil.waitForCompletion();
        AbstractPanel.logger.finer(() -> LMG.log("(Appliance=%s): Done.", () -> appliance.getName()));
    }
}

