/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.function;

import java.io.Serializable;
import java.util.Arrays;
import org.jfree.chart.HashUtils;
import org.jfree.chart.util.Args;
import org.jfree.data.function.Function2D;

public class PolynomialFunction2D
implements Function2D,
Serializable {
    private double[] coefficients;

    public PolynomialFunction2D(double[] coefficients) {
        Args.nullNotPermitted(coefficients, "coefficients");
        this.coefficients = (double[])coefficients.clone();
    }

    public double[] getCoefficients() {
        return (double[])this.coefficients.clone();
    }

    public int getOrder() {
        return this.coefficients.length - 1;
    }

    @Override
    public double getValue(double x) {
        double y = 0.0;
        int i = 0;
        while (i < this.coefficients.length) {
            y += this.coefficients[i] * Math.pow(x, i);
            ++i;
        }
        return y;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PolynomialFunction2D)) {
            return false;
        }
        PolynomialFunction2D that = (PolynomialFunction2D)obj;
        return Arrays.equals(this.coefficients, that.coefficients);
    }

    public int hashCode() {
        return HashUtils.hashCodeForDoubleArray(this.coefficients);
    }
}

