/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.awt;

import com.jmorgan.awt.ShapeCreator;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;

public class ConnectorShapeCreator
implements ShapeCreator {
    private int pointedSide;

    public ConnectorShapeCreator() {
        this(3);
    }

    public ConnectorShapeCreator(int pointedSide) {
        this.setPointedSide(pointedSide);
    }

    public int getPointedSide() {
        return this.pointedSide;
    }

    public void setPointedSide(int pointedSide) {
        switch (pointedSide) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.pointedSide = pointedSide;
                break;
            }
            default: {
                this.pointedSide = 3;
            }
        }
    }

    @Override
    public Shape createShape(Rectangle bounds) {
        if (this.pointedSide == 1) {
            return ConnectorShapeCreator.createTopPointedShape(bounds);
        }
        if (this.pointedSide == 3) {
            return ConnectorShapeCreator.createBottomPointedShape(bounds);
        }
        if (this.pointedSide == 2) {
            return ConnectorShapeCreator.createLeftPointedShape(bounds);
        }
        return ConnectorShapeCreator.createRightPointedShape(bounds);
    }

    private static Shape createTopPointedShape(Rectangle bounds) {
        int halfHeight = bounds.height / 2;
        int halfWidth = bounds.width / 2;
        Polygon shape = new Polygon(new int[]{halfWidth, bounds.width - 1, bounds.width - 1, 1, 1}, new int[]{1, halfHeight, bounds.height - 1, bounds.height - 1, halfHeight}, 5);
        return shape;
    }

    private static Shape createBottomPointedShape(Rectangle bounds) {
        int halfHeight = bounds.height / 2;
        int halfWidth = bounds.width / 2;
        Polygon shape = new Polygon(new int[]{1, bounds.width - 1, bounds.width - 1, halfWidth, 1}, new int[]{1, 1, halfHeight, bounds.height - 1, halfHeight}, 5);
        return shape;
    }

    private static Shape createLeftPointedShape(Rectangle bounds) {
        int halfHeight = bounds.height / 2;
        int halfWidth = bounds.width / 2;
        Polygon shape = new Polygon(new int[]{1, halfWidth, bounds.width - 1, bounds.width - 1, halfWidth}, new int[]{halfHeight, 1, 1, bounds.height - 1, bounds.height - 1}, 5);
        return shape;
    }

    private static Shape createRightPointedShape(Rectangle bounds) {
        int halfHeight = bounds.height / 2;
        int halfWidth = bounds.width / 2;
        Polygon shape = new Polygon(new int[]{1, halfWidth, bounds.width - 1, halfWidth, 1}, new int[]{1, 1, halfHeight, bounds.height - 1, bounds.height - 1}, 5);
        return shape;
    }
}

