/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.beans.util;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.util.Index;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;

public class BeanIndexer<BT> {
    private Collection<BT> beanCollection;

    public BeanIndexer(Collection<BT> beanCollection) {
        this.setBeanCollection(beanCollection);
    }

    public BeanIndexer(BT[] beanArray) {
        this(Arrays.asList(beanArray));
    }

    public Collection<BT> getBeanCollection() {
        return this.beanCollection;
    }

    public void setBeanCollection(Collection<BT> beanCollection) {
        if (beanCollection == null) {
            throw new IllegalArgumentException("The value of the collection for BeanIndexer.setBeanCollection(Collection<BT> beanCollection) cannot be null.");
        }
        this.beanCollection = beanCollection;
    }

    public <PT> Index<PT, BT> getIndexOf(String propertyName, PT valueForNull) {
        Index<PT, BT> index = new Index<PT, BT>();
        for (BT bean : this.beanCollection) {
            if (bean == null) continue;
            Object value = BeanService.getPropertyValue(bean, propertyName);
            index.put(value == null ? valueForNull : value, bean);
        }
        return index;
    }

    public <PT> HashMap<PT, BT> getMapOf(String propertyName, PT valueForNull) {
        HashMap<PT, BT> map = new HashMap<PT, BT>();
        for (BT bean : this.beanCollection) {
            Object value = BeanService.getPropertyValue(bean, propertyName);
            map.put(value == null ? valueForNull : value, bean);
        }
        return map;
    }
}

