/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.beans.util;

import com.jmorgan.beans.util.BeanService;
import java.util.Map;
import java.util.Set;

public class BeanPropertyLoader {
    private Object bean;

    public BeanPropertyLoader() {
    }

    public BeanPropertyLoader(Object bean) {
        this();
        this.setBean(bean);
    }

    public BeanPropertyLoader(Object bean, String propertyName, Object value) {
        this(bean);
        this.setProperty(propertyName, value);
    }

    public BeanPropertyLoader(Object bean, Map<String, Object> properties) {
        this(bean);
        this.setProperties(properties);
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public void setProperties(Map<String, Object> properties) {
        if (properties == null || this.bean == null) {
            throw new IllegalStateException("BeanPropertyLoader.setProperties():  Neither bean nor properties can be null.");
        }
        if (properties.size() == 0) {
            return;
        }
        Set<String> keys = properties.keySet();
        for (String propName : keys) {
            this.setProperty(propName, properties.get(propName));
        }
    }

    public void setProperty(String propertyName, Object value) {
        if (this.bean == null) {
            throw new IllegalStateException("BeanPropertyLoader.setProperty(): The bean is null.");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("BeanPropertyLoader.setProperty():  The propertyName cannot be null.");
        }
        BeanService.setPropertyValue(this.bean, propertyName, value);
    }
}

