/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.beans.util;

import com.jmorgan.annotations.Bindable;
import com.jmorgan.beans.util.BeanPropertyLoader;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.UniqueArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class BeanPropertyMap<T> {
    @Bindable
    protected T bean;
    @Bindable
    protected Map<String, String> defaultPropertyNameMap;
    private ArrayList<String> propertyNames;
    private ArrayList<String> keyProcessingOrder;
    private boolean debug;

    protected BeanPropertyMap() {
    }

    public BeanPropertyMap(T bean) {
        this(bean, false);
    }

    public BeanPropertyMap(T bean, boolean debug) {
        this.setDebug(debug);
        this.setBean(bean);
    }

    public BeanPropertyMap(T bean, Map<String, String> defaultPropertyNameMap) {
        this(bean, defaultPropertyNameMap, false);
    }

    public BeanPropertyMap(T bean, Map<String, String> defaultPropertyNameMap, boolean debug) {
        this(bean, debug);
        this.setDefaultPropertyNameMap(defaultPropertyNameMap);
    }

    public T getBean() {
        return this.bean;
    }

    public void setBean(T bean) throws NullPointerException {
        if (this.propertyNames != null) {
            this.propertyNames.clear();
        }
        this.propertyNames = null;
        if (bean == null) {
            throw new NullPointerException("The value of the given bean cannot be null.");
        }
        this.bean = bean;
        this.propertyNames = BeanService.getMutablePropertyNames(this.bean);
    }

    public Map<String, String> getDefaultPropertyNameMap() {
        return this.defaultPropertyNameMap;
    }

    public void setDefaultPropertyNameMap(Map<String, String> defaultPropertyNameMap) {
        this.defaultPropertyNameMap = defaultPropertyNameMap;
    }

    public ArrayList<String> getKeyProcessingOrder() {
        return this.keyProcessingOrder;
    }

    public void setKeyProcessingOrder(ArrayList<String> keyProcessingOrder) {
        this.keyProcessingOrder = keyProcessingOrder;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void loadBean() {
        Map<String, Object> sourceMap = this.getMap();
        HashMap<String, Object> map = new HashMap<String, Object>();
        Set<String> keys = sourceMap.keySet();
        UniqueArrayList<String> allKeysInOrder = new UniqueArrayList<String>(keys.size());
        this.keyProcessingOrder = this.getKeyProcessingOrder();
        if (CollectionUtility.isNotEmpty(this.keyProcessingOrder)) {
            allKeysInOrder.addAll(this.keyProcessingOrder);
        }
        allKeysInOrder.addAll(keys);
        for (String key : allKeysInOrder) {
            if (this.debug) {
                System.out.println("BeanPropertyMap.loadBean(): " + (this.allowMap(key) ? "Mapping " : "Not Mapping ") + key);
            }
            if (!this.allowMap(key)) continue;
            Object sourceValue = sourceMap.get(key);
            if (this.debug) {
                System.out.println("BeanPropertyMap.loadBean(): Source Key=Value: " + key + "=" + String.valueOf(sourceValue));
            }
            String propertyName = this.getPropertyNameFor(key);
            Object propertyValue = this.getValueFor(key, sourceValue);
            if (this.debug) {
                System.out.println("BeanPropertyMap.loadBean(): Actual Property=Value: " + propertyName + "=" + String.valueOf(propertyValue));
            }
            map.put(propertyName, propertyValue);
        }
        new BeanPropertyLoader(this.bean, map);
    }

    public abstract Map<String, Object> getMap();

    public boolean allowMap(String sourceProperty) {
        boolean allow = false;
        if (this.defaultPropertyNameMap != null && this.defaultPropertyNameMap.size() > 0) {
            allow = this.defaultPropertyNameMap.containsKey(sourceProperty);
        } else {
            for (String propertyName : this.propertyNames) {
                if (!sourceProperty.equalsIgnoreCase(propertyName)) continue;
                allow = true;
                break;
            }
        }
        if (this.debug) {
            System.out.printf("BeanPropertyMap.allowMap(sourceProperty=%s): %b\n", sourceProperty, allow);
        }
        return allow;
    }

    public String getPropertyNameFor(String sourceProperty) {
        if (this.debug) {
            System.out.printf("BeanPropertyMap.getPropertyNameFor(sourceProperty=%s)\n", sourceProperty);
        }
        if (this.defaultPropertyNameMap != null && this.defaultPropertyNameMap.size() > 0) {
            for (String key : this.defaultPropertyNameMap.keySet()) {
                if (!key.equals(sourceProperty)) continue;
                return this.defaultPropertyNameMap.get(key);
            }
        }
        return sourceProperty;
    }

    public Object getValueFor(String property, Object value) {
        return value;
    }
}

