/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.beans.util;

import com.jmorgan.beans.PropertyNotFoundException;
import com.jmorgan.beans.util.DataTypeConverter;
import com.jmorgan.beans.util.StringToBooleanConverter;
import com.jmorgan.beans.util.StringToCalendarConverter;
import com.jmorgan.beans.util.StringToDateConverter;
import com.jmorgan.beans.util.StringToDateTimeConverter;
import com.jmorgan.beans.util.StringToDoubleConverter;
import com.jmorgan.beans.util.StringToFloatConverter;
import com.jmorgan.beans.util.StringToIntegerConverter;
import com.jmorgan.beans.util.StringToLongConverter;
import com.jmorgan.beans.util.StringToTimeConverter;
import com.jmorgan.beans.util.StringToTimestampConverter;
import com.jmorgan.beans.util.StringToUtilDateConverter;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.lang.Types;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.DynamicClassLoader;
import com.jmorgan.util.Pair;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.Time;
import com.jmorgan.util.collection.UniqueArrayList;
import com.jmorgan.util.comparator.AnyObjectComparator;
import com.jmorgan.util.logging.LMG;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;

public final class BeanService {
    public static int HASHCODE_PRIME = 31;
    private static ArrayList<String> entityExemptProperties = new ArrayList();
    private static HashMap<Class<?>, HashSet<String>> classSpecificExemptProperties;
    private static HashMap<Class<?>, DataTypeConverter<?, ?>> coercionMap;

    static {
        entityExemptProperties.add("wait");
        entityExemptProperties.add("notify");
        entityExemptProperties.add("notifyAll");
        entityExemptProperties.add("clone");
        entityExemptProperties.add("compareTo");
        entityExemptProperties.add("toString");
        entityExemptProperties.add("equals");
        entityExemptProperties.add("hashCode");
        entityExemptProperties.add("getHashCode");
        entityExemptProperties.add("getClass");
        entityExemptProperties.add("getPropertyChangeSupport");
        entityExemptProperties.add("getToStringDelimiter");
        classSpecificExemptProperties = new HashMap();
        BeanService.addClassSpecificExemptProperties(File.class, "createNewFile", "delete", "deleteOnExit", "mkdir", "mkdirs", "renameTo");
        coercionMap = new HashMap();
        coercionMap.put(Boolean.class, new StringToBooleanConverter());
        coercionMap.put(Integer.class, new StringToIntegerConverter());
        coercionMap.put(Long.class, new StringToLongConverter());
        coercionMap.put(Float.class, new StringToFloatConverter());
        coercionMap.put(Double.class, new StringToDoubleConverter());
        coercionMap.put(Date.class, new StringToUtilDateConverter());
        coercionMap.put(Calendar.class, new StringToCalendarConverter());
        coercionMap.put(Timestamp.class, new StringToTimestampConverter());
        coercionMap.put(com.jmorgan.util.Date.class, new StringToDateConverter());
        coercionMap.put(Time.class, new StringToTimeConverter());
        coercionMap.put(DateTime.class, new StringToDateTimeConverter());
    }

    private BeanService() {
    }

    public static Object getBean(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        return BeanService.getBean(DynamicClassLoader.loadClass(className));
    }

    public static <CT> CT getBean(Class<CT> type) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Constructor<?>[] constructors;
        Constructor<?>[] constructorArray = constructors = type.getDeclaredConstructors();
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> constructor = constructorArray[n2];
            if (constructor.getParameterCount() == 0) {
                return (CT)constructor.newInstance(null);
            }
            ++n2;
        }
        return type.newInstance();
    }

    public static Object getBean(String className, Object ... parameters) throws ClassNotFoundException, IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        return BeanService.getBean(DynamicClassLoader.loadClass(className), parameters);
    }

    public static <CT> CT getBean(Class<CT> type, Object ... parameters) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?> constructor = BeanService.findConstructor(type, parameters);
        constructor.setAccessible(true);
        Class<?>[] parmTypes = constructor.getParameterTypes();
        int i = 0;
        while (i < parmTypes.length) {
            if (parmTypes[i].isPrimitive() && parameters[i] == null) {
                parameters[i] = Types.getDefaultPrimitiveValue(parmTypes[i]);
            }
            ++i;
        }
        Object newInstance = constructor.newInstance(parameters);
        return (CT)newInstance;
    }

    private static Constructor<?> findConstructor(Class<?> type, Object ... arguments) {
        Constructor<?> constructor = null;
        int maxWeight = 0;
        Constructor<?>[] constructors = type.getDeclaredConstructors();
        int i = 0;
        while (i < constructors.length) {
            block15: {
                Class<?>[] parmTypes = constructors[i].getParameterTypes();
                if (parmTypes.length == arguments.length) {
                    int weight = 0;
                    int j = 0;
                    while (j < arguments.length) {
                        if (arguments[j] == null) {
                            weight += 10;
                        } else {
                            Class<?> argClass = arguments[j].getClass();
                            if (parmTypes[j].equals(argClass)) {
                                weight += 10;
                            } else if (parmTypes[j].isAssignableFrom(argClass)) {
                                weight += 5;
                            } else if (parmTypes[j].isPrimitive() && Types.isPrimitiveWrapper(argClass)) {
                                int w = Types.getPrimitiveMatchWeight(parmTypes[j], argClass);
                                if (w == 0) break block15;
                                weight += w;
                            } else if (argClass.isInterface() && BeanService.isInterfaceCompatible(parmTypes[j], argClass)) {
                                weight += 10;
                            } else {
                                if (!parmTypes[j].isInterface() || !BeanService.isInterfaceCompatible(argClass, parmTypes[j])) break block15;
                                weight += 10;
                            }
                        }
                        ++j;
                    }
                    if (weight > maxWeight) {
                        maxWeight = weight;
                        constructor = constructors[i];
                    }
                }
            }
            ++i;
        }
        return constructor;
    }

    private static boolean isInterfaceCompatible(Class<?> type, Class<?> interfaceType) {
        Class<?>[] classInterfaces = type.getInterfaces();
        if (classInterfaces.length == 0) {
            if (type.equals(Object.class)) {
                return false;
            }
            Class<?> ancestor = type.getSuperclass();
            return BeanService.isInterfaceCompatible(ancestor, interfaceType);
        }
        int i = 0;
        while (i < classInterfaces.length) {
            if (interfaceType.equals(classInterfaces[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Field getField(Class<?> type, String fieldName) {
        HashMap<String, Field> fieldMap = BeanService.getFieldMap(type);
        Field field = fieldMap.get(fieldName);
        return field;
    }

    public static HashMap<String, Field> getFieldMap(Class<?> type) {
        Field[] fields;
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        Field[] fieldArray = fields = type.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            fieldMap.put(field.getName(), field);
            ++n2;
        }
        return fieldMap;
    }

    public static HashMap<String, Field> getFieldMap(Class<?> type, int modifiers) {
        Field[] fields;
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        Field[] fieldArray = fields = type.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int fieldModifiers = field.getModifiers();
            if ((modifiers & fieldModifiers) == modifiers) {
                fieldMap.put(field.getName(), field);
            }
            ++n2;
        }
        return fieldMap;
    }

    public static HashMap<String, Field> getFieldMap(Class<?> type, Class<? extends Annotation> annotationType) {
        Field[] fields;
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        Field[] fieldArray = fields = type.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.isAnnotationPresent(annotationType)) {
                fieldMap.put(field.getName(), field);
            }
            ++n2;
        }
        return fieldMap;
    }

    public static ArrayList<String> getDeclaredPropertyNames(Class<?> type) {
        Field[] fields = type.getDeclaredFields();
        UniqueArrayList<String> propertyNames = new UniqueArrayList<String>();
        Field[] fieldArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            propertyNames.add(field.getName());
            ++n2;
        }
        return propertyNames;
    }

    public static ArrayList<String> getPropertyNames(Class<?> type) {
        Field[] fields = type.getFields();
        Method[] accessors = BeanService.getBeanAccessors(type);
        UniqueArrayList<String> propertyNames = new UniqueArrayList<String>();
        AccessibleObject[] accessibleObjectArray = fields;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = accessibleObjectArray[n2];
            propertyNames.add(field.getName());
            ++n2;
        }
        accessibleObjectArray = accessors;
        n = accessors.length;
        n2 = 0;
        while (n2 < n) {
            AccessibleObject method = accessibleObjectArray[n2];
            Object methodName = ((Method)method).getName();
            if (!((String)methodName).startsWith("set") && !entityExemptProperties.contains(methodName)) {
                if (((String)methodName).startsWith("get")) {
                    methodName = ((String)methodName).substring(3);
                    methodName = ((String)methodName).toLowerCase().charAt(0) + ((String)methodName).substring(1);
                } else if (((String)methodName).startsWith("is")) {
                    methodName = ((String)methodName).substring(2);
                    methodName = ((String)methodName).toLowerCase().charAt(0) + ((String)methodName).substring(1);
                }
                propertyNames.add((String)methodName);
            }
            ++n2;
        }
        return propertyNames;
    }

    public static ArrayList<String> getPropertyNames(Object bean) {
        return BeanService.getPropertyNames(bean.getClass());
    }

    public static ArrayList<String> getMutablePropertyNames(Class<?> type) {
        Method[] mutators = BeanService.getBeanMutators(type);
        UniqueArrayList<String> propertyNames = new UniqueArrayList<String>();
        Method[] methodArray = mutators;
        int n = mutators.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Object methodName = method.getName();
            if (((String)methodName).startsWith("set")) {
                methodName = ((String)methodName).substring(3);
                methodName = ((String)methodName).toLowerCase().charAt(0) + ((String)methodName).substring(1);
            }
            propertyNames.add((String)methodName);
            ++n2;
        }
        return propertyNames;
    }

    public static ArrayList<String> getMutablePropertyNames(Object bean) {
        return BeanService.getMutablePropertyNames(bean.getClass());
    }

    public static boolean hasProperty(Class<?> type, String propertyName) {
        ArrayList<String> propertyNames = BeanService.getPropertyNames(type);
        return propertyNames.contains(propertyName);
    }

    public static boolean hasProperty(Object source, String expression) throws NullPointerException {
        if (source == null) {
            throw new NullPointerException("BeanService.hasProperty(source, expression):  Source cannot be null");
        }
        if (expression == null) {
            throw new NullPointerException("BeanService.hasProperty(source, expression):  Expression cannot be null");
        }
        try {
            BeanService.getPropertyValue(source, expression);
        }
        catch (RuntimeException e) {
            return false;
        }
        return true;
    }

    public static Class<?> getPropertyType(Object source, String expression) throws NullPointerException, PropertyNotFoundException {
        if (source == null) {
            throw new NullPointerException("BeanService.getPropertyType(source, expression):  Source cannot be null");
        }
        if (expression == null) {
            throw new NullPointerException("BeanService.getPropertyType(source, expression):  Expression cannot be null");
        }
        Object expressionValue = BeanService.getPropertyValue(source, expression);
        if (expressionValue == null) {
            Method method = BeanService.resolveAccessorMethod(source, expression);
            if (method == null) {
                return null;
            }
            return method.getReturnType();
        }
        return expressionValue.getClass();
    }

    public static Class<?> getPropertyType(Class<?> type, String propertyName) {
        if (type == null) {
            throw new NullPointerException("BeanService.getPropertyType(type, propertyname):  Type cannot be null");
        }
        if (propertyName == null) {
            throw new NullPointerException("BeanService.getPropertyType(type, propertyname):  PropertyName cannot be null");
        }
        try {
            Field field = type.getField(propertyName);
            return field.getType();
        }
        catch (NoSuchFieldException field) {
            Method method = BeanService.getAccessorFor(type, propertyName);
            if (method == null) {
                return null;
            }
            return method.getReturnType();
        }
    }

    public static final <AnnotationType> AnnotationType getClassAnnotation(Class<?> type, Class<? extends Annotation> annotationClass) {
        if (type == null) {
            throw new IllegalStateException("BeanService.getClassAnnocation(type, annotationClass):  type cannot be null");
        }
        if (annotationClass == null) {
            throw new IllegalStateException("BeanService.getMethodAnnocation(method, annotationClass):  annotationClass cannot be null");
        }
        if (type.isAnnotationPresent(annotationClass)) {
            Annotation annotationType = type.getAnnotation(annotationClass);
            return (AnnotationType)annotationType;
        }
        return null;
    }

    public static final <AnnotationType> AnnotationType getMethodAnnotation(Method method, Class<? extends Annotation> annotationClass) throws PropertyNotFoundException {
        if (method == null) {
            throw new IllegalStateException("BeanService.getMethodAnnocation(method, annotationClass):  method cannot be null");
        }
        if (annotationClass == null) {
            throw new IllegalStateException("BeanService.getMethodAnnocation(method, annotationClass):  annotationClass cannot be null");
        }
        if (method.isAnnotationPresent(annotationClass)) {
            Annotation annotationType = method.getAnnotation(annotationClass);
            return (AnnotationType)annotationType;
        }
        return null;
    }

    public static final <AnnotationType> AnnotationType getMethodAnnotation(Class<?> objectClass, String methodName, Class<? extends Annotation> annotationClass) throws PropertyNotFoundException {
        ArrayList<Method> methods = BeanService.getMethods(objectClass);
        for (Method method : methods) {
            if (!method.getName().equals(methodName)) continue;
            return BeanService.getMethodAnnotation(method, annotationClass);
        }
        throw new PropertyNotFoundException(methodName);
    }

    private static final Method resolveAccessorMethod(Object source, String propertyName) {
        if (propertyName.contains(".")) {
            int dotPos = propertyName.indexOf(46);
            String prefix = propertyName.substring(0, dotPos);
            Method method = BeanService.resolveAccessorMethod(source, prefix);
            if (method == null) {
                return null;
            }
            Class<?> returnType = method.getReturnType();
            return BeanService.getAccessorFor(returnType, propertyName.substring(dotPos + 1));
        }
        String[] methodNames = BeanService.getAccessorMethodCandidateNames(propertyName);
        Method[] methods = BeanService.getBeanAccessors(source);
        return BeanService.getMatchingMethod(Arrays.asList(methods), methodNames);
    }

    private static Method getAccessorFor(Class<?> type, String propertyName) {
        if (propertyName.contains(".")) {
            int dotPos = propertyName.indexOf(46);
            Method accessor = BeanService.getAccessorFor(type, propertyName.substring(0, dotPos));
            Class<?> returnType = accessor.getReturnType();
            return BeanService.getAccessorFor(returnType, propertyName.substring(dotPos + 1));
        }
        ArrayList<Method> allMethods = BeanService.getMethods(type);
        String[] accessorCandidates = BeanService.getAccessorMethodCandidateNames(propertyName);
        Method matchingMethod = BeanService.getMatchingMethod(allMethods, accessorCandidates);
        return matchingMethod;
    }

    private static Method getMatchingMethod(List<Method> methods, String[] methodNames) {
        String[] stringArray = methodNames;
        int n = methodNames.length;
        int n2 = 0;
        while (n2 < n) {
            String methodName = stringArray[n2];
            for (Method method : methods) {
                if (!methodName.equalsIgnoreCase(method.getName())) continue;
                return method;
            }
            ++n2;
        }
        return null;
    }

    private static ArrayList<Method> getMethods(Class<?> type) {
        if (type == null) {
            return null;
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        Method[] m = type.getDeclaredMethods();
        methods.addAll(Arrays.asList(m));
        Class<?> superType = type.getSuperclass();
        if (superType != null) {
            methods.addAll(BeanService.getMethods(superType));
        }
        return methods;
    }

    public static final <T> T getPropertyValue(Object source, String expression) throws NullPointerException, PropertyNotFoundException {
        Field[] fields;
        Field[] fieldArray;
        if (source == null) {
            throw new NullPointerException("BeanService.getPropertyValue(source, expression):  Source cannot be null");
        }
        if (expression == null) {
            throw new NullPointerException("BeanService.getPropertyValue(source, expression):  Expression cannot be null");
        }
        if (BeanService.isExpression(expression)) {
            return (T)BeanService.processExpression(source, expression);
        }
        int dotPos = expression.indexOf(46);
        if (dotPos >= 0) {
            String leftProperty = expression.substring(0, dotPos);
            T value = BeanService.getPropertyValue(source, leftProperty);
            if (value == null) {
                return null;
            }
            expression = expression.substring(dotPos + 1);
            return BeanService.getPropertyValue(value, expression);
        }
        Object[] parsedExpression = BeanService.parseIndexExpression(expression);
        expression = (String)parsedExpression[0];
        if (source instanceof Class) {
            Class type = (Class)source;
            fieldArray = type.getFields();
        } else {
            fieldArray = source.getClass().getFields();
        }
        Field[] fieldArray2 = fields = fieldArray;
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            if (field.getName().equals(expression)) {
                try {
                    return (T)field.get(source);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        Object propertyValue = BeanService.invokeMethod(source, expression);
        if (propertyValue != null && parsedExpression.length > 1) {
            Object[] array = null;
            List list = null;
            String string = null;
            int type = -1;
            if (propertyValue.getClass().isArray()) {
                type = 0;
                array = propertyValue;
            } else if (propertyValue instanceof List) {
                type = 1;
                list = (List)propertyValue;
            } else if (propertyValue instanceof String || propertyValue instanceof StringBuffer || propertyValue instanceof StringBuilder) {
                type = 2;
                string = propertyValue.toString();
            }
            ArrayList<Object> returnValues = new ArrayList<Object>();
            int i = 1;
            while (i < parsedExpression.length) {
                Object object = parsedExpression[i];
                if (object instanceof Integer) {
                    Integer index = (Integer)object;
                    switch (type) {
                        case 0: {
                            returnValues.add(array[index]);
                            break;
                        }
                        case 1: {
                            returnValues.add(list.get(index));
                            break;
                        }
                        case 2: {
                            returnValues.add(Character.valueOf(string.charAt(index)));
                        }
                    }
                }
                if (parsedExpression[i] instanceof Pair) {
                    Pair range = (Pair)parsedExpression[i];
                    int beginIndex = (Integer)range.first;
                    int endIndex = (Integer)range.second;
                    int m = beginIndex;
                    while (m <= endIndex) {
                        switch (type) {
                            case 0: {
                                returnValues.add(array[m]);
                                break;
                            }
                            case 1: {
                                returnValues.add(list.get(i));
                                break;
                            }
                            case 2: {
                                returnValues.add(Character.valueOf(string.charAt(i)));
                            }
                        }
                        ++m;
                    }
                }
                ++i;
            }
            switch (returnValues.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    propertyValue = returnValues.get(0);
                    break;
                }
                default: {
                    propertyValue = returnValues.toArray();
                }
            }
        }
        return (T)propertyValue;
    }

    private static boolean isExpression(String expression) {
        boolean hasOperator = false;
        boolean inQuotes = false;
        boolean inBrackets = false;
        char[] cArray = expression.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            switch (ch) {
                case '\'': {
                    if (!inQuotes) {
                        hasOperator = true;
                    }
                    inQuotes = !inQuotes;
                    break;
                }
                case '[': {
                    if (inQuotes) break;
                    inBrackets = true;
                    break;
                }
                case ']': {
                    if (inQuotes) break;
                    inBrackets = false;
                    break;
                }
                case '%': 
                case '*': 
                case '+': 
                case '-': 
                case '/': 
                case '^': {
                    if (inQuotes || inBrackets) break;
                    hasOperator = true;
                }
            }
            if (hasOperator) break;
            ++n2;
        }
        return hasOperator;
    }

    private static Object[] parseIndexExpression(String expression) {
        int leftBracket = expression.indexOf(91);
        if (leftBracket == -1) {
            return new Object[]{expression};
        }
        ArrayList<String> indexValues = new ArrayList<String>();
        if (leftBracket >= 0) {
            int rightBracket = expression.indexOf(93);
            String nameExpression = StringUtility.getLeftSubstring(expression, leftBracket);
            String indexExpression = expression.substring(leftBracket + 1, rightBracket).trim();
            int commaPos = indexExpression.indexOf(44);
            if (commaPos >= 0) {
                String[] indexValueList;
                String[] stringArray = indexValueList = indexExpression.split(",");
                int n = indexValueList.length;
                int n2 = 0;
                while (n2 < n) {
                    String indexValue = stringArray[n2];
                    indexValues.add(indexValue.trim());
                    ++n2;
                }
            } else {
                indexValues.add(indexExpression);
            }
            expression = nameExpression;
        }
        Object[] returnValue = new Object[indexValues.size() + 1];
        returnValue[0] = expression;
        int i = 1;
        for (String indexValue : indexValues) {
            int dashPos = indexValue.indexOf(45);
            if (dashPos >= 0) {
                String[] indexRangeList = indexValue.split("-");
                int beginRange = Integer.parseInt(indexRangeList[0].trim());
                int endRange = Integer.parseInt(indexRangeList[1].trim());
                Pair<Integer, Integer> rangeList = new Pair<Integer, Integer>(beginRange, endRange);
                returnValue[i++] = rangeList;
                continue;
            }
            int index = Integer.parseInt(indexValue.trim());
            returnValue[i++] = index;
        }
        return returnValue;
    }

    /*
     * Unable to fully structure code
     */
    private static final Object processExpression(Object source, String expression) {
        operators = new String[]{"+", "-", "*", "/", "%", "^"};
        lValue = null;
        rValue = null;
        operatorIndex = 0;
        tokens = new ArrayList<String>();
        exprChars = expression.toCharArray();
        sb = new StringBuilder();
        inQuotes = false;
        inBrackets = false;
        ops = "+-*/%^".toCharArray();
        var15_12 = exprChars;
        var14_13 = exprChars.length;
        var13_14 = 0;
        while (var13_14 < var14_13) {
            c = var15_12[var13_14];
            if (c == '[') {
                sb.append(c);
                inBrackets = true;
            } else if (c == ']') {
                sb.append(c);
                inBrackets = false;
            } else if (c == '\'') {
                sb.append(c);
                if (inQuotes && sb.length() > 0) {
                    tokens.add(sb.toString());
                    sb.setLength(0);
                }
                inQuotes = inQuotes == false;
            } else if (c == ' ' && !inQuotes) {
                if (sb.length() > 0) {
                    tokens.add(sb.toString());
                    sb.setLength(0);
                }
            } else if (Comparison.isIn(c, ops) && !inQuotes && !inBrackets) {
                if (sb.length() > 0) {
                    tokens.add(sb.toString());
                    sb.setLength(0);
                }
                sb.append(c);
                tokens.add(sb.toString());
                sb.setLength(0);
            } else {
                sb.append(c);
            }
            ++var13_14;
        }
        if (sb.length() > 0) {
            tokens.add(sb.toString());
        }
        for (String token : tokens) {
            tokenIndex = ArrayUtility.indexOf(token, operators);
            switch (tokenIndex) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    operatorIndex = tokenIndex;
                    break;
                }
                default: {
                    if (token.contains("'")) {
                        token = token.replaceAll("'", "");
                        if (lValue == null) {
                            lValue = token;
                            break;
                        }
                        rValue = token;
                        break;
                    }
                    propertyValue = BeanService.getPropertyValue(source, token);
                    if (lValue == null) {
                        lValue = propertyValue;
                        break;
                    }
                    rValue = propertyValue;
                }
            }
            if (rValue == null) continue;
            if (!(lValue instanceof Number)) ** GOTO lbl-1000
            ld = (Number)lValue;
            if (rValue instanceof Number) {
                rd = (Number)rValue;
                ldValue = ld.doubleValue();
                rdValue = rd.doubleValue();
                switch (operatorIndex) {
                    case 0: {
                        ldValue += rdValue;
                        break;
                    }
                    case 1: {
                        ldValue -= rdValue;
                        break;
                    }
                    case 2: {
                        ldValue *= rdValue;
                        break;
                    }
                    case 3: {
                        ldValue /= rdValue;
                        break;
                    }
                    case 4: {
                        ldValue %= rdValue;
                        break;
                    }
                    case 5: {
                        ldValue = Math.pow(ldValue, rdValue);
                    }
                }
                lValue = ldValue;
            } else lbl-1000:
            // 2 sources

            {
                lsValue = lValue.toString();
                rsValue = rValue.toString();
                lValue = lsValue + rsValue;
            }
            rValue = null;
        }
        return lValue;
    }

    public static final void setPropertyValue(Object target, String property, Object value) {
        block11: {
            int dotPos;
            String message;
            if (target == null || property == null) {
                return;
            }
            Object newValue = BeanService.coerceToExpectedType(target, property, value);
            if (target instanceof Class) {
                Class classTarget = (Class)target;
                Field field = BeanService.getField(classTarget, property);
                try {
                    field.set(classTarget, newValue);
                    return;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    message = String.format("BeanService.setPropertyValue(target=%s, property=%s, value=%s) Failed setting class variable directly because of '%s'.  Will try via method inspection.", target.getClass().getName(), property, value, e.getClass().getName());
                    LMG.log(Level.INFO, message);
                }
            }
            if ((dotPos = property.lastIndexOf(46)) == -1) {
                block10: {
                    try {
                        String setMethodName = BeanService.getSetMethodName(property);
                        new MethodInvoker(target, setMethodName, newValue).invoke();
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() == null) {
                            message = String.format("BeanService.setPropertyValue(target=%s, property=%s, value=%s) Failed setting via standard setter.", target.getClass().getName(), property, value);
                            LMG.log(Level.INFO, message);
                        }
                        if (!e.getCause().getClass().equals(NoSuchMethodException.class)) break block10;
                        new MethodInvoker(target, property, newValue).invoke();
                    }
                }
                return;
            }
            String propertyToSet = property.substring(dotPos + 1);
            String targetNesting = property.substring(0, dotPos);
            Object actualTarget = BeanService.getPropertyValue(target, targetNesting);
            try {
                new MethodInvoker(actualTarget, BeanService.getSetMethodName(propertyToSet), newValue).invoke();
            }
            catch (RuntimeException e) {
                if (!e.getCause().getClass().equals(NoSuchMethodException.class)) break block11;
                new MethodInvoker(actualTarget, propertyToSet, newValue).invoke();
            }
        }
    }

    public static final <SourceType, TargetType> void addCoercionMap(Class<TargetType> targetType, DataTypeConverter<SourceType, TargetType> converter) {
        if (targetType == null || converter == null) {
            return;
        }
        coercionMap.put(targetType, converter);
    }

    public static final <TargetType> void removeCoercionMap(Class<TargetType> targetType) {
        if (targetType == null) {
            return;
        }
        coercionMap.remove(targetType);
    }

    private static final Object coerceToExpectedType(Object target, String property, Object value) {
        if (value == null) {
            return value;
        }
        Class<?> propertyType = null;
        try {
            propertyType = BeanService.getPropertyType(target, property);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            // empty catch block
        }
        if (propertyType == null) {
            return value;
        }
        if (propertyType.equals(value.getClass())) {
            return value;
        }
        if (value instanceof String || value instanceof StringBuilder || value instanceof StringBuffer) {
            String valueToCoerce = value.toString();
            for (Class<?> type : coercionMap.keySet()) {
                if (!propertyType.equals(type)) continue;
                DataTypeConverter<?, ?> dtc = coercionMap.get(type);
                return dtc.convert(valueToCoerce);
            }
        }
        if (propertyType.isInstance(String.class)) {
            if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                return b.toString();
            }
            if (value instanceof Number) {
                Number n = (Number)value;
                return n.toString();
            }
        }
        return value;
    }

    public static final Method[] getBeanAccessors(Class<?> type) {
        Method[] methods;
        ArrayList<Method> beanAccessors = new ArrayList<Method>();
        Method[] methodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (!method.getName().startsWith("set") && method.getParameterTypes().length == 0 && !method.getReturnType().getName().equals("void")) {
                beanAccessors.add(method);
            }
            ++n2;
        }
        return beanAccessors.toArray(new Method[beanAccessors.size()]);
    }

    public static final Method[] getBeanAccessors(Object bean) {
        return BeanService.getBeanAccessors(bean.getClass());
    }

    public static final Method getPropertyAccessor(Class<?> type, String propertyName) {
        Method[] methods;
        Method[] methodArray = methods = BeanService.getBeanAccessors(type);
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String methodName = method.getName();
            if (methodName.equals(BeanService.getGetMethodName(propertyName)) || methodName.equals(BeanService.getIsMethodName(propertyName)) || methodName.equals(propertyName)) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    public static final Method getPropertyAccessor(Object bean, String propertyName) {
        return BeanService.getPropertyAccessor(bean.getClass(), propertyName);
    }

    public static final Method[] getBeanMutators(Class<?> type) {
        Method[] methods;
        ArrayList<Method> beanMutators = new ArrayList<Method>();
        Method[] methodArray = methods = type.getMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().startsWith("set") && method.getParameterTypes().length > 0) {
                beanMutators.add(method);
            }
            ++n2;
        }
        return beanMutators.toArray(new Method[beanMutators.size()]);
    }

    public static final Method[] getBeanMutators(Object bean) {
        return BeanService.getBeanMutators(bean.getClass());
    }

    public static final <BeanType> BeanType getClone(BeanType bean) {
        if (bean == null) {
            throw new NullPointerException("BeanService.getClone(bean):  bean cannot be null");
        }
        try {
            Object clone;
            MethodInvoker cloneInvoker;
            if (bean instanceof Cloneable && (cloneInvoker = new MethodInvoker(bean, "clone", new Object[0])).hasMethod() && (clone = cloneInvoker.invoke()) != null) {
                return (BeanType)clone;
            }
            Object clone2 = BeanService.getBean(bean.getClass());
            BeanService.copyTo(bean, clone2);
            return (BeanType)clone2;
        }
        catch (Exception e) {
            System.err.printf("BeanService.getClone(bean=%s): Error obtaining clone from source.\n", bean.getClass().getName());
            e.printStackTrace();
            return null;
        }
    }

    public static final void copyTo(Object source, Object target) {
        BeanService.copyTo(source, target, null);
    }

    public static final void copyTo(Object source, Object target, HashMap<String, String> propertyNameMap) {
        if (source == null || target == null) {
            throw new NullPointerException("BeanService.copyTo(Object source, Object target, HashMap<String, String> propertyNameMap):  Neither source nor target can be null.");
        }
        ArrayList<String> sourceProperties = BeanService.getPropertyNames(source);
        for (String sourceProperty : sourceProperties) {
            String tp;
            Object propertyValue = BeanService.getPropertyValue(source, sourceProperty);
            String targetProperty = sourceProperty;
            if (propertyNameMap != null && (tp = propertyNameMap.get(sourceProperty)) != null) {
                targetProperty = tp;
            }
            if (!BeanService.hasProperty(target, targetProperty)) continue;
            try {
                BeanService.setPropertyValue(target, targetProperty, propertyValue);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static final int compareTo(Object thisBean, Object thatBean) {
        return BeanService.compareTo(thisBean, thatBean, null);
    }

    public static final void addClassSpecificExemptProperties(Class<?> type, String ... properties) {
        HashSet<String> exemptProperties = new HashSet<String>();
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            exemptProperties.add(property);
            ++n2;
        }
        classSpecificExemptProperties.put(type, exemptProperties);
    }

    public static final void addClassSpecificExemptProperties(Class<?> type, Iterable<String> properties) {
        HashSet<String> exemptProperties = new HashSet<String>();
        for (String property : properties) {
            exemptProperties.add(property);
        }
        classSpecificExemptProperties.put(type, exemptProperties);
    }

    public static final int compareTo(Object thisBean, Object thatBean, String ... properties) {
        if (thisBean == null && thatBean == null) {
            return 0;
        }
        if (thisBean == null) {
            return -1;
        }
        if (thatBean == null) {
            return 1;
        }
        if (thisBean == thatBean) {
            return 0;
        }
        if (thisBean.equals(thatBean)) {
            return 0;
        }
        ArrayList<Object> propertyNames = new ArrayList<String>();
        AnyObjectComparator comparator = new AnyObjectComparator();
        if (ArrayUtility.isEmpty(properties)) {
            propertyNames = BeanService.getPropertyNames(thisBean);
        } else {
            propertyNames.addAll(Arrays.asList(properties));
        }
        int cmp = 0;
        for (String string : propertyNames) {
            Object thatProperty;
            Object thisProperty = BeanService.getPropertyValue(thisBean, string);
            cmp = comparator.compare(thisProperty, thatProperty = BeanService.getPropertyValue(thatBean, string));
            if (cmp != 0) break;
        }
        return cmp;
    }

    public static final boolean areEqual(Object thisBean, Object thatBean) {
        return BeanService.areEqual(thisBean, thatBean, null);
    }

    public static final boolean areEqual(Object thisBean, Object thatBean, String ... properties) {
        if (thisBean == null && thatBean == null) {
            return true;
        }
        if (thisBean == null && thatBean != null) {
            return false;
        }
        if (thisBean != null && thatBean == null) {
            return false;
        }
        if (thisBean == thatBean) {
            return true;
        }
        if (properties == null || properties.length == 0) {
            return thisBean.equals(thatBean);
        }
        ArrayList<String> propertyNames = new ArrayList<String>();
        propertyNames.addAll(Arrays.asList(properties));
        for (String propertyName : propertyNames) {
            Object thatPropertyValue;
            Object thisPropertyValue = BeanService.getPropertyValue(thisBean, propertyName);
            boolean equal = BeanService.areEqual(thisPropertyValue, thatPropertyValue = BeanService.getPropertyValue(thatBean, propertyName));
            if (equal) continue;
            return false;
        }
        return true;
    }

    public static final int getHashCode(Object bean) {
        String methodName;
        Method method;
        Method[] accessors;
        if (bean == null) {
            return 0;
        }
        int hashCode = 1;
        Method[] methodArray = accessors = BeanService.getBeanAccessors(bean);
        int n = accessors.length;
        int n2 = 0;
        while (n2 < n) {
            method = methodArray[n2];
            methodName = method.getName();
            if (methodName.equals("hashCode")) {
                if (!method.getDeclaringClass().equals(bean.getClass())) break;
                return bean.hashCode();
            }
            ++n2;
        }
        methodArray = accessors;
        n = accessors.length;
        n2 = 0;
        while (n2 < n) {
            method = methodArray[n2];
            methodName = method.getName();
            if (!entityExemptProperties.contains(methodName)) {
                try {
                    Object fieldValue = method.invoke(bean, new Object[0]);
                    if (fieldValue == null) {
                        hashCode *= HASHCODE_PRIME;
                    } else if (fieldValue != bean) {
                        if (fieldValue.getClass().isEnum()) {
                            hashCode = 31 * hashCode + fieldValue.hashCode();
                        } else if (fieldValue instanceof Collection) {
                            Collection collection = (Collection)fieldValue;
                            for (Object c : collection) {
                                hashCode = HASHCODE_PRIME * hashCode + BeanService.getHashCode(c);
                            }
                        } else if (fieldValue.getClass().isArray()) {
                            Object[] array;
                            Object[] objectArray = array = (Object[])fieldValue;
                            int n3 = array.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Object a = objectArray[n4];
                                hashCode = HASHCODE_PRIME * hashCode + BeanService.getHashCode(a);
                                ++n4;
                            }
                        } else {
                            hashCode = HASHCODE_PRIME * hashCode + BeanService.getHashCode(fieldValue);
                        }
                    }
                }
                catch (Exception e) {
                    hashCode *= HASHCODE_PRIME;
                }
            }
            ++n2;
        }
        return hashCode;
    }

    public static <T> int hashCode(T bean, String ... properties) {
        if (bean == null) {
            return 0;
        }
        int hashCode = 1;
        if (ArrayUtility.isEmpty(properties)) {
            ArrayList<String> propertyList = BeanService.getPropertyNames(bean);
            properties = propertyList.toArray(new String[propertyList.size()]);
        }
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            T property = BeanService.getPropertyValue(bean, propertyName);
            hashCode = HASHCODE_PRIME * hashCode + BeanService.getHashcodeOf(property);
            ++n2;
        }
        return hashCode;
    }

    public static <T> int getHashcodeOf(T value) {
        if (value == null) {
            return 0;
        }
        return value.hashCode();
    }

    public static final String toString(Object bean, String delimiter) {
        Method[] accessors;
        StringBuilder sb = new StringBuilder();
        String value = null;
        Method[] methodArray = accessors = BeanService.getBeanAccessors(bean);
        int n = accessors.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            String methodName = method.getName();
            if (!entityExemptProperties.contains(methodName)) {
                try {
                    value = new MethodInvoker(bean, methodName, new Object[0]).invoke();
                }
                catch (Exception e) {
                    value = e.getMessage();
                }
                if (methodName.startsWith("get")) {
                    methodName = methodName.substring(3);
                } else if (methodName.startsWith("is")) {
                    methodName = methodName.substring(2);
                }
                sb.append(StringUtility.getDisplayableTitle(methodName));
                sb.append('=');
                sb.append(String.valueOf(value));
                sb.append(delimiter);
            }
            ++n2;
        }
        return sb.substring(0, sb.lastIndexOf(delimiter));
    }

    public static final String toString(Object bean, String delimiter, String ... properties) {
        StringBuilder sb = new StringBuilder();
        String value = null;
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String propertyName = stringArray[n2];
            if (sb.length() > 0) {
                sb.append(delimiter);
            }
            try {
                value = (String)BeanService.getPropertyValue(bean, propertyName);
                if (value == null) {
                    value = "-null-";
                }
            }
            catch (Exception e) {
                value = e.getMessage();
            }
            sb.append(StringUtility.getDisplayableTitle(propertyName));
            sb.append('=');
            if (value.getClass().isArray()) {
                sb.append(delimiter);
                int arrayLength = Array.getLength(value);
                int i = 0;
                while (i < arrayLength) {
                    Object arrayElement = Array.get(value, i);
                    sb.append("\t");
                    sb.append(String.format("[%d] - ", i));
                    if (arrayElement == null) {
                        sb.append("-null-");
                    } else {
                        sb.append(arrayElement);
                    }
                    sb.append(delimiter);
                    ++i;
                }
            } else {
                sb.append(String.valueOf(value));
            }
            ++n2;
        }
        return sb.toString();
    }

    private static final Object invokeMethod(Object source, String methodName) throws PropertyNotFoundException {
        String[] methodNames = BeanService.getAccessorMethodCandidateNames(methodName);
        Object value = null;
        String[] stringArray = methodNames;
        int n = methodNames.length;
        int n2 = 0;
        while (n2 < n) {
            String method = stringArray[n2];
            try {
                value = new MethodInvoker(source, method, new Object[0]).invoke();
                return value;
            }
            catch (RuntimeException e) {
                if (!(e.getCause() instanceof NoSuchMethodException)) {
                    throw e;
                }
                ++n2;
            }
        }
        throw new PropertyNotFoundException(String.format("%s %s", source.getClass().getName(), methodName));
    }

    private static String[] getAccessorMethodCandidateNames(String propertyName) {
        String lc = propertyName.toLowerCase();
        String uc = propertyName.toUpperCase();
        String[] methodNames = new String[]{BeanService.getGetMethodName(propertyName), BeanService.getIsMethodName(propertyName), propertyName, "get" + lc, "is" + lc, "get" + uc, "is" + uc, lc, uc};
        return methodNames;
    }

    private static String getGetMethodName(String property) {
        return "get" + property.toUpperCase().charAt(0) + property.substring(1);
    }

    private static String getIsMethodName(String property) {
        return "is" + property.toUpperCase().charAt(0) + property.substring(1);
    }

    private static String getSetMethodName(String property) {
        return "set" + property.toUpperCase().charAt(0) + property.substring(1);
    }
}

