/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.beans.util;

import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.StringUtility;

public final class Encoder {
    public static String encode(String text) {
        char[] sourceChars;
        if (StringUtility.isEmpty(text)) {
            return text;
        }
        char[] badChars = new char[]{'<', '>', '&', '\'', '%', '\"', '\n', '\r'};
        String[] goodStrings = new String[]{"&lt;", "&gt;", "&amp;", "&#39;", "&#37;", "&quot;", "%0D", "%0A"};
        StringBuilder sb = new StringBuilder();
        char[] cArray = sourceChars = text.toCharArray();
        int n = sourceChars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Comparison.isIn(c, badChars)) {
                sb.append(goodStrings[ArrayUtility.indexOf(c, badChars)]);
            } else {
                sb.append(c);
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String decode(String text) {
        if (StringUtility.isEmpty(text)) {
            return text;
        }
        String[] oldStrings = new String[]{"&lt;", "&gt;", "&amp;", "&#39;", "&#37;", "&quot;", "%0D", "%0A"};
        String[] newChars = new String[]{"<", ">", "&", "'", "%", "\"", "\n", "\r"};
        String result = "";
        int i = 0;
        while (i < oldStrings.length) {
            result = text.replaceAll(oldStrings[i], newChars[i]);
            ++i;
        }
        return result;
    }
}

