/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.beans.util;

import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.beans.util.DataTypeConverter;
import com.jmorgan.beans.util.PropertyBindingMap;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.util.animator.Animator;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;

public class PropertyBinder
extends JMBean
implements PropertyChangeListener {
    private ArrayList<PropertyBindingMap> bindingMap = new ArrayList();
    private Animator animator;
    private boolean showProperties;

    public PropertyBinder() {
    }

    public PropertyBinder(Object sourceObject, String sourceProperty, Object targetObject, String targetProperty) {
        this();
        this.addBindingMap(sourceObject, sourceProperty, targetObject, targetProperty);
    }

    public PropertyBinder(Object sourceObject, String sourceProperty, Object targetObject, String targetProperty, DataTypeConverter<?, ?> typeConverter) {
        this();
        this.addBindingMap(sourceObject, sourceProperty, targetObject, targetProperty, typeConverter);
    }

    public void addBindingMap(Object sourceObject, String sourceProperty, Object targetObject, String targetProperty) {
        PropertyBindingMap map = new PropertyBindingMap(sourceObject, sourceProperty, targetObject, targetProperty);
        this.bindingMap.add(map);
        new MethodInvoker(sourceObject, "addPropertyChangeListener", this).invoke();
    }

    public void addBindingMap(Object sourceObject, String sourceProperty, Object targetObject, String targetProperty, DataTypeConverter<?, ?> typeConverter) {
        PropertyBindingMap map = new PropertyBindingMap(sourceObject, sourceProperty, targetObject, targetProperty, typeConverter);
        this.bindingMap.add(map);
        new MethodInvoker(sourceObject, "addPropertyChangeListener", this).invoke();
    }

    public void removeBindingMap(Object sourceObject, String sourceProperty, Object targetObject, String targetProperty) {
        PropertyBindingMap map = new PropertyBindingMap(sourceObject, sourceProperty, targetObject, targetProperty);
        this.removeBindingMap(map);
    }

    public void removeBindingMap(PropertyBindingMap map) {
        new MethodInvoker(map.getSourceObject(), "removePropertyChangeListener", this).invoke();
    }

    public void clearBindingMaps() {
        for (PropertyBindingMap map : this.bindingMap) {
            this.removeBindingMap(map);
            Object var1_2 = null;
        }
        this.bindingMap.clear();
    }

    public Animator getAnimator() {
        return this.animator;
    }

    public void setAnimator(Animator animator) {
        this.animator = animator;
    }

    public boolean isShowProperties() {
        return this.showProperties;
    }

    public void setShowProperties(boolean showProperties) {
        this.showProperties = showProperties;
    }

    protected ArrayList<PropertyBindingMap> getBindingMap() {
        return this.bindingMap;
    }

    protected boolean showProperties() {
        return this.showProperties;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object source = evt.getSource();
        String propertyName = evt.getPropertyName();
        if (this.showProperties) {
            System.out.printf("PropertyBinder.propertyChange(%s.%s)\nProperty Name: %s\nOldValue=%s, New Value=%s\n", source.getClass().getName(), propertyName, propertyName, evt.getOldValue(), evt.getNewValue());
        }
        for (PropertyBindingMap map : this.bindingMap) {
            if (!map.getSourceObject().equals(source) || !map.getSourceProperty().equals(propertyName)) continue;
            DataTypeConverter<?, ?> typeConverter = map.getTypeConverter();
            if (typeConverter != null) {
                if (this.animator == null) {
                    BeanService.setPropertyValue(map.getTargetObject(), map.getTargetProperty(), typeConverter.convert(evt.getNewValue()));
                } else {
                    this.animator.animate(map.getTargetObject(), map.getTargetProperty(), typeConverter.convert(evt.getNewValue()));
                }
            } else if (this.animator == null) {
                BeanService.setPropertyValue(map.getTargetObject(), map.getTargetProperty(), evt.getNewValue());
            } else {
                this.animator.animate(map.getTargetObject(), map.getTargetProperty(), evt.getNewValue());
            }
            return;
        }
        if (this.showProperties) {
            System.out.printf("PropertyBinder.propertyChange(%s.%s):\nThe changed property name \"%s\" did not match any bound property in the mapping of this binder.  \nRemember, if the bound property is from a component, the component may send the name of the component as the property \nname, rather than the bean compliant name of the actual property being changed.\n", source.getClass().getName(), propertyName, propertyName);
        }
    }
}

