/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.beans.util;

import com.jmorgan.beans.util.AbstractEventInvoker;
import com.jmorgan.util.StringUtility;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.regex.Pattern;

public class PropertyChangeInvoker
extends AbstractEventInvoker<PropertyChangeEvent>
implements PropertyChangeListener {
    private String propertyMatchPattern;
    private boolean showPropertyNames;

    public PropertyChangeInvoker(Object eventProducer, Object target, String methodName) {
        super(eventProducer, target, methodName);
        this.setListenerAddRemoveMethodNames("addPropertyChangeListener", "removePropertyChangeListener");
        this.setPropertyMatchPattern(".*");
        this.setShowPropertyNames(false);
    }

    public PropertyChangeInvoker(Object eventProducer, Object target, String methodName, Object ... arguments) {
        super(eventProducer, target, methodName, arguments);
        this.setListenerAddRemoveMethodNames("addPropertyChangeListener", "removePropertyChangeListener");
        this.setPropertyMatchPattern(".*");
        this.setShowPropertyNames(false);
    }

    public String getPropertyMatchPattern() {
        return this.propertyMatchPattern;
    }

    public void setPropertyMatchPattern(String propertyMatchPattern) {
        if (propertyMatchPattern == null) {
            propertyMatchPattern = ".*";
        }
        this.propertyMatchPattern = propertyMatchPattern;
    }

    public boolean getShowPropertyNames() {
        return this.showPropertyNames;
    }

    public void setShowPropertyNames(boolean showPropertyNames) {
        this.showPropertyNames = showPropertyNames;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String pattern;
        if (this.showPropertyNames) {
            System.out.println("PropertyChangeInvoker.propertyChange(evt): Received a change in property: " + evt.getPropertyName());
        }
        String string = pattern = StringUtility.isEmpty(this.propertyMatchPattern) ? ".*" : this.propertyMatchPattern;
        if (Pattern.matches(pattern, evt.getPropertyName())) {
            if (this.showPropertyNames) {
                System.out.println("PropertyChangeInvoker.propertyChange(evt): " + evt.getPropertyName() + " Matched the pattern " + this.propertyMatchPattern + " and the PropertyChangeEvent will be invoked");
            }
            this.setEvent(evt);
            this.invoke();
        }
    }
}

