/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.graphics;

import com.jmorgan.io.CDataReader;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BitmapFileHeader {
    private String fileType;
    private long size;
    private short reserved01;
    private short reserved02;
    private long bitsOffset;

    public String getFileType() {
        return this.fileType;
    }

    public long getSize() {
        return this.size;
    }

    public long getBitsOffset() {
        return this.bitsOffset;
    }

    public void read(RandomAccessFile raf) {
        try {
            byte[] b2 = new byte[]{(byte)raf.read(), (byte)raf.read()};
            this.fileType = new String(b2);
            this.size = CDataReader.readDoubleWord(raf);
            this.reserved01 = raf.readShort();
            this.reserved02 = raf.readShort();
            this.bitsOffset = CDataReader.readDoubleWord(raf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        Object s = "";
        s = "File Type:\t\t" + this.fileType + "\nSize:\t\t" + this.size + "\nReserved01:\t" + this.reserved01 + "\nReserved02:\t" + this.reserved02 + "\nbitsOffset:\t\t" + this.bitsOffset;
        return s;
    }
}

