/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.graphics.drawing;

import com.jmorgan.graphics.drawing.AbstractDrawer;
import com.jmorgan.lang.MathExt;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;

public class CogWheelDrawer
extends AbstractDrawer {
    private Color edgeColor;
    private Color fillColor;
    private double radius;

    public CogWheelDrawer() {
        this(new Point(0, 0), 16, Color.DARK_GRAY, Color.DARK_GRAY);
    }

    public CogWheelDrawer(Point location, Dimension size) {
        super(location, size);
        int radius = Math.min(size.width, size.height);
        this.setRadius(radius);
        this.setEdgeColor(Color.DARK_GRAY);
        this.setFillColor(Color.DARK_GRAY);
    }

    public CogWheelDrawer(Point location, int radius) {
        this(location, new Dimension(radius, radius));
    }

    public CogWheelDrawer(Point location, Dimension size, Color color) {
        this(location, size);
        this.setEdgeColor(color);
        this.setFillColor(color);
    }

    public CogWheelDrawer(Point location, int radius, Color edgeColor, Color fillColor) {
        this(location, radius);
        this.setEdgeColor(edgeColor);
        this.setFillColor(fillColor);
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setEdgeColor(Color edgeColor) {
        this.edgeColor = edgeColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setFillColor(Color fillColor) {
        this.fillColor = fillColor;
    }

    @Override
    public void draw(Graphics graphics) {
        super.draw(graphics);
        double angle = -22.5;
        int[] xPoints = new int[8];
        int[] yPoints = new int[8];
        Ellipse2D[] circles = new Ellipse2D[8];
        int i = 0;
        while (i < 8) {
            Point2D polyPoint = MathExt.getPointFromOrigin(this.getLocation(), angle, this.radius);
            xPoints[i] = (int)polyPoint.getX();
            yPoints[i] = (int)polyPoint.getY();
            circles[i] = new Ellipse2D.Double(xPoints[i] - 3, yPoints[i] - 3, 6.0, 6.0);
            ++i;
            angle += 45.0;
        }
        Polygon polygon = new Polygon(xPoints, yPoints, 8);
        Area cogWheel = new Area(polygon);
        int i2 = 0;
        while (i2 < 8) {
            cogWheel.subtract(new Area(circles[i2]));
            ++i2;
        }
        int centerX = this.getLocation().x;
        int centerY = this.getLocation().y;
        cogWheel.subtract(new Area(new Ellipse2D.Double(centerX - 5, centerY - 5, 8.0, 8.0)));
        graphics.setColor(this.fillColor);
        ((Graphics2D)graphics).fill(cogWheel);
        graphics.setColor(this.edgeColor);
        ((Graphics2D)graphics).draw(cogWheel);
    }
}

