/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.graphics.drawing;

import com.jmorgan.graphics.Line;
import com.jmorgan.graphics.drawing.AbstractDrawer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;

public class LineDrawer
extends AbstractDrawer {
    private Line line;
    private Color color;
    private int lineType;
    private int lineThickness;
    private Point locationOrigin;
    private Dimension surfaceSize;

    public LineDrawer(Line line) {
        this(line, Color.BLACK);
    }

    public LineDrawer(Line line, Color color) {
        this(line, color, 0);
    }

    public LineDrawer(Line line, Color color, int lineType) {
        this(line, color, lineType, 1);
    }

    public LineDrawer(Line line, Color color, int lineType, int lineThickness) {
        this.setLine(line);
        this.setColor(color);
        this.setLineType(lineType);
        this.setLineThickness(lineThickness);
    }

    @Override
    public void draw(Graphics graphics) {
        super.draw(graphics);
        graphics.setColor(this.color);
        Point loc = this.getLocation();
        Point sp = this.line.getStartPoint();
        Point ep = this.line.getEndPoint();
        graphics.drawLine(sp.x + loc.x, sp.y + loc.y, ep.x + loc.x, ep.y + loc.y);
    }

    @Override
    public Point getLocation() {
        return this.locationOrigin;
    }

    @Override
    public Dimension getSize() {
        return this.surfaceSize;
    }

    public Color getColor() {
        return this.color;
    }

    public Line getLine() {
        return this.line;
    }

    public int getLineThickness() {
        return this.lineThickness;
    }

    public int getLineType() {
        return this.lineType;
    }

    @Override
    public void setLocation(Point location) {
        this.locationOrigin = location;
    }

    @Override
    public void setSize(Dimension size) {
        this.surfaceSize = size;
    }

    public void setColor(Color color) {
        if (color != null) {
            this.color = color;
        }
    }

    public void setLine(Line line) {
        if (line != null) {
            this.line = line;
        }
    }

    public void setLineThickness(int lineThickness) {
        if (lineThickness > 0) {
            this.lineThickness = lineThickness;
        }
    }

    public void setLineType(int lineType) {
        if (lineType == 1 || lineType == 3 || lineType == 5 || lineType == 4 || lineType == 2 || lineType == 0) {
            this.lineType = lineType;
        }
    }
}

