/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.graphics.drawing;

import com.jmorgan.graphics.drawing.AbstractDrawer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;

public class PaperDrawer
extends AbstractDrawer {
    private Color edgeColor;
    private Color textColor;
    private Color paperColor;
    private Font font;
    private FontMetrics fontMetrics;

    public PaperDrawer(Point location, Dimension size, Color edgeColor, Color textColor) {
        super(location, size);
        this.setPaperColor(Color.WHITE);
        this.setEdgeColor(edgeColor);
        this.setTextColor(textColor);
        this.font = new Font("Tahoma", 0, 2);
        this.fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
    }

    public Color getPaperColor() {
        return this.paperColor;
    }

    public void setPaperColor(Color paperColor) {
        if (paperColor == null) {
            return;
        }
        this.paperColor = paperColor;
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setEdgeColor(Color edgeColor) {
        if (edgeColor == null) {
            return;
        }
        this.edgeColor = edgeColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        if (textColor == null) {
            return;
        }
        this.textColor = textColor;
    }

    @Override
    public void draw(Graphics graphics) {
        super.draw(graphics);
        Dimension size = this.getSize();
        Point min = this.getLocation();
        Point max = new Point(min.x + size.width - 1, min.y + size.height - 1);
        int xWidth = max.x - min.x;
        int yHeight = max.y - min.y;
        int cornerWidth = Math.min(xWidth, yHeight) / 2;
        Point corner = new Point(max.x - cornerWidth, min.y + cornerWidth);
        int[] paperXPoints = new int[]{min.x, min.x, max.x, max.x, corner.x, corner.x};
        int[] paperYPoints = new int[]{min.y, max.y, max.y, corner.y, corner.y, min.y};
        Polygon frontPaper = new Polygon(paperXPoints, paperYPoints, paperXPoints.length);
        graphics.setColor(this.paperColor);
        if (graphics instanceof Graphics2D) {
            GradientPaint paint = new GradientPaint(new Point(min.x, min.y), this.paperColor, new Point(max.x, max.y), this.edgeColor);
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.setPaint(paint);
        }
        graphics.fillPolygon(frontPaper);
        graphics.setColor(this.edgeColor);
        graphics.drawPolygon(frontPaper);
        int[] cornerXPoints = new int[]{corner.x, corner.x, max.x};
        int[] cornerYPoints = new int[]{min.y, corner.y, corner.y, min.y};
        Polygon foldedCorner = new Polygon(cornerXPoints, cornerYPoints, cornerXPoints.length);
        graphics.setColor(Color.LIGHT_GRAY);
        graphics.fillPolygon(foldedCorner);
        graphics.setColor(this.edgeColor);
        graphics.drawPolygon(foldedCorner);
        graphics.setColor(Color.GRAY);
        graphics.drawLine(min.x + 1, max.y + 1, max.x + 1, max.y + 1);
        graphics.drawLine(max.x + 1, max.y + 1, max.x + 1, min.y + cornerWidth + 1);
        graphics.drawLine(max.x + 1, min.y + cornerWidth + 1, corner.x + 1, corner.y + 1);
        graphics.setColor(this.textColor);
        String[] text = PaperDrawer.getText();
        graphics.setFont(this.font);
        int line = 0;
        int y = min.y + 4;
        while (y < max.y - 4) {
            int endOfString;
            Rectangle2D rect;
            int width;
            int maxX = y <= min.y + cornerWidth ? max.x - cornerWidth - 4 : max.x - 4;
            int maxWidth = maxX - (min.x + 4);
            if (line >= text.length) {
                line = 0;
            }
            String textLine = text[line];
            while ((width = (int)(rect = this.fontMetrics.getStringBounds(textLine, graphics)).getWidth()) >= maxWidth && (endOfString = textLine.length() - 2) > 0) {
                textLine = textLine.substring(0, endOfString);
            }
            graphics.drawString(textLine, min.x + 4, y + this.fontMetrics.getHeight());
            y += 4;
            ++line;
        }
    }

    private static String[] getText() {
        return new String[]{"     If it wasn't for computers, we'd definitely have more time on our hands.  There ", "has never been a single instance where people using this wonderful technology has ", "actually reduced the work they do in their daily lives.  Computers have only served to ", "open more doors than we are able to enter, but, interestingly enough, we still try.", "     Don't ever think that technology has improved your life.  Though there are many ", "conveniences technology has brought, how much more time would you spend with your ", "family and in your home if it took 3 hours to get to the nearest facility?", "     Whatever happened to free time.  Companies more and more expect us to carry ", "pagers, cellular phones, and to use our personal equipment and time for company ", "purposes.  Many times we need to have these devices available even when on vacation."};
    }
}

