/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.graphics.drawing;

import com.jmorgan.graphics.drawing.AbstractDrawer;
import com.jmorgan.graphics.drawing.PaperDrawer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;

public class PrinterDrawer
extends AbstractDrawer {
    private static final int GRID_HEIGHT = 5;
    private static final int GRID_WIDTH = 7;
    private Color edgeColor;
    private Color textColor;
    private Color printerColor;

    public PrinterDrawer(Point location, Dimension size, Color edgeColor, Color textColor, Color printerColor) {
        super(location, size);
        this.setEdgeColor(edgeColor);
        this.setTextColor(textColor);
        this.setPrinterColor(printerColor);
    }

    public Color getPrinterColor() {
        return this.printerColor;
    }

    public void setPrinterColor(Color printerColor) {
        this.printerColor = printerColor;
    }

    public Color getEdgeColor() {
        return this.edgeColor;
    }

    public void setEdgeColor(Color edgeColor) {
        this.edgeColor = edgeColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    @Override
    public void draw(Graphics graphics) {
        super.draw(graphics);
        Dimension size = this.getSize();
        Point location = this.getLocation();
        int cellWidth = size.width / 7;
        int cellHeight = size.height / 5;
        PaperDrawer paperDrawer = new PaperDrawer(new Point(location.x + cellWidth, location.y), new Dimension(cellWidth * 5, cellHeight * 2), this.edgeColor, this.textColor);
        paperDrawer.draw(graphics);
        int[] printerXPoints = new int[]{location.x, location.x + cellWidth, location.x + cellWidth, location.x + cellWidth * 6, location.x + cellWidth * 6, location.x + size.width, location.x + size.width, location.x};
        int[] printerYPoints = new int[]{location.y + cellHeight, location.y + cellHeight, location.y + cellHeight * 2, location.y + cellHeight * 2, location.y + cellHeight, location.y + cellHeight, location.y + cellHeight * 4, location.y + cellHeight * 4};
        Polygon polygon = new Polygon(printerXPoints, printerYPoints, printerXPoints.length);
        graphics.setColor(this.printerColor);
        graphics.fillPolygon(polygon);
        graphics.setColor(new Color(128, 128, 128));
        graphics.fillRect(location.x + cellWidth, location.y + cellHeight * 4, cellWidth * 5, cellHeight);
        graphics.setColor(this.getEdgeColor());
        graphics.drawPolygon(polygon);
        graphics.drawRect(location.x + cellWidth, location.y + cellHeight * 4, cellWidth * 5, cellHeight);
    }
}

