/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.image;

import com.jhlabs.image.ContrastFilter;
import com.jhlabs.image.GammaFilter;
import com.jhlabs.image.GaussianFilter;
import com.jhlabs.image.InvertFilter;
import com.jhlabs.image.OilFilter;
import com.jmorgan.image.AbstractBufferedImageOp;
import com.jmorgan.lang.MathExt;
import com.jmorgan.swing.JMLabel;
import com.jmorgan.util.comparator.BeanComparator;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import javax.imageio.ImageIO;

public final class ImageUtilities {
    public static final int ALPHA_INDEX = 0;
    public static final int RED_INDEX = 1;
    public static final int GREEN_INDEX = 2;
    public static final int BLUE_INDEX = 3;

    private ImageUtilities() {
    }

    public static int[] decodeRGB(int rgb) {
        int alpha = (rgb & 0xFF000000) >> 24;
        int red = (rgb & 0xFF0000) >> 16;
        int green = (rgb & 0xFF00) >> 8;
        int blue = rgb & 0xFF;
        return new int[]{alpha, red, green, blue};
    }

    public static int encodeRGB(int[] elements) {
        return ImageUtilities.encodeRGB(elements[1], elements[2], elements[3], elements[0]);
    }

    public static int encodeRGB(int r, int g, int b, int a) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static BufferedImage getContrastedImage(BufferedImage image, int brightness, int contrast) {
        ContrastFilter contrastFilter = new ContrastFilter();
        contrastFilter.setBrightness((float)brightness / 100.0f);
        contrastFilter.setContrast((float)contrast / 100.0f);
        return contrastFilter.filter(image, null);
    }

    public static BufferedImage getGammaImage(BufferedImage image, int gamma) {
        GammaFilter gammaFilter = new GammaFilter((float)gamma / 100.0f);
        return gammaFilter.filter(image, null);
    }

    public static BufferedImage createBlankImage(int width, int height, int imageType) {
        BufferedImage image = new BufferedImage(width, height, imageType);
        Graphics2D g2d = image.createGraphics();
        g2d.setPaint(Color.WHITE);
        g2d.fillRect(0, 0, width, height);
        g2d.dispose();
        return image;
    }

    public static BufferedImage createTranslucentImage(BufferedImage image, float transparency) {
        BufferedImage alphaImage = new BufferedImage(image.getWidth(), image.getHeight(), 3);
        Graphics2D g = alphaImage.createGraphics();
        g.setComposite(AlphaComposite.getInstance(3, transparency));
        g.drawImage(image, null, 0, 0);
        g.dispose();
        return alphaImage;
    }

    public static BufferedImage makeColorTransparent(BufferedImage image, Color color) {
        BufferedImage dimg = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        Graphics2D g = dimg.createGraphics();
        g.setComposite(AlphaComposite.Src);
        g.drawImage(image, null, 0, 0);
        g.dispose();
        int i = 0;
        while (i < dimg.getHeight()) {
            int j = 0;
            while (j < dimg.getWidth()) {
                if (dimg.getRGB(j, i) == color.getRGB()) {
                    dimg.setRGB(j, i, 9378844);
                }
                ++j;
            }
            ++i;
        }
        return dimg;
    }

    public static BufferedImage getHorizontallyFlippedImage(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        int imageType = image.getType();
        if (imageType == 0) {
            imageType = 6;
        }
        BufferedImage newImage = new BufferedImage(w, h, imageType);
        Graphics2D g = newImage.createGraphics();
        g.drawImage(image, 0, 0, w, h, w, 0, 0, h, null);
        g.dispose();
        return newImage;
    }

    public static BufferedImage getVerticallyFlippedImage(BufferedImage image) {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage newImage = new BufferedImage(w, h, image.getColorModel().getTransparency());
        Graphics2D g = newImage.createGraphics();
        g.drawImage(image, 0, 0, w, h, 0, h, w, 0, null);
        g.dispose();
        return newImage;
    }

    public static BufferedImage getRotatedImage(BufferedImage image, int angle) {
        if (angle == 0) {
            return image;
        }
        int w = image.getWidth();
        int h = image.getHeight();
        double rotationCenterX = (double)w / 2.0;
        double rotationCenterY = (double)h / 2.0;
        double angleRad = Math.toRadians(angle);
        Point2D topLeft = ImageUtilities.getRotatedCorner(0.0, 0.0, rotationCenterX, rotationCenterY, angleRad);
        Point2D topRight = ImageUtilities.getRotatedCorner(w, 0.0, rotationCenterX, rotationCenterY, angleRad);
        Point2D bottomLeft = ImageUtilities.getRotatedCorner(0.0, h, rotationCenterX, rotationCenterY, angleRad);
        Point2D bottomRight = ImageUtilities.getRotatedCorner(w, h, rotationCenterX, rotationCenterY, angleRad);
        double minimumX = MathExt.getMinimumOf(topLeft.getX(), topRight.getX(), bottomLeft.getX(), bottomRight.getX());
        double maximumX = MathExt.getMaximumOf(topLeft.getX(), topRight.getX(), bottomLeft.getX(), bottomRight.getX());
        double minimumY = MathExt.getMinimumOf(topLeft.getY(), topRight.getY(), bottomLeft.getY(), bottomRight.getY());
        double maximumY = MathExt.getMaximumOf(topLeft.getY(), topRight.getY(), bottomLeft.getY(), bottomRight.getY());
        double rotatedWidth = maximumX - minimumX;
        double rotatedHeight = maximumY - minimumY;
        BufferedImage newImage = new BufferedImage((int)rotatedWidth, (int)rotatedHeight, image.getType());
        Graphics2D g = newImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.translate(-minimumX, -minimumY);
        g.rotate(angleRad, (int)rotationCenterX, (int)rotationCenterY);
        g.drawImage((Image)image, 0, 0, null);
        g.dispose();
        return newImage;
    }

    private static Point2D getRotatedCorner(double x, double y, double rx, double ry, double andgleInRadians) {
        double x2 = rx + (x - rx) * Math.cos(andgleInRadians) + (y - ry) * Math.sin(andgleInRadians);
        double y2 = ry - (x - rx) * Math.sin(andgleInRadians) + (y - ry) * Math.cos(andgleInRadians);
        return new Point2D.Double(x2, y2);
    }

    public static Dimension computeBestFitSize(int sourceWidth, int sourceHeight, int targetWidth, int targetHeight) {
        int maxSource = Math.max(sourceWidth, sourceHeight);
        int maxTarget = Math.max(targetWidth, targetHeight);
        if (maxSource == sourceWidth && maxTarget == targetHeight || maxSource == sourceHeight && maxTarget == targetWidth) {
            int tmp = sourceWidth;
            sourceWidth = sourceHeight;
            sourceHeight = tmp;
        }
        double widthRatio = (double)targetWidth / (double)sourceWidth;
        double heightRatio = (double)targetHeight / (double)sourceHeight;
        double minRatio = Math.min(widthRatio, heightRatio);
        int newWidth = (int)((double)sourceWidth * minRatio);
        int newHeight = (int)((double)sourceHeight * minRatio);
        return new Dimension(newWidth, newHeight);
    }

    public static BufferedImage getScaledImage(BufferedImage image, int newWidth, int newHeight) {
        int imageType = image.getType();
        if (imageType == 0) {
            imageType = 2;
        }
        BufferedImage newImage = new BufferedImage(newWidth, newHeight, imageType);
        Graphics2D g = newImage.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(image, 0, 0, newWidth, newHeight, null);
        g.dispose();
        return newImage;
    }

    public static Image getScaledImage(Image image, int newWidth, int newHeight) {
        BufferedImage bufferedImage = new BufferedImage(newWidth, newHeight, 6);
        Graphics2D g = (Graphics2D)bufferedImage.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(image, 0, 0, newWidth, newHeight, null);
        g.dispose();
        return bufferedImage;
    }

    public static BufferedImage getBlurredImage(BufferedImage image, float blurAmount) {
        GaussianFilter gaussianFilter = new GaussianFilter();
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        gaussianFilter.setRadius(blurAmount);
        gaussianFilter.setUseAlpha(true);
        gaussianFilter.filter(image, newImage);
        return newImage;
    }

    public static BufferedImage getColorInvertedImage(BufferedImage image) {
        InvertFilter invertFilter = new InvertFilter();
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 2);
        return invertFilter.filter(image, newImage);
    }

    public static long getColorCount(BufferedImage image, boolean includeAlpha) {
        int[] pixels;
        BitSet counter = new BitSet();
        int[] nArray = pixels = AbstractBufferedImageOp.getRGB((BufferedImage)image, (int)0, (int)0, (int)image.getWidth(), (int)image.getHeight(), null);
        int n = pixels.length;
        int n2 = 0;
        while (n2 < n) {
            int pixel = nArray[n2];
            int[] rgb = ImageUtilities.decodeRGB(pixel);
            if (!includeAlpha) {
                rgb[0] = 0;
                pixel = ImageUtilities.encodeRGB(rgb);
            }
            counter.set(pixel);
            ++n2;
        }
        return counter.cardinality();
    }

    public static Color[] getColors(BufferedImage image) {
        int[] pixels = AbstractBufferedImageOp.getRGB((BufferedImage)image, (int)0, (int)0, (int)image.getWidth(), (int)image.getHeight(), null);
        HashMap<Integer, Color> colors = new HashMap<Integer, Color>();
        Object object = pixels;
        int n = pixels.length;
        int n2 = 0;
        while (n2 < n) {
            int pixel = object[n2];
            if (!colors.containsKey(pixel)) {
                int[] rgb = ImageUtilities.decodeRGB(pixel);
                colors.put(pixel, new Color(pixel, rgb[0] > 0));
            }
            ++n2;
        }
        Color[] colorArray = new Color[colors.size()];
        int i = 0;
        object = colors.values().iterator();
        while (object.hasNext()) {
            Color c = (Color)object.next();
            colorArray[i++] = c;
        }
        BeanComparator colorComparator = new BeanComparator();
        colorComparator.addCompareProperties("RGB");
        Arrays.sort(colorArray, colorComparator);
        return colorArray;
    }

    public static BufferedImage getOilPainting(BufferedImage image, int distance, int levels) {
        OilFilter oilFilter = new OilFilter();
        oilFilter.setRange(distance);
        oilFilter.setLevels(levels);
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), image.getType());
        return oilFilter.filter(image, newImage);
    }

    public static final BufferedImage loadImage(String fileName) {
        return ImageUtilities.loadImage(new File(fileName));
    }

    public static final BufferedImage loadImage(File file) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bufferedImage;
    }

    public static final BufferedImage loadImage(URL url) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bufferedImage;
    }

    public static void saveImage(BufferedImage image, String fileName) {
        ImageUtilities.saveImage(image, new File(fileName));
    }

    public static void saveImage(BufferedImage image, File file) {
        try {
            String format = null;
            String lcFileName = file.getAbsolutePath().toLowerCase();
            String[] writerSuffixes = ImageIO.getWriterFileSuffixes();
            int i = 0;
            while (i < writerSuffixes.length) {
                if (lcFileName.endsWith("." + writerSuffixes[i])) {
                    format = writerSuffixes[i];
                    break;
                }
                ++i;
            }
            if (format == null) {
                format = "png";
            }
            if (format.equals("jpg") || format.equals("jpeg")) {
                BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 1);
                Graphics2D g = newImage.createGraphics();
                g.setPaint(Color.WHITE);
                g.fillRect(0, 0, image.getWidth(), image.getHeight());
                g.drawImage((Image)image, 0, 0, null);
                g.dispose();
                image = newImage;
            }
            ImageIO.write((RenderedImage)image, format, file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static boolean compare(Image image1, Image image2) {
        if (image1 == image2) {
            return true;
        }
        if (image1 == null && image2 == null) {
            return true;
        }
        if (image1 == null && image2 != null) {
            return false;
        }
        if (image1 != null && image2 == null) {
            return false;
        }
        BufferedImage bImage1 = ImageUtilities.getBufferedImage(image1);
        BufferedImage bImage2 = ImageUtilities.getBufferedImage(image2);
        if (bImage1.getWidth() != bImage2.getWidth() || bImage1.getHeight() != bImage2.getHeight() || bImage1.getType() != bImage2.getType() || bImage1.getTransparency() != bImage2.getTransparency()) {
            return false;
        }
        int width = bImage1.getWidth();
        int height = bImage1.getHeight();
        int x = 0;
        while (x < width) {
            int y = 0;
            while (y < height) {
                int pixel2;
                int pixel1 = bImage1.getRGB(x, y);
                if (pixel1 != (pixel2 = bImage2.getRGB(x, y))) {
                    return false;
                }
                ++y;
            }
            ++x;
        }
        return true;
    }

    public static BufferedImage copyImage(BufferedImage image) {
        BufferedImage newImage = ImageUtilities.createBlankImage(image.getWidth(), image.getHeight(), image.getType());
        Graphics g = newImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return newImage;
    }

    public static BufferedImage getBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        JMLabel c = new JMLabel();
        ImageUtilities.waitForImage(image, c);
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(c), image.getHeight(c), 1);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.drawImage(image, 0, 0, c);
        g2d.dispose();
        return bufferedImage;
    }

    public static BufferedImage getBufferedImage(String imageFile) {
        Image image = Toolkit.getDefaultToolkit().getImage(imageFile);
        return ImageUtilities.getBufferedImage(image);
    }

    public static BufferedImage getBufferedImage(byte[] imageData) {
        ByteArrayInputStream bis = new ByteArrayInputStream(imageData);
        BufferedInputStream buffIn = new BufferedInputStream(bis, imageData.length);
        try {
            return ImageIO.read(buffIn);
        }
        catch (IOException e) {
            System.err.println("ImageUtilities.getBufferedImage(byte[] imageData): Could not create image.");
            return null;
        }
    }

    public static int[] getRGBData(Image image) {
        BufferedImage bImage = ImageUtilities.getBufferedImage(image);
        return ImageUtilities.getRGBData(image, 0, 0, bImage.getWidth(null), bImage.getHeight(null));
    }

    public static int[] getRGBData(Image image, int startX, int startY, int width, int height) {
        BufferedImage bImage = ImageUtilities.getBufferedImage(image);
        int[] pixelData = new int[width * height];
        bImage.getRGB(startX, startY, width, height, pixelData, 0, width);
        return pixelData;
    }

    public static Image getRotatedImage(Image image, double angle, Point anchor) {
        AffineTransform at = new AffineTransform();
        at.rotate(Math.toRadians(angle), anchor.x, anchor.y);
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 6);
        Graphics2D g = (Graphics2D)bufferedImage.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(image, at, null);
        g.dispose();
        return bufferedImage;
    }

    public static boolean waitForImage(Image image, Component c) {
        MediaTracker tracker = new MediaTracker(c);
        tracker.addImage(image, 0);
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !tracker.isErrorAny();
    }

    public static boolean waitForImages(Image[] images, Component c) {
        MediaTracker tracker = new MediaTracker(c);
        int i = 0;
        while (i < images.length) {
            tracker.addImage(images[i], 0);
            ++i;
        }
        try {
            tracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !tracker.isErrorAny();
    }
}

