/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.StringUtility;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class AnySourceInputStream
extends InputStream {
    private static final long READ_TIMEOUT = 10000L;
    private Vector<Byte> buffer = new Vector();
    private boolean closed;

    public void write(byte b) {
        this.buffer.add(b);
    }

    public void write(byte[] bytes) {
        if (ArrayUtility.isEmpty(bytes)) {
            return;
        }
        byte[] byArray = bytes;
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            this.write(b);
            ++n2;
        }
    }

    public void write(String bytes) {
        if (StringUtility.isEmpty(bytes)) {
            return;
        }
        this.write(bytes.getBytes());
    }

    public void supply(byte[] data) {
        if (ArrayUtility.isEmpty(data)) {
            return;
        }
        this.write(data);
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        int bufferSize = this.buffer.size();
        long startTime = System.currentTimeMillis();
        while (!this.closed && bufferSize == 0) {
            Thread.yield();
            bufferSize = this.buffer.size();
            long endTime = System.currentTimeMillis();
            long elapsed = endTime - startTime;
            if (elapsed < 10000L) continue;
            System.err.printf("AnySourceInputStream.read(): Read Timeout\n", new Object[0]);
            return -1;
        }
        byte b = this.buffer.remove(0);
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int i = 0;
        while (i < b.length && this.buffer.size() > 0) {
            int singleByte = this.read();
            if (singleByte == -1) break;
            b[i] = (byte)singleByte;
            ++i;
        }
        return i;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int i = 0;
        while (i < b.length && i < len && i < this.buffer.size()) {
            int singleByte = this.read();
            if (singleByte == -1) break;
            b[off + i] = (byte)singleByte;
            ++i;
        }
        return i;
    }

    @Override
    public long skip(long n) throws IOException {
        int i = 0;
        while (i < this.buffer.size() && (long)i < n) {
            this.buffer.remove(0);
            ++i;
        }
        return i;
    }

    @Override
    public int available() throws IOException {
        return this.buffer.size();
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.buffer.clear();
        super.close();
    }
}

