/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

public class CharacterFilterReader
extends FilterReader {
    private ArrayList<Integer> exceptions = new ArrayList();

    public CharacterFilterReader(Reader in) {
        super(in);
    }

    public CharacterFilterReader(Reader in, int ... exceptions) {
        this(in);
        int[] nArray = exceptions;
        int n = exceptions.length;
        int n2 = 0;
        while (n2 < n) {
            int c = nArray[n2];
            this.addException(c);
            ++n2;
        }
    }

    public void addException(int c) {
        Integer ch = new Integer(c);
        if (this.exceptions.contains(ch)) {
            return;
        }
        this.exceptions.add(ch);
    }

    @Override
    public int read() throws IOException {
        int c = 0;
        Integer i = null;
        do {
            if ((c = super.read()) != -1) continue;
            return c;
        } while (this.exceptions.contains(i = new Integer(c)));
        return c;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int i = 0;
        while (i < len) {
            int c = this.read();
            if (c == -1 && i == 0) {
                return -1;
            }
            if (c == -1) {
                return i;
            }
            cbuf[off] = (char)c;
            ++i;
            ++off;
        }
        return len;
    }
}

