/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import com.jmorgan.beans.PropertyChangeNotifier;
import com.jmorgan.beans.PropertyChangeSupport;
import com.jmorgan.io.DEOExecutor;
import com.jmorgan.io.DEORowSelector;
import com.jmorgan.io.IORowObject;
import com.jmorgan.io.IORowObjectBeanMap;
import com.jmorgan.io.RetrievalArgument;
import com.jmorgan.util.comparator.DEOComparator;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public abstract class DEO<T, RAT extends RetrievalArgument>
implements PropertyChangeNotifier {
    private ArrayList<IORowObject> dataBuffer = new ArrayList();
    private DEORowSelector<IORowObject> dataSelector = new DEORowSelector<IORowObject>(this.dataBuffer);
    private ArrayList<RAT> retrievalArguments = new ArrayList();
    private PropertyChangeSupport propertyChangeSupporter = new PropertyChangeSupport(this);
    private boolean forcingRetrieve = false;

    public DEO() {
    }

    public DEO(Collection<IORowObject> data) {
        this();
        this.dataBuffer.addAll(data);
    }

    public ArrayList<RAT> getRetrievalArguments() {
        return this.retrievalArguments;
    }

    public void addRetrievalArgument(RAT arg) {
        this.retrievalArguments.add(arg);
    }

    public void removeRetrievalArgument(RAT arg) {
        this.retrievalArguments.remove(arg);
    }

    public void clearRetrievalArguments() {
        this.retrievalArguments.clear();
    }

    public void setRetrievalArguments(Collection<RAT> args) {
        this.clearRetrievalArguments();
        this.retrievalArguments.addAll(args);
    }

    public boolean hasChanged() {
        if (this.getNewRowCount() > 0) {
            return true;
        }
        if (this.getDeletedRowCount() > 0) {
            return true;
        }
        return this.getChangedRowCount() > 0;
    }

    public void reset() {
        PropertyChangeListener[] listeners = this.propertyChangeSupporter.getPropertyChangeListeners();
        this.forcingRetrieve = true;
        ArrayList<IORowObject> rows = this.getRows();
        ArrayList<IORowObject> dRows = this.getDeletedRows();
        if (listeners.length > 0 && (rows.size() > 0 || dRows.size() > 0)) {
            PropertyChangeListener[] propertyChangeListenerArray = listeners;
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyChangeListener listener = propertyChangeListenerArray[n2];
                for (IORowObject row : rows) {
                    row.removePropertyChangeListener(listener);
                    row.reset();
                }
                for (IORowObject row : dRows) {
                    row.removePropertyChangeListener(listener);
                    row.reset();
                }
                ++n2;
            }
        }
        this.forcingRetrieve = false;
        this.dataBuffer.clear();
        this.dataBuffer = null;
        this.dataBuffer = new ArrayList();
        this.dataSelector.setCollection(this.dataBuffer);
    }

    public abstract int retrieve() throws Exception;

    public int retrieve(Collection<RAT> arguments) throws Exception {
        this.retrievalArguments.addAll(arguments);
        return 0;
    }

    private void forceRetrieve() {
        if (this.forcingRetrieve) {
            return;
        }
        if (this.dataBuffer.size() == 0) {
            try {
                this.forcingRetrieve = true;
                if (this.retrievalArguments.size() == 0) {
                    this.retrieve();
                } else {
                    this.retrieve(this.retrievalArguments);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.forcingRetrieve = false;
    }

    public boolean update() throws Exception {
        if (this.dataBuffer.size() == 0) {
            return true;
        }
        this.dataSelector.setSelectionType(0);
        DEOExecutor executor = new DEOExecutor(this.dataSelector.getSelectedElements(), 3);
        executor.execute();
        if (this.dataBuffer.size() == 0) {
            return true;
        }
        executor = new DEOExecutor(this.dataBuffer, 1);
        executor.execute();
        return true;
    }

    public Collection<? extends IORowObject> getData() {
        return this.dataBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<T> getPOJOData(Collection<IORowObject> rawData, Class<T> beanType) {
        ArrayList<T> data = new ArrayList<T>();
        Collection<IORowObject> collection = rawData;
        synchronized (collection) {
            for (IORowObject row : rawData) {
                try {
                    T bean = beanType.newInstance();
                    this.mapDataToBean(row, bean);
                    data.add(bean);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("Instantiation Exception creating a bean of " + beanType.getClass().getName(), e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("IllegalAccessException Exception creating a bean of " + beanType.getClass().getName(), e);
                }
            }
        }
        return data;
    }

    public Collection<T> getData(Class<T> beanType) {
        return this.getPOJOData(this.dataBuffer, beanType);
    }

    public Collection<T> loadData(Class<T> beanType) {
        return this.retrieve(beanType);
    }

    public Collection<T> retrieve(Class<T> beanType) {
        this.forceRetrieve();
        return this.getPOJOData(this.dataBuffer, beanType);
    }

    protected void mapDataToBean(IORowObject row, T bean) {
        new IORowObjectBeanMap<T>(row, bean);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sortData(DEOComparator comparator) {
        if (comparator == null) {
            throw new NullPointerException("DEO.sortData(DEOComparator comparator):  comparator cannot be null");
        }
        ArrayList<IORowObject> arrayList = this.dataBuffer;
        synchronized (arrayList) {
            Collections.sort(this.dataBuffer, comparator);
        }
    }

    public int getRowCount() {
        return this.getCount(1);
    }

    public int getNewRowCount() {
        return this.getCount(2);
    }

    public int getDeletedRowCount() {
        return this.getCount(0);
    }

    public int getChangedRowCount() {
        return this.getCount(3);
    }

    private int getCount(int type) {
        this.forceRetrieve();
        this.dataSelector.setSelectionType(type);
        return this.dataSelector.getSelectedElements().size();
    }

    public abstract int getColumnNumber(String var1);

    public void setValue(int row, int column, Object value) throws ArrayIndexOutOfBoundsException {
        this.validateRow(row);
        IORowObject rowObject = this.dataBuffer.get(row);
        rowObject.setValue(column, value);
    }

    public void setValue(int row, String columnName, Object value) throws ArrayIndexOutOfBoundsException {
        this.setValue(row, this.getColumnNumber(columnName), value);
    }

    public Object getValue(int row, int column) throws ArrayIndexOutOfBoundsException {
        this.validateRow(row);
        IORowObject rowObject = this.dataBuffer.get(row);
        return rowObject.getValue(column);
    }

    public Object getValue(int row, String columnName) throws ArrayIndexOutOfBoundsException {
        return this.getValue(row, this.getColumnNumber(columnName));
    }

    public ArrayList<IORowObject> findRows(int column, Object value) {
        this.forceRetrieve();
        if (this.dataBuffer.size() > 0) {
            this.dataSelector.setSelectionType(4);
            this.dataSelector.addSearchCriteria(column, value);
            Collection matchingRows = this.dataSelector.getSelectedElements();
            this.dataSelector.removeSearchCriteria(column, value);
            return new ArrayList<IORowObject>(matchingRows);
        }
        return IORowObject.EMPTY_ARRAY;
    }

    public ArrayList<T> findRows(int column, Object value, Class<T> beanType) {
        ArrayList<IORowObject> matchingRows = this.findRows(column, value);
        return (ArrayList)this.getPOJOData(matchingRows, beanType);
    }

    public ArrayList<IORowObject> findRows(String columnName, Object value) {
        return this.findRows(this.getColumnNumber(columnName), value);
    }

    public ArrayList<T> findRows(String columnName, Object value, Class<T> beanType) {
        return this.findRows(this.getColumnNumber(columnName), value, beanType);
    }

    public IORowObject getRow(int rowNumber) throws ArrayIndexOutOfBoundsException {
        this.validateRow(rowNumber);
        IORowObject row = this.dataBuffer.get(rowNumber);
        return row;
    }

    public T getRow(int rowNumber, Class<T> beanType) throws ArrayIndexOutOfBoundsException {
        this.validateRow(rowNumber);
        IORowObject row = this.dataBuffer.get(rowNumber);
        try {
            T bean = beanType.newInstance();
            this.mapDataToBean(row, bean);
            return bean;
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Instantiation Exception creating a bean of " + beanType.getClass().getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("IllegalAccessException Exception creating a bean of " + beanType.getClass().getName(), e);
        }
    }

    public ArrayList<IORowObject> getRows() {
        return this.getRows(1);
    }

    public ArrayList<T> getRows(Class<T> beanType) {
        return this.getRows(1, beanType);
    }

    public ArrayList<IORowObject> getNewRows() {
        return this.getRows(2);
    }

    public ArrayList<T> getNewRows(Class<T> beanType) {
        return this.getRows(2, beanType);
    }

    public ArrayList<IORowObject> getChangedRows() {
        return this.getRows(3);
    }

    public ArrayList<T> getChangedRows(Class<T> beanType) {
        return this.getRows(3, beanType);
    }

    public ArrayList<IORowObject> getDeletedRows() {
        return this.getRows(0);
    }

    public ArrayList<T> getDeletedRows(Class<T> beanType) {
        return this.getRows(0, beanType);
    }

    private ArrayList<IORowObject> getRows(int type) {
        this.forceRetrieve();
        if (this.dataBuffer.size() > 0) {
            this.dataSelector.setSelectionType(type);
            Collection goodRows = this.dataSelector.getSelectedElements();
            if (goodRows.size() > 0) {
                return new ArrayList<IORowObject>(goodRows);
            }
        }
        return IORowObject.EMPTY_ARRAY;
    }

    private ArrayList<T> getRows(int type, Class<T> beanType) {
        ArrayList<IORowObject> rows = this.getRows(type);
        return (ArrayList)this.getPOJOData(rows, beanType);
    }

    public boolean isForcingRetrieve() {
        return this.forcingRetrieve;
    }

    public void setForcingRetrieve(boolean forcingRetrieve) {
        this.forcingRetrieve = forcingRetrieve;
    }

    public void addRow(IORowObject newData) throws IllegalArgumentException {
        if (newData == null) {
            throw new IllegalArgumentException("The given data cannot be null");
        }
        this.propertyChangeSupporter.propagateListeners(newData);
        this.dataBuffer.add(newData);
    }

    public void insertRow(IORowObject newData, int location) throws IllegalArgumentException {
        if (newData == null) {
            throw new IllegalArgumentException("The given data cannot be null");
        }
        if (location < 0) {
            throw new IllegalArgumentException("The given location cannot be negative");
        }
        this.propertyChangeSupporter.propagateListeners(newData);
        if (location > this.dataBuffer.size()) {
            this.addRow(newData);
        } else {
            this.dataBuffer.add(location, newData);
        }
    }

    public boolean isRowDeleted(int row) {
        int rowCount = this.getRowCount() + this.getDeletedRowCount();
        if (row < 0 || row >= rowCount) {
            throw new IllegalArgumentException("The given row value of " + row + " is out of range of 0 - " + rowCount);
        }
        IORowObject rowToCheck = this.getRow(row);
        return rowToCheck.isDeleted();
    }

    public boolean deleteRow(int row) {
        int rowCount = this.getRowCount() + this.getDeletedRowCount();
        if (row < 0 || row >= rowCount) {
            throw new IllegalArgumentException("The given row value of " + row + " is out of range of 0 - " + rowCount);
        }
        IORowObject rowToDelete = this.getRow(row);
        rowToDelete.setDeleted(true);
        return true;
    }

    public boolean deleteRow(IORowObject data) throws IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException("The given data cannot be null");
        }
        ArrayList<IORowObject> rows = this.getRows();
        for (IORowObject row : rows) {
            if (row != data) continue;
            row.setDeleted(true);
            return true;
        }
        return false;
    }

    public void deleteAll() {
        this.dataSelector.setSelectionType(1);
        DEOExecutor executor = new DEOExecutor(this.dataSelector.getSelectedElements(), 0);
        executor.execute();
    }

    public boolean unDeleteRow(int row) {
        int rowCount = this.getRowCount() + this.getDeletedRowCount();
        if (row < 0 || row >= rowCount) {
            throw new IllegalArgumentException("The given row value of " + row + " is out of range of 0 - " + rowCount);
        }
        IORowObject rowToDelete = this.getRow(row);
        rowToDelete.setDeleted(false);
        return true;
    }

    public boolean unDeleteRow(IORowObject data) throws IllegalArgumentException {
        if (data == null) {
            throw new IllegalArgumentException("The given data cannot be null");
        }
        ArrayList<IORowObject> deletedRows = this.getDeletedRows();
        for (IORowObject deletedRow : deletedRows) {
            if (deletedRow != data) continue;
            deletedRow.setDeleted(false);
            return true;
        }
        return false;
    }

    public void unDeleteAll() {
        ArrayList<IORowObject> deletedRows = this.getDeletedRows();
        for (IORowObject deletedRow : deletedRows) {
            deletedRow.setDeleted(false);
        }
    }

    private void validateRow(int row) throws ArrayIndexOutOfBoundsException {
        int rowCount = this.dataBuffer.size();
        if (row < 0 || row >= rowCount) {
            throw new ArrayIndexOutOfBoundsException("The row " + row + " is invalid.  It should be in the range 0 to " + (rowCount - 1));
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupporter.addPropertyChangeListener(listener);
        ArrayList<IORowObject> rows = this.getRows();
        for (IORowObject row : rows) {
            row.addPropertyChangeListener(listener);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupporter.removePropertyChangeListener(listener);
        ArrayList<IORowObject> rows = this.getRows();
        for (IORowObject row : rows) {
            row.removePropertyChangeListener(listener);
        }
    }
}

