/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.PropertyChangeSupport;
import com.jmorgan.io.IOColumnObject;
import com.jmorgan.io.IORowObject;
import java.beans.PropertyChangeListener;

public class DefaultIOColumnObject
extends JMBean
implements IOColumnObject {
    private IORowObject row;
    private String columnName;
    private Object value;
    private Object originalValue;
    private PropertyChangeSupport propertyChangeSupporter;

    public DefaultIOColumnObject(IORowObject row, String columnName) {
        this.setRow(row);
        this.setColumnName(columnName);
        this.propertyChangeSupporter = new PropertyChangeSupport(this);
    }

    public DefaultIOColumnObject(IORowObject row, String columnName, Object value) {
        this(row, columnName);
        this.value = value;
        this.originalValue = value;
    }

    public IORowObject getRow() {
        return this.row;
    }

    public void setRow(IORowObject row) {
        this.row = row;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    @Override
    public Object getOriginalValue() {
        return this.originalValue;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public void setValue(Object value) {
        if (this.value == null && value == null || this.value == value) {
            return;
        }
        if (this.value != null && this.value.equals(value)) {
            return;
        }
        Object oldValue = this.value;
        this.value = value;
        if (this.propertyChangeSupporter.hasListeners()) {
            this.propertyChangeSupporter.firePropertyChange(this.columnName, oldValue, value);
        }
    }

    @Override
    public boolean hasChanged() {
        if (this.value == null && this.originalValue == null) {
            return false;
        }
        if (this.value == null || this.originalValue == null) {
            return true;
        }
        return !this.value.equals(this.originalValue);
    }

    @Override
    public void commit() {
        this.originalValue = this.value;
    }

    @Override
    public void rollback() {
        this.setValue(this.originalValue);
    }

    @Override
    public void reset() {
        this.row = null;
        this.value = null;
        this.originalValue = null;
        this.propertyChangeSupporter.clearPropertyChangeListeners();
        this.propertyChangeSupporter.setSource(null);
        this.propertyChangeSupporter = null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupporter.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupporter.removePropertyChangeListener(listener);
    }

    @Override
    public int compareTo(IOColumnObject that) {
        if (this.equals(that)) {
            return 0;
        }
        int cmp = this.compareForNull(this.getValue(), that.getValue());
        if (cmp != 100) {
            return cmp;
        }
        if (this.value instanceof Comparable) {
            return ((Comparable)this.value).compareTo(that.getValue());
        }
        return this.value.toString().compareTo(that.getValue().toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof IOColumnObject) {
            IOColumnObject that = (IOColumnObject)o;
            return this.areEqual(this.getValue(), that.getValue());
        }
        return false;
    }

    @Override
    public String toString() {
        return this.columnName + "=(" + String.valueOf(this.originalValue) + ") " + String.valueOf(this.value);
    }
}

