/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import com.jmorgan.io.CopyEvent;
import com.jmorgan.io.CopyStatusListener;
import com.jmorgan.io.filefilter.DirectoryFileFilter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;

public class File
extends java.io.File {
    private static final int BUFSIZE = 262144;
    private DirectoryFileFilter dirFilter;

    public File(java.io.File parent, String child) {
        super(parent, child);
    }

    public File(String pathName) {
        super(pathName);
    }

    public File(String parent, String child) {
        super(parent, child);
    }

    public File(java.io.File file) {
        super(file.getAbsolutePath());
    }

    public String getFileNameExtension() {
        String fileName = this.getAbsolutePath();
        int periodLocation = fileName.lastIndexOf(46);
        return periodLocation < 0 ? "" : fileName.substring(periodLocation + 1);
    }

    public void copyTo(java.io.File target) throws IOException {
        this.copyTo(target, null);
    }

    public void copyTo(java.io.File target, CopyStatusListener listener) throws IOException {
        int bytesRead;
        CopyEvent event = new CopyEvent(this, target, 0L);
        int bufferSize = 262144;
        if (!this.isFile()) {
            throw new UnsupportedOperationException("Source File (" + String.valueOf(this) + ") is not a File");
        }
        if (target == null) {
            throw new IllegalArgumentException("Target file cannot be null");
        }
        if (target.isDirectory()) {
            throw new IllegalArgumentException("Target file (" + String.valueOf(target) + ") is not a file");
        }
        target.delete();
        target.createNewFile();
        if (this.length() < 262144L) {
            bufferSize = (int)this.length();
        }
        if (bufferSize <= 0) {
            return;
        }
        FileInputStream fin = new FileInputStream(this);
        BufferedInputStream bis = new BufferedInputStream(fin, bufferSize);
        FileOutputStream fout = new FileOutputStream(target);
        BufferedOutputStream bos = new BufferedOutputStream(fout, bufferSize);
        long totalBytesRead = 0L;
        byte[] buffer = new byte[bufferSize];
        while ((bytesRead = bis.read(buffer)) != -1) {
            bos.write(buffer, 0, bytesRead);
            if (listener == null) continue;
            event.setBytesCopied(totalBytesRead += (long)bytesRead);
            listener.copyStatusEvent(event);
        }
        bis.close();
        fin.close();
        bos.flush();
        fout.flush();
        bos.close();
        fout.close();
        target.setLastModified(this.lastModified());
    }

    public void moveTo(java.io.File target) throws IOException {
        this.moveTo(target, null);
    }

    public void moveTo(java.io.File target, CopyStatusListener listener) throws IOException {
        this.copyTo(target, listener);
        this.delete();
    }

    public java.io.File[] recursiveListFiles() throws IllegalArgumentException {
        if (!this.isDirectory()) {
            throw new IllegalArgumentException("Must be a Directory");
        }
        ArrayList<java.io.File> files = new ArrayList<java.io.File>();
        this._loadAllFiles(this, files);
        java.io.File[] fileArr = new java.io.File[files.size()];
        files.toArray(fileArr);
        return fileArr;
    }

    private void _loadAllFiles(java.io.File directory, ArrayList<java.io.File> files) {
        java.io.File[] fileArr = directory.listFiles();
        if (fileArr == null) {
            return;
        }
        int i = 0;
        while (i < fileArr.length) {
            if (fileArr[i].isDirectory()) {
                this._loadAllFiles(fileArr[i], files);
            }
            files.add(fileArr[i]);
            ++i;
        }
    }

    public java.io.File[] recursiveListFiles(FileFilter filter) throws IllegalArgumentException {
        return this._recursiveListFiles(filter);
    }

    public java.io.File[] recursiveListFiles(FilenameFilter filter) throws IllegalArgumentException {
        return this._recursiveListFiles(filter);
    }

    private java.io.File[] _recursiveListFiles(Object filter) throws IllegalArgumentException {
        if (!this.isDirectory()) {
            throw new IllegalArgumentException("Must be a Directory");
        }
        if (!(filter instanceof FileFilter) && !(filter instanceof FilenameFilter)) {
            throw new IllegalArgumentException("com.jmorgan.io.File._recursiveListFiles(): Given filter must be a FileFilter or FilenameFilter");
        }
        ArrayList<java.io.File> files = new ArrayList<java.io.File>();
        if (this.dirFilter == null) {
            this.dirFilter = new DirectoryFileFilter();
        }
        this._loadAllFiles(this, files, filter);
        java.io.File[] fileArr = new java.io.File[files.size()];
        files.toArray(fileArr);
        return fileArr;
    }

    private void _loadAllFiles(java.io.File directory, ArrayList<java.io.File> files, Object filter) {
        int i;
        if (!(filter instanceof FileFilter) && !(filter instanceof FilenameFilter)) {
            throw new IllegalArgumentException("com.jmorgan.io.File._loadAllFiles(): Given filter must be a FileFilter or FilenameFilter");
        }
        java.io.File[] dirArr = directory.listFiles(this.dirFilter);
        java.io.File[] fileArr = null;
        if (filter instanceof FileFilter) {
            fileArr = directory.listFiles((FileFilter)filter);
        } else if (filter instanceof FilenameFilter) {
            fileArr = directory.listFiles((FilenameFilter)filter);
        }
        if (dirArr != null) {
            i = 0;
            while (i < dirArr.length) {
                this._loadAllFiles(dirArr[i], files, filter);
                ++i;
            }
        }
        if (fileArr != null) {
            i = 0;
            while (i < fileArr.length) {
                if (!fileArr[i].isDirectory()) {
                    files.add(fileArr[i]);
                }
                ++i;
            }
        }
    }
}

