/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class FileHierarchy {
    private File path;
    private ArrayList<FileHierarchy> dirs;
    private ArrayList<File> files;

    public FileHierarchy(String path) {
        this(new File(path));
    }

    public FileHierarchy(File path) {
        this.path = path;
        File[] fileList = path.listFiles();
        if (fileList == null) {
            System.out.println("FileHierarchy.FileHierarchy(File path): Invalid Path=" + path.getAbsolutePath());
            return;
        }
        this.dirs = new ArrayList();
        this.files = new ArrayList();
        File[] fileArray = fileList;
        int n = fileList.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.dirs.add(new FileHierarchy(file));
            } else {
                this.files.add(file);
            }
            ++n2;
        }
    }

    public File getPath() {
        return this.path;
    }

    public ArrayList<FileHierarchy> getDirectories() {
        return this.dirs;
    }

    public ArrayList<File> getFiles() {
        return this.files;
    }

    public ArrayList<File> getHierarchy() {
        ArrayList<File> resultSet = new ArrayList<File>();
        this.unravel(resultSet, this);
        return resultSet;
    }

    public HashMap<File, Boolean> delete() {
        ArrayList<File> hierarchy = this.getHierarchy();
        HashMap<File, Boolean> deleteResults = new HashMap<File, Boolean>(hierarchy.size());
        Collections.reverse(hierarchy);
        for (File file : hierarchy) {
            boolean deleted = file.delete();
            deleteResults.put(file, deleted);
        }
        return deleteResults;
    }

    private void unravel(ArrayList<File> resultSet, FileHierarchy hierarchy) {
        resultSet.add(hierarchy.getPath());
        ArrayList<File> hierarchyFiles = hierarchy.getFiles();
        if (hierarchyFiles != null) {
            resultSet.addAll(hierarchy.getFiles());
        }
        for (FileHierarchy fileHierarchy : hierarchy.getDirectories()) {
            this.unravel(resultSet, fileHierarchy);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (File file : this.getHierarchy()) {
            String fileName = String.format("%s\n", file);
            sb.append(fileName);
        }
        return sb.toString();
    }
}

