/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import com.jmorgan.beans.nbit.NBit;
import com.jmorgan.io.AbstractNBitStream;
import java.io.IOException;
import java.io.OutputStream;

public class NBitOutputStream
extends AbstractNBitStream {
    private OutputStream outputStream;

    public NBitOutputStream(OutputStream outputStream) {
        if (outputStream == null) {
            throw new IllegalArgumentException("NBitOutputStream must have a valid output stream.");
        }
        this.outputStream = outputStream;
        this.bitPosition = -1;
    }

    public void write(NBit nBit) throws IOException {
        if (nBit == null) {
            return;
        }
        int bitCount = nBit.getBitCount();
        if (bitCount == 0) {
            return;
        }
        int i = bitCount - 1;
        while (i >= 0) {
            boolean bit = nBit.getBit(i);
            this.writeNextBit(bit);
            --i;
        }
    }

    private void writeNextBit(boolean bit) throws IOException {
        ++this.bitPosition;
        if (bit) {
            this.currentByte |= BITMASK[this.bitPosition];
        }
        if (this.bitPosition == 7) {
            this.outputStream.write(this.currentByte);
            this.currentByte = 0;
            this.bitPosition = -1;
        }
    }

    public void flush() throws IOException {
        if (this.bitPosition != -1) {
            this.outputStream.write(this.currentByte);
            this.outputStream.flush();
        }
    }
}

