/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;

public abstract class ReaderHelper {
    private ArrayList<Reader> readers = new ArrayList();
    protected int bufferSize;
    protected BufferedReader bufferedReader;
    protected IOException exception;

    public ReaderHelper() {
        this(65535);
    }

    public ReaderHelper(int bufferSize) {
        this.setBufferSize(bufferSize);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void addReader(Reader reader) {
        if (reader == null) {
            return;
        }
        this.readers.add(reader);
    }

    public Reader getReader() {
        return this.readers.get(this.readers.size() - 1);
    }

    public abstract boolean open();

    public boolean close() {
        Collections.reverse(this.readers);
        boolean success = true;
        for (Reader reader : this.readers) {
            try {
                reader.close();
            }
            catch (IOException e) {
                this.exception = e;
                success = false;
            }
        }
        return success;
    }

    public IOException getException() {
        return this.exception;
    }
}

