/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io.excel;

import com.jmorgan.io.DEO;
import com.jmorgan.io.DefaultIOColumnObject;
import com.jmorgan.io.IOColumnObject;
import com.jmorgan.io.IORowObject;
import com.jmorgan.io.excel.ColumnPropertyBeanMap;
import com.jmorgan.io.excel.ColumnPropertyMap;
import com.jmorgan.io.excel.DefaultExcelRowObject;
import com.jmorgan.io.excel.ExcelColumnInfo;
import com.jmorgan.io.excel.ExcelRetrievalArgument;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public class ExcelDEO<T>
extends DEO<T, ExcelRetrievalArgument> {
    private String excelFileName;
    private ArrayList<ColumnPropertyMap<?, ?>> columnPropertyMaps;

    public ExcelDEO() {
    }

    public ExcelDEO(String excelFileName) {
        this();
        this.setExcelFileName(excelFileName);
    }

    public String getExcelFileName() {
        return this.excelFileName;
    }

    public void setExcelFileName(String excelFileName) {
        this.excelFileName = excelFileName;
    }

    public void addColumnPropertyMap(ColumnPropertyMap<?, ?> columnPropertyMap) {
        if (columnPropertyMap == null) {
            return;
        }
        if (this.columnPropertyMaps == null) {
            this.columnPropertyMaps = new ArrayList();
        }
        this.columnPropertyMaps.add(columnPropertyMap);
    }

    public Collection<ColumnPropertyMap<?, ?>> getColumnPropertyMaps() {
        return this.columnPropertyMaps;
    }

    public void setColumnPropertyMaps(Collection<ColumnPropertyMap<?, ?>> columnPropertyMaps) {
        if (this.columnPropertyMaps != null) {
            this.columnPropertyMaps.clear();
            this.columnPropertyMaps = null;
        }
        this.columnPropertyMaps = new ArrayList(columnPropertyMaps);
    }

    public Collection<T> loadData(Collection<ColumnPropertyMap<?, ?>> columnPropertyMaps, Class<T> beanType) {
        this.setColumnPropertyMaps(columnPropertyMaps);
        return this.retrieve(beanType);
    }

    @Override
    protected void mapDataToBean(IORowObject row, T bean) {
        new ColumnPropertyBeanMap<T>(this.columnPropertyMaps, row, bean);
    }

    @Override
    public int getColumnNumber(String columnName) {
        char[] chars = columnName.toUpperCase().toCharArray();
        int highNumber = chars[0] - 65 + 1;
        int lowNumber = 0;
        if (chars.length == 2) {
            highNumber *= 26;
            lowNumber = chars[1] - 65 + 1;
        }
        return highNumber + lowNumber;
    }

    @Override
    public int retrieve() throws Exception {
        return this.retrieve(0, 0, 0, -1, -1);
    }

    @Override
    public int retrieve(Collection<ExcelRetrievalArgument> arguments) throws Exception {
        super.retrieve(arguments);
        return this.retrieve(0, 0, 0, 65535, 702);
    }

    public int retrieve(int sheetIndex, int beginRow, int beginColumn, int endRow, int endColumn) throws Exception {
        block11: {
            this.reset();
            if (this.excelFileName == null) {
                throw new IllegalStateException("The excel file name is not defined.");
            }
            FileInputStream fin = new FileInputStream(this.excelFileName);
            POIFSFileSystem fs = new POIFSFileSystem(fin);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet sheet = wb.getSheetAt(sheetIndex - 1);
            try {
                try {
                    Iterator<Row> rows = sheet.rowIterator();
                    while (rows.hasNext()) {
                        HSSFRow row = (HSSFRow)rows.next();
                        int rowNumber = row.getRowNum() + 1;
                        if (rowNumber < beginRow) continue;
                        if (endRow <= -1 || rowNumber <= endRow) {
                            ArrayList<IOColumnObject> cols = new ArrayList<IOColumnObject>();
                            ArrayList<ExcelColumnInfo> columnInfo = new ArrayList<ExcelColumnInfo>();
                            Iterator<Cell> cells = row.cellIterator();
                            while (cells.hasNext()) {
                                HSSFCell cell = (HSSFCell)cells.next();
                                int columnNumber = cell.getColumnIndex() + 1;
                                if (columnNumber < beginColumn) continue;
                                if (endColumn > -1 && columnNumber > endColumn) break;
                                String columnName = ExcelDEO.getColumnName(columnNumber);
                                Object value = ExcelDEO.getCellValue(cell);
                                ExcelColumnInfo cInfo = new ExcelColumnInfo();
                                cInfo.setAutoIncrement(false);
                                cInfo.setCaseSensitive(false);
                                if (value != null) {
                                    cInfo.setColumnClassName(value.getClass().getName());
                                }
                                cInfo.setColumnLabel(columnName);
                                cInfo.setColumnName(columnName);
                                cInfo.setColumnType(cell.getCellType());
                                cInfo.setColumnTypeName(ExcelDEO.getColumnTypeName(cell.getCellType()));
                                String dataFormat = cell.getCellStyle().getDataFormatString();
                                cInfo.setCurrency(dataFormat.contains("$"));
                                cInfo.setDefinitelyWritable(true);
                                cInfo.setDisplaySize(100);
                                cInfo.setLength(100);
                                cInfo.setNullable(0);
                                cInfo.setPosition(columnNumber);
                                cInfo.setPrecision(0);
                                cInfo.setQualifier("???");
                                cInfo.setRadix(10);
                                cInfo.setReadOnly(false);
                                HSSFComment comment = cell.getCellComment();
                                if (comment != null) {
                                    cInfo.setRemarks(comment.toString());
                                }
                                cInfo.setScale(0);
                                cInfo.setSearchable(true);
                                cInfo.setSheetName(sheet.getSheetName());
                                cInfo.setSigned(true);
                                cInfo.setWritable(true);
                                columnInfo.add(cInfo);
                                DefaultIOColumnObject colObject = new DefaultIOColumnObject(null, columnName, value);
                                colObject.setColumnName(columnName);
                                cols.add(colObject);
                            }
                            this.addRow(new DefaultExcelRowObject((Collection<ExcelColumnInfo>)columnInfo, (Collection<IOColumnObject>)cols));
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    fin.close();
                    break block11;
                }
            }
            catch (Throwable throwable) {
                fin.close();
                throw throwable;
            }
            fin.close();
        }
        this.setForcingRetrieve(true);
        int rowCount = this.getRowCount();
        this.setForcingRetrieve(false);
        return rowCount;
    }

    private static String getColumnTypeName(int cellType) {
        switch (cellType) {
            case 1: {
                return "String";
            }
            case 4: {
                return "boolean";
            }
            case 0: {
                return "double";
            }
            case 2: {
                return "formula";
            }
            case 5: {
                return "error";
            }
            case 3: {
                return "String";
            }
        }
        return "*** Unknown ***";
    }

    private static Object getCellValue(HSSFCell cell) {
        Object cellValue = null;
        int cellType = cell.getCellType();
        switch (cellType) {
            case 0: {
                cellValue = cell.getNumericCellValue();
                break;
            }
            case 1: {
                cellValue = cell.getRichStringCellValue();
                if (cellValue == null) break;
                cellValue = cellValue.toString();
                break;
            }
            case 4: {
                cellValue = cell.getBooleanCellValue();
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                cellValue = cell.getCellFormula();
                break;
            }
            case 5: {
                cellValue = cell.getErrorCellValue();
                break;
            }
            default: {
                System.out.println("unsuported cell type");
            }
        }
        return cellValue;
    }

    private static String getColumnName(int columnNumber) {
        int highNumber = --columnNumber / 26;
        int lowNumber = columnNumber % 26;
        char lowChar = (char)(lowNumber + 65);
        char highChar = (char)(highNumber + 65);
        if (highNumber == 0) {
            return "" + lowChar;
        }
        return "" + highChar + lowChar;
    }
}

