/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io.excel;

import com.jmorgan.io.RetrievalArgument;

public class ExcelRetrievalArgument
extends RetrievalArgument {
    private int columnNumber;

    public ExcelRetrievalArgument(int columnNumber, Object value) {
        super(ExcelRetrievalArgument.getColumnName(columnNumber), value);
        this.setColumnNumber(columnNumber);
    }

    public ExcelRetrievalArgument(String columnName, Object value) {
        super(columnName, value);
        this.setColumnNumber(ExcelRetrievalArgument.getColumnNumber(columnName));
    }

    public ExcelRetrievalArgument(int columnNumber, Object value, String logicalOperator) {
        super(ExcelRetrievalArgument.getColumnName(columnNumber), value, logicalOperator);
        this.setColumnNumber(columnNumber);
    }

    public ExcelRetrievalArgument(String columnName, Object value, String logicalOperator) {
        super(columnName, value, logicalOperator);
        this.setColumnNumber(ExcelRetrievalArgument.getColumnNumber(columnName));
    }

    public ExcelRetrievalArgument(int columnNumber, String operator, Object value) {
        super(ExcelRetrievalArgument.getColumnName(columnNumber), operator, value);
        this.setColumnNumber(columnNumber);
    }

    public ExcelRetrievalArgument(String columnName, String operator, Object value) {
        super(columnName, operator, value);
        this.setColumnNumber(ExcelRetrievalArgument.getColumnNumber(columnName));
    }

    public ExcelRetrievalArgument(int columnNumber, String operator, Object value, String logicalOperator) {
        super(ExcelRetrievalArgument.getColumnName(columnNumber), operator, value, logicalOperator);
        this.setColumnNumber(columnNumber);
    }

    public ExcelRetrievalArgument(String columnName, String operator, Object value, String logicalOperator) {
        super(columnName, operator, value, logicalOperator);
        this.setColumnNumber(ExcelRetrievalArgument.getColumnNumber(columnName));
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    private static String getColumnName(int columnNumber) {
        int highNumber = columnNumber / 26;
        int lowNumber = columnNumber % 26;
        char lowChar = (char)(lowNumber + 65);
        char highChar = (char)(highNumber + 65);
        if (highNumber == 0) {
            return "" + lowChar;
        }
        return "" + highChar + lowChar;
    }

    private static int getColumnNumber(String columnName) {
        char[] chars = columnName.toUpperCase().toCharArray();
        int highNumber = chars[0] - 65 + 1;
        int lowNumber = 0;
        if (chars.length == 2) {
            highNumber *= 27;
            lowNumber = chars[1] - 65 + 1;
        }
        return highNumber + lowNumber;
    }

    @Override
    public void setOperator(String operator) {
        if (this.getValue() == null && !operator.equalsIgnoreCase("is null") && !operator.equalsIgnoreCase("is not null")) {
            operator = "is null";
        }
        super.setOperator(operator);
    }
}

