/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.io.filefilter;

import com.jmorgan.io.filefilter.FileFilterAdapter;
import java.io.File;

public class ExtensionFileFilter
extends FileFilterAdapter {
    private String[] filterSpecification;
    private boolean caseSensitive = false;

    public ExtensionFileFilter(String ... filterSpec) {
        this.setFilterSpecification(filterSpec);
    }

    @Override
    public boolean accept(File pathname) {
        String fn = pathname.getName();
        if (!this.caseSensitive) {
            fn = fn.toLowerCase();
        }
        String[] stringArray = this.filterSpecification;
        int n = this.filterSpecification.length;
        int n2 = 0;
        while (n2 < n) {
            String filterSpec = stringArray[n2];
            if (!this.caseSensitive) {
                filterSpec = filterSpec.toLowerCase();
            }
            if (fn.endsWith(filterSpec)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean accept(File dir, String fname) {
        String fn = fname.toLowerCase();
        if (!this.caseSensitive) {
            fn = fn.toLowerCase();
        }
        String[] stringArray = this.filterSpecification;
        int n = this.filterSpecification.length;
        int n2 = 0;
        while (n2 < n) {
            String filterSpec = stringArray[n2];
            if (!this.caseSensitive) {
                filterSpec = filterSpec.toLowerCase();
            }
            if (fn.endsWith(filterSpec)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String[] getFilterSpecification() {
        return this.filterSpecification;
    }

    public void setFilterSpecification(String ... filterSpecification) {
        this.filterSpecification = filterSpecification;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }
}

